#version 120

/*
 _______ _________ _______  _______  _
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the LICENSE.txt contained in the root directory of this shaderpack!

*/

/////////////////////////CONFIGURABLE VARIABLES////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////CONFIGURABLE VARIABLES////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////END OF CONFIGURABLE VARIABLES/////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////END OF CONFIGURABLE VARIABLES/////////////////////////////////////////////////////////////////////////////////////////////////////////////



#include "Common.inc"


#define SHADOW_MAP_BIAS 0.9

#define VARIABLE_PENUMBRA_SHADOWS	// Contact-hardening (area) shadows

#define GI_RENDER_RESOLUTION 1 // Render resolution of GI. 0 = High. 1 = Low. Set to 1 for faster but blurrier GI. [0 1 1.5 2 3 4 5 6 7 8 9 10]

#define RAYLEIGH_AMOUNT 1.0 // Density of atmospheric scattering. [0.5 1.0 1.5 2.0 3.0 4.0]

#define WATER_REFRACT_IOR 1.2

#define TORCHLIGHT_FILL 2.0 // Amount of fill/ambient light to add to torchlight falloff. Higher values makes torchlight dim less intensely based on distance. [0.5 1.0 2.0 4.0 8.0]

#define TORCHLIGHT_BRIGHTNESS 1.0 // Brightness of torch light. [0.5 1.0 2.0 3.0 4.0]

#define TAA_ENABLED // Temporal Anti-Aliasing. Utilizes multiple rendered frames to reconstruct an anti-aliased image similar to supersampling. Can cause some artifacts.

#define SUNLIGHT_INTENSITY 1.0 // Intensity of sunlight. [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.5 3.0 3.5 4.0 4.5 6.0 7.0 8.0]

#define ENABLE_SOFT_SHADOWS

#define COLORED_SHADOWS // Colored shadows from stained glass.

//#define PIXEL_SHADOWS

#define HELD_TORCHLIGHT // Holding an item with a light value will cast light into the scene when this is enabled. 

//#define Plane_Clouds1

//#define Plane_Clouds2

#define Volumetric_Clouds

#define Cloud3Height 3000.0						//[100.0 120.0 140.0 160.0 180.0 200.0 220.0 240.0 250.0 270.0 300.0 310.0 320.0 330.0 340.0 350.0 360.0 370.0 400.0 500.0 550.0 600.0 650.0 700.0 800.0 900.0 1000.0 1500.0 1600.0 2000.0 2500.0  3000.0 4000.0 5000.0 6000.0 7000.0 8000.0 9000.0 10000.0] //Sets the Volumetric clouds3 Height

#define Cloud3thick 1600.0						//[100.0 120.0 140.0 160.0 180.0 200.0 220.0 240.0 250.0 270.0 300.0 310.0 320.0 330.0 340.0 350.0 360.0 370.0 400.0 500.0 550.0 600.0 650.0 700.0 800.0 900.0 1000.0 1500.0 1600.0 2000.0 2500.0 3000.0 4000.0 5000.0 6000.0 7000.0 8000.0 9000.0 10000.0] //Sets the Volumetric clouds3 Height

#define Cloud5Height 60.0						//[10.0 12.0 14.0 16.0 18.0 20.0 22.0 24.0 25.0 27.0 30.0 35.0 40.0 50.0 60.0 70.0 80.0 90.0 100.0 150.0 200.0 300.0] //Sets the Volumetric clouds Height

#define Cloud5thick 200.0						//[10.0 12.0 14.0 16.0 18.0 20.0 22.0 24.0 25.0 27.0 30.0 35.0 40.0 50.0 60.0 70.0 80.0 90.0 100.0 150.0 200.0 300.0] //Sets the Volumetric clouds Height

#define VOLUMETRIC_CLOUD_SPEED 0.02             //[0.0 0.001 0.0025 0.005 0.006 0.007 0.008 0.009 0.01 0.0125 0.015 0.02 0.025 0.03 0.04 0.05 0.06 0.07 0.075 0.08 0.09 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.4 1.6 1.8 2.0 2.5 3.0 3.5 4.0 4.5 5.0 5.5 6.0 6.5 7.0 7.5 8.0] //Default is 0.01f, Lower number to slow speed, Higher number to increase speed 

#define L_A_C                 0.07              //[0.0 0.00025 0.0005 0.0006 0.0007 0.00075 0.0008 0.0009 0.001 0.0015 0.002 0.0022 0.0025 0.003 0.004 0.005 0.006 0.007 0.0075 0.008 0.009 0.01 0.011 0.012 0.013 0.014 0.0l5 0.016 0.017 0.018 0.019 0.02 0.021 0.025 0.03 0.04 0.05 0.06 0.07 0.075 0.08 0.09 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.86 0.9 0.95 0.99 1.0 1.25 1.5 1.75 2.0 2.5 3.0 3.5 4.0 4.5 5.0 6.0 7.0 8.0 9.0 10.0]
 
#define L_L                   25.0              //[1.0 2.0 2.5 5.0 5.6 10.0 12.0 16.0 20.0 25.0 32.0 35.0 40.0 50.0 70.0 80.0 90.0 100.0 110.0 120.0 130.0 140.0 150.0 160.0 170.0 180.0 190.0 200.0 225.0  250.0 300.0 350.0 400.0 500.0]

#define C_Q                   25                //[5 8 10 16 18 20 22 24 25 26 30 32 40 48 50 56 60 64 70 72 80 90 100 110 120 130 140 150 160 180 200 225 250 275 300 320]

#define L_Q                   6                 //[1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32]

#define VC_R                  0.5               //[0.3 0.33 0.4 0.42 0.43 0.44 0.45 0.46 0.48 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95]

#define C_S_W                 0.2               //[0.005 0.0075 0.01 0.015 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.25 1.5 1.75 2.0 2.25 2.5 3.0 3.5 4.0 4.5 5.0 6.0 7.0 8.0 9.0 10.0]

#define L_R_S                 1.0               //[0.0 0.025 0.05 0.075 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.75 0.8 0.9 0.92 0.94 0.95 0.96 0.98 0.99 1.0]

//#define C_D

#define C_O_S                 3                 //[0 1 2 3 4 5 6 7 8 9 10]     
           
#define A_C_O_S               3.0               //[0.0 1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0]          

#define Micro_airflow_Strength 0.02             //[0.0 0.005 0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8]

#define airflow_Strength      1.0               //[0.0 0.05 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0]

#define upprtairflow_Strength 1.0               //[0.0 0.05 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0]

#define Vol_Cloud_Coverage    2.0               //[1.3 1.4 1.5 2.0 2.1 2.2 2.3 2.4 2.5 3.0 3.5 4.0 4.5 5.0]

#define CLC   
                                   
#define HQ_S 

#define CBL                   1.0               //[0.0 0.001 0.002 0.003 0.004 0.005 0.006 0.007 0.008 0.009 0.01 0.0125 0.015 0.016 0.02 0.025 0.03 0.04 0.05 0.06 0.07 0.075 0.08 0.09 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.4 1.6 1.8 2.0 2.5 3.0 3.5 4.0 4.5 5.0 5.5 6.0 6.5 7.0 7.5 8.0]

//#define C_GI

#define S_GI

//#define RP_RS
#define RP_RS_Q               40                //[1 2 3 4 5 6 7 8 9 10 12 14 16 18 20 22 24 25 26 30 32 40 48 50 56 60 64 70 72 80 90 100 110 120 128 130 140 150 160 180 200 225 250 275 300 320]
#define RP_RS_min             0.0               //[0.0 0.05 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0]
#define RP_RS_L               1.0               //[0.0 0.05 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0]

#define G_GI
#define G_GI_L_D

#define LQ_G_GI
#define LQ_S_L_S
//#define LQ_D_L_L

#define D_L_L                 1.0               //[0.0 0.001 0.002 0.003 0.004 0.005 0.006 0.007 0.008 0.009 0.01 0.0125 0.015 0.016 0.02 0.025 0.03 0.04 0.05 0.06 0.07 0.075 0.08 0.09 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.4 1.6 1.8 2.0 2.5 3.0 3.5 4.0 4.5 5.0 5.5 6.0 6.5 7.0 7.5 8.0]
//#define D_L_D  
#define D_L_S                 0.0               //[0.0 0.001 0.002 0.003 0.004 0.005 0.006 0.007 0.008 0.009 0.01 0.0125 0.015 0.016 0.02 0.025 0.03 0.04 0.05 0.06 0.07 0.075 0.08 0.09 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.4 1.6 1.8 2.0 2.5 3.0 3.5 4.0 4.5 5.0 5.5 6.0 6.5 7.0 7.5 8.0]

#define S_L_L                 1.0               //[0.0 0.001 0.002 0.003 0.004 0.005 0.006 0.007 0.008 0.009 0.01 0.0125 0.015 0.016 0.02 0.025 0.03 0.04 0.05 0.06 0.07 0.075 0.08 0.09 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.4 1.6 1.8 2.0 2.5 3.0 3.5 4.0 4.5 5.0 5.5 6.0 6.5 7.0 7.5 8.0]
//#define S_L_D
#define S_L_S                 1.0               //[0.0 0.001 0.002 0.003 0.004 0.005 0.006 0.007 0.008 0.009 0.01 0.0125 0.015 0.016 0.02 0.025 0.03 0.04 0.05 0.06 0.07 0.075 0.08 0.09 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.4 1.6 1.8 2.0 2.5 3.0 3.5 4.0 4.5 5.0 5.5 6.0 6.5 7.0 7.5 8.0]

#define Density_Curve_C       1.0               //[1.0 1.1 1.2 1.3 1.4 1.5 2.0 2.1 2.2 2.3 2.4 2.5 3.0 3.5 4.0 4.3 4.5 4.7 5.0 5.2 5.7 6.0 6.5 7.0 8.0 9.0 10.0 15.0 20.0 50.0 100.0 200.0 400.0 800.0 1000.0]

//#define HALO

#define cloud_shadow

#define HCCURVE               1.0               //[0.0 0.05 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.2 1.25 1.3 1.5 2.0 2.5 3.0 2.75 4.0 5.0 6.0 7.0 8.0]

//#define PWNOISE 

//#define HDR 

//#define nightVision_torch

//#define SSPTGI

const int 		shadowMapResolution 	= 1000;	// Shadowmap resolution [1 2 4 8 16 32 64 128 256 512 1000 1024 2048 4096]
const float 	shadowDistance 			= 120.0; // Shadow distance. Set lower if you prefer nicer close shadows. Set higher if you prefer nicer distant shadows. [80.0 100.0 120.0 180.0 240.0]
const float 	shadowIntervalSize 		= 4.0f;
const float 	rainModefactor 		= 0.0f;
const bool 		shadowHardwareFiltering0 = true;

const bool 		shadowtex1Mipmap = true;
const bool 		shadowtex1Nearest = false;
const bool 		shadowcolor0Mipmap = true;
const bool 		shadowcolor0Nearest = false;
const bool 		shadowcolor1Mipmap = true;
const bool 		shadowcolor1Nearest = false;

const float shadowDistanceRenderMul = 1.0f;

const int 		RGB8 					= 0;
const int 		RGBA8 					= 0;
const int 		RGBA16 					= 0;
const int 		RG16 					= 0;
const int 		RGB16 					= 0;
const int 		gcolorFormat 			= RGB8;
const int 		gdepthFormat 			= RGBA8;
const int 		gnormalFormat 			= RGBA16;
const int 		compositeFormat 		= RGB8;
const int 		gaux1Format 			= RGBA16;
const int 		gaux2Format 			= RGBA8;
const int 		gaux3Format 			= RGBA16;
const int 		gaux4Format 			= RGBA16;


const int 		superSamplingLevel 		= 1;

const float	    sunPathRotation 		= -40.0f;

const int 		noiseTextureResolution  = 64;

const float 	ambientOcclusionLevel 	= 0.0f;


const bool gaux3MipmapEnabled = true;
const bool gaux1MipmapEnabled = false;

const bool gaux4Clear = false;

const float wetnessHalflife = 1.0;
const float drynessHalflife = 60.0;

/* DRAWBUFFERS:26 */


uniform sampler2D gcolor;
uniform sampler2D gdepth;
uniform sampler2D depthtex1;
uniform sampler2D gdepthtex;
uniform sampler2D gnormal;
uniform sampler2D composite;
uniform sampler2D gaux1;
uniform sampler2D gaux2;
uniform sampler2D gaux3;
uniform sampler2D gaux4;
uniform sampler2D noisetex;

uniform sampler2DShadow shadow;


varying vec4 texcoord;
varying vec3 lightVector;
varying vec3 sunVector;
varying vec3 upVector;

uniform int worldTime;

uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float aspectRatio;
uniform float frameTimeCounter;
uniform sampler2D shadowcolor;
uniform sampler2D shadowcolor1;
uniform sampler2D shadowtex1;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;
uniform mat4 gbufferModelView;

uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;
uniform vec3 skyColor;

uniform int   isEyeInWater;
uniform float eyeAltitude;
uniform ivec2 eyeBrightness;
uniform ivec2 eyeBrightnessSmooth;
uniform int   fogMode;

varying float timeSunriseSunset;
varying float timeNoon;
varying float timeMidnight;

varying vec3 colorSunlight;
varying vec3 colorSkylight;
varying vec3 colorTorchlight;
varying vec3 upperCloudSunlightColor;
varying vec3 CloudSunlightColor;

varying vec4 skySHR;
varying vec4 skySHG;
varying vec4 skySHB;

varying vec3 worldLightVector;
varying vec3 worldSunVector;

uniform int heldBlockLightValue;

varying float contextualFogFactor;

uniform int frameCounter;

uniform float frameTime;

uniform float nightVision;

varying float heldLightBlacklist;

float SCLE = pow(2.0f, (1.0 + cos(frameTimeCounter * 2000.0) * 0.) * .0);

/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
vec3 BlueNoiseTemporal(vec2 coord)
{
	vec2 noiseCoord = vec2(coord.st * vec2(viewWidth, viewHeight)) / 64.0;

	noiseCoord = (floor(noiseCoord * 64.0) + 0.5) / 64.0;
	
	vec3 irrationals = vec3(sqrt(1.0 / 5.0), sqrt(2.0), 1.61803398) * 1.0;

	vec3 n = texture2D(noisetex, noiseCoord).bbb;

	n = mod(n + irrationals * mod(frameCounter, 64.0f), vec3(1.0));

	return n;
}

vec2 rot(vec2 p, float angle)
{
    vec2 po = p;
	
    mat2 mat = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    p = mat * p;

    return p;
}

vec2 WeylNth(int n)
{
	return fract(vec2(n * 12664745, n*9560333) / exp2(24.0));
}

vec2 JitterSampleOffset(int frameOffset)
{
	return (WeylNth((frameCounter + frameOffset) % 16) * 2.0 - 1.0);
	
}

void TemporalJitterProjPos(inout vec4 pos)
{
	#ifdef TAA_ENABLED

	 pos.xy -= (JitterSampleOffset(0) * 0.5) / vec2(viewWidth, viewHeight);

	#else

	 pos.xy -= (JitterSampleOffset(0) * 0.5) / vec2(viewWidth, viewHeight);	
	
	#endif
}

void TemporalJitterProjPos(inout vec3 pos)
{
	#ifdef TAA_ENABLED
	
	 pos.xy -= (JitterSampleOffset(0) * 0.5) / vec2(viewWidth, viewHeight);

	#else
 
 	 pos.xy -= (JitterSampleOffset(0) * 0.5) / vec2(viewWidth, viewHeight);
	 
	#endif
}

vec4 GetViewPosition(in vec2 coord, in float depth) 
{	
	vec4 tcoord = vec4(coord.xy, 0.0, 0.0);

	TemporalJitterProjPos(tcoord);


	vec4 fragposition = gbufferProjectionInverse * vec4(tcoord.s * 2.0f - 1.0f, tcoord.t * 2.0f - 1.0f, 2.0f * depth - 1.0f, 1.0f);
		 fragposition /= fragposition.w;

	
	return fragposition;
}

vec4 GetViewPositionRaw(in vec2 coord, in float depth) 
{	
	vec4 tcoord = vec4(coord.xy, 0.0, 0.0);
	//TemporalJitterProjPos(tcoord);
	//TemporalJitterProjPos(tcoord);
	//tcoord.x += 1.1;
	//tcoord.x = 0.0;

	vec4 fragposition = gbufferProjectionInverse * vec4(tcoord.s * 2.0f - 1.0f, tcoord.t * 2.0f - 1.0f, 2.0f * depth - 1.0f, 1.0f);
		 fragposition /= fragposition.w;

	
	return fragposition;
}

float 	ExpToLinearDepth(in float depth)
{
	return 2.0f * near * far / (far + near - (2.0f * depth - 1.0f) * (far - near));
}


float GetMaterialMask(const in int ID, in float matID) 
{
	//Catch last part of sky
	if (matID > 254.0f) 
	{
		matID = 0.0f;
	}

	if (matID == ID) 
	{
		return 1.0f;
	} 
	else 
	{
		return 0.0f;
	}
}

float CurveBlockLightSky(float blockLight){
	//blockLight = 1.0 - pow(1.0 - blockLight * 0.9, 0.7);
	//blockLight = saturate(blockLight * blockLight * blockLight * 1.95);
	//if(texcoord.s > 0.5){
	//  float dist1 = blockLight;
	//  float dist2 = (1.0 - dist1) * 15.0 + 1.0;
	//    blockLight = mix(1.0 / (dist2 * dist2), dist1 * dist1, saturate(dist1 * dist1));	
    //
	//}else{
	  float dist = (1.0 - blockLight) * 15.0 + 1.0;
	    blockLight /= mix(dist * dist, 1.0 / (blockLight * blockLight), saturate(blockLight));	
		blockLight = saturate(blockLight);
	//}

	return blockLight;
}

float CurveBlockLightTorch(float blockLight, float emissive, vec3 albedo){
    if (emissive > 0.0) {
        float angularRadius = 0.15;
        float luminance = 1.0 / (PI * angularRadius * angularRadius);

        float glow = length(albedo / length(vec3(1.0)));
              glow = glow * glow * glow * glow * glow;
              glow *= luminance;

        return ((1.0 / luminance) + glow);
    }
	float dist = (1.0 - blockLight) * 15.0 + 1.0;
	blockLight /= dist * dist;

	return blockLight;
}

float BlueNoise(vec2 coord)
{
	vec2 noiseCoord = vec2(coord.st * vec2(viewWidth, viewHeight)) / 64.0;
	noiseCoord += vec2(sin(frameCounter * 0.075), cos(frameCounter * 0.075)) * 10.0;

	noiseCoord = (floor(noiseCoord * 64.0) + 0.5) / 64.0;

	float blueNoise = texture2DLod(noisetex, noiseCoord.st, 0).b;

	return blueNoise;
}

vec2 BlueNoiseXY(vec2 coord)
{
	return vec2(BlueNoise(coord.st), BlueNoise(coord.st + 32.0 / vec2(viewWidth, viewHeight)));
}

float BlueNoiseStatic(vec2 coord)
{
	vec2 noiseCoord = vec2(coord.st * vec2(viewWidth, viewHeight)) / 64.0;

	noiseCoord = (floor(noiseCoord * 64.0) + 0.5) / 64.0;

	float blueNoise = texture2DLod(noisetex, noiseCoord.st, 0).b;

	return blueNoise;
}

vec3 BlueNoiseL(vec2 coord)
{
	vec2 noiseCoord = vec2(coord.st * vec2(viewWidth, viewHeight)) / 64.0;
	noiseCoord += vec2(sin(frameCounter * 0.75), cos(frameCounter * 0.75));

	noiseCoord = (floor(noiseCoord * 64.0) + 0.5) / 64.0;

	vec3 blueNoise = texture2DLod(noisetex, noiseCoord.st, 0).xyz;

	return blueNoise;
}

vec3 CalculateNoisePattern1(vec2 offset, float size) 
{
	vec2 coord = texcoord.st;

	coord *= vec2(viewWidth, viewHeight);
	coord = mod(coord + offset, vec2(size));
	coord /= noiseTextureResolution;

	return texture2D(noisetex, coord).xyz;
}

float GetDepthLinear(in vec2 coord) 
{					
	return (near * far) / (texture2D(depthtex1, coord).x * (near - far) + far);
}

float GetDepthLinear2(float depth){
	return (2.0 * near) / (far + near - depth * (far - near));
}

vec3 GetNormals(vec2 coord)
{
	return DecodeNormal(texture2D(gnormal, coord).xy);
}

float GetDepth(vec2 coord)
{
	return texture2D(depthtex1, coord).x;
}

float LinearToExpDepth(float depth)
{
	return (far * (depth - near)) / (depth * (far - near));
}

float  	CalculateDitherPattern1() {
	const int[16] ditherPattern = int[16] (0 , 8 , 2 , 10,
									 	   12, 4 , 14, 6 ,
									 	   3 , 11, 1,  9 ,
									 	   15, 7 , 13, 5 );

	vec2 count = vec2(0.0f);
	     count.x = floor(mod((texcoord.s) * viewWidth, 4.0f));
		 count.y = floor(mod((texcoord.t) * viewHeight, 4.0f));

	int dither = ditherPattern[int(count.x) + int(count.y) * 4];

	return (float(dither)) / 16.0f;
}

float  	CalculateDitherPattern2() {
	const int[64] ditherPattern = int[64] ( 1, 49, 13, 61,  4, 52, 16, 64,
										   33, 17, 45, 29, 36, 20, 48, 32,
										    9, 57,  5, 53, 12, 60,  8, 56,
										   41, 25, 37, 21, 44, 28, 40, 24,
										    3, 51, 15, 63,  2, 50, 14, 62,
										   35, 19, 47, 31, 34, 18, 46, 30,
										   11, 59,  7, 55, 10, 58,  6, 54,
										   43, 27, 39, 23, 42, 26, 38, 22);

	vec2 count = vec2(0.0f);
	     count.x = floor(mod(texcoord.s * viewWidth, 8.0f));
		 count.y = floor(mod(texcoord.t * viewHeight, 8.0f));

	int dither = ditherPattern[int(count.x) + int(count.y) * 8];

	return float(dither) / 64.0f;
}

vec4 GetCloudPosition(vec2 coord, float depth, float distanceMult)
{
	// depth *= 30.0f;

	//Convert texture coordinates and depth into view space
	vec4 viewPos = gbufferProjectionInverse * vec4(coord.s * 2.0f - 1.0f, coord.t * 2.0f - 1.0f, 2.0f * depth - 1.0f, 1.0f);
		 viewPos /= viewPos.w;

	//Convert from view space to world space
	vec4 worldPos = gbufferModelViewInverse * viewPos;

	worldPos.xyz *= distanceMult;
	worldPos.xyz += cameraPosition.xyz;

	return worldPos;
}

/////////////////////////STRUCTS///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////STRUCTS///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

struct GbufferData
{
	vec3 albedo;
	vec3 normal;
	float depth;
	vec2 mcLightmap;
	float smoothness;
	float metallic;
	float emissive;
	float materialID;
	vec4 transparentAlbedo;
	float parallaxShadow;
    float rainMask;
};


struct MaterialMask
{
	float sky;
	float land;
	float grass;
	float leaves;
	float hand;
	float entityPlayer;
	float water;
	float stainedGlass;
	float ice;
	float torch;
	float lava;
	float glowstone;
	float fire;
};

struct Ray {
	vec3 dir;
	vec3 origin;
};

struct Plane {
	vec3 normal;
	vec3 origin;
};

struct Intersection {
	vec3 pos;
	float distance;
	float angle;
};

vec2 GetNearFragment(vec2 coord, float depth, out float minDepth)
{

	vec2 texel = 1.0 / vec2(viewWidth, viewHeight);

	float step = 2.0;

	vec4 depthSamples;
	depthSamples.x = texture2D(gdepthtex, coord + texel * vec2(step, step)).x;
	depthSamples.y = texture2D(gdepthtex, coord + texel * vec2(step, -step)).x;
	depthSamples.z = texture2D(gdepthtex, coord + texel * vec2(-step, step)).x;
	depthSamples.w = texture2D(gdepthtex, coord + texel * vec2(-step, -step)).x;

	vec2 targetFragment = vec2(0.0, 0.0);

	if (depthSamples.x < depth)
		targetFragment = vec2(step, step);
	if (depthSamples.y < depth)
		targetFragment = vec2(step, -step);
	if (depthSamples.z < depth)
		targetFragment = vec2(-step, step);
	if (depthSamples.w < depth)
		targetFragment = vec2(-step, -step);


	minDepth = min(min(min(depthSamples.x, depthSamples.y), depthSamples.z), depthSamples.w);

	return coord + texel * targetFragment;
}

/////////////////////////STRUCT FUNCTIONS//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////STRUCT FUNCTIONS//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


GbufferData GetGbufferData()
{
	GbufferData data;

	vec4 tex2 = texture2DLod(gnormal, texcoord.st, 0);
	vec3 gbuffer0 = texture2D(gcolor, texcoord.st * SCLE).rgb;
	vec4 gbuffer1 = texture2D(gdepth, texcoord.st * SCLE).rgba;
	vec2 gbuffer2 = texture2D(gnormal, texcoord.st * SCLE).rg;
	vec3 gbuffer3 = texture2D(composite, texcoord.st * SCLE).rgb;
	float depth = texture2D(depthtex1, texcoord.st * SCLE).x;


	data.albedo = GammaToLinear(gbuffer0);
	
	data.emissive = gbuffer1.b;
	data.mcLightmap = gbuffer1.rg;
	data.mcLightmap.g = CurveBlockLightSky(data.mcLightmap.g);
	data.mcLightmap.r = CurveBlockLightTorch(data.mcLightmap.r, data.emissive, data.albedo);


	data.normal = DecodeNormal(gbuffer2);


	data.smoothness = gbuffer3.r;
	data.metallic = gbuffer3.g;
	data.materialID = gbuffer3.b;

	data.depth = depth;

	data.transparentAlbedo = texture2D(gaux2, texcoord.st);

	data.parallaxShadow = gbuffer1.a;
	data.rainMask = tex2.a;
	return data;
}

MaterialMask CalculateMasks(float materialID)
{
	MaterialMask mask;

	materialID *= 255.0;

	// if (isEyeInWater > 0)
	// 	mask.sky = 0.0f;
	// else
	// {
	// 	mask.sky = 0.0;
	// 	if (texture2D(depthtex1, texcoord.st).x > 0.999999)
	// 	{
	// 		mask.sky = 1.0;
	// 	}
	// }
		mask.sky = GetMaterialMask(0, materialID);
		//mask.sky = texture2D(depthtex1, texcoord).x > 0.999999 ? 1.0 : 0.0;



	mask.land 			= GetMaterialMask(1, materialID);
	mask.grass 			= GetMaterialMask(2, materialID);
	mask.leaves 		= GetMaterialMask(3, materialID);
	mask.hand 			= GetMaterialMask(4, materialID);
	mask.entityPlayer 	= GetMaterialMask(5, materialID);
	mask.water 			= GetMaterialMask(6, materialID);
	mask.stainedGlass	= GetMaterialMask(7, materialID);
	mask.ice 			= GetMaterialMask(8, materialID);

	mask.torch 			= GetMaterialMask(30, materialID);
	mask.lava 			= GetMaterialMask(31, materialID);
	mask.glowstone 		= GetMaterialMask(32, materialID);
	mask.fire 			= GetMaterialMask(33, materialID);

	return mask;
}

Intersection 	RayPlaneIntersectionWorld(in Ray ray, in Plane plane)
{
	float rayPlaneAngle = dot(ray.dir, plane.normal);

	float planeRayDist = 100000000.0f;
	vec3 intersectionPos = ray.dir * planeRayDist;

	if (rayPlaneAngle > 0.0001f || rayPlaneAngle < -0.0001f)
	{
		planeRayDist = dot((plane.origin), plane.normal) / rayPlaneAngle;
		intersectionPos = ray.dir * planeRayDist;
		intersectionPos = -intersectionPos;

		intersectionPos += cameraPosition.xyz;
	}
	
	Intersection i;

	i.pos = intersectionPos;
	i.distance = planeRayDist;
	i.angle = rayPlaneAngle;

	return i;
}

Intersection 	RayPlaneIntersection(in Ray ray, in Plane plane)
{
	float rayPlaneAngle = dot(ray.dir, plane.normal);

	float planeRayDist = 100000000.0f;
	vec3 intersectionPos = ray.dir * planeRayDist;

	if (rayPlaneAngle > 0.0001f || rayPlaneAngle < -0.0001f)
	{
		planeRayDist = dot((plane.origin - ray.origin), plane.normal) / rayPlaneAngle;
		intersectionPos = ray.origin + ray.dir * planeRayDist;
		// intersectionPos = -intersectionPos;

		// intersectionPos += cameraPosition.xyz;
	}

	Intersection i;

	i.pos = intersectionPos;
	i.distance = planeRayDist;
	i.angle = rayPlaneAngle;

	return i;
}

vec3 CalculateSunlightVisibility(vec4 screenSpacePosition, MaterialMask mask, float ifcloudShadow) {				//Calculates shadows
	//if (rainStrength >= 0.99f)
	//	return vec3(1.0f);



	//if (shadingStruct.direct > 0.0f) {
		float distance = sqrt(  screenSpacePosition.x * screenSpacePosition.x 	//Get surface distance in meters
							  + screenSpacePosition.y * screenSpacePosition.y
							  + screenSpacePosition.z * screenSpacePosition.z);

		vec4 ssp = screenSpacePosition;

		// if (isEyeInWater > 0.5)
		// {
		// 	ssp.xy *= 0.82;
		// }

		vec4 worldposition = vec4(0.0f);
			 worldposition = gbufferModelViewInverse * ssp;		//Transform from screen space to world space


		float yDistanceSquared  = worldposition.y * worldposition.y;

		worldposition = shadowModelView * worldposition;	//Transform from world space to shadow space
		float comparedepth = -worldposition.z;				//Surface distance from sun to be compared to the shadow map

		worldposition = shadowProjection * worldposition;
		worldposition /= worldposition.w;

		float dist = sqrt(worldposition.x * worldposition.x + worldposition.y * worldposition.y);
		float distortFactor = (1.0f - SHADOW_MAP_BIAS) + dist * SHADOW_MAP_BIAS;
		worldposition.xy *= 0.95f / distortFactor;
		worldposition.z = mix(worldposition.z, 0.5, 0.8);
		worldposition = worldposition * 0.5f + 0.5f;		//Transform from shadow space to shadow map coordinates

		float shadowMult = 0.0f;																			//Multiplier used to fade out shadows at distance
		float shading = 0.0f;

		float fademult = 0.15f;
			shadowMult = clamp((shadowDistance * 1.4f * fademult) - (distance * fademult), 0.0f, 1.0f);	//Calculate shadowMult to fade shadows out

		if (shadowMult > 0.0) 
		{

			float diffthresh = dist * 1.0f + 0.10f;
				  diffthresh *= 1.5f / (shadowMapResolution / 2048.0f);
				  //diffthresh /= shadingStruct.direct + 0.1f;


			#ifdef PIXEL_SHADOWS
				  diffthresh += 1.5;
			#endif


			#ifdef ENABLE_SOFT_SHADOWS
			#ifndef VARIABLE_PENUMBRA_SHADOWS

				int count = 0;
				float spread = 1.0f / shadowMapResolution;

				vec3 noise = CalculateNoisePattern1(vec2(0.0), 64.0);

				for (float i = -0.5f; i <= 0.5f; i += 1.0f) 
				{
					for (float j = -0.5f; j <= 0.5f; j += 1.0f) 
					{
						float angle = noise.x * PI * 2.0;

						mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

						vec2 coord = vec2(i, j) * rot;

						shading += shadow2DLod(shadow, vec3(worldposition.st + coord * spread, worldposition.z - 0.0008f * diffthresh), 0).x;
						count += 1;
					}
				}
				shading /= count;

			#endif
			#endif

			#ifdef VARIABLE_PENUMBRA_SHADOWS

				float vpsSpread = 0.145 / distortFactor;

				float avgDepth = 0.0;
				float minDepth = 11.0;
				int c;

				for (int i = -1; i <= 1; i++)
				{
					for (int j = -1; j <= 1; j++)
					{
						vec2 lookupCoord = worldposition.xy + (vec2(i, j) / shadowMapResolution) * 8.0 * vpsSpread;
						//avgDepth += pow(texture2DLod(shadowtex1, lookupCoord, 2).x, 4.1);
						float depthSample = texture2DLod(shadowtex1, lookupCoord, 2).x;
						minDepth = min(minDepth, depthSample);
						avgDepth += pow(min(max(0.0, worldposition.z - depthSample) * 1.0, 0.025), 2.0);
						c++;
					}
				}

				avgDepth /= c;
				avgDepth = pow(avgDepth, 1.0 / 2.0);

				// float penumbraSize = min(abs(worldposition.z - minDepth), 0.15);
				float penumbraSize = avgDepth;

				//if (mask.leaves > 0.5)
				//{
					//penumbraSize = 0.02;
				//}

				int count = 0;
				float spread = penumbraSize * (0.125 + ifcloudShadow * 1.875) * min(0.2, vpsSpread) + 0.25 / shadowMapResolution;
				spread += dist * 2.0 / shadowMapResolution;
				//spread = min(0.01, spread);
				//vec3 noise = CalculateNoisePattern1(vec2(0.0 + sin(frameTimeCounter)), 64.0);
				#ifdef TAA_ENABLED
					vec2 noise = rand(texcoord.st + sin(frameTimeCounter)).xy;
				#else
					vec2 noise = rand(texcoord.st).xy;
				#endif
				
				// worldposition.z -= (1.0 / shadowMapResolution) * noise.x * dist;

				diffthresh *= 0.5 + avgDepth * 50.0;

				for (float i = -1.5f; i <= 1.5f; i += 1.0f) 
				{
					for (float j = -1.5f; j <= 1.5f; j += 1.0f) 
					{
						float angle = noise.x * PI * 2.0;

						mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

						vec2 coord = vec2(i + noise.y - 0.5, j + noise.y - 0.5) * rot;

						shading += shadow2DLod(shadow, vec3(worldposition.st + coord * spread, worldposition.z - 0.0012f * diffthresh), 0).x;
						count += 1;
					}
				}
				shading /= count;

				// float clampFactor = (1.0 / (penumbraSize * 2000.0 + 0.001)) + 1.0;
				// shading = saturate(((shading * 2.0 - 1.0) * clampFactor) * 0.5 + 0.5);

			#endif

			#ifndef VARIABLE_PENUMBRA_SHADOWS
			#ifndef ENABLE_SOFT_SHADOWS
				//diffthresh *= 2.0f;
				shading = shadow2DLod(shadow, vec3(worldposition.st, worldposition.z - 0.0006f * diffthresh), 0).x;
			#endif
			#endif

		}

		//shading = mix(1.0f, shading, shadowMult);

		//surface.shadow = shading;

		float clampFactor = max(0.0, dist - 0.1) * 5.0 + 1.0;
		shading = saturate(((shading * 2.0 - 1.0) * clampFactor) * 0.5 + 0.5);

		vec3 result = vec3(shading);


		///*
		#ifdef COLORED_SHADOWS

		float shadowNormalAlpha = texture2DLod(shadowcolor1, worldposition.st, 0).a;

		if (shadowNormalAlpha < 0.1)
		{
			#ifdef TAA_ENABLED
				vec2 noise = rand(texcoord.st + sin(frameTimeCounter)).xy;
			#else
				vec2 noise = rand(texcoord.st).xy;
			#endif

			float angle = noise.x * 3.142 * 2.0;
			mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

			float solidShadowSum = 0.0;
			vec3 shadowColorSampleSum = vec3(0.0);

			int c = 0;

			for (float i = -1.5f; i <= 1.5f; i += 1.0f) 
			{
				for (float j = -1.5f; j <= 1.5f; j += 1.0f) 
				{
					// worldposition.st += (vec2(i, j) * rot) * (0.5 / shadowMapResolution);
					worldposition.st += (vec2(i + (noise.y - 0.5) * 0.7, j + (noise.y - 0.5) * 0.7) * rot) * (0.5 / shadowMapResolution);

					vec4 shadowColorSample = texture2DLod(shadowcolor, worldposition.st, 0);
					float opacityCheck = 1.0 - saturate(pow(shadowColorSample.a * 1.1, 4.0));
					// result = mix(vec3(1.0), pow(shadowColorSample.rgb, vec3(1.6)) * (opacityCheck), vec3(1.0 - shading));
					shadowColorSampleSum += pow(shadowColorSample.rgb, vec3(1.6)) * (opacityCheck);
					float solidDepth = texture2DLod(shadowtex1, worldposition.st, 0).x;
					float solidShadow = 1.0 - clamp((worldposition.z - solidDepth) * 5200.0, 0.0, 1.0); 
					solidShadowSum += solidShadow;
					// result *= solidShadow;
					c++;
				}
			}

			solidShadowSum /= c;
			shadowColorSampleSum /= c;

			result = mix(vec3(1.0), shadowColorSampleSum.rgb, vec3(1.0 - shading));
			result *= solidShadowSum;
		}
		#endif
		//*/

		result = mix(vec3(1.0), result, shadowMult);

		//result = pow(result, vec3(0.1));
		//result = smoothstep(vec3(0.0), vec3(1.0), result);


		return result;
	//} else {
	//	return vec3(0.0f);
	//}
}

float RenderSunDisc(vec3 worldDir, vec3 sunDir)
{
	float d = dot(worldDir, sunDir);

	float disc = 0.0;

	//if (d > 0.99)
	//	disc = 1.0;

	float size = 0.0001;
	float hardness = 50000.0;

	disc = pow(curve(saturate((d - (1.0 - size)) * hardness)), 2.0);

	float visibility = curve(saturate(worldDir.y * 400.0));

	disc *= visibility;

	return disc;
}



vec4 BilateralUpsample(const in float scale, in vec2 offset, in float depth, in vec3 normal, float dist)
{
    /*
	vec2 recipres = vec2(1.0f / viewWidth, 1.0f / viewHeight);

	vec4 light = vec4(0.0f);
	float weights = 0.0f;
    float dither2 = BlueNoise(texcoord.st) - 0.5;
	float dither1 = BlueNoise(texcoord.st + 16.0 * recipres) - 0.5;
	vec2 border = vec2(exp2(-scale)) - recipres * 2.0;

		for (int j = 0; j < 4; j++)
		{
			vec2 coord = offsetUV5[j] * recipres * 20.0f * vec2(BlueNoise(texcoord.st), BlueNoise(texcoord.st + 16.0 * recipres));	    
			vec2 sampleCoord = clamp(texcoord.st * exp2(-scale) + coord.st, vec2(0.0), border);
			vec2 sampleCoord1 = clamp(texcoord.st * exp2(-scale) + coord.st * 0.2, vec2(0.0), border);
			vec2 sampleCoord2 = clamp(texcoord.st + coord.st * exp2(scale), vec2(0.0), border * exp2(scale));
				
			float sampleDepth = GetDepthLinear(sampleCoord2);
			//float sampleDepth = GetDepthLinear(sampleCoord2.st);
			vec3 sampleNormal = GetNormals(sampleCoord2 + vec2(0.0, 0.0) * exp2(-scale));
			vec3 sampleDitheredColor = texture2DLod(gaux3, texcoord.st * exp2(-scale) + coord, 0).xyz;	
			vec3 sampleColor = texture2DLod(gaux3, texcoord.st * exp2(-scale), 0).xyz;			
			//vec3 sampleNormal = texture2DLod(gaux3, sampleCoord.st + exp2(-scale) * vec2(1.0, 0.0), 0).xyz;			
			//vec3 sampleNormal = texture2DLod(gaux3, texcoord.st * exp2(-scale) + coord, 0).xyz;					
			float weight = 1.0f;
			      weight *= saturate(1.0f - abs(sampleDepth - depth) * 0.5);
				  //weight *= 1.0 / (pow(abs(sampleDepth - depth) * 1000.0f, 2.0f) + 0.001f);
				  weight *= saturate(pow(saturate(dot(normal, sampleNormal * 2.0 - 1.0)), 1.0));
				  //weight *= saturate(pow(saturate(dot(sampleColor, sampleDitheredColor * 1.0 - 0.0)), 1.0));				  
				  weight *= saturate(exp2(-length(coord) * length(coord) * 0.1));
			//weight = 1.0f;

			light.rgb += pow(texture2DLod(gaux3, sampleCoord.st, 1).rgb, vec3(2.2f, 2.2f, 2.2f)) * (weight + 1e-20);
            light.a += texture2DLod(gaux3, sampleCoord1.st, 1).a * (weight + 1e-20);
			weights += weight;
		}
	


	light /= max(0.000001f, weights);
    //if(weights < 1e-3){
	//   light =	pow(texture2DLod(gaux3, (texcoord.st) * (1.0f / exp2(scale 	)) + offset, 4), vec4(2.2f, 2.2f, 2.2f, 1.0f));
	//}
	light.rgb =	mix(pow(texture2DLod(gaux3, (texcoord.st) * (1.0f / exp2(scale 	)) + offset, 3), vec4(2.2f, 2.2f, 2.2f, 1.0f)).rgb, light.rgb, saturate(weights));
    light.a =	mix(pow(texture2DLod(gaux3, (texcoord.st) * (1.0f / exp2(scale 	)) + offset, 2), vec4(2.2f, 2.2f, 2.2f, 1.0f)).a, light.a, saturate(weights));
	


	// vec3 light =	texture2DLod(gcolor, (texcoord.st) * (1.0f / pow(2.0f, 	scale 	)) + 	offset, 2).rgb;

  
	return light;
	*/
	vec2 recipres = vec2(1.0f / viewWidth, 1.0f / viewHeight);

	vec4 light = vec4(0.0f);
	float weights = 0.0f;
    float dither2 = BlueNoise(texcoord.st) - 0.5;
	float dither1 = BlueNoise(texcoord.st + 16.0 / vec2(viewWidth, viewHeight)) - 0.5;
	for (float i = -0.5f; i <= 0.5f; i += 1.0f)
	{
		for (float j = -0.5f; j <= 0.5f; j += 1.0f)
		{
			vec2 coord = vec2(i + dither2, j + dither1) * recipres * 16.0f;

			float sampleDepth = GetDepthLinear(texcoord.st + coord * 2.0f * (exp2(scale)));
			vec3 sampleNormal = GetNormals(texcoord.st + coord * 2.0f * (exp2(scale)));
			//float weight = 1.0f / (pow(abs(sampleDepth - depth) * 1000.0f, 2.0f) + 0.001f);
			float weight = clamp(1.0f - abs(sampleDepth - depth) / 2.0f, 0.0f, 1.0f);
				  weight *= max(0.0f, dot(sampleNormal, normal) * 2.0f - 1.0f);
			//weight = 1.0f;

			light.rgb += pow(texture2DLod(gaux3, (texcoord.st) * (1.0f / exp2(scale )) + offset + coord, 1).rgb, vec3(2.2f)) * weight;
			light.a   +=     texture2DLod(gaux3, (texcoord.st) * (1.0f / exp2(scale )) + offset + coord * 0.15, 1).a * weight;

			weights += weight;
		}
	}


	light /= max(0.00001f, weights);

	if (weights < 0.01f)
	{
		light =	pow(texture2DLod(gaux3, (texcoord.st) * (1.0f / exp2(scale 	)) + offset, 2), vec4(2.2f, 2.2f, 2.2f, 1.0f));
	}


	// vec3 light =	texture2DLod(gcolor, (texcoord.st) * (1.0f / pow(2.0f, 	scale 	)) + 	offset, 2).rgb;


	return light;
}

vec4 GetGI(vec3 albedo, vec3 normal, float depth, float skylight, float dist)
{
	depth = ExpToLinearDepth(depth);

	vec4 indirectLight = BilateralUpsample(GI_RENDER_RESOLUTION, vec2(0.0f, 0.0f), depth, normal, dist);
    //if(texcoord.s>0.5)
	//{
	//  indirectLight = pow(texture2D(gaux3, texcoord.st / exp2(GI_RENDER_RESOLUTION)), vec4(vec3(2.2),1.0));	
	//}

    	
	indirectLight.rgb = length(indirectLight.rgb) * pow(normalize(indirectLight.rgb + 1e-9), vec3(1.0 / 2.2));	
	indirectLight.rgb = mix(indirectLight.rgb, vec3(dot(indirectLight.rgb, vec3(0.3333))), vec3(-0.8));

	indirectLight.rgb *= albedo;
	
	indirectLight.rgb *= mix(saturate(skylight * 7.0), 1.0, saturate(pow(eyeBrightnessSmooth.y / 240.0f, 6.0))) * colorSunlight * 200.0;
	
    //indirectLight.rgb *= saturate(skylight * 8.0) * colorSunlight;
	
	//indirectLight.rgb /= 1e-3;
    indirectLight.rgb = saturate(indirectLight.rgb);
	return indirectLight;
}

vec3 GetWavesNormal(vec3 position) {

	vec2 coord = position.xz / 40.0;
	coord.xy -= position.y / 40.0;
	//coord -= floor(coord);

	coord = mod(coord, vec2(1.0));


	float texelScale = 4.0;

	//to fix color error with GL_CLAMP
	coord.x = coord.x * ((viewWidth - 1 * texelScale) / viewWidth) + ((0.5 * texelScale) / viewWidth);
	coord.y = coord.y * ((viewHeight - 1 * texelScale) / viewHeight) + ((0.5 * texelScale) / viewHeight);


	vec3 normal;
	//normal.xyz = ((texture2DLod(gaux4, coord, 2).xyz) * 2.0 - 1.0);
	normal.xyz = DecodeNormal(texture2DLod(gaux1, coord, 2).zw);

	return normal;
}

vec3 FakeRefract(vec3 vector, vec3 normal, float ior)
{
	return refract(vector, normal, ior);
	//return vector + normal * 0.5;
}

float CalculateWaterCaustics(vec4 screenSpacePosition, MaterialMask mask)
{
	//if (shading.direct <= 0.0)
	//{
	//	return 0.0;
	//}
	if (isEyeInWater == 1)
	{
		if (mask.water > 0.5)
		{
			return 1.0;
		}
	}
	vec4 worldPos = gbufferModelViewInverse * screenSpacePosition;
	worldPos.xyz += cameraPosition.xyz;

	vec2 dither = vec2(BlueNoise(texcoord.st));
	// float waterPlaneHeight = worldPos.y + 8.0;
	float waterPlaneHeight = 63.0;

	// vec4 wlv = shadowModelViewInverse * vec4(0.0, 0.0, 1.0, 0.0);
	vec4 wlv = gbufferModelViewInverse * vec4(lightVector.xyz, 0.0);
	vec3 worldLightVector = -normalize(wlv.xyz);
	// worldLightVector = normalize(vec3(-1.0, 1.0, 0.0));

	float pointToWaterVerticalLength = min(abs(worldPos.y - waterPlaneHeight), 2.0);
	vec3 flatRefractVector = FakeRefract(worldLightVector, vec3(0.0, 1.0, 0.0), 1.0 / 1.3333);
	float pointToWaterLength = pointToWaterVerticalLength / -flatRefractVector.y;
	vec3 lookupCenter = worldPos.xyz - flatRefractVector * pointToWaterLength;


	const float distanceThreshold = 0.15;

	const int numSamples = 1;
	int c = 0;

	float caustics = 0.0;
	for (int i = -numSamples; i <= numSamples; i++)
	{
		for (int j = -numSamples; j <= numSamples; j++)
		{
			vec2 offset = vec2(i + dither.x, j + dither.y) * 0.2;
			vec3 lookupPoint = lookupCenter + vec3(offset.x, 0.0, offset.y);
			// vec3 wavesNormal = normalize(GetWavesNormal(lookupPoint).xzy + vec3(0.0, 1.0, 0.0) * 100.0);
			vec3 wavesNormal = GetWavesNormal(lookupPoint).xzy;
			vec3 refractVector = FakeRefract(worldLightVector.xyz, wavesNormal.xyz, 1.0 / 1.3333);
			float rayLength = pointToWaterVerticalLength / refractVector.y;
			vec3 collisionPoint = lookupPoint - refractVector * rayLength;

			//float dist = distance(collisionPoint, worldPos.xyz);
			float dist = dot(collisionPoint - worldPos.xyz, collisionPoint - worldPos.xyz) * 7.1;

			caustics += 1.0 - saturate(dist / distanceThreshold);

			c++;
		}
	}

	caustics /= c;

	caustics /= distanceThreshold;


	return pow(caustics * 2.0, 1.0);
}

vec3  	GetWaterNormals(in vec2 coord) {				//Function that retrieves the screen space surface normals. Used for lighting calculations
	return DecodeNormal(texture2D(gaux1, coord).xy);
}

void WaterFog(inout vec3 color, in MaterialMask mask, float waterSkylight, float waterTorchlight, vec4 viewSpacePositionSolid, vec4 viewSpacePosition)
{
	if (mask.water > 0.5 || isEyeInWater > 0 || mask.ice > 0.5)
	{
		vec3 viewVector = normalize(viewSpacePosition.xyz);

		float waterDepth = distance(viewSpacePosition.xyz, viewSpacePositionSolid.xyz);
		if (isEyeInWater > 0)
		{
			waterDepth = length(viewSpacePosition.xyz) * 0.5;		
			if (mask.water > 0.5 || mask.ice > 0.5)
			{
				waterDepth = length(viewSpacePosition.xyz) * 0.5;		
			}	
		}

		float fogDensity = 0.03;

		vec3 waterNormal = normalize(GetWaterNormals(texcoord.st * SCLE));

		// vec3 waterFogColor = vec3(1.0, 1.0, 0.1);	//murky water
		// vec3 waterFogColor = vec3(0.2, 0.95, 0.0) * 1.0; //green water
		// vec3 waterFogColor = vec3(0.4, 0.95, 0.05) * 2.0; //green water
		// vec3 waterFogColor = vec3(0.7, 0.95, 0.00) * 0.75; //green water
		// vec3 waterFogColor = vec3(0.2, 0.95, 0.4) * 5.0; //green water
		 vec3 waterFogColor = vec3(0.2, 0.8, 1.0) * 1.0; //clear water
		 vec3 waterFogColor2 = vec3(1.0, 1.0, 0.1) * 1.0; //clear water		 
		// vec3 waterFogColor = vec3(0.1, 0.9, 1.0); //clear water
			if (mask.ice > 0.5)
			{
				waterFogColor = vec3(0.2, 0.6, 1.0) * 10.0;
				fogDensity = 0.35;
			}
			  waterFogColor *= 0.01 * dot(vec3(0.33333), colorSunlight * 1.59);
			   waterFogColor *= (1.0 - rainStrength * 0.95);
			  waterFogColor *= isEyeInWater * 2.0 + 1.0;

		if (isEyeInWater == 0)
		{
			waterFogColor *= waterSkylight;
		}
		else
		{
			waterFogColor *= 0.5;
			//waterFogColor *= pow(eyeBrightnessSmooth.y / 240.0f, 6.0f);

			vec3 waterSunlightVector = refract(-lightVector, upVector, 1.0 / WATER_REFRACT_IOR);

			//waterFogColor *= (dot(lightVector, viewVector) * 0.5 + 0.5) * 2.0 + 1.0;
			float scatter = 1.0 / (pow(saturate(dot(waterSunlightVector, viewVector) * 0.5 + 0.5) * 20.0, 1.0) + 0.1);
			vec3 waterSunlightScatter = colorSunlight * scatter * 1.0 * waterFogColor * 20.0;

			float eyeWaterDepth = eyeBrightnessSmooth.g / 240.0;

			waterFogColor *= dot(viewVector, upVector) * 0.5 + 0.5;
			waterFogColor = waterFogColor * pow(eyeWaterDepth, 1.0f) + waterSunlightScatter * pow(eyeWaterDepth, 1.0);
			//waterFogColor = waterFogColor + waterSunlightScatter;
		

			waterFogColor *= pow(vec3(0.4, 0.72, 1.0), vec3(0.2 + (1.0 - eyeWaterDepth)));

			fogDensity *= 0.5;
		}
		
		if (isEyeInWater == 0)
		{
			waterFogColor2 *= waterTorchlight;
		}
		else
		{
			waterFogColor2 *= 0.5;

			float eyeWaterDepth = waterTorchlight;

			waterFogColor2 = waterFogColor2 * pow(eyeWaterDepth, 1.0f);
		
			//waterFogColor2 *= pow(vec3(0.4, 0.72, 1.0), vec3(0.2 + (1.0 - eyeWaterDepth)));
		}
		
        //waterTorchlight;
		float visibility = exp2(-waterDepth * fogDensity);
		float visibility2 = exp2(-waterDepth * fogDensity);

		vec3 viewVectorRefracted = refract(viewVector, waterNormal, 1.0 / 1.33);
		float scatter = 1.0 / (pow(saturate(dot(-lightVector, viewVectorRefracted) * 0.5 + 0.5) * 20.0, 2.0) + 0.1);
		//vec3 reflectedLightVector = reflect(lightVector, upVector);
			  //scatter += (1.0 / (pow(saturate(dot(-reflectedLightVector, viewVectorRefracted) * 0.5 + 0.5) * 30.0, 2.0) + 0.1)) * saturate(1.0 - dot(lightVector, upVector) * 1.4);

		// scatter += pow(saturate(dot(-lightVector, viewVectorRefracted) * 0.5 + 0.5), 3.0) * 0.02;
		if (isEyeInWater < 1)
		{
			waterFogColor = mix(waterFogColor, colorSunlight * 20.0 * waterFogColor, vec3(scatter));
		}

		// color *= pow(vec3(0.7, 0.88, 1.0) * 0.99, vec3(waterDepth * 0.45 + 0.2));
		// color *= pow(vec3(0.7, 0.88, 1.0) * 0.99, vec3(waterDepth * 0.45 + 1.0));
		 color *= pow(vec3(0.5, 0.8, 1.0), vec3(waterDepth * 0.25 + 0.25));
		// color *= pow(vec3(0.7, 1.0, 0.2) * 0.8, vec3(waterDepth * 0.15 + 0.1));
		color = mix(waterFogColor * 20.0, color, saturate(visibility)) + waterFogColor2 * 1e-2;





	}
}

vec3 ProjectBack(vec3 cameraSpace) 
{
    vec4 clipSpace = gbufferProjection * vec4(cameraSpace, 1.0);
    vec3 NDCSpace = clipSpace.xyz / clipSpace.w;
    vec3 screenSpace = 0.5 * NDCSpace + 0.5;
		 //screenSpace.z = 0.1f;
    return screenSpace;
}

float GetAO(vec2 coord, vec3 normal, float dither, float ln)
{
	const int numRays = 0;

	const float phi = 1.62;
	const float gAngle = phi * 3.1416;

	float depth = GetDepth(coord);
	float linDepth = ExpToLinearDepth(depth);
	vec3 origin = GetViewPosition(coord, depth).xyz;

	float aoAccum = 0.0;

	float radius = saturate(ln);
	
	for (int i = 0; i < numRays; i++)
	{
		float fi = float(i) + dither;
		float fiN = fi / float(numRays);
		float lon = gAngle * fi * 6.0;
		float lat = asin(fiN * 2.0 - 1.0) * 1.0;

		vec3 kernel;
		kernel.x = cos(lat) * cos(lon);
		kernel.z = cos(lat) * sin(lon);
		kernel.y = sin(lat);

		kernel.xyz = normalize(kernel.xyz + normal.xyz);

		float sampleLength = radius * mod(fiN, 0.07) / 0.07;

		vec3 samplePos = origin + kernel * sampleLength;

		vec3 samplePosProj = ProjectBack(samplePos);


		samplePosProj *= -1.0;
		TemporalJitterProjPos(samplePosProj);
		samplePosProj *= -1.0;
		
		/*
		float sampleDepth = ExpToLinearDepth(GetDepth(samplePosProj.xy));

		float kernelAngle = dot(kernel, normal);

		if (sampleDepth < linDepth && kernelAngle > 0.0)
		{
			aoAccum += 1.0 * saturate(kernelAngle) * saturate(abs(sampleDepth - linDepth) * 50.0);
		}
		*/

		vec3 actualSamplePos = GetViewPosition(samplePosProj.xy, GetDepth(samplePosProj.xy)).xyz;

		float depthDiff = actualSamplePos.z - samplePos.z;

		if (depthDiff > 0.0 && depthDiff < 1.0)
		{
			//aoAccum += 1.0 * saturate(depthDiff * 100.0) * saturate(1.0 - depthDiff * 0.25 / (sampleLength + 0.001));
			aoAccum += 1.0;
		}
	}

	aoAccum /= numRays;

	float ao = 1.0 - saturate(aoAccum - 0.0);
	ao = pow(ao, 1.5);

	return ao;
}

float ScreenSpaceShadow(vec3 origin, vec3 normal, MaterialMask mask)
{
	if (mask.sky > 0.5
	// || rainStrength >= 0.999
	)
	{
		return 1.0;
	}

	if (isEyeInWater > 0.5)
	{
		//origin.xy *=
	}

	vec3 viewDir = normalize(origin.xyz);


	float nearCutoff = 0.50;
	float traceBias = 0.015;


	//Prevent self-intersection issues
	float viewDirDiff = dot(fwidth(viewDir), vec3(0.333));

    vec3 lightDir = lightVector;
	vec3 rayPos = origin;
	vec3 rayDir = lightDir * 0.01;
	rayDir *= viewDirDiff * 1500.0;
	rayDir *= -origin.z * 0.25 + nearCutoff;


	rayPos += rayDir * -origin.z * 0.000037 * traceBias;


#ifdef TAA_ENABLED
	float randomness = rand(texcoord.st + sin(frameTimeCounter)).x * 1.0f;
#else
	float randomness = 0.0;
#endif

	rayPos += rayDir * randomness;



	float zThickness = 0.03 * -origin.z;

	float shadow = 1.0;

	float numSamplesf = 64.0;

	int numSamples = int(numSamplesf);


	float shadowStrength = 0.8;

	if (mask.grass > 0.5)
	{
		shadowStrength = 0.4;
	}
	if (mask.leaves > 0.5)
	{
		shadowStrength = 0.5;
	}

	// vec3 prevRayProjPos = ProjectBack(rayPos);

	for (int i = 0; i < 5; i++)
	{
		float fi = float(i) / float(5);

		rayPos += rayDir;

		vec3 rayProjPos = ProjectBack(rayPos);

		rayProjPos.xy *= -1.0;
		TemporalJitterProjPos(rayProjPos);
		rayProjPos.xy /= -1.0;

		// vec2 pixelPos = floor(rayProjPos.xy * vec2(viewWidth, viewHeight));
		// vec2 pixelPosPrev = floor(prevRayProjPos.xy * vec2(viewWidth, viewHeight));
		// if (pixelPos.x == pixelPosPrev.x || pixelPos.y == pixelPosPrev.y)
		// {
		// 	continue;
		// }

		// prevRayProjPos = rayProjPos;

		/*
		float sampleDepth = GetDepthLinear(rayProjPos.xy);

		float depthDiff = -rayPos.z - sampleDepth;
		*/

		vec3 samplePos = GetViewPositionRaw(rayProjPos.xy, GetDepth(rayProjPos.xy)).xyz;

		float depthDiff = samplePos.z - rayPos.z - 0.02 * -origin.z * traceBias;

		if (depthDiff > 0.0 && depthDiff < zThickness)
		{
			shadow *= 1.0 - shadowStrength;
		}
	}

	return shadow;
}


const int Qt = 1;
float ScreenSpaceShadow2(vec3 origin, vec3 normal, MaterialMask mask, int num)
{
	const float phi = 1.618033988;
	const float gAngle = phi * 3.14159265 * 1.0003;
	vec3 viewDir = normalize(origin.xyz);


	float nearCutoff = 0.50;
	float traceBias = 0.015;


	//Prevent self-intersection issues
	float viewDirDiff = dot(fwidth(viewDir), vec3(0.333333));

		float fi = float(num) + BlueNoise(texcoord.st + 0.131);
		float fiN = fi / float(Qt);
		float lon = gAngle * fi * 6.0;
		float lat = asin(fiN * 2.0 - 1.0) * 1.0;
		vec3 kernel;
		kernel.x = cos(lat) * cos(lon);
		kernel.z = cos(lat) * sin(lon);
		kernel.y = sin(lat);
		kernel.xyz = normalize(normal.xyz + kernel.xyz);
	vec3 rayPos = origin;
	vec3 rayDir = (vec3(0.0, 1.0, 0.0) + kernel.xyz) * 0.025;
	rayDir *= viewDirDiff * 1500.001;
	rayDir *= -origin.z * 0.15 + nearCutoff;


	rayPos += rayDir * -origin.z * 0.000037 * traceBias;


#ifdef TAA_ENABLED
	float randomness = BlueNoise(texcoord.st + 0.121);
#else
	float randomness = 0.0;
#endif

	rayPos += rayDir * randomness;



	float zThickness = 0.015 * -origin.z;

	float shadow = 1.0;

	float numSamplesf = 64.0;
	//numSamplesf /= -origin.z * 0.125 + nearCutoff;

	int numSamples = int(numSamplesf);


	float shadowStrength = 0.9;

	if (mask.grass > 0.5)
	{
		shadowStrength = 0.4;
	}
	if (mask.leaves > 0.5)
	{
		shadowStrength = 0.5;
	}

	// vec3 prevRayProjPos = ProjectBack(rayPos);

	for (int i = 0; i < 0; i++)
	{
		float fi = float(i) / float(2);

		rayPos += rayDir;

		vec3 rayProjPos = ProjectBack(rayPos);


		rayProjPos.xy *= -1.0;
		TemporalJitterProjPos(rayProjPos);
		rayProjPos.xy /= -1.0;

		vec3 samplePos = GetViewPositionRaw(rayProjPos.xy, GetDepth(rayProjPos.xy)).xyz;

		float depthDiff = samplePos.z - rayPos.z - 0.02 * -origin.z * traceBias;

		if (depthDiff > 0.0 && depthDiff < zThickness)
		{
			shadow *= 1.0 - shadowStrength;
		}
	}
	return shadow;
}

float finalscreenspaceshadow2(vec3 origin, vec3 normal, MaterialMask mask, float l)
{
 float S = 0.0f;
 	for (int i = 0; i < Qt; i++)
	{
      S += ScreenSpaceShadow2(origin, normal, mask, i);
	}
	S /= Qt;
	S = max(pow(S, 2.5f), saturate(l * 0.5));
  return S;	
}

float ScreenSpaceShadow3(vec3 origin, vec3 normal, MaterialMask mask)
{
	if (mask.sky > 0.5
	)
	{
		return 1.0;
	}

	//origin.z *= 2.0;
	const float phi = 1.61803;
	const float gAngle = phi *  3.14254;
	float dither = BlueNoiseTemporal(texcoord.st).x;
	float f = float(1) + dither;
	float fiN = f / float(2);
	float lon = gAngle * f * 6.0;
	float lat = asin(fiN * 2.0 - 1.0) * 1.0;

	vec3 kernel;
	kernel.x = cos(lat) * cos(lon);
	kernel.z = cos(lat) * sin(lon);
	kernel.y = sin(lat);
	//kernel.xyz
	
	vec3 viewDir = normalize(origin.xyz + (rand(texcoord.st + sin(frameTimeCounter)) * 2.0 - 1.0) * 0.0);


	float nearCutoff = 0.50;
	float traceBias = 0.015;


	//Prevent self-intersection issues
	float viewDirDiff = dot(fwidth(viewDir), vec3(0.333333));


	vec3 rayPos = origin;
	vec3 rayDir = lightVector * 0.01;
	rayDir *= viewDirDiff * 1500.001;
	rayDir *= -origin.z * 0.28 + nearCutoff;


	rayPos += rayDir * -origin.z * 0.000037 * traceBias;

	float randomness = BlueNoise(texcoord.st + 0.117);

	rayPos += rayDir * randomness;



	float zThickness = -origin.z;

	float shadow = 1.0;

	float numSamplesf = 64.0;
	//numSamplesf /= -origin.z * 0.125 + nearCutoff;

	int numSamples = int(numSamplesf);


	float shadowStrength = 0.9;

	if (mask.grass > 0.5)
	{
		shadowStrength = 0.6;
	}
	if (mask.leaves > 0.5)
	{
		shadowStrength = 0.8;
	}

	for (int i = 0; i < 0; i++)
	{
		float fi = float(i) / float(2);

		rayPos += rayDir;

		vec3 rayProjPos = ProjectBack(rayPos);

		rayProjPos.xy *= -1.0;
		TemporalJitterProjPos(rayProjPos);
		rayProjPos.xy /= -1.0;

		vec3 samplePos = GetViewPositionRaw(rayProjPos.xy, GetDepth(rayProjPos.xy)).xyz;

		float depthDiff = samplePos.z
		- rayPos.z - 0.02 * -origin.z * traceBias
		;

		if (depthDiff > 0.0 && depthDiff < zThickness)
		{
			shadow *= 1.0 - shadowStrength;
		}
	}

	return shadow;
}

vec3 OrenNayar(vec3 normal, vec3 eyeDir, vec3 lightDir, vec3 albedo)
{
  float roughness = 0.55;

	float NdotL = dot(normal, lightDir);
	float NdotV = max(1e-6, dot(normal, eyeDir));
    float NdotH = max(-(clamp(NdotV * 1e35, 0.0, 1.0) * 2.0 - 1.0), (NdotL + NdotV) / NdotV);
	
	float LdotV = length(lightDir + eyeDir);
    float LdotH = 0.5 * LdotV;
	
	float angleVN = acos(NdotV);
	float angleLN = acos(NdotL);

	float alpha = max(angleVN, angleLN);
	float beta = min(angleVN, angleLN);
	float gamma = dot(eyeDir - normal * dot(eyeDir, normal), lightDir - normal * dot(lightDir, normal));

	float roughnessSquared = roughness * roughness;

	// calculate A and B
	float A = 1.0 - 0.5 * (roughnessSquared / (roughnessSquared + 0.57));

	float B = 0.45 * (roughnessSquared / (roughnessSquared + 0.09));

	float C = sin(alpha) * tan(beta);

	// put it all together
	float L1 = max(0.0, NdotL) * (A + B * max(0.0, gamma) * C);

    vec3 result = L1 * vec3(1.0);	
	return result;
}


void LandAtmosphericScattering(inout vec3 color, in vec3 viewPos, in vec3 viewDir)
{
	float dist = length(viewPos);

	float fogDensity = 0.003 * RAYLEIGH_AMOUNT;
	float fogFactor = pow(1.0 - exp(-dist * fogDensity), 2.0);


	vec3 absorption = vec3(0.2, 0.45, 1.0);

	color *= exp(-dist * absorption * fogDensity * 0.27);
	color += max(vec3(0.0), vec3(1.0) - exp(-fogFactor * absorption)) * mix(colorSunlight, vec3(dot(colorSunlight, vec3(0.33333))), vec3(0.9)) * 2.0;

	float VdotL = dot(viewDir, sunVector);

	float g = 0.72;
				//float g = 0.9;
	float g2 = g * g;
	float theta = VdotL * 0.5 + 0.5;
	float anisoFactor = 1.5 * ((1.0 - g2) / (2.0 + g2)) * ((1.0 + theta * theta) / (1.0 + g2 - 2.0 * g * theta)) + g * theta;

	color += colorSunlight * fogFactor * 0.2 * anisoFactor;

}

void ContextualFog(inout vec3 color, in vec3 viewPos, in vec3 viewDir, float density)
{
	float dist = length(viewPos);

	float fogDensity = density * 0.019;
		  fogDensity *= 1.0 -  saturate(viewDir.y * 0.5 + 0.5) * exp(-density * 0.125);
		  fogDensity *= mix(0.0f, 1.0f, pow(eyeBrightnessSmooth.y / 240.0f, 6.0f));

	float fogFactor = pow(1.0 - exp(-dist * fogDensity), 1.6);
		  //fogFactor = 1.0 -  saturate(viewDir.y * 0.5 + 0.5);




	vec3 fogColor = pow(gl_Fog.color.rgb, vec3(2.2));


	float VdotL = dot(viewDir, worldSunVector);

	float g = 0.72;
				//float g = 0.9;
		  //g = exp(-density) * 0.4 + 0.5;

	float g2 = g * g;
	float theta = VdotL * 0.5 + 0.5;
	float anisoFactor = 1.5 * ((1.0 - g2) / (2.0 + g2)) * ((1.0 + theta * theta) / (1.0 + g2 - 2.0 * g * theta)) + g * theta;


	float skyFactor = pow(saturate(viewDir.y * 0.5 + 0.5), 2.0);
		  //skyFactor = skyFactor * (3.0 - 2.0 * skyFactor);

	fogColor = colorSunlight * anisoFactor * (1.0 - rainStrength) + skyFactor * colorSkylight * 2.0;

	fogColor *= exp(-density * 1.5) * 2.0;

	color = mix(color, fogColor, fogFactor);

}

float Get2DNoise(in vec3 pos)
{
	pos.xy = pos.xz;
	pos.xy += 0.5f;

	vec2 p = floor(pos.xy);
	vec2 f = fract(pos.xy);
	//f = smoothstep(vec2(0.0), vec2(1.0), f);
	f = curve(f);
	vec2 uv = p.xy + f.xy;

	 //uv -= 0.5f;

	vec2 coord = (uv + 0.5f) / noiseTextureResolution;
	float xy1 = texture2D(noisetex, coord).x;
	return xy1;
}

float Get2DNoisel(in vec3 pos)
{
	pos.xy = pos.xz;
	pos.xy += 0.5f;

	vec2 p = floor(pos.xy);
	vec2 f = fract(pos.xy);

	vec2 uv = p.xy + f.xy;

	 //uv -= 0.5f;

	vec2 coord = (uv + 0.5f) / noiseTextureResolution;
	float xy1 = texture2D(noisetex, coord).x;
	return xy1;
}

float Get2DNoise2(in vec2 pos)
{

	vec2 p = floor(pos);
	vec2 f = curve(fract(pos));

	vec2 uv =  p.xy + f.xy;
	
	vec2 coord =  (uv + 0.5f) / noiseTextureResolution;
	//float xy1 = mix(rand(coord.st).x, rand(coord.ts).y, rand(coord.st).x);
	float xy1 = texture2D(noisetex, coord).x;
	return xy1;
}

float Get3DNoiseSmooth(in vec3 pos){
    vec3 p = floor(pos);
	vec3 b = curve(pos - p);
    
	vec2 uv = p.xy + b.xy - 17.0f * p.z;
    vec2 rg = rand((uv + 0.5) / noiseTextureResolution * 0.00001).xy;

    return mix(rg.x, rg.y, b.z);
}

float C3DNoise(vec3 position){
    vec3 p = floor(position);
    vec3 b = 
	//curve(
	fract(position)
	//)
	;

    vec2 uv = vec2(-17.0) * p.z + p.xy + b.xy;
    vec2 rg = texture2D(noisetex, (uv + 0.5) / noiseTextureResolution).xy;

    return mix(rg.x, rg.y, b.z);
}

float Get3DNoise(in vec3 pos)
{ 
    pos += 0.5;
	vec3 p = floor(pos);
	vec3 f = fract(pos);
	f = curve(f);
	vec2 uv =  p.xy + p.z * vec2(-17.0f) + f.xy;
	vec2 uv1 =  p.xy + (p.z + 0.0) * vec2(-17.0f) + f.xy;	
	vec2 coord = (uv + 0.5f) / 64.0;
	vec2 coord1 = (uv1 + 0.5f) / 64.0;	
	float rr = texture2D(noisetex, coord).x;	
	float gg = texture2D(noisetex, coord1).y;		
	return mix(rr, gg, f.z);
}

float Get3DNoise2(in vec3 pos)
{
    pos += 0.5;
	vec3 p = floor(pos);
	vec3 f = fract(pos);
	//f = curve(f);
	vec2 uv =  p.xy + p.z * vec2(17.0f) + f.xy;
	vec2 uv1 =  p.xy + (p.z + 1.0) * vec2(17.0f) + f.xy;	
	vec2 coord = (uv + 0.5f) / 64.0;
	vec2 coord1 = (uv1 + 0.5f) / 64.0;	
	float rr = texture2D(noisetex, coord).x;	
	float gg = texture2D(noisetex, coord1).x;		
	return mix(rr, gg, f.z);
}

float Get3DPWNoise(in vec3 pos)
{   
    float PN = Get3DNoise2(pos);
    float WN = 1.0 - Get3DNoise(pos);	
	return (PN + WN) * 0.53;	
	//return saturate((PN - WN) / (1.0 - WN) * 0.2 + 0.57);
}

float Get2DPWNoise(in vec3 pos)
{   
    float PN = Get2DNoise(pos);
    float WN = 1.0 - Get2DNoisel(pos);	
	return (PN + WN) * 0.52;		
	//return (PN + WN);
}

float Get3DNoise3(in vec3 pos)
{
	pos.z += 0.0f;

	pos.xyz += 0.5f;

	vec3 p = floor(pos);
	vec3 f = fract(pos);

	vec2 uv =  p.xy + p.z * vec2(-17.0f) + f.xy;
	vec2 uv2 = p.xy + (p.z + 0.0) * vec2(-17.0f) + f.xy;

	vec2 coord =  (uv  + 0.5f) / 64.0;
	vec2 coord2 = (uv2 + 0.5f) / 64.0;
	float xy1 = texture2D(noisetex, coord).x;
	float xy2 = texture2D(noisetex, coord2).y;
	return mix(xy1, xy2, f.z);
}

float GetCoverage(in float coverage, in float density, in float clouds)
{
	clouds = clamp(clouds - (1.0f - coverage), 0.0f, 1.0f -density) / (1.0f - density);
		clouds = max(0.0f, clouds * 1.1f - 0.1f);
	 clouds = clouds = clouds * clouds * (3.0f - 2.0f * clouds);
	 // clouds = pow(clouds, 1.0f);
	return clouds;
}

float   CalculateSunglow(vec3 npos, vec3 lightVector) {

	float curve = 4.0f;

	vec3 halfVector2 = normalize(-lightVector + npos);
	float factor = 1.0f - dot(halfVector2, npos);

	return factor * factor * factor * factor;
}

#include "lib/planeclouds.glsl"

const float CMS = VOLUMETRIC_CLOUD_SPEED;
const float Nb = 0.3f;
const float DNb = 0.005f;
const int Nc = 3;
const float CPH2 = 9000.0;

float CloudDensity(vec3 p, vec3 pos2, vec3 worldDir, const int level, const float lunacrity, vec3 worldLightVector, float roughness, float Detail, vec2 O, float RDMap)
{	
	float dist = length(p - cameraPosition);	
	p *= 0.0002; 	
    if(cameraPosition.y > CPH2)
	{
	  worldDir *= vec3(1.0f, -1.0f, 1.0f);
	}		 
	float LdotV = pow(-dot(worldDir, -worldLightVector) * 0.5 + 0.5, 0.2);	

	float n = 0.0;
	float G = 1.0;
	float w = 0.0;	
    float t = -frameTimeCounter * CMS;
	p.xz += vec2(0.1, 0.06) * t;	
	roughness = lunacrity * roughness;
	p.x *= 0.5;
	p.xz += Get2DNoise(p * 16.0) * 0.04;
	p.xz += Get2DNoise(p * 8.0) * 0.02;
	p.xz += Get2DNoise(p * 4.0) * 0.01;
	
	p.z -= p.x * 0.3;
	float lC = saturate(pow(Get2DNoise(p * 0.6 + vec3(t, 0.0f, 0.0f) * 0.4), 1.2) * 1.5 - 0.35) * 0.5 + 0.5;	
	   lC *= saturate(pow(Get2DNoise(p * 0.3 + vec3(t, 0.0f, 0.0f) * 0.4), 1.2) * 1.5 - 0.35) * 0.6 + 0.4;
	p += lC * 0.65;
	int octaves = int(clamp(6.0 - floor(sqrt(dist) * 8e-3), 0.0, 6.0));
	//int octaves = 6; 	 	
	float octScale = 3.0f; 	
	for (int j = 1; j < octaves; j++)
    {	 
		p += n * 0.6f;	
		G *= pow(0.7, float(j));
    	n += Get2DNoise(p)*G;	 
		p *= octScale;	
		G *= 8.0 / octScale * lunacrity;		
		w += G;
		p += n * 0.6f;		
        //octScale *= 1.0;
    } 	
	n /= w;

	//n += Get2DNoise(p);	 
	//n += Get2DNoise(p * 4.0)   * 0.25;	 
	//n += Get2DNoise(p * 16.0)  * 0.0625;	 
	//n += Get2DNoise(p * 64.0)  * 0.0156;	 
	//n += Get2DNoise(p * 256.0) * 0.0039;	 
	
	n = n * 0.7 * (1.+wetness)
	* lC
	// * mix(1.0, LdotV, saturate(worldLightVector.y * 10.0))
	- 0.05;
    //n -= abs(worldDir.y) * 0.01 - 0.01;
    n += 0.05 * wetness;

	return saturate(n);
}

float TraceCloudDensity(vec3 pos, vec3 pos2, vec3 lightDir, vec3 worldDir, float Detail, float cloudDensity, float cloudDist, vec3 worldLightVector, float RDMap)
{
	float shadowFactor = 0.0;
	float r = 1.0;
	for (int i = 1; i <= 0; i++)
	{
	    float fi = float(i);
		vec3 sp = pos + 2000.0 * lightDir * fi;
		float d = max(0.0, CloudDensity(sp, pos2, worldDir, Nc, Nb, worldLightVector, r, 0.0f, vec2(0.1, 0.2), RDMap) - cloudDist * 0.00);
        r *= 0.5;
		shadowFactor += d;		
	}

	return shadowFactor;
}

float TraceRay(vec3 pos, vec3 pos2, vec3 lightDir, vec3 worldDir, float Detail, float cloudDensity, float cloudDist, vec3 worldLightVector, float RDMap)
{
	float shadowFactor = 0.0;
	const int LQnum = 0;
	float dither = BlueNoiseTemporal(texcoord.st).s - 0.5;	
	float r = 1.0;
	float LdotV = dot(-worldDir, -worldLightVector);	
	
	lightDir = lightDir - worldDir / abs(worldDir.y) * timeNoon * 0.4;	
	//lightDir = normalize(lightDir);	
	lightDir *= pow(-LdotV * 0.5 + 0.5, 0.25);
	
	for (int i = 1; i <= LQnum; i++)
	{
	    float fi = pow((float(i) + dither) / float(LQnum), 1.0);
		vec3 sp = pos + 200.0 * lightDir * fi;
		float d = max(0.0, CloudDensity(sp, pos2, worldDir, Nc, Nb, worldLightVector, r, 0.0f, vec2(0.1, 0.2), RDMap));
        //r *= pow(1.0 - cloudDensity * 0.5, 2.0 / float(LQnum));
		shadowFactor += d * 2.0 / float(LQnum);		
	}

	return shadowFactor;
}

float TraceCloudShadow(vec3 pos, vec3 pos2, vec3 lightDir, vec3 worldDir, float Detail, float cloudDensity, float cloudDist, vec3 worldLightVector, float RDMap)
{
	float LdotV = dot(worldDir, -worldLightVector);
	float LdotV01 = LdotV * 0.5 + 0.5;
	float sundiff = TraceRay(pos, pos2, lightDir, worldDir, 0.0f, 1.0f, 0.0f, worldLightVector, 0.0);		 
	float Order = exp2(-sundiff * (1.0 + wetness * 5.0));
    float dist = length(pos - cameraPosition) * 0.0001;
		 dist = 1.0 / (1.0 + dist);	
		 Order = mix(1.0, Order, dist);
	return Order;
}

vec4 CloudColor(in vec4 worldPosition, in float sunglow, in vec3 worldLightVector, in float altitude, in float thickness, const bool isShadowPass, vec3 dir, vec3 atmosphere)
{
    float dist = length(worldPosition.xyz - cameraPosition);
	float cloudHeight = altitude;
	float cloudDepth  = thickness;
	float cloudUpperHeight = cloudHeight + (cloudDepth / 2.0f);
	float cloudLowerHeight = cloudHeight - (cloudDepth / 2.0f);
	
	float normalizedHeight  = saturate(worldPosition.y / 940.0 + abs(dir.y) / (abs(dir.y) + 1.0));
	
	//worldPosition.xz /= 1.0f + max(0.0f, length(worldPosition.xz - cameraPosition.xz) / 5000.0f);
	float LdotV = dot(dir, -worldLightVector);
	float LdotV01 = LdotV * 0.5 + 0.5;
	float LdotV2 = LdotV * LdotV;
		float LdotVo = dot(dir, -worldLightVector);	
	    float LdotVo2 = LdotVo * LdotVo;	
		float LdotVo01 = LdotVo * 0.5 + 0.5;	
		
    float CloudVolumeShadow = TraceCloudShadow(worldPosition.xyz, worldPosition.xyz, worldLightVector, dir, 0.0f, 1.0f, 0.0f, worldLightVector, 0.0f);
	
	float Detail = 0.0f;
	
	float motion = frameTimeCounter * 0.1f * CMS;
		
	const float num = 1.0;	
	const float nm = 1.0f;	
	
	vec3 p = worldPosition.xyz;

	float noise = CloudDensity(p, p, dir, Nc, 0.6, worldLightVector, 1.0, Detail, vec2(0.0), 1.0);
	
	vec3 ppos2 = dir;		 
	    ppos2 += sqrt(noise) * 0.1;
		ppos2.x *= 0.3;
        ppos2.z += ppos2.x * 0.5;
        ppos2.y += Get3DNoise3((dir) * 20.0) * 0.03 + Get3DNoise3((dir) * 10.0) * 0.06 + Get3DNoise3((dir) * 5.0) * 0.12;		
        ppos2 /= (abs(dir.y) + 0.001) / nm;
			
		 Detail += (num - Get3DNoise3((ppos2 - motion) * 50.0)) * 2.0 / (1.0 + dist * 1e-5 * 2.0);	
		 Detail += (num - Get3DNoise3((ppos2 - motion) * 100.0)) * 2.0 / (1.0 + dist * 1e-5 * 2.0);
		 Detail += (num - Get3DNoise3((ppos2 - motion) * 200.0)) * 1.0 	/ (1.0 + dist * 1e-5);
		 Detail += (num - Get3DNoise3((ppos2 - motion) * 400.0)) * 0.5 	/ (1.0 + dist * 1e-6 * 5.0);
		 Detail += (num - Get3DNoise3((ppos2 - motion) * 800.0)) * 0.25 / (1.0 + dist * 1e-6 * 2.5);
		 Detail *= dist * 0.0001 + 1.0;
		 //noise = max(0.0, noise - Detail * DNb + DNb / 0.2);
		 
	#ifdef HALO	
	    vec3 Halo = mix(vec3(1.0), pow(1.0 + pow(1.0 - C_R1, vec3(1.0)) * pow(LdotV01, 100.0) - 1.0 * pow(LdotV01, 50.0) * (1.0 - C_R1), vec3(-1.5)) * (1.0 + C_R1 * pow(LdotV01, 100.0)), vec3(0.95));	
	#else
	    vec3 Halo = vec3(1.0);				
	#endif		 
	
	vec3 colorDirect = upperCloudSunlightColor * 50.0;
		 colorDirect = mix(colorDirect, colorDirect * 0.2, timeMidnight);
		 //colorDirect = mix(colorDirect, colorDirect * 0.1, saturate(wetness));
		 colorDirect *= 1.0f
			 //* mix(phase_mie(exp(-noise * 2.0) * 0.95, LdotV01, LdotV01 * LdotV01), phase_mie(-exp(-noise * 1.0) * 0.5, LdotV, LdotV * LdotV), 0.0)
			 * Halo
         // * CalculateMultipleScatteringCloudPhases(LdotV)
		 ;
		 /*
			 //float test = abs(sin(frameTimeCounter * VOLUMETRIC_CLOUD_SPEED * 50.0));
			 const float af = 0.83;				 
			 const float agc1 = 1.0;
			 const float agc2 = 1.0;	
			 float Lagc2 = pow(LdotV * 0.5 + 0.5, 1.2);	
			 float Lagco2 = pow(LdotVo * 0.5 + 0.5, 1.2);	
			 float Ldagc = pow(1.0 + 0.05 * 1.3, -1.0);			 
			 colorDirect *= 1.0 * af * max(0.0, 0.0		
			 + phase_mie(-0.5 * Lagco2 * Ldagc, LdotV * agc2, LdotV * LdotV * agc2 * agc2) 
			 + phase_mie( 0.9 * Lagc2 * Ldagc, LdotV * agc1, LdotV * LdotV * agc1 * agc1)		
             )	
             * mix((1.0 - exp(-0.05), 1.0, LdotV01)	
             * ((1.0 - exp(-noise))* (1.0 - LdotV01 * LdotV01) * 1.0 + LdotV01 * LdotV01) + 0.05)				 
             //+ (1.0 - 1.0) * 0.0	 
			 ;
		*/	 
	vec3 colorAmbient = colorSkylight;
		 //colorAmbient = mix(colorAmbient, vec3(1.0) * Luminance(colorSkylight), saturate(wetness) * rainModefactor);
		 //colorAmbient *= mix(1.0f, 0.0f, timeMidnight);

	vec3 color = vec3(0.0f);
	color += colorAmbient;
	color += colorDirect;
	
	float AD = dist * 15e-4; 
		 AD = min(AD, 80.0);	
		 
	//atmosphere += AtmosphericScattering(normalize(-dir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), worldSunVector, 1.0, AD);	
	//atmosphere += AtmosphericScattering(normalize(-dir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), -worldSunVector, 1.0, AD) * 4e-4;	
    //vec3 absorb = AtmosphereAbsorption(normalize(-dir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), AD);
		 
	atmosphere += AtmosphericScattering(-dir, worldSunVector, 1.0, AD);	
	atmosphere += AtmosphericScattering(-dir, -worldSunVector, 1.0, AD) * 4e-4;	
    vec3 absorb = AtmosphereAbsorption(-dir, AD);
		
	color *= absorb;	
	color += atmosphere;

	noise = 1.0 - exp(-noise * noise * 9.0);
	vec4 result = vec4(color.rgb, noise);

	return result;

}

void CloudPlane(inout vec3 color, vec3 viewDir, vec3 worldVector, float linearDepth, MaterialMask mask, vec3 worldLightVector, vec3 lightVector, float gbufferdepth, vec3 worldDir, vec3 worldPos)
{
	//Initialize view ray
	// vec4 worldPos = gbufferModelViewInverse * (vec4(-GetViewPosition(texcoord.st, gbufferdepth).xyz, 1.0));
	// worldVector = normalize(worldPos.xyz);


	Ray viewRay;
    viewRay.dir = worldVector.xyz;
	//viewRay.dir = normalize(worldVector.xyz - cameraPosition.y * vec3(0.0f, 1.0, 0.0f) * worldscale);
	// viewRay.origin = (gbufferModelViewInverse * vec4(0.0, 0.0, 0.0, 1.0)).xyz;
	viewRay.origin = vec3(0.0);

	float sunglow = CalculateSunglow(viewDir, lightVector);



	float cloudsAltitude = CPH2;
	float cloudsThickness = 150.0f;

	float cloudsUpperLimit = cloudsAltitude + cloudsThickness * 0.5f;
	float cloudsLowerLimit = cloudsAltitude - cloudsThickness * 0.5f;

	float density = 1.0f;
	vec3 atmosphere = vec3(0.0f);
	float planeHeight = cloudsUpperLimit;
	float stepSize = 25.5f;
	planeHeight -= cloudsThickness * 0.85f;
	//atmosphere = mix(atmosphere, vec3(1.0) * Luminance(colorSkylight), saturate(wetness) * rainModefactor);

	Plane pl;
	pl.origin = vec3(0.0f, cameraPosition.y - planeHeight, 0.0f);
	pl.normal = vec3(0.0f, 1.0f, 0.0f);
	
    if(cameraPosition.y > cloudsAltitude)
	{
	  pl.normal = vec3(0.0f, -1.0f, 0.0f);	
	  worldVector *= vec3(1.0f, -1.0f, 1.0f);
	}
	
	Intersection intersection = RayPlaneIntersectionWorld(viewRay, pl);

	vec3 original = color.rgb;

	if (intersection.angle < 0.0f)
	{
		if (intersection.distance < linearDepth || mask.sky > 0.5 || linearDepth >= far - 0.1 || length(intersection.pos.xyz - cameraPosition) < length(worldPos))
		{
			vec4 cloudSample = CloudColor(vec4(intersection.pos.xyz, 1.0f), sunglow, worldLightVector, cloudsAltitude, cloudsThickness, false, worldVector, atmosphere);
			 	 cloudSample.a = saturate(cloudSample.a * density);


			float cloudDist = length(intersection.pos.xyz - cameraPosition.xyz);

			const vec3 absorption = vec3(0.2, 0.4, 1.0);

            //float CloudVolumeShadow = TraceCloudShadow(intersection.pos.xyz, intersection.pos.xyz, worldLightVector, worldDir, 0.0f, 1.0f, 0.0f, worldLightVector, 1.0f);
			//color.rgb *= CloudVolumeShadow;
			color.rgb = mix(color.rgb, cloudSample.rgb, cloudSample.a) ;

		}
	}
}

 
#include "lib/clouds.glsl"
#include "lib/fog.glsl"

void CalculateClouds(inout vec3 color, inout float cloudAlpha, vec4 worldPos, vec3 viewDir, MaterialMask mask, vec3 worldLightVector, vec3 lightVector, vec3 worldDir)
{
		vec2 coord = texcoord.st * 2.0f;

		float cloudHeight = Cloud5Height;
		float cloudDepth  = Cloud5thick;
		float cloudDensity = 1.0f;

		float startingRayDepth = far - 1.0f;

		float rayDepth = startingRayDepth;
			  
		float rayIncrement = far / 1.0;

		//#ifdef SOFT_FLUFFY_CLOUDS
			  rayDepth += BlueNoise(texcoord.st) * rayIncrement;
			//#else
			  //rayDepth += CalculateDitherPattern2() * rayIncrement;
		//#endif

		int i = 0;
	    vec3 atmosphere = AtmosphericScattering(normalize(worldDir.xyz), worldLightVector, 1.0);
		vec3 cloudColor3 = colorSunlight;
		vec4 cloudSum = vec4(0.0f);
			 cloudSum.rgb = color.rgb;
	    //atmosphere = mix(atmosphere, vec3(1.0) * Luminance(colorSkylight), saturate(wetness) * rainModefactor);
		float sunglow = min(CalculateSunglow(viewDir, lightVector), 1.0);
		
		float cloudDistanceMult = 1600.0f / far;

		float surfaceDistance = length(worldPos);

		while (rayDepth > 0.0f) {
			//determine worldspace ray position
			vec4 rayPosition = GetCloudPosition(texcoord.st, LinearToExpDepth(rayDepth), cloudDistanceMult);

			float rayDistance = length((rayPosition.xyz - cameraPosition.xyz) / cloudDistanceMult);

			vec4 proximity = CloudColorf(vec4(rayPosition.xyz, 1.0f), 1.0f, worldLightVector, worldDir, vec3(0.0f), cloudHeight, cloudDepth, rayDistance);
				 proximity.a *= cloudDensity;

				 if (surfaceDistance < rayDistance * cloudDistanceMult  && mask.sky == 0.0)
				 	proximity.a = 0.0f;

			cloudSum.rgb = mix( cloudSum.rgb, proximity.rgb, vec3(min(1.0f, proximity.a)));
			cloudSum.a += proximity.a * cloudDensity;

			cloudAlpha += proximity.a;

			//Increment ray
			rayDepth -= rayIncrement;
			i++;
		}

	color.rgb = mix(color.rgb, cloudSum.rgb, saturate(cloudSum.a));

	if (cloudSum.a > 0.00f)
	{
		//materialMask.volumeCloud = 1.0;
	}
}

float GetCL(vec4 worldPosition, float sunglow, vec3 worldLightVector, bool forCL, vec3 worldDir, float lightingRoughness, float Detail, int NS)
{
	float cloudHeight = Cloud3Height;
    float dist = length(worldPosition.xyz-cameraPosition);
	float cloudDepth  = Cloud3thick;

	float cloudUpperHeight = cloudHeight + (cloudDepth / 2.0f);
	float cloudLowerHeight = cloudHeight - (cloudDepth / 2.0f);
		vec3 p = worldPosition.xyz * 0.01;
	float highPoint = cloudHeight + cloudDepth;
	float lowPoint =  cloudHeight;
	float midPoint = mix(lowPoint, highPoint, 0.2);
	float density = remap(lowPoint, midPoint, worldPosition.y);
	density *= remap(highPoint, midPoint, worldPosition.y);
	density = smoothstep(0.0, 1.0, density);
		float t = frameTimeCounter * VOLUMETRIC_CLOUD_SPEED ;
		p.x += t * 0.02f;

		vec3 p1 = p;
		float noise = mix(Get2DNoise2(p.xz), 1.0, 0.2)
		//- pow((dot(worldDir, worldLightVector) * 0.5 + 0.5) * timeNoon, 2.0) * 0.1
		;	  
	    noise *= 1.0 - wetness * 0.4;		
		int num = 2;		

		float S = 3.0;	
		float G = 1.0;
		float T = 1.;	
 		noise *= density;    
        p.z *= 0.5;		
	    for (int i = 1; i <= num; i++)
	    {	
		      p *= S;
		      G *= .5;
			  noise -= Get3DNoise(p)*G; 			  
			  T -= G;
        } 	    
		noise /= T;
  		noise = saturate(noise); 
        noise = max(noise - Detail * 0.1 + 0.1, 0.0);			   
	return noise;
}

vec4 CloudColor4(vec4 worldPosition, float sunglow, vec3 worldLightVector, vec3 worldDir, vec3 atmosphere)
{
	float cloudHeight = Cloud3Height;
	float LdotV = dot(worldDir, worldLightVector);
	float LdotV01 = LdotV * 0.5 + 0.5;
	float LdotV2 = LdotV * LdotV;
	float cloudDepth  = Cloud3thick;

	float cloudUpperHeight = cloudHeight + cloudDepth;
	float cloudLowerHeight = cloudHeight - (cloudDepth / 2.0f);
    float dist = length(worldPosition.xyz-cameraPosition);
	float highPoint = cloudHeight + cloudDepth;
	float lowPoint =  cloudHeight;
	float midPoint = mix(lowPoint, highPoint, 0.2);	
	if (worldPosition.y < cloudLowerHeight || worldPosition.y > cloudUpperHeight)
		return vec4(0.0f);
	else
	{
		

		float Detail = 0.0f;
	    vec3 motion = vec3(frameTimeCounter * 0.05, 0, 0);
	    vec3 ppos = worldDir
	    + Get3DNoise(worldDir * 20.0) * 0.05
	    ;
		ppos.z *= 0.5;
	    const float nm = 1.f;	
	     Detail += (1.0 - Get3DNoise((ppos + motion) * 20.0)*nm) / (1.0 + dist * 0.08);
		 Detail += (1.0 - Get3DNoise((ppos + motion) * 40.0)*nm) * 0.5 	/ (1.0 + dist * 0.04);
		 Detail += (1.0 - Get3DNoise((ppos + motion) * 80.0)*nm) * 0.25 	/ (1.0 + dist * 0.02);
		 Detail += (1.0 - Get3DNoise((ppos + motion) * 160.0)*nm) * 0.125 	/ (1.0 + dist * 0.01);	
		 Detail += (1.0 - Get3DNoise((ppos + motion) * 320.0)*nm) * 0.063 	/ (1.0 + dist * 0.005);					 
         Detail *= dist * 0.1 + 1.0;	 	 	    
        float noise = GetCL(worldPosition, sunglow, worldLightVector, false, worldDir, 1.0, Detail, 0); 		 
         //noise = max(noise - Detail * 0.08 + 0.1, 0.0);		  		
         noise = noise;	 
		float DN = noise;	
		//DN *= mix(0.1, 2.0, pow(remap(lowPoint, midPoint, worldPosition.y), 2.0));
		noise = smoothstep(0.0, 0.6, noise); 			
		if (noise < 0.0001f)
		{
			return vec4(0.0f, 0.0f, 0.0f, 0.0f);
		}					

	     vec3 colorDirect = upperCloudSunlightColor * 3.0f;
		      //colorDirect = mix(colorDirect, colorDirect * 0.2, timeMidnight);
		      colorDirect = mix(colorDirect, colorDirect * 0.1, saturate(wetness));
		      colorDirect *= exp2(-DN * 0.5)
		      ;
		//noise += 0.1*exp2(-sunlightExtinction * 100.);

		vec4 shadowPosition = shadowModelView * (worldPosition - vec4(cameraPosition, 0.0f));
		 shadowPosition = shadowProjection * shadowPosition;
		 shadowPosition /= shadowPosition.w;

	    float shadowdist = sqrt(dot(shadowPosition.xy, shadowPosition.xy));
	    float distortFactor = (1.0f - SHADOW_MAP_BIAS) + shadowdist * SHADOW_MAP_BIAS;
		 shadowPosition.xy *= 0.95f / distortFactor;
		 shadowPosition.z = mix(shadowPosition.z, 0.5, 0.8);
		 shadowPosition = shadowPosition * 0.5f + 0.5f;
		vec3 CSL = mix(colorSkylight, vec3(1.0) * Luminance(colorSkylight), saturate(wetness) * rainModefactor); 
	    float sunlightVisibility = shadow2D(shadow, vec3(shadowPosition.st, shadowPosition.z - 0.0f)).x;
        //colorDirect *= sunlightVisibility;
        noise *= sunlightVisibility;
		atmosphere *= (1.0 - timeMidnight * 0.995);
		vec3 color = colorDirect * 1.0;
        color += atmosphere;			
		//color *= 1.0f;
	    color *= exp2(-dist * mix(vec3(0.15, 0.4, 1.0), vec3(1.0), vec3(wetness * 0.9)) * (0.001 + wetness * 0.003));
	    //color += atmosphere * (1.0 - exp2(-dist * (0.001 + wetness * 0.003)));      
		vec4 result = vec4(color.rgb, noise);

		return result;
	}
}

void CalculateRay (inout vec3 color, inout float cloudAlpha, vec4 worldPos, vec3 viewDir, MaterialMask mask, vec3 worldLightVector, vec3 lightVector, vec3 worldDir)
{
		vec2 coord = texcoord.st * 2.0f;

		float cloudHeight = Cloud3Height;
		float cloudDepth  = Cloud3thick;
		float cloudDensity = 0.1f;

		float startingRayDepth = far - 5.0f;

		float rayDepth = startingRayDepth;
			  
		float rayIncrement = far / 1.;

		//#ifdef SOFT_FLUFFY_CLOUDS
			  rayDepth += BlueNoiseTemporal(texcoord.st).x * rayIncrement;
			//#else
			  //rayDepth += CalculateDitherPattern2() * rayIncrement;
		//#endif

		int i = 0;
	    vec3 atmosphere = AtmosphericScattering(normalize(worldDir.xyz), worldSunVector, 1.0);
		vec3 cloudColor3 = colorSunlight;
		vec4 cloudSum = vec4(0.0f);
			 cloudSum.rgb = color.rgb;
	    //atmosphere = mix(atmosphere, vec3(1.0) * Luminance(colorSkylight), saturate(wetness) * rainModefactor);
		float sunglow = min(CalculateSunglow(viewDir, lightVector), 1.0);
		
		float cloudDistanceMult = 100.0f / far;

		float surfaceDistance = length(worldPos);

		while (rayDepth > 0.0f) {
			//determine worldspace ray position
			vec4 rayPosition = GetCloudPosition(texcoord.st, LinearToExpDepth(rayDepth), cloudDistanceMult);

			float rayDistance = length((rayPosition.xyz - cameraPosition.xyz) / cloudDistanceMult);

			vec4 proximity =  CloudColor4(rayPosition, sunglow, worldLightVector, worldDir, atmosphere);
				 proximity.a *= cloudDensity;

				 if (surfaceDistance < rayDistance * cloudDistanceMult  && mask.sky == 0.0)
				 	proximity.a = 0.0f;

			cloudSum.rgb = mix( cloudSum.rgb, proximity.rgb, vec3(min(1.0f, proximity.a)));
			cloudSum.a += proximity.a * cloudDensity;

			cloudAlpha += proximity.a;

			//Increment ray
			rayDepth -= rayIncrement;
			i++;
		}

	color.rgb = mix(color.rgb, cloudSum.rgb, saturate(cloudSum.a));

	if (cloudSum.a > 0.00f)
	{
		//materialMask.volumeCloud = 1.0;
	}
}

//CloudColor3(rayPosition, sunglow, worldLightVector, worldDir);

float CloudShadow2(vec3 lightVector, vec4 screenSpacePosition)
{
	lightVector = upVector;

	float cloudsAltitude = 540.0f;
	float cloudsThickness = 150.0f;

	float cloudsUpperLimit = cloudsAltitude + cloudsThickness * 0.5f;
	float cloudsLowerLimit = cloudsAltitude - cloudsThickness * 0.5f;

	float planeHeight = cloudsUpperLimit;

	planeHeight -= cloudsThickness * 0.85f;

	Plane pl;
	pl.origin = vec3(0.0f, planeHeight, 0.0f);
	pl.normal = vec3(0.0f, 1.0f, 0.0f);

	//Cloud shadow
	Ray surfaceToSun;
	vec4 sunDir = gbufferModelViewInverse * vec4(lightVector, 0.0f);
	surfaceToSun.dir = normalize(sunDir.xyz);
	vec4 surfacePos = gbufferModelViewInverse * screenSpacePosition;
	surfaceToSun.origin = surfacePos.xyz + cameraPosition.xyz;

	Intersection i = RayPlaneIntersection(surfaceToSun, pl);

	//float cloudShadow = CloudColor(vec4(i.pos.xyz * 30.5f + vec3(30.0f) + vec3(1000.0, 0.0, 0.0), 1.0f), 0.0, worldLightVector, cloudsAltitude, cloudsThickness, false).x;
		  //cloudShadow += CloudColor(vec4(i.pos.xyz * 0.65f + vec3(10.0f) + vec3(i.pos.z * 0.5f, 0.0f, 0.0f), 1.0f), 0.0f, vec3(1.0f), cloudsAltitude, cloudsThickness, true).x;

	i.pos *= 0.015;
	i.pos.x -= frameTimeCounter * 0.42;

	float noise = Get2DNoise(i.pos.xzx);
	noise += Get2DNoise(i.pos.xzx * 0.5);

	noise *= 0.5;

	noise = mix(saturate(noise * 1.0 - 0.3), 1.0, rainStrength);
	noise = pow(noise, 0.5);
	//noise = mix(saturate(noise * 2.6 - 1.0), 1.0, rainStrength);

	noise = noise * noise * (3.0 - 2.0 * noise);

	//noise = GetCoverage(0.6, 0.2, noise);

	float cloudShadow = noise;

		  cloudShadow = min(cloudShadow, 1.0f);
		  cloudShadow = 1.0f - cloudShadow;

	return cloudShadow;
	// return 1.0f;
}

float G1V(float dotNV, float k)
{
	return 1.0 / (dotNV * (1.0 - k) + k);
}

vec3 SpecularGGX(vec3 N, vec3 V, vec3 L, float roughness, float F0)
{
	float alpha = roughness * roughness;

	vec3 H = normalize(V + L);

	float dotNL = saturate(dot(N, L));
	float dotNV = saturate(dot(N, V));
	float dotNH = saturate(dot(N, H));
	float dotLH = saturate(dot(L, H));

	float F, D, vis;

	float alphaSqr = alpha * alpha;
	float pi = 3.14159265359;
	float denom = dotNH * dotNH * (alphaSqr - 1.0) + 1.0;
	D = alphaSqr / (pi * denom * denom);

	float dotLH5 = pow(1.0f - dotLH, 5.0);
	F = F0 + (1.0 - F0) * dotLH5;

	float k = alpha / 2.0;
	vis = G1V(dotNL, k) * G1V(dotNV, k);

	vec3 specular = vec3(dotNL * D * F * vis) * colorSunlight;

	//specular = vec3(0.1);
	specular *= saturate(pow(1.0 - roughness, 0.7) * 2.0);

	return specular;
}


 float GetTorchlightHighP(vec2 coord)
 {
 	return texture2D(gnormal, coord).b;
 }

 vec3 WorldSpaceToProjSpace(vec3 worldPos)
 {
 	worldPos = (gbufferModelView * vec4(worldPos.xyz, 0.0)).xyz;

 	return ProjectBack(worldPos);
 }

 vec3 DirectionalTorchLight(vec3 viewPos, vec3 worldPos, vec3 worldNormal)
 {
 	float rawTorchlight = GetTorchlightHighP(texcoord.st * SCLE);
 	vec3 diff = vec3(dFdx(rawTorchlight), dFdy(rawTorchlight), 0.0);

 	vec3 tangent;
 	vec3 binormal;
 		if (worldNormal.x > 0.5) {
 			tangent  = normalize(worldNormal * vec3( 0.0,  0.0,  -1.0));
 			binormal = normalize(worldNormal * vec3( 0.0, -1.0,  0.0));
 		} else if (worldNormal.x < -0.5) {
 			tangent  = normalize(worldNormal * vec3( 0.0,  0.0,  1.0));
 			binormal = normalize(worldNormal * vec3( 0.0, -1.0,  0.0));
 		} else if (worldNormal.y > 0.5) {
 			tangent  = normalize(worldNormal * vec3( 1.0,  0.0,  0.0));
 			binormal = normalize(worldNormal * vec3( 0.0,  0.0,  1.0));
 		} else if (worldNormal.y < -0.5) {
 			tangent  = normalize(worldNormal * vec3( 1.0,  0.0,  0.0));
 			binormal = normalize(worldNormal * vec3( 0.0,  0.0,  -1.0));
 		} else if (worldNormal.z > 0.5) {
 			tangent  = normalize(worldNormal * vec3( 1.0,  0.0,  0.0));
 			binormal = normalize(worldNormal * vec3( 0.0, -1.0,  0.0));
 		} else if (worldNormal.z < -0.5) {
 			tangent  = normalize(worldNormal * vec3( -1.0,  0.0,  0.0));
 			binormal = normalize(worldNormal * vec3( 0.0, -1.0,  0.0));
 		}

 	float offset = 0.001 * -viewPos.z;

 	float torchlightC = GetTorchlightHighP(WorldSpaceToProjSpace(worldPos).xy);
 	float torchlightT = GetTorchlightHighP(WorldSpaceToProjSpace(worldPos + tangent * offset).xy);
 	float torchlightB = GetTorchlightHighP(WorldSpaceToProjSpace(worldPos + binormal * offset).xy);

 	vec3 torchlightFlow = vec3(0.0);
 	torchlightFlow.x = torchlightC - torchlightT;
 	torchlightFlow.y = torchlightC - torchlightB;
 	torchlightFlow.z = 0.02;
	torchlightFlow = normalize(torchlightFlow);


 	//return diff;
 	return vec3(torchlightFlow);
 }

float CloudShadow(vec4 worldPos, vec3 worldLightVector)
{
	Ray ray;
	ray.dir = worldLightVector;
	ray.origin = worldPos.xyz + cameraPosition.xyz;
	
    float cloudsAltitude = Cloud3Height;
    float cloudsThickness = Cloud3thick;
	cloudsThickness *= mix(1.0, 2.0, wetness);
	Plane plane;
	plane.normal = vec3(0.0, 1.0, 0.0);
	plane.origin = vec3(0.0, cloudsAltitude + cloudsThickness * 0.05, 0.0);

	vec3 cloudCheckPos = RayPlaneIntersection(ray, plane).pos;

	float cloudDensity = 1.0;
          //cloudDensity = CloudColor(vec4(cloudCheckPos, 1.0f), 1.0f, worldLightVector, cloudsAltitude, cloudsThickness, false, vec3(1.0), vec3(1.0)).a;
	return max(1.0 - cloudDensity, 0.0);
}

void CrepuscularRays(inout float color, float depth)
{
    //if (rainStrength == 1.0)
    //  return;
 
 
    float rayDepth = 0.02f;
    float increment = 2.0f;
 
    const float rayLimit = 100.0f;
 
    float dither = BlueNoiseStatic(texcoord.st);
 
    float lightAccumulation = 0.0f;
    float ambientFogAccumulation = 0.0f;
 
    float numSteps = rayLimit / increment;
 
    int count = 0;
 
    while (rayDepth < rayLimit)
    {
        float expViewDepth = LinearToExpDepth(rayDepth + dither * increment);
        if (depth < expViewDepth)
        {
            break;
        }
        vec4 rayPosition = GetViewPosition(texcoord.st * SCLE, expViewDepth);
             rayPosition = gbufferModelViewInverse * rayPosition;
             rayPosition = shadowModelView * rayPosition;
             rayPosition = shadowProjection * rayPosition;
             rayPosition /= rayPosition.w;
 
        float dist = sqrt(dot(rayPosition.xy, rayPosition.xy));
        float distortFactor = (1.0f - SHADOW_MAP_BIAS) + dist * SHADOW_MAP_BIAS;
        rayPosition.xy *= 0.95f / distortFactor;
        rayPosition.z = mix(rayPosition.z, 0.5, 0.8);
        rayPosition = rayPosition * 0.5f + 0.5f;
 
        float shadowSample = shadow2DLod(shadow, vec3(rayPosition.st, rayPosition.z), 2).x;
 
        lightAccumulation += shadowSample * increment;
         
        ambientFogAccumulation += 1.0f;
 
        rayDepth += increment;
        count++;
        increment *= 1.5f;
    }
 
    lightAccumulation /= numSteps;
    ambientFogAccumulation /= numSteps;
 
    color = lightAccumulation * 0.3;
 
    return;
}

vec3 Blackbody(float temperature){
	// https://en.wikipedia.org/wiki/Planckian_locus
	const vec4[2] xc = vec4[2](
		vec4(-0.2661293e9,-0.2343589e6, 0.8776956e3, 0.179910), // 1667k <= t <= 4000k
		vec4(-3.0258469e9, 2.1070479e6, 0.2226347e3, 0.240390)  // 4000k <= t <= 25000k
	);
	const vec4[3] yc = vec4[3](
		vec4(-1.1063814,-1.34811020, 2.18555832,-0.20219683), // 1667k <= t <= 2222k
		vec4(-0.9549476,-1.37418593, 2.09137015,-0.16748867), // 2222k <= t <= 4000k
		vec4( 3.0817580,-5.87338670, 3.75112997,-0.37001483)  // 4000k <= t <= 25000k
	);

	float temperatureSquared = temperature * temperature;
	vec4 t = vec4(temperatureSquared * temperature, temperatureSquared, temperature, 1.0);

	float x = dot(1.0 / t, temperature < 4000.0 ? xc[0] : xc[1]);
	float xSquared = x * x;
	vec4 xVals = vec4(xSquared * x, xSquared, x, 1.0);

	vec3 xyz = vec3(0.0);
	xyz.y = 1.0;
	xyz.z = 1.0 / dot(xVals, temperature < 2222.0 ? yc[0] : temperature < 4000.0 ? yc[1] : yc[2]);
	xyz.x = x * xyz.z;
	xyz.z = xyz.z - xyz.x - 1.0;

    const mat3 xyzToSrgb = mat3(
        3.24097, -0.96924, 0.05563,
        -1.53738, 1.87597, -0.20398,
        -0.49861, 0.04156, 1.05697
    );

	return max(xyzToSrgb * xyz, vec3(0.0));
}

vec3 CalculateStars(vec3 worldDir){
	float angleY = frameTimeCounter * 0.004;
	mat3 eyeRoataionMatrixY = mat3(cos(angleY), 0, sin(angleY), 0, 1, 0, -sin(angleY), 0, cos(angleY));

	worldDir = eyeRoataionMatrixY * worldDir;

	const float scale = 384.0;
	const float coverage = 0.007;
	const float maxLuminance = 0.04;
	const float minTemperature = 4000.0;
	const float maxTemperature = 8000.0;

	//float visibility = curve(saturate(worldDir.y));

	float cosine = dot(worldSunVector,  vec3(0, 0, 1));
	vec3 axis = cross(worldSunVector,  vec3(0, 0, 1));
	float cosecantSquared = 1.0 / dot(axis, axis);
	worldDir = cosine * worldDir + cross(axis, worldDir) + (cosecantSquared - cosecantSquared * cosine) * dot(axis, worldDir) * axis;

	vec3  p = worldDir * scale;
	ivec3 i = ivec3(floor(p));
	vec3  f = p - i;
	float r = dot(f - 0.5, f - 0.5);

	vec3 i3 = fract(i * vec3(443.897, 441.423, 437.195));
	i3 += dot(i3, i3.yzx + 19.19);
	vec2 hash = fract((i3.xx + i3.yz) * i3.zy);
	hash.y = 2.0 * hash.y - 4.0 * hash.y * hash.y + 3.0 * hash.y * hash.y * hash.y;

	float c = remap(1.0 - coverage, 1.0, hash.x);
	return (maxLuminance * remap(0.25, 0.0, r) * c * c) * Blackbody(mix(minTemperature, maxTemperature, hash.y));
}

/////////////////////////MAIN//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////MAIN//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void main() 
{

	GbufferData gbuffer 			= GetGbufferData();
	MaterialMask materialMask 		= CalculateMasks(gbuffer.materialID);

	if (materialMask.stainedGlass > 0.5)
	{
		if (gbuffer.transparentAlbedo.a >= 0.9)
		{
			gbuffer.depth = texture2D(gdepthtex, texcoord.st * SCLE).x;
			gbuffer.normal = DecodeNormal(texture2D(gaux1, texcoord.st * SCLE).xy);
			gbuffer.albedo.rgb = GammaToLinear(gbuffer.transparentAlbedo.rgb);

			vec2 transparentLightmap = texture2D(composite, texcoord.st * SCLE).rg;
			gbuffer.mcLightmap.x = CurveBlockLightTorch(transparentLightmap.x, gbuffer.emissive, gbuffer.albedo);
			gbuffer.mcLightmap.y = CurveBlockLightSky(transparentLightmap.y);

			materialMask.sky = 0.0;


		}

		gbuffer.smoothness = 0.0;
		gbuffer.metallic = 0.0;
	}
	//		gbuffer.albedo.rgb = vec3(1.0f);
	// vec4 gnormalData = texture2D(gnormal, texcoord.st * SCLE);
	// gl_FragData[0] = gnormalData;
	// gl_FragData[1] = vec4(gbuffer.albedo.rgb, 1.0);
	// return;

	if (materialMask.water > 0.5)
	{
		gbuffer.smoothness = 0.0;
		gbuffer.metallic = 0.0;
	}

	vec4 viewPos 					= GetViewPosition(texcoord.st * SCLE, gbuffer.depth);
	vec4 worldPos					= gbufferModelViewInverse * vec4(viewPos.xyz, 0.0);
	     //worldPos					-= vec3(0.0, cameraPosition.z) * 100.0, 0.0);
	vec3 viewDir 					= normalize(viewPos.xyz);
	
	//if (isEyeInWater > 0.5)
	//{
	//	viewDir.xy *= 0.80;
	//}
	
	vec3 worldDir 					= normalize(worldPos.xyz);
	//vec3 worldLightVector 			= normalize((gbufferModelViewInverse * vec4(lightVector, 0.0)).xyz);
	//vec3 worldSunVector 			= normalize((gbufferModelViewInverse * vec4(sunVector, 0.0)).xyz);
	vec3 worldNormal 				= normalize((gbufferModelViewInverse * vec4(gbuffer.normal, 0.0)).xyz);
	vec3 worldTransparentNormal 	= normalize((gbufferModelViewInverse * vec4(GetWaterNormals(texcoord.st * SCLE), 0.0)).xyz);
	float linearDepth 				= length(viewPos.xyz);

	vec3 finalComposite = vec3(0.0);
	
    //float balllimit = mix(pow(dot(worldDir, worldLightVector) * 0.5 + 0.5, 2.0), 1.0, 1.0 / (max(worldDir.y + cameraPosition.y * worldscale, 0.0) / worldscale * 1e-4 * pow(max(cameraPosition.y * 0.015, 0.0f), 2.0) * 0.1 + 1.0f));
    //if(normalize(worldDir.y + cameraPosition.y * worldscale) <= 0.0){
    //  balllimit = mix(pow(dot(worldDir, worldLightVector) * 0.45 + 0.55, 2.0), 1.0, 1.0 / (max(-worldDir.y + cameraPosition.y * worldscale, 0.0) / worldscale * 1e-4 * pow(max(cameraPosition.y * 0.015, 0.0f), 2.0) * 0.1 + 1.0f));	
	//} 
	

	float HeigthH = 1.0 - exp2(-300.0 * worldscale * max(cameraPosition.y, 0.0f));	
	float balllimit = dot(normalize(worldDir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), -worldLightVector + normalize(worldDir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale));
	balllimit = (saturate(1.0 - mix(balllimit * HeigthH, 0.0, saturate(worldLightVector.y))) * 0.996 + 0.004);
	   balllimit = 1.0;	 	
	gbuffer.albedo *= 1.0 + materialMask.water * 0.2;
	gbuffer.albedo *= 1.0 + materialMask.stainedGlass * 0.2;
	if (materialMask.water > 0.5 || materialMask.ice > 0.5)
	{
		gbuffer.mcLightmap.g = CurveBlockLightSky(texture2D(composite, texcoord.st * SCLE).g);
	}
	
	if (materialMask.sky < 0.5)
	{
	//	gbuffer.albedo.rgb = vec3(1.0f);
	}
	
    float Tdist = length(worldPos.xyz + cameraPosition.xyz);

    //float cloudShadow = CloudShadow(worldPos, worldLightVector);
	//GI
	vec4 gi = GetGI(gbuffer.albedo, gbuffer.normal, gbuffer.depth, gbuffer.mcLightmap.g, Tdist);
	// vec4 gi = vec4(0.0, 0.0, 0.0, 1.0);
    //gi = vec4(vec3(0.0f), 1.0);  //ddd
	vec3 fakeGI = normalize(gbuffer.albedo + 0.0001) * pow(length(gbuffer.albedo), 1.0) * colorSunlight * 0.05 * gbuffer.mcLightmap.g;
	float fakeGIFade = saturate((shadowDistance * 0.1) - length(viewPos) * 0.1);
	
	gi.rgb = (mix(fakeGI, gi.rgb, vec3(fakeGIFade)));
	
    //float LN = (1.0 - pow(gbuffer.mcLightmap.r, 0.2f)) * (1.0 - pow(gbuffer.mcLightmap.r, 0.2f)) * 2.0;
    //float LN2 = 8.0 / pow((1.0 + pow(gbuffer.mcLightmap.g, 2.0) * 10.0 + pow(gbuffer.mcLightmap.g, 1.0) * 1.0), 2.0);
	//float ao1 = GetAO(texcoord.st * SCLE, gbuffer.normal, CalculateNoisePattern1(vec2(0.0f), 4.0).x - 0.235f, LN);
	//float ao2 = GetAO(texcoord.st * SCLE, gbuffer.normal, BlueNoiseTemporal(texcoord.st).x, LN2);
	//ao1 = pow(ao1, pow(gbuffer.mcLightmap.r, 0.5f) * 3.0 + 1.0) * 0.9 + 0.1;	
	//ao2 = pow(ao2, LN2);
	
	float ao = gi.a;
	gi.rgb *= ao;

	//float ao = 1.0;
	const float NLA = 4e-4;
	//grass points up
	if (materialMask.leaves > 0.5 || materialMask.grass > 0.5)
		worldNormal = vec3(0.0, 1.0, 0.0);

	//shading from sky
	vec3 skylight = FromSH(skySHR, skySHG, skySHB, worldNormal);
	//if(texcoord.s > 0.5) skylight = colorSkylight;	
	
	skylight *= pow(gbuffer.mcLightmap.g, 0.9 - isEyeInWater * 0.5) * (1.0 - wetness * 0.5);
	skylight *= ao * 2.5
	;	//ddd
	#ifdef SSPTGI
	  skylight *= 0.4f;
	#endif	
	#ifdef HDR 
      skylight *= 3.0f;
	#endif
	//skylight *= dot(worldNormal, vec3(0.0, 1.0, 0.0)) * 0.2 + 0.8;
	finalComposite += skylight * gbuffer.albedo;
    //finalComposite += (worldNormal.x * 0.5 + 0.6) * vec3(0.0,1.0,0.0);

    vec3 DirectionalTorchLight = DirectionalTorchLight(viewPos.xyz, worldPos.xyz, worldNormal.xyz);
	//Torchlight
	const float torchlightBrightness = TORCHLIGHT_BRIGHTNESS * 30.0;//ddd
  
	finalComposite += gbuffer.mcLightmap.r * colorTorchlight * gbuffer.albedo * ao * torchlightBrightness
	;
    //finalComposite += DirectionalTorchLight;
#ifdef HELD_TORCHLIGHT
	//held torch light
	float heldLightFalloff = pow(length(worldPos.xyz) * 3.0 + 1.0, -2.0);
	finalComposite += gbuffer.albedo * heldLightFalloff * saturate(heldBlockLightValue) * colorTorchlight * torchlightBrightness * ao * heldLightBlacklist
    #ifdef nightVision_torch	
	  + 0.5 * gbuffer.albedo * saturate(heldBlockLightValue/1e-4) * ao
	#endif  
	;
	  
#endif

	if (materialMask.torch > 0.5 ||  materialMask.glowstone > 0.5 ||  materialMask.lava > 0.5)
	{
	    if (materialMask.glowstone > 0.5)
	    {
		    finalComposite += gbuffer.albedo * colorTorchlight * 1.0 * pow(length(gbuffer.albedo.rgb), 2.0) * torchlightBrightness;
	    }
	    if (materialMask.lava > 0.5)
	    {
		    finalComposite += gbuffer.albedo * colorTorchlight * 1.0 * pow(length(gbuffer.albedo.rgb), 2.0) * torchlightBrightness;
	    }
	    if (materialMask.torch > 0.5)
	    {
		    finalComposite += gbuffer.albedo * colorTorchlight * 1.0 * saturate(pow(length(gbuffer.albedo.rgb) - 0.5, 1.0)) * torchlightBrightness;
	    }	

	}
	else
	{
		//finalComposite += gbuffer.albedo * saturate(pow(gbuffer.mcLightmap.r, 0.1) - 0.977) * 30.0 * saturate(saturate(pow(length(gbuffer.albedo.rgb) - 0.5, 0.8)) + 0.1);	
	}
	float faketex = saturate(curve(length(gbuffer.albedo.rgb)) - 0.05) * 0.9;
	float LdotV = dot(-worldDir, -worldLightVector) * 0.5 + 0.5;	  
	faketex = (1.0 + LdotV * LdotV) * pow(1.0 + faketex * faketex - faketex * LdotV * 2.0, -1.5);
	float sunlightMult = SUNLIGHT_INTENSITY * (1.0 - wetness * 0.5) * 100.0 * balllimit;
	
	#ifdef HDR 
      sunlightMult *= 2.0f;
	#endif
	
	//float cloudShadow = CloudShadow3(worldPos.xyz, worldLightVector);
	float cloudShadow = 1.0;
	#ifdef Volumetric_Clouds
	   cloudShadow *= CloudShadow3(worldPos, worldLightVector);
	#endif
	
	vec3 shadow = CalculateSunlightVisibility(viewPos, materialMask, saturate(1.0 - cloudShadow));
	float NdotL = dot(worldNormal, worldLightVector);
	//float sunlight = saturate(NdotL); 
	//sunlightMult *= pow(gbuffer.mcLightmap.g, 0.1 + isEyeInWater * 0.3);	
	sunlightMult *= mix(pow(gbuffer.mcLightmap.g, 0.1 + isEyeInWater * 0.3), 1.0, saturate(pow(eyeBrightnessSmooth.y / 240.0f, 6.0)));

	vec3 sunlight = OrenNayar(worldNormal, -worldDir, worldLightVector, gbuffer.albedo.rgb);
	if (materialMask.leaves > 0.5 || materialMask.grass > 0.5)
	{    
		gbuffer.metallic = 0.0;
        //sunlightMult *= faketex;
		sunlight *= faketex;
        //float Phases = CalculateMultipleScatteringCloudPhases(LdotV);		
	}
	
    float WWC = 1.0f;
	if (materialMask.water > 0.5 || isEyeInWater > 0.5)
	{
		sunlight *= CalculateWaterCaustics(viewPos, materialMask);
		WWC *= CalculateWaterCaustics(viewPos, materialMask) * 0.5 + 0.2;
	}

    vec3 fakeGI2 = GammaToLinear(texture2DLod(gaux3, texcoord.st / exp2(GI_RENDER_RESOLUTION), 8.0).rgb);
	if(materialMask.sky > 0.5f)
	{
	  fakeGI2 *= 0.0f;
	}

	//vec3 shadow = vec3(1.0);
	//if (isEyeInWater < 1)
	{
		shadow *= ScreenSpaceShadow(viewPos.xyz, gbuffer.normal.xyz, materialMask)
		;		
	}

	
	shadow *= gbuffer.parallaxShadow;
	
	#ifdef Volumetric_Clouds
	   //cloudShadow *= CloudShadow3(worldPos, worldLightVector);
       gi.rgb *= cloudShadow * 0.8 + 0.2;
       shadow *= cloudShadow * 0.9 + 0.1;
	#endif
	
	//sunlight *= 1.6; 
	//if(texcoord.s > 0.5) sunlight = 1.0; 
	
	finalComposite += sunlight * gbuffer.albedo * shadow * sunlightMult
	* colorSunlight
	;
	//Sunlight specular
	vec3 specularGGX = SpecularGGX(worldNormal, -worldDir, worldLightVector, pow(1.0 - pow(gbuffer.smoothness, 1.0), 1.0), gbuffer.metallic * 0.98 + 0.02) * sunlightMult * shadow;
	specularGGX *= pow(gbuffer.mcLightmap.g, 0.1);

	if (isEyeInWater < 0.5)
	{
		finalComposite += specularGGX;
	}

	//GI
	finalComposite += gi.rgb * sunlightMult;

	vec4 viewPosTransparent = GetViewPosition(texcoord.st * SCLE, texture2D(gdepthtex, texcoord.st * SCLE).x);


	//Refraction of unterwater surface and total internal reflection detection for water
	if (isEyeInWater > 0)
	{
		if (materialMask.water > 0.5)
		{
			worldDir = refract(worldDir, worldTransparentNormal, WATER_REFRACT_IOR);
		}
	}

	float nightBrightness = NLA;
    float cloudAlpha = 0.0;
	//sky
	if (materialMask.sky > 0.5 || (isEyeInWater > 0 || materialMask.ice > 0.5 || materialMask.stainedGlass > 0.5 || materialMask.water > 0.5) && gbuffer.depth > 0.9999999)
	{
		//remove sun texture
		gbuffer.albedo *= 1.0 - saturate((dot(normalize(worldDir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), worldSunVector) - 0.95) * 50.0);
		//gbuffer.albedo *= 1.0 - worldDir;		
		gbuffer.albedo *= max(worldDir.y, 0.0f);
		
		//finalComposite.rgb = vec3(1.0);
		
		vec3 sunDisc = vec3(RenderSunDisc(normalize(worldDir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), worldSunVector));
		vec3 moonDisc = vec3(RenderSunDisc(normalize(worldDir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), -worldSunVector));		
		vec3 atmosphere = AtmosphericScattering(normalize(worldDir.xyz + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), worldSunVector, cameraPosition.y * 0.015);

		//vec3 sunDisc = vec3(RenderSunDisc(worldDir, worldSunVector));
		//vec3 moonDisc = vec3(RenderSunDisc(worldDir, -worldSunVector));		
		//vec3 atmosphere = AtmosphericScattering(worldDir, worldSunVector, cameraPosition.y * 0.015);

		//atmosphere = mix(atmosphere, vec3(20.0) * Luminance(colorSkylight) / (max(worldDir.y + cameraPosition.y * worldscale, 0.0) / worldscale * 1e-4 * pow(max(cameraPosition.y * 0.015, 0.0f), 2.0) * 0.1 + 1.0f), saturate(wetness) * rainModefactor);
        if(normalize(worldDir.y + cameraPosition.y * worldscale) <= 0.0){
        //if(normalize(worldDir.y) <= 0.0){		
          atmosphere *= exp(-pow(C_R1, vec3(0.3)) * 1.9 * wetness);
	    }
		finalComposite.rgb = atmosphere;
		
		sunDisc *= colorSunlight;	
		//sunDisc *= colorSunlight * mix(exp(-vec3(0.17, 0.4, 0.99) * 50.0), vec3(1.0), saturate(-worldSunVector.y * 20.0));		
		sunDisc *= pow(saturate(worldSunVector.y), 2.0);		
		moonDisc *= colorSunlight;
		//moonDisc *= colorSunlight * mix(exp(-vec3(0.17, 0.4, 0.99) * 50.0), vec3(1.0), saturate(-worldSunVector.y * 20.0));
		moonDisc *= pow(saturate(-worldSunVector.y), 2.0);
		
		finalComposite += sunDisc / 2e-8;	
		
		//float Gnoise = 0.1;	
		//float G = 1.0;	
		//vec3 ppos = worldDir + -worldSunVector.xyz + Get3DNoise(worldDir * 80.0) * 1e-2;
		//ppos *= vec3(240.0);
		//for(int i; i < 0; i++){	
		//	Gnoise += (Get3DNoise(ppos) - 0.5) * G;	
		//	ppos *= 2.5;		
		//	G *= 0.8;
		//}
		//finalComposite += moonDisc * (saturate(Gnoise) + 0.2) / 1e-7;		
		finalComposite += moonDisc * sunlightMult / nightBrightness;			
		vec3 moonAtmosphere = AtmosphericScattering(normalize(worldDir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), -worldSunVector, cameraPosition.y * 0.015);
        //vec3 moonAtmosphere = AtmosphericScattering(worldDir, -worldSunVector, cameraPosition.y * 0.015);		
        if(normalize(worldDir.y + cameraPosition.y * worldscale) <= 0.0){
        //if(normalize(worldDir.y) <= 0.0){		
          moonAtmosphere *= exp(-pow(C_R1, vec3(0.3)) * 1.9 * wetness);
	    }		
		moonAtmosphere = mix(moonAtmosphere, vec3(20.0) * nightBrightness / (max(worldDir.y + cameraPosition.y * worldscale, 0.0) / worldscale * 1e-4 * pow(max(cameraPosition.y * 0.015, 0.0f), 2.0) * 0.1 + 1.0f), saturate(wetness) * rainModefactor);
		
		if(worldDir.y + cameraPosition.y * worldscale > 0.0f){
		//if(worldDir.y > 0.0f){		
		  finalComposite += CalculateStars(worldDir);		
		}

		///  finalComposite = vec3(0.0, 0.0, 0.0) * 000.0;	
		//vec3 VPos = vec3(gbufferProjection[0].x, gbufferProjection[1].y, gbufferProjection[2].z) * viewDir + gbufferProjection[3].xyz;	
        //vec3 Vpos = worldPos.xyz / length(worldPos.xyz) * length(worldLightVector);		
		//if(worldDir / abs(worldDir) == -worldLightVector / abs(worldLightVector))
		//{
		  //finalComposite = (-viewPos.xyz + worldPos.xyz) + rand(texcoord.st) * 0.0 - 0.0;
		  //finalComposite = reflect(worldDir, worldLightVector);
		  //finalComposite = worldDir / abs(worldDir) - worldLightVector / abs(worldLightVector);

		  
		  
		  
		  
		  
		  
		  
		  
		  
		  /*
		  float lightrayreflectionway = 0.0;
		  float sunEdiff = 0.0;
		  float scale = 10.0;
		  float raylength = 0.2;
		  float density = 0.07;
		  for(int i = 1; i <= 128; i++)
		  {
		    vec3 poscheck = worldDir.xyz * scale;
			poscheck += (worldLightVector + sunEdiff * (rand(texcoord.st + BlueNoise(vec2(0.0))) * 2.0 - 1.0)) * raylength;
		    float noisecheck = curve(Get3DNoise(poscheck));
			sunEdiff += noisecheck * raylength * density;
		  }	

		  float lightvisibilityhit = reflect(-worldDir, -worldLightVector + sunEdiff * (rand(texcoord.st + BlueNoise(vec2(0.0))) * 2.0 - 1.0)).g;
		  float Scatter1 = (1.0 - exp(-density * curve(Get3DNoise(worldDir.xyz * scale))));
		  finalComposite = Scatter1 * lightvisibilityhit * vec3(50.0) * exp(-sunEdiff);
		  */
		  
		  
		  
		  
		  
		 
 
		  
		  
		  
		  //finalComposite += vec3(1.0, 0.0, 0.0) * 500.0;
		//}
		finalComposite += moonAtmosphere * nightBrightness;
        //finalComposite += CloudShadow3(worldPos, worldLightVector);
		
 
      if(texcoord.s < SCLE && texcoord.t < SCLE)
      {		
	    if(cameraPosition.y < 1000.0f){
		  #ifdef Plane_Clouds1
            CloudPlane(finalComposite, viewDir, -worldDir, linearDepth, materialMask, worldLightVector, lightVector, gbuffer.depth, worldDir, worldPos.xyz);	
	      #endif				
		  #ifdef Plane_Clouds2
            CloudPlane1(finalComposite, viewDir, -worldDir, linearDepth, materialMask, worldLightVector, lightVector, gbuffer.depth);		
	      #endif	
		}

		if (cameraPosition.y <= Cloud3Height * C_S_W)
	    {
		  #ifdef Plane_Clouds1
            CloudPlane(finalComposite, viewDir, -worldDir, linearDepth, materialMask, worldLightVector, lightVector, gbuffer.depth, worldDir, worldPos.xyz);	
	      #endif				
		  #ifdef Plane_Clouds2
            CloudPlane1(finalComposite, viewDir, -worldDir, linearDepth, materialMask, worldLightVector, lightVector, gbuffer.depth);		
	      #endif	
		  if (gbuffer.depth > 0.99999)
	      {
		    worldPos.xyz *= 10000.0;
	      }		
		   #ifdef Volumetric_Clouds
             CloudPlane2(finalComposite, viewDir, worldDir, linearDepth, materialMask, worldLightVector, lightVector, worldDir, gbuffer.depth, cloudAlpha, worldPos.xyz);	
	       #endif	
			   
		  if (gbuffer.depth > 0.99999)
	      {
		    worldPos.xyz /= 10000.0;
	      }			   
        }		
	  }	
        //finalComposite *= mix(dot(worldDir, worldLightVector) * 0.3 + 0.7, 1.0, 1.0 / (max(worldDir.y + cameraPosition.y * worldscale, 0.0) / worldscale * 1e-4 * pow(max(cameraPosition.y * 0.015, 0.0f), 2.0) * 0.1 + 1.0f));

		worldPos.xyz = worldDir.xyz * 2670.0;
	}
	else
	{
		//finalComposite += AtmosphericScattering(worldDir, worldSunVector, 1.0, ExpToLinearDepth(gbuffer.depth) * 0.000005);
		//LandAtmosphericScattering(finalComposite, viewPos.xyz, viewDir.xyz);

	}

	//If total internal reflection, make black
	float totalInternalReflection = 0.0;
	if (length(worldDir) < 0.5)
	{
		finalComposite *= 0.0;
		totalInternalReflection = 1.0;
	}

	//finalComposite = vec3(saturate(dot(gbuffer.normal, viewDir)));
	//finalComposite = gbuffer.normal;

		//ContextualFog(finalComposite, worldPos.xyz * 0.5, worldDir.xyz, contextualFogFactor);

	WaterFog(finalComposite, materialMask, gbuffer.mcLightmap.g, gbuffer.mcLightmap.r, viewPos, viewPosTransparent);

	//finalComposite = GetWavesNormal(worldPos.xyz + cameraPosition) * 0.5 + 0.5;
if(texcoord.s < SCLE && texcoord.t < SCLE)
{

	if (cameraPosition.y < Cloud3Height * C_S_W
	){
		if (gbuffer.depth > 0.99999)
	    {
		   worldPos.xyz *= 10000.0;
	    }	
	      //CloudPlane5(finalComposite, viewDir, worldDir, linearDepth, materialMask, worldLightVector, lightVector, worldDir, gbuffer.depth, cloudAlpha, worldPos.xyz);		
		  //CalculateClouds(finalComposite, cloudAlpha, worldPos, viewDir, materialMask, worldLightVector, lightVector, worldDir);	
		if (gbuffer.depth > 0.99999)
	    {
		   worldPos.xyz /= 10000.0;
	    }	  
	}
	
	if (cameraPosition.y > Cloud3Height * C_S_W
	&& cameraPosition.y <= Cloud3Height * C_S_W + Cloud3thick * C_S_W
	)
	{	
	    //colorSunlight *= mix(dot(worldDir, worldLightVector) * 0.3 + 0.7, 1.0, 1.0 / (max(worldDir.y + cameraPosition.y * worldscale, 0.0) / worldscale * 1e-4 * pow(max(cameraPosition.y * 0.015, 0.0f), 2.0) * 0.1 + 1.0f));
	    //CloudSunlightColor *= mix(dot(worldDir, worldLightVector) * 0.3 + 0.7, 1.0, 1.0 / (max(worldDir.y + cameraPosition.y * worldscale, 0.0) / worldscale * 1e-4 * pow(max(cameraPosition.y * 0.015, 0.0f), 2.0) * 0.1 + 1.0f));		
	    //upperCloudSunlightColor *= mix(dot(worldDir, worldLightVector) * 0.3 + 0.7, 1.0, 1.0 / (max(worldDir.y + cameraPosition.y * worldscale, 0.0) / worldscale * 1e-4 * pow(max(cameraPosition.y * 0.015, 0.0f), 2.0) * 0.1 + 1.0f));
	    //colorSkylight *= mix(dot(worldDir, worldLightVector) * 0.3 + 0.7, 1.0, 1.0 / (max(worldDir.y + cameraPosition.y * worldscale, 0.0) / worldscale * 1e-4 * pow(max(cameraPosition.y * 0.015, 0.0f), 2.0) * 0.1 + 1.0f));
		
		#ifdef Plane_Clouds1
            CloudPlane(finalComposite, viewDir, -worldDir, linearDepth, materialMask, worldLightVector, lightVector, gbuffer.depth, worldDir, worldPos.xyz);	
	    #endif				
		#ifdef Plane_Clouds2
            CloudPlane1(finalComposite, viewDir, -worldDir, linearDepth, materialMask, worldLightVector, lightVector, gbuffer.depth);		
	    #endif				  		  	

		if (gbuffer.depth > 0.99999)
	    {
		   worldPos.xyz *= 10000.0;
	    }	
	    //CloudPlane5(finalComposite, viewDir, worldDir, linearDepth, materialMask, worldLightVector, lightVector, worldDir, gbuffer.depth, cloudAlpha, worldPos.xyz);		
		//CalculateClouds(finalComposite, cloudAlpha, worldPos, viewDir, materialMask, worldLightVector, lightVector, worldDir);			  		
		#ifdef Volumetric_Clouds
            CloudPlane3(finalComposite, viewDir, worldDir, linearDepth, materialMask, worldLightVector, lightVector, worldDir, gbuffer.depth, cloudAlpha, worldPos.xyz);	
	    #endif		
		if (gbuffer.depth > 0.99999)
	    {
		   worldPos.xyz /= 10000.0;
	    }			
	}
	

	if (cameraPosition.y > Cloud3Height * C_S_W + Cloud3thick * C_S_W && cameraPosition.y <= CPH)
	{
	    //colorSunlight *= mix(dot(worldDir, worldLightVector) * 0.3 + 0.7, 1.0, 1.0 / (max(worldDir.y + cameraPosition.y * worldscale, 0.0) / worldscale * 1e-4 * pow(max(cameraPosition.y * 0.015, 0.0f), 2.0) * 0.1 + 1.0f));
	    //CloudSunlightColor *= mix(dot(worldDir, worldLightVector) * 0.3 + 0.7, 1.0, 1.0 / (max(worldDir.y + cameraPosition.y * worldscale, 0.0) / worldscale * 1e-4 * pow(max(cameraPosition.y * 0.015, 0.0f), 2.0) * 0.1 + 1.0f));		
	    //upperCloudSunlightColor *= mix(dot(worldDir, worldLightVector) * 0.3 + 0.7, 1.0, 1.0 / (max(worldDir.y + cameraPosition.y * worldscale, 0.0) / worldscale * 1e-4 * pow(max(cameraPosition.y * 0.015, 0.0f), 2.0) * 0.1 + 1.0f));
	    //colorSkylight *= mix(dot(worldDir, worldLightVector) * 0.3 + 0.7, 1.0, 1.0 / (max(worldDir.y + cameraPosition.y * worldscale, 0.0) / worldscale * 1e-4 * pow(max(cameraPosition.y * 0.015, 0.0f), 2.0) * 0.1 + 1.0f));
			
		#ifdef Plane_Clouds1
            CloudPlane(finalComposite, viewDir, -worldDir, linearDepth, materialMask, worldLightVector, lightVector, gbuffer.depth, worldDir, worldPos.xyz);	
	    #endif				
		#ifdef Plane_Clouds2
            CloudPlane1(finalComposite, viewDir, -worldDir, linearDepth, materialMask, worldLightVector, lightVector, gbuffer.depth);		
	    #endif		
	    //CloudPlane5(finalComposite, viewDir, worldDir, linearDepth, materialMask, worldLightVector, lightVector, worldDir, gbuffer.depth, cloudAlpha, worldPos.xyz);		
		//CalculateClouds(finalComposite, cloudAlpha, worldPos, viewDir, materialMask, worldLightVector, lightVector, worldDir);			
	    #ifdef Volumetric_Clouds
            CloudPlane4(finalComposite, viewDir, worldDir, linearDepth, materialMask, worldLightVector, lightVector, worldDir, gbuffer.depth, cloudAlpha, worldPos.xyz);	
	    #endif	   	  
	}	
	
	if(cameraPosition.y > CPH && cameraPosition.y <= CPH2){
	    //colorSunlight *= mix(dot(worldDir, worldLightVector) * 0.3 + 0.7, 1.0, 1.0 / (max(worldDir.y + cameraPosition.y * worldscale, 0.0) / worldscale * 1e-4 * pow(max(cameraPosition.y * 0.015, 0.0f), 2.0) * 0.1 + 1.0f));
	    //CloudSunlightColor *= mix(dot(worldDir, worldLightVector) * 0.3 + 0.7, 1.0, 1.0 / (max(worldDir.y + cameraPosition.y * worldscale, 0.0) / worldscale * 1e-4 * pow(max(cameraPosition.y * 0.015, 0.0f), 2.0) * 0.1 + 1.0f));		
	    //upperCloudSunlightColor *= mix(dot(worldDir, worldLightVector) * 0.3 + 0.7, 1.0, 1.0 / (max(worldDir.y + cameraPosition.y * worldscale, 0.0) / worldscale * 1e-4 * pow(max(cameraPosition.y * 0.015, 0.0f), 2.0) * 0.1 + 1.0f));
	    //colorSkylight *= mix(dot(worldDir, worldLightVector) * 0.3 + 0.7, 1.0, 1.0 / (max(worldDir.y + cameraPosition.y * worldscale, 0.0) / worldscale * 1e-4 * pow(max(cameraPosition.y * 0.015, 0.0f), 2.0) * 0.1 + 1.0f));
			
		#ifdef Plane_Clouds1
            CloudPlane(finalComposite, viewDir, -worldDir, linearDepth, materialMask, worldLightVector, lightVector, gbuffer.depth, worldDir, worldPos.xyz);	
	    #endif	
	    //CloudPlane5(finalComposite, viewDir, worldDir, linearDepth, materialMask, worldLightVector, lightVector, worldDir, gbuffer.depth, cloudAlpha, worldPos.xyz);		
		//CalculateClouds(finalComposite, cloudAlpha, worldPos, viewDir, materialMask, worldLightVector, lightVector, worldDir);		
	    #ifdef Volumetric_Clouds
            CloudPlane4(finalComposite, viewDir, worldDir, linearDepth, materialMask, worldLightVector, lightVector, worldDir, gbuffer.depth, cloudAlpha, worldPos.xyz);	
	    #endif	   			  
			
		#ifdef Plane_Clouds2
            CloudPlane1(finalComposite, viewDir, -worldDir, linearDepth, materialMask, worldLightVector, lightVector, gbuffer.depth);		
	    #endif			  
	}	  

	
	if(cameraPosition.y > CPH2){	
	    //colorSunlight *= mix(dot(worldDir, worldLightVector) * 0.3 + 0.7, 1.0, 1.0 / (max(worldDir.y + cameraPosition.y * worldscale, 0.0) / worldscale * 1e-4 * pow(max(cameraPosition.y * 0.015, 0.0f), 2.0) * 0.1 + 1.0f));
	    //CloudSunlightColor *= mix(dot(worldDir, worldLightVector) * 0.3 + 0.7, 1.0, 1.0 / (max(worldDir.y + cameraPosition.y * worldscale, 0.0) / worldscale * 1e-4 * pow(max(cameraPosition.y * 0.015, 0.0f), 2.0) * 0.1 + 1.0f));		
	    //upperCloudSunlightColor *= mix(dot(worldDir, worldLightVector) * 0.3 + 0.7, 1.0, 1.0 / (max(worldDir.y + cameraPosition.y * worldscale, 0.0) / worldscale * 1e-4 * pow(max(cameraPosition.y * 0.015, 0.0f), 2.0) * 0.1 + 1.0f));
	    //colorSkylight *= mix(dot(worldDir, worldLightVector) * 0.3 + 0.7, 1.0, 1.0 / (max(worldDir.y + cameraPosition.y * worldscale, 0.0) / worldscale * 1e-4 * pow(max(cameraPosition.y * 0.015, 0.0f), 2.0) * 0.1 + 1.0f));
			
	    //CloudPlane5(finalComposite, viewDir, worldDir, linearDepth, materialMask, worldLightVector, lightVector, worldDir, gbuffer.depth, cloudAlpha, worldPos.xyz);		
		//CalculateClouds(finalComposite, cloudAlpha, worldPos, viewDir, materialMask, worldLightVector, lightVector, worldDir);
	    #ifdef Volumetric_Clouds
            CloudPlane4(finalComposite, viewDir, worldDir, linearDepth, materialMask, worldLightVector, lightVector, worldDir, gbuffer.depth, cloudAlpha, worldPos.xyz);	
	    #endif		
		#ifdef Plane_Clouds2
            CloudPlane1(finalComposite, viewDir, -worldDir, linearDepth, materialMask, worldLightVector, lightVector, gbuffer.depth);		
	    #endif	
		#ifdef Plane_Clouds1
            CloudPlane(finalComposite, viewDir, -worldDir, linearDepth, materialMask, worldLightVector, lightVector, gbuffer.depth, worldDir, worldPos.xyz);	
	    #endif						  
	}	
}
	//CalculateRay (finalComposite, cloudAlpha, worldPos, viewDir, materialMask, worldLightVector, lightVector, worldDir);
    //Fog(finalComposite, viewDir, worldDir, linearDepth, materialMask, worldLightVector, lightVector, worldDir, gbuffer.depth, cloudAlpha, worldPos.xyz);
	//Fog(finalComposite, viewDir, -worldDir, linearDepth, materialMask, worldLightVector, lightVector, worldDir, gbuffer.depth, cloudAlpha, worldPos.xyz);
	//CalculateClouds(finalComposite, cloudAlpha, worldPos, viewDir, materialMask, worldLightVector, lightVector, worldDir);
	//CloudPlane5(finalComposite, viewDir, worldDir, linearDepth, materialMask, worldLightVector, lightVector, worldDir, gbuffer.depth, cloudAlpha, worldPos.xyz);	
	finalComposite *= 0.0001;

    float crepuscularRays = 0.0;
    //#ifdef Volumetric_Light
    //    CrepuscularRays(crepuscularRays, gbuffer.depth);
    //#endif
	

	
	finalComposite = LinearToGamma(finalComposite);
	
	//finalComposite += rand(texcoord.st + sin(frameTimeCounter)) * 1e-4;	
	
	vec3 result = vec3(0.0f);
    if(texcoord.s < SCLE && texcoord.t < SCLE)
	//float padding = 0.002f;
	//if (	texcoord.s + padding < 1.0f / SCLE + (padding * 2.0f) 
	//	&&  texcoord.t + padding < 1.0f / SCLE + (padding * 2.0f)
	//	&&  texcoord.s + padding > 0.0f 
	//	&&  texcoord.t + padding > 0.0f)
	{
      result = finalComposite.rgb;
	}



	vec4 gnormalData = texture2D(gnormal, texcoord.st * SCLE);
	//gl_FragData[0] = vec4(gnormalData.xy, totalInternalReflection, cloudShadow);
	gl_FragData[0] = vec4(gnormalData.xy, totalInternalReflection, ao);	
	//gl_FragData[0] = vec4(finalComposite.rgb, totalInternalReflection);	
	gl_FragData[1] = vec4(result.rgb, cloudAlpha);
}
