
float GetCN(vec3 wp, bool forCL, float lr, float Detail, float cloudHeight, float cloudDepth, int co)
{		
	float t = frameTimeCounter * VOLUMETRIC_CLOUD_SPEED;		
	float lC = 1.0f;
	

	float Hc = saturate(  (wp.y - cloudHeight) / cloudDepth);
	float Hcf = saturate(1.-Hc); 	
	float Hch = saturate( (wp.y - 3000.0)      / 200.0);
	float Hchf = saturate(1.-Hch); 		
    //float Hc2 = Hc * Hc;
	//float HchitDen = (Hc - (Hc2 * 1.3 - 0.3)) / 0.492;
	//float Hchit = (Hc - Hc2) / 0.3 * Hc;	
	//float FHchit = Hc * 0.0 + Hchit * 0.5;		


	float HA = saturate(Hc * 5.0) * saturate(Hcf * 5.0);		
	float HA3 = saturate(Hch * 4.0) * saturate(Hchf * 5.0); 
	//HA -= HA3;
	//HA = saturate(HA);
	//HA2 = saturate(HA2);
	//HA3 = saturate(HA3);	
	
	wp += 500.0 * vec3(1.0, 0.0, 1.0) * Hc;		
	vec3 p = wp.xyz * 0.00045 / C_S_W;  	
	
	#ifdef CLC
	  lC = texture2D(noisetex, (wp.xz - t * 2000.0) /C_S_W * 1e-6 + 0.5).x;
	  lC = saturate(lC * 3.4 - 0.8 + wetness * 0.7) * 0.5 + 0.5;
	  //lC *= saturate(texture2D(noisetex, (wp.xz - vec2(t * 3.0,.0f)/6e-5*VOLUMETRIC_CLOUD_SPEED)*14e-7/C_S_W).x * 3.-.75)*.5+.5;  
	  if (lC < 0.02)
	  {
	    return 0.0f;
	  } 
	#endif	


	
	float largernoise = saturate(Get2DNoise(p * 0.3) * 3.0 - 0.8);
	
    float G = 1.0;	
    float T = 1.0;	
    float LocalNC = 0.0f;	
	
	float topwindshape = Get3DNoise(p * 2.0);
			
	    p.xz -= saturate(Hc * Hc * 1.2 - 0.5) * vec2(0.2, 0.2) * topwindshape; 		
		//p *= 1.0 + saturate(Hc * Hc * 1.2 - 0.5) * 0.05 * topwindshape; 
		//p.xz *= 1.0 - saturate(Hc * Hc * 1.2 - 0.5) * vec2(0.04, 0.02);	
		
	float octScale = 3.0;		
	float noise = Get3DNoise(p + t * vec3(0.5, -1.0, 0.0));	
	
        //p.xz += Get3DNoise(p * 20.0) * 1.5 * Micro_airflow_Strength;	
        //p.xz += Get3DNoise(p * 15.0) * 2.0 * Micro_airflow_Strength + Get3DNoise(p * 30.0) * 1.0 * Micro_airflow_Strength;		
		p += t * vec3(1.0, 0.0, 0.0);	
		
	for (int j = 1; j < C_O_S + co; ++j)
    {	  
		p *= octScale;		
		G *= VC_R;		
	    noise += Get3DNoise(p)*G;  	    
		T += G;	
    } 		 
	    noise /= T;
		noise += Detail;
        noise *= Vol_Cloud_Coverage * lC;		
	    //noise *= Vol_Cloud_Coverage * (1.0 + wetness * (0.1 + saturate(Hc * Hc * 1.2 - 0.5) * 1.2)) * (1.0 - HA3 * 0.25 * (1.0 - wetness * 0.15)) * lC; 		
		noise = (HA * (noise - 0.9) - Hc * 0.5)
		// / (1.0 - Hc * 0.5)
		- 0.1; 
		//noise = HA * (noise - Hc * 0.5 - 0.9) - 0.1; 			
		//noise *= Vol_Cloud_Coverage * lC * (1.0 + wetness * 0.25);
		//noise = (HA * (noise - (0.2 * largernoise + 0.5 + wetness * 0.2) * HA2 - 0.7 + Hc * Hc * 0.6 * wetness) - 0.1);
 		//noise = HA * (noise - 0.4) - 0.1 - HA * Hc * (Hc * largernoise * 0.9 + 0.1); 		
 		//noise = HA * (noise - 0.9) - 0.0 - Hc * 0.0;      	
        //noise = HA * largernoise;
	//return saturate(noise * 20.0) * (1.0 + Hchit * 0.6) / 1.6;
	
	//if(texcoord.s>0.5)noise = (1.0 - saturate(lC * 3.0 - 0.75));
	return saturate(noise
	* Density_Curve_C
	//* (4.0 * (1.0 - largernoise) + 1.0)
	// * HA2	 
	)
	;	
}
//summon as @e[type=bat] at @s run summon arrow ~ ~ ~
//summon as @e[type=snowball] at @s run summon bat ~ ~1 ~

//scoreboard players add @e[type=snowball] 雪球 1
//execute as @e[type=snowball,scores={雪球=3..}] at run damage @e[r=2,type=snowball,c=1] 10 contact entity @s

//execute at @e[type=snowball,scores={雪球=3..}] as @e[r=2,type=!snowball] run damage @e 2

float CalculatePowderEffect(float od){
    return 1.0 - exp(-od * 2.0);
}

float CalculatePowderEffect(float powder, float vDotL){
    return mix(powder, 1.0, pow(vDotL * 0.5 + 0.5, 1.0));
}

float TraceRayVC(vec3 pos, vec3 pos2, vec3 lightDir, vec3 worldDir, float Detail, float cloudDensity, float cloudDist, vec3 worldLightVector, float RDMap)
{
    float dist = length(pos - cameraPosition) * 0.0002;
	float shadowFactor = 0.0;
	const int LQnum = 0;
	float dither = BlueNoise(texcoord.st + 0.111) - 0.5;	
	float r = 1.0;
	float LdotV = dot(-worldDir, -worldLightVector);		
	lightDir = lightDir - worldDir / abs(worldDir.y) * timeNoon;		
	for (int i = 1; i <= LQnum; i++)
	{
	    float fi = exp2(float(i) + dither);
		vec3 spos = pos + 100.0 * lightDir * fi;
		float d = GetCN(spos, true, r, 0.0f, Cloud3Height, Cloud3thick, 0);
		shadowFactor += d * 100.0 * fi;		
	}
	return shadowFactor;
}

float TraceShadowVC(vec3 pos, vec3 pos2, vec3 lightDir, vec3 worldDir, float Detail, float cloudDensity, float cloudDist, vec3 worldLightVector, float RDMap)
{
	//float LdotV = dot(worldDir, -worldLightVector);
	//float sundiff = TraceRayVC(pos, pos2, lightDir, worldDir, 0.0f, 1.0f, 0.0f, worldLightVector, 0.0);		 
	//float Order = exp(-sundiff * 80.0);
    //float dist = length(pos - cameraPosition) * 0.0002;
		 //dist = 1.0 / (1.0 + dist);	
		 //Order = mix(1.0, Order, dist);
	return 1.0f;
}

float GetSNGIWay(vec3 wp, vec3 l, vec3 wd, float ch, float cd, float Detail, int co)
{
        vec3 lv = vec3(-l.x, -l.y, -l.z);
	    float se = 0.0;
	    float r = 1.0;					
		const int q = 4;				
		float spread = 0.0;
		float dither = 0.0f;	
		#ifdef TAA_ENABLED
		  dither = BlueNoiseTemporal(texcoord.st+frameTimeCounter*1e-3).x - 0.5;			
		#else
	      dither = CalculateNoisePattern1(vec2(0.566483f), 4).b * 2.5 - 1.25;	
		#endif	
	    for (int i = 1; i <= q; ++i)
	    {	
    		if(wp.y > ch + cd || wp.y < ch) break;	  
            float fi = pow(1.5, float(i)+dither);  
			wp -= l * fi * 200.0 * C_S_W;					
		    //float densityCheck = saturate(GetCN(wp, true, r, 0.4 * spread,ch,cd, co));
		    float densityCheck = saturate(GetCN(wp, true, r, spread,ch,cd, max(co - 1, 0)));			
		           se += densityCheck * fi * 200.0;		
                   spread += fi * 5e-2;				   
		           //r *= exp2(-L_R_S * fi / float(q) * L_L * 1e-1);
	    }
		
        //se -= 2.0;
		//se /= 100.0;
		//float distancediff = pow(max(se - 50.0, 0.0f) * 2e-4 + 1.0f, -2.0);
	    float distancediff = exp2(-max(se - 50.0, 0.0) * 0.01);
		se = 1.0 * distancediff * saturate(se - 50.0);
		//se = max(1.0 - se, 0.0f);			
	    //se = 1.0 - se;
		//se *= distancediff;
	return se;
}

float GetSNGIHit(vec3 wp, vec3 l, vec3 wd, float ch, float cd, float Detail, int co)
{
        float Density = 2.0 * saturate((wp.y - ch) / cd) + 0.1;

	    float se = 0.0;
	    float r = 1.0;			
		const int q = 2;				
		vec3 dither = vec3(0.0f);	
		#ifdef TAA_ENABLED
		  dither = vec3(BlueNoise(texcoord.st+2.0 / vec2(viewWidth, viewHeight)) - 0.5,
		  BlueNoise(texcoord.st+4.0 / vec2(viewWidth, viewHeight)) - 0.5,
          BlueNoise(texcoord.st+16.0 / vec2(viewWidth, viewHeight)) - 0.5		  
		  );		
	      //dither = CalculateNoisePattern1(vec2(0.566483f), 4).b * 2.5 - 1.25;		  
		#else
	      dither = CalculateNoisePattern1(vec2(0.566483f), 4).rgb * 2.5 - 1.25;	
		#endif		  			     
		vec3 lv = vec3(-l.x, -l.y, -l.z) + dither * 2.0;
	    for (int i = 1; i <= q; ++i)
	    {	
    		if(wp.y > ch + cd || wp.y < ch) break;	   
            float fi = pow(2.0, float(i));  
			wp += lv * fi * 20.0 * C_S_W;					
		    float densityCheck = GetCN(wp, true, r, 0.0f, ch, cd, co);
		           se += densityCheck * fi * 20.0;				
		        //r *= exp2(-L_R_S * fi / float(q) * 25.0);
				co = 0;
	    }
	return se;
}

float GetSNScatterway(vec3 wp, vec3 l, vec3 wd, float ch, float cd, float Detail, int co, float sEcheck)
{
        float Density = 2.0 * saturate((wp.y - ch) / cd) + 0.1;	
	    float se = 0.0;
	    float r = 1.0;		
        float rl = L_L;		
		const int q = 0;				
		vec3 dither = vec3(0.0f);	
		#ifdef TAA_ENABLED
		  dither = vec3(BlueNoise(texcoord.st+2.0 / vec2(viewWidth, viewHeight)) - 0.5,
		  BlueNoise(texcoord.st+4.0 / vec2(viewWidth, viewHeight)) - 0.5,
          BlueNoise(texcoord.st+16.0 / vec2(viewWidth, viewHeight)) - 0.5		  
		  );		
	      //dither = CalculateNoisePattern1(vec2(0.566483f), 4).b * 2.5 - 1.25;		  
		#else
	      dither = CalculateNoisePattern1(vec2(0.566483f), 4).rgb * 2.5 - 1.25;	
		#endif	

	    for (int i = 1; i <= q; ++i)
	    {	
    		if(wp.y > ch + cd || wp.y < ch) break;	    
            float fi = pow(1.6, float(i));  		

			wp += l * fi * rl * C_S_W;					
		    float densityCheck = GetCN(wp, true, r, 0.0f, ch, cd, co) * L_A_C / i * sEcheck;
		           se += densityCheck;
				   l += dither * se;
            //r *= exp2(-L_L * fi * 1e-3);   			
	    }
		
		//if(1.0 - se == 1.0){
		//   se = 0.0f;
		//}
		
		se = saturate(se * 1.0);
	return se;
}

float GetSNScatterwayDen(vec3 wp, vec3 l, vec3 wd, float ch, float cd, float Detail, int co)
{
        float Density = 2.0 * saturate((wp.y - ch) / cd) + 0.1;	
	    float se = 0.0;
	    float r = 1.0;		
        float rl = L_L;		
		const int q = 0;				
		vec3 dither = vec3(0.0f);	
		#ifdef TAA_ENABLED
		  dither = vec3(BlueNoise(texcoord.st+2.0 / vec2(viewWidth, viewHeight)) - 0.5,
		  BlueNoise(texcoord.st+4.0 / vec2(viewWidth, viewHeight)) - 0.5,
          BlueNoise(texcoord.st+16.0 / vec2(viewWidth, viewHeight)) - 0.5		  
		  );		
	      //dither = CalculateNoisePattern1(vec2(0.566483f), 4).b * 2.5 - 1.25;		  
		#else
	      dither = CalculateNoisePattern1(vec2(0.566483f), 4).rgb * 2.5 - 1.25;	
		#endif
        l += dither;		
	    for (int i = 1; i <= q; ++i)
	    {	
    		if(wp.y > ch + cd || wp.y < ch) break;	    
            float fi = pow(1.6, float(i));  		

			wp += l * fi * rl * C_S_W;					
		    float densityCheck = GetCN(wp, true, r, 0.0f, ch, cd, co) * L_A_C * fi;
		           se += densityCheck * rl;	
            //r *= exp2(-L_L * fi * 1e-3);   			
	    }
		
	return se;
}

float GetSNShadow(vec3 wp, vec3 l, vec3 wd, float ch, float cd, float Detail, int co, vec3 kernel)
{
	    float se = 0.0;
	    float r = 1.0;				
		const int q = L_Q;				
		vec3 dither = vec3(0.0f);	
		#ifdef TAA_ENABLED
		  dither = vec3(BlueNoise(texcoord.st+2.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5,
		  BlueNoise(texcoord.st+4.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5,
          BlueNoise(texcoord.st+16.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5		  
		  );				
	      //dither = CalculateNoisePattern1(vec2(0.0), 4 + sin(frameTimeCounter * 1.0) * 1.0f).rgb * 2.5 - 1.25;	  		  
		#else
	      //dither = CalculateNoisePattern1(vec2(0.566483f), 4).rgb * 2.5 - 1.25;	
	      dither = rand(texcoord.st).rgb - .5;			  
		#endif
		
		//if(texcoord.s > 0.5){
        //  dither = vec3(0.0);	
	    //}	
		//float densitytouchCheck = GetCN(wp, true, r, 0.0f, ch, cd, co);
		
	    for (int i = 1; i <= q; ++i)
	    {	
    		if(wp.y > ch + cd || wp.y < ch) break;	  
            float fi = pow(1.6, float(i) - 1.0			
	        #ifdef D_L_D	
		      + dither.x
	        #endif		
			);  		
		    vec3 lv = l + kernel * D_L_S * se;
		    //vec3 lv = l + dither * (0.0 + se * 1.0);			
			//lv.y = abs(lv.y);
			#ifdef S_GI
			   lv = l; 
	        #endif	
			wp += lv * fi * L_L * C_S_W;  					
		    float densityCheck = GetCN(wp, true, r, 0.0f, ch, cd, max(co - int(floor(max(fi - 1.0, 0.0) * L_L * 1e-3 * L_R_S * D_L_S * C_S_W * (co + C_O_S))), 0)) * L_A_C * L_L * fi;
		    //float densityCheck = GetCN(wp, true, r, 0.0f, ch, cd, co) * L_A_C * L_L * fi;
  			 se += densityCheck;
	    }
	return se;
}

/*
float GetSNShadow(vec3 wp, vec3 l, vec3 wd, float ch, float cd, float Detail, int co)
{
	    float dse = 0.0;
	    float ase = 0.0;		
	    float r = 1.0;				
		const int q = 0;				
		vec3 dither = vec3(0.0f);	
		#ifdef TAA_ENABLED	
	      dither = CalculateNoisePattern1(vec2(0.0), 64 + sin(frameTimeCounter * 2.0) * 0.001f).rgb * 1.0 - 0.5;		  
		#else
	      dither = CalculateNoisePattern1(vec2(0.566483f), 7).rgb * 1.0 - 0.5;	
		#endif	
        vec3 l2 = vec3(1.0, 0.0, 0.0);		
		l = vec3(1.0, 0.0, 0.0) + (dither + 0.0) * 0.0;
		float densitytouchCheck = GetCN(wp, true, r, 0.0f, ch, cd, co);
		vec3 SatterVector = l;
	
		vec3 wpd = wp;
		vec3 wpa = wp;
	    for (int i = 1; i <= q; ++i)
	    {	
    		if(wpd.y > ch + cd || wpd.y < ch) break;	  
            float fi = pow(1.6, float(i) - 1.0			
	        #ifdef D_L_D	
		      + dither.x
			  //+ mix(dither, 1.0, 1.0 / (float(i) + 1.0))
	        #endif		
			);  		
						
			wpd += l * fi * L_L * C_S_W;  
					    
		    float densityCheck = GetCN(wpd, true, r, 0.0f, ch, cd, co) * L_A_C * L_L;
            dse += densityCheck;			
	    }
		
	    for (int i = 1; i <= q; ++i)
	    {	
    		if(wpa.y > ch + cd || wpa.y < ch) break;	  
            float fi = pow(1.6, float(i) - 1.0			
	        #ifdef D_L_D	
		      + dither.x
			  //+ mix(dither, 1.0, 1.0 / (float(i) + 1.0))
	        #endif		
			);  		
						
			wpa += l2 * fi * L_L * C_S_W;
				    
		    float SatterDistance = GetCN(wpa, true, r, 0.0f, ch, cd, co) * L_A_C * L_L * (1.0 - exp(-dse));
			ase += SatterDistance;
            l2 += SatterDistance * dither;
			//if(se * densitytouchCheck > 0.0){
			//	l += dither * D_L_S * 2.0;
			//}
 			
	    }			
	return ase;
}
*/
float GetSkyN(vec3 wp, vec3 l, vec3 wd, float ch, float cd, float Detail, int co)
{        	
	    float se = 0.0;
	    float r = 1.0;
		const int q = 4;		
	    float spread = 0.0;		
		vec3 dither = vec3(0.0f);	
		#ifdef TAA_ENABLED
		  dither = vec3(BlueNoise(texcoord.st+2.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5,
		  BlueNoise(texcoord.st+4.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5,
          BlueNoise(texcoord.st+16.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5		  
		  );		
	      //dither = CalculateNoisePattern1(vec2(0.566483f), 4).b * 2.5 - 1.25;		 
		  //dither = vec3(LDdither(texcoord.st / vec2(viewWidth, viewHeight) / 4e-5 + frameTimeCounter * 1e-4+2.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5,
		  //LDdither(texcoord.st / vec2(viewWidth, viewHeight) / 4e-5 + frameTimeCounter * 1e-4+4.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5,
		  //LDdither(texcoord.st / vec2(viewWidth, viewHeight) / 4e-5 + frameTimeCounter * 1e-4+8.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5)
		  //;		  
		#else
	      dither = CalculateNoisePattern1(vec2(0.566483f), 4).rgb * 2.5 - 1.25;	
		#endif	
		//vec3 lv = mix(l, vec3(0.0, 1.0, 0.0), saturate(l.y*100.0)) + dither * 2.0;
		vec3 lv = vec3(0.0, 1.0, 0.0) + dither * 2.0 * S_L_S;		
		
	    for (int j = 1; j <= q; ++j)
	    {
    		if(wp.y > ch + cd || wp.y < ch) break;	  		
		    float fi = pow(1.7, float(j) - 1.0
	        #ifdef S_L_D	
		      + dither.x
			  //+ mix(dither, 1.0, 1.0 / (float(i) + 1.0))
	        #endif	
			);
			    
				wp += lv * fi * L_L * C_S_W * 4.0;	
				
		    //float densityCheck = GetCN(wp, true, r, 0.0f, ch, cd, co) * L_A_C;	
		    //float densityCheck = GetCN(wp, true, r, -spread, ch, cd, max(co - i + 1, 0)) * L_A_C;	
		    float densityCheck = GetCN(wp, true, r, 0.0f, ch, cd, max(co - int(floor(max(fi - 1.0, 0.0) * L_L * D_L_S * 5e-3 * L_R_S * C_S_W * (co + C_O_S))), 0)) * L_A_C;			
                //if(texcoord.s>0.5)
				//spread += fi * 0.01;		
		        se += densityCheck * fi;
                //r *= exp2(-L_L * L_R_S * fi * 800.0 * C_S_W); 				
	    }
        se *= L_L * 4.0;		
	return se;
}

float GetGN(vec3 wp, vec3 l, vec3 wd, float ch, float cd, float Detail, int co)
{        		
	    float se = 0.0;
	    float r = 1.0;
		const int q = 4;	
	    float spread = 0.0;		
		vec3 dither = vec3(0.0f);	
		#ifdef TAA_ENABLED
		  dither = vec3(BlueNoise(texcoord.st+2.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5,
		  BlueNoise(texcoord.st+4.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5,
          BlueNoise(texcoord.st+16.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5		  
		  );		
	      //dither = CalculateNoisePattern1(vec2(0.566483f), 4).b * 2.5 - 1.25;		  
		  //dither = vec3(LDdither(texcoord.st / vec2(viewWidth, viewHeight) / 4e-5 + frameTimeCounter * 1e-4+2.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5,
		  //LDdither(texcoord.st / vec2(viewWidth, viewHeight) / 4e-5 + frameTimeCounter * 1e-4+4.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5,
		  //LDdither(texcoord.st / vec2(viewWidth, viewHeight) / 4e-5 + frameTimeCounter * 1e-4+8.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5)
		  //;	
		#else
	      dither = CalculateNoisePattern1(vec2(0.566483f), 4).rgb * 2.5 - 1.25;	
		#endif	
		vec3 lv = vec3(0.0, -1.0, 0.0) + dither * 2.0;
		
	    for (int j = 1; j <= q; ++j)
	    {
    		if(wp.y > ch + cd || wp.y < ch) break;	  		
		    float fi = pow(1.8, float(j) - 1.0
	        #ifdef G_GI_L_D	
		      + dither.x
			  //+ mix(dither, 1.0, 1.0 / (float(i) + 1.0))
	        #endif	
			);
			    
				wp += lv * fi * L_L * C_S_W * 8.0;	
				
		    float densityCheck = GetCN(wp, true, r, 0.0f, ch, cd, max(co - int(floor(max(fi - 1.0, 0.0) * L_L * D_L_S * 5e-3 * L_R_S * C_S_W * (co + C_O_S))), 0)) * L_A_C;	
		    //float densityCheck = GetCN(wp, true, r, -spread, ch, cd, co) * L_A_C;			
                //if(texcoord.s>0.5)
				//spread += fi * 0.002;		
		        se += densityCheck * fi;
                //r *= exp2(-L_L * L_R_S * fi * 800.0 * C_S_W); 					
	    }
        se *= L_L * 8.0;		
	return se;
}

float DirectDetail(vec3 worldDir, float dist, vec3 WindDir)
{	
    float pnoise = 0.0f;
	
	#ifdef C_D	
      vec3 pos = worldDir + WindDir;

	    pos += Get3DNoise3(worldDir*60.0)*.375*Micro_airflow_Strength*min(abs(worldDir.y),1.);	  
	    pos += Get3DNoise3(worldDir*30.0)*.75*Micro_airflow_Strength*min(abs(worldDir.y),1.);
	    pos += Get3DNoise3(worldDir*15.0)*1.5*Micro_airflow_Strength*min(abs(worldDir.y),1.);	
		
	float octScale = 2.0;
 	float G = 6e-2;	
 	float R = 1.5 / octScale;
 	float LM = -0.5; 
    for(int j = 1; j <= 5; ++j)
    {
      pnoise += (LM + Get3DNoise3(pos * 100.0)) * G
	  // / (1.0 + dist * G)
	  ;		
	  pos *= octScale;
	  G *= R;	
	}   	
	
	  pnoise *= VC_R * (1.0 - 1.0 / (1.0 + dist * 5e-3)) / (C_O_S + A_C_O_S + 1.0);
	  //pnoise *= VC_R * dist * 7e-2 / (C_O_S + A_C_O_S + 1.0);
	  //pnoise += mix(9e-2 / (1.0 + C_Q), 0.0, exp(-dist * 4e-5));	  
	#endif	
	
	return pnoise;	
}		

const float llscale = 1.0;
vec4 CloudColor3(vec4 worldPosition, float sunglow, vec3 worldLightVector, vec3 worldDir, vec3 atmosphere, float cloudHeight, float cloudDepth, float eyeLength)
{	
    float dist = length(worldPosition.xyz - cameraPosition) / C_S_W;
    float DirDensity = saturate(((worldPosition.xyz + normalize(worldLightVector + worldDir)).y - cloudHeight) / cloudDepth);	
    float Density = saturate((worldPosition.y - cloudHeight) / cloudDepth);
	float obDensity = 1.0 - Density;
	
	//const float DSa = 0.1;
	//const float DSb = 0.1;
    //float trueDensity = saturate((Density * DSa / (1.0 + Density * DSa)) * (obDensity * DSb / (1.0 + obDensity * DSb)) / ((0.5 * DSa / (1.0 + 0.5 * DSa)) * (0.5 * DSb / (1.0 + 0.5 * DSb)))); 		
	//const float mixc = 2.0;
	//const float DSa = mixc;	
	//const float DSb = 1.0 / (1.0 - 1.0 / mixc);
	const float DSa = 2.0;
	const float DSb = 3.0;	
    float trueDensity = saturate(Density * DSa) * saturate(obDensity * DSb); 		
	
    const float AC = A_C_O_S;	
	int co = int(clamp(AC - floor(sqrt(dist) * 0.01), 0.0, AC));	
		float LdotV = dot(worldDir, worldLightVector);	
	    float LdotV2 = LdotV * LdotV;	
		float LdotV01 = LdotV * 0.5 + 0.5;	
		
		float LdotVo = dot(worldDir, -worldLightVector);	
	    float LdotVo2 = LdotVo * LdotVo;	
		float LdotVo01 = LdotVo * 0.5 + 0.5;	
		
	float Detail = 0.0f;
	float t = frameTimeCounter * VOLUMETRIC_CLOUD_SPEED;
	vec3 motion = vec3(t,t * 0.,.0f);	
	vec3 ppos = worldDir;
		 Detail = DirectDetail(ppos, dist, motion);
		 
    float noise = GetCN(worldPosition.xyz, false, 1.0, Detail, cloudHeight, cloudDepth, co);
  
	     //noise = saturate(noise * mix(1., 25., Density * Density));	 	
	     //noise = saturate((1.0 - exp2(-rLOG2 * noise * dist * 5e-3 / C_Q * 20.0 * L_A_C)) / L_A_C);
	     //noise = saturate(sqrt(noise) * (1.0 + sqrt(dist) * 1e-2)
		 // / mix(C_Q, 0.8, noise) * cloudDepth / 80.0
		 //)
		 //;
		 	
		 float Dirlength = length(Cloud3thick / C_Q * worldDir / abs(worldDir.y));
		 if(cameraPosition.y > cloudHeight * 0.8)
		 {
		       Dirlength = min(Dirlength, Cloud3thick / C_Q + dist * 3.0);
		 }
		 
		 float sn = noise;
         //noise = saturate(1.0 - exp2(-noise * cloudDepth / C_Q * rLOG2 * L_A_C * sqrt(dist) * 0.0003));	 
		 //noise = mix(saturate(1.0 - exp2(-noise * rLOG2 * L_A_C * Dirlength)), 1.0, saturate((noise - 0.04) * noise * 120.0));	  
	 
		 noise = saturate(1.0 - exp(-noise * L_A_C * Dirlength));
		 //noise = mix(saturate(1.0 - exp2(-noise * rLOG2 * L_A_C * 1.0 * Dirlength)), 1.0, saturate((noise - 0.03) * noise * 1.0));	
		 //noise = saturate(noise * Dirlength);
		 
 		if (noise < 0.0001f){
		  return vec4(0.0f, 0.0f, 0.0f, 0.0f);
		}		 
 			
	float sunGIE = max(GetSNGIWay(worldPosition.xyz, worldLightVector, worldDir, cloudHeight, cloudDepth, Detail, co), 0.0f);
	    sunGIE *= exp(-GetSNGIHit(worldPosition.xyz, worldLightVector, worldDir, cloudHeight, cloudDepth, Detail, co) * L_A_C * llscale);
	float sunE = 0.0;	
	const int numRays = 1;	
	for (int i = 0; i < numRays; i++)
	{
		//float fi = float(i) + CalculateNoisePattern1(vec2(0.0f), 4).x * 2.5;  	
		////float fi = float(i) * (BlueNoise(texcoord.st + 0.156)); 		
		//float fiN = fi / float(numRays);
		//float lon = 1.62 * 19.2 * fi;
		//float lat = asin(fiN * 2.0 - 1.0) * 1.0;
		vec3 kernel;
		//kernel.x = cos(lat) * cos(lon);
		//kernel.z = cos(lat) * sin(lon);
  	    //kernel.y = sin(lat);
  	    kernel = vec3(BlueNoiseStatic(texcoord.st+2.0 / vec2(viewWidth, viewHeight) + 0.111 + BlueNoise(vec2(0.0))) - 0.5,
		BlueNoiseStatic(texcoord.st+4.0 / vec2(viewWidth, viewHeight) + 0.111 + BlueNoise(vec2(0.0))) - 0.5,
        BlueNoiseStatic(texcoord.st+16.0 / vec2(viewWidth, viewHeight) + 0.111 + BlueNoise(vec2(0.0))) - 0.5		  
		) * 2.0;	
		sunE += GetSNShadow(worldPosition.xyz, worldLightVector, worldDir, cloudHeight, cloudDepth, Detail, co, kernel) * llscale / float(numRays);	
	}	
	//sunE += GetSNShadow(worldPosition.xyz, worldLightVector, worldDir, cloudHeight, cloudDepth, Detail, co, vec3(0.0)) * llscale;	
	
	float sE = exp(-sunE);	

	float sunGISEd = GetSNScatterwayDen(worldPosition.xyz, worldLightVector, worldDir, cloudHeight, cloudDepth, Detail, co);
	     sunGISEd = exp(-sunGISEd);
    float sscheck = sunGISEd;
	if(texcoord.s > 0.5){
     sscheck = 1.0;	
	}	
	float sunGISEw = GetSNScatterway(worldPosition.xyz, worldLightVector, worldDir, cloudHeight, cloudDepth, Detail, co, sscheck);
	float innersatterGI = sunGISEw
	* exp(-sunGISEd) * 1.0
	;	
	
	float skyE = GetSkyN(worldPosition.xyz, worldLightVector, worldDir, cloudHeight, cloudDepth, Detail, co) * llscale;
	float groE = GetGN(worldPosition.xyz, worldLightVector, worldDir, cloudHeight, cloudDepth, Detail, co) * llscale;	
	
    //float sEf = pow(1.0 + sunE, -.8);
    //float sEf = max(sE, (exp(-sunE * 0.25) * 0.7));	
	//float sEtfexp = pow(1.0 + sunE, -1.);
	//float sEtfexp = pow(1.0 + sunE * 0.5, -1.5);	
	//float sEtfexp = pow(1.0 + sunE * 0.38, -.9);
	float sEtfexp = sE;
	
	//if(texcoord.s > 0.5) sE = pow(1.0 + sunGISE * 0.5, -1.5 - 25.0 / L_L * 6.0);	
	//if(texcoord.s > 0.5) sEtfexp = pow(1.+sunE*.23, -1.9); 		
	
	const float sunlightmlut = 50.0f;
	
	#ifdef S_GI
	         //sEtfexp = pow(1.+sunGISE, -1.); 
			 //sEtfexp = pow(1.0 + sunE * 0.38, -0.9);
			 //if(texcoord.s > 0.5){
               sEtfexp = pow(1.0 + sunE * 1.2, -0.93);
	         //}	
			 //sEtfexp = 1.0 / (1.0 + sunE);
			 //sEtfexp = max(sEtfexp, exp2(-sunE * rLOG2 * 0.25) * 0.7);
             //sEtfexp = pow(1.0 + sunE * 4.0, -0.4);					 
	#endif	
	
	float lodod = GetCN(worldPosition.xyz, false, 1.0, 0.0, cloudHeight, cloudDepth, 1);	
	
	#ifdef LQ_D_L_L
			 sEtfexp = 1.0
			 * saturate((Density - 0.02) * 4.0 + 0.1)			 
			 * exp2(-lodod * 4.0 * L_A_C / 0.07);		

			 sE = 1.0
			 * saturate((Density - 0.02) * 5.0 + 0.1)			 
			 * exp2(-lodod * 4.0 * L_A_C / 0.07);				 
	#endif		
	
	float limit = pow(saturate((Density - 0.1) * 4.0 + 0.1), 0.9);
	float fakeAO = 1.0 - exp2(-sn * 300.0);
	//float slE = pow(1.0 + skyE * 0.63, -5.215); 
	float slE = pow(1.0 + skyE * 1.3, -0.98);	
	//float slE = 1.0 / (1.0 + skyE);	
	
		#ifdef LQ_S_L_S 
	         slE = 1.0 
			 //* pow(1.0 + (1.0 - Density) * cloudDepth * 1.3 * L_A_C * 0.005, -0.98)
			 * saturate((Density - 0.02) * 3.0 + 0.1)	
             //* exp2(-sn * 2.0 * L_A_C / 0.07)			 
			 * exp2(-lodod * 4.0 * L_A_C / 0.07);		
	    #endif
             //sn *= L_L * L_A_C * 1.5;	
             //sn *= L_A_C * 120.0;
 		 
			 //sn = max(sn, 0.9);
             //sn *= 2.0;			 
	         //sE = mix(sE, sunGISE, 0.5);
			 //sn = pow(1.+sn*.4,-1.);
			 //sn = exp(-sn);
			 
	//float sEftexp = mix(sEtfexp, sE, sEtfexp);		
	//float sEftexp = sEtfexp;	
	
	#ifdef HALO	
	    vec3 Halo = mix(vec3(1.0), pow(1.0 + pow(1.0 - C_R1, vec3(1.0)) * pow(LdotV01, 100.0) - 1.0 * pow(LdotV01, 50.0) * (1.0 - C_R1), vec3(-1.5)) * (1.0 + C_R1 * pow(LdotV01, 100.0)), vec3(sE));	
	#else
	    vec3 Halo = vec3(1.0);				
	#endif
	
    //float Phases = CalculateMultipleScatteringCloudPhases(LdotV);			
	vec3 colorDirect = vec3(1.0 - wetness * 0.2);
    float powderLight  = CalculatePowderEffect(sunE);	
    float powderView = CalculatePowderEffect(sn
	* sqrt(C_Q * Dirlength)
	* L_A_C);
	
	//powderView = exp2(-saturate(sn - 1.0)
	//* rLOG2
	//* 10.0
	//* L_A_C);
	
    //float powder = mix(powderView + 0.05, min((1.0 - sE * sE) / (2.0 + sE * sE) * 1.5 * pow(1.0 + sE * sE - sE * 2.0 * LdotV01, -1.5), 1.0), sE) * 1.0
    //         + (powderView + 0.05) * pow(1. + sqrt(C_Q * Dirlength) * L_A_C * 1.3, -0.98)
	//		 ;
    //float powder = powderView * (1.0 - sE * sE) * (1.0 - LdotV01) + LdotV01
	//		 ;		
    //float powder = mix(powderView + 0.05, (1.0 - sE * sE) * (1.0 - LdotV01) + LdotV01, sE) * 1.0
    //         + (powderView + 0.05) * pow(1. + sqrt(C_Q * Dirlength) * L_A_C * 1.3, -0.98)
	//		 ;
    //float powder = (pow(powderView * 3.2, sE * 0.5 + 0.4) + 0.05) * (((1.0 - sE * sE) * 1.5 / (2.0 + sE * sE) * (1.0 - LdotV01) + LdotV01)
    //         + pow(1.0 + sqrt(C_Q * Dirlength) * L_A_C * 2.6, -0.98)
	//		 )
	//		 ;	
			 
	    #ifdef HQ_S	
			 //colorDirect *= sEf;	            			 
		     //colorDirect *= sEtfexp;
			 //sEftexp *= mix(sEtfexp, exp(-sn) * sE, sE * sE);   					 
			 //colorDirect *= phase_mie(sE * L_R_S, LdotV01, LdotV01 * LdotV01);	
             //colorDirect *= 1.0 + phase_mie(-0.5 * sEtfexp, LdotV01, LdotV01 * LdotV01) * 0.5 + phase_mie(0.95 * sEtfexp, LdotV01, LdotV01 * LdotV01) * 0.5;				 
			 //if(texcoord.s > 0.5) colorDirect *= 1.0 + MiePhaseFunction(-0.5 * sEtfexp, LdotV01) * 0.5 + MiePhaseFunction(0.8 * sEtfexp, LdotV01) * 0.5;
             //if(texcoord.s <= 0.5) colorDirect *= 1.0 + MiePhaseFunction(-0.5 * sEftexp, LdotV01) * 0.5 + MiePhaseFunction(0.8 * sEftexp, LdotV01) * 0.5;	
			 
		  //if(texcoord.s <= 0.5)
		  {		
             /*		  
			 colorDirect *= sEtfexp * 0.7 * max(0.0, 0.0		
			 + phase_mie(-0.5 * pow(1.0 + sunE * 2.0, -4.0), LdotV, LdotV * LdotV)
			 + phase_mie(0.9 * pow(1.0 + sunE * 2.0, -20.0), LdotV, LdotV * LdotV)		
			  
             //+ MiePhaseFunction(-0.5 * pow(1.0 + sunE * 1.5, -1.0), LdotV * 0.99)
			 //+ MiePhaseFunction(0.8 * pow(1.0 + sunE * 1.5, -1.0), LdotV * 0.99)	
             )	
             //+ (1.0 - sEtfexp) * 0.1		 
			 ;	
			 */
			 
			 /*
			 colorDirect *= sEtfexp * 0.5 * max(0.0, 0.0		
			 //+ phase_mie(-0.5 * pow(sEtfexp, 0.8), LdotV, LdotV * LdotV)
			 //+ phase_mie(0.8 * pow(sEtfexp, 0.8), LdotV, LdotV * LdotV)		
			  
             + phase_mie(-0.5 * pow(1.0 + sunE * 0.04, -6.4), LdotV * 0.93, LdotV * LdotV * 0.837)
			 + phase_mie(0.8 * pow(1.0 + sunE * 0.04, -6.4), LdotV * 0.93, LdotV * LdotV * 0.837)	
             )
			 ;	
			 */
			 
			 ///*
			 float test = abs(sin(frameTimeCounter * VOLUMETRIC_CLOUD_SPEED * 50.0));
			 const float af = 0.83;				 
			 const float agc1 = 1.0;
			 const float agc2 = 1.0;	
			 float Lagc2 = pow(LdotV * 0.5 + 0.5, 1.2);	
			 float Lagco2 = pow(LdotVo * 0.5 + 0.5, 1.2);	
			 float Ldagc = pow(1.0 + sunE * 1.3, -1.0);			 
			 colorDirect *= sEtfexp * af * max(0.0, 0.0		
			 + MiePhaseFunction(-0.5 * Lagco2 * Ldagc * L_R_S, LdotV * agc2)
			 + MiePhaseFunction( 0.95 * Lagc2 * Ldagc * L_R_S, LdotV * agc1)	
             )		 
             //+ (1.0 - sEtfexp) * 0.0	 
			 ;	
             //*/				 
          }		
             float sv = min(sn * 8.0, PI);
			 float bias = 0.05;	
			 float DepthD = sE * 0.0 + 1.0;	
			 //float inerA = max(pow(sv, max((trueDensity - 0.3) * 2.727 + 0.5, 0.0)) + bias, sEtfexp - sE);
			 float inerA = pow(sv, max((trueDensity - 0.3) * 2.727 + 0.5, 0.0)) + bias;			 
             //float inerB = 1.0 - sEtfexp;
             float inerB = saturate(sunE);			 
			 float inerC = inerA + (1.0 - inerA) * inerB;     
			       inerC = inerC * (1.0 - LdotV01 * LdotV01) + LdotV01 * LdotV01 * saturate(1.0 + bias - inerA * inerC / pow(PI, max((trueDensity - 0.3) * 2.727 + 0.5, 0.0)));			 
			 float inerE = pow(clamp((Density - 0.07) * 4.8 * DepthD + 1.0 - DepthD * 0.9, 0.0, 1.0), 0.8) * (1.0 - LdotV01 * LdotV01) + LdotV01 * LdotV01;  
                   //inerE = max(inerE + bias, sEtfexp - sE);			 
			 colorDirect *= 1.0			 		 
             * inerC
			 * inerE	
			 //  * (sv * (1.0 - LdotV01 * LdotV01)                         + LdotV01 * LdotV01 * saturate(0.0 - sv * 1.0 * 0.3183)      + 0.2)
			 //  * ((1.0 - exp(-sunE * 2.0) * (1.0 - LdotV01 * LdotV01)    + LdotV01 * LdotV01 * (0.0 + exp(-sunE * 2.0) * 1.0))        + 0.2) * 1.3
			  
			 //* (pow(saturate((Density - 0.07) * 6.0 + 0.1), 0.8) * (1.0 - LdotV01 * LdotV01) + LdotV01 * LdotV01)			 			 
			 //* (pow(sqrt(min(sn * 8.0 * (saturate(Density * Density * 3.0 + 0.1) * (1.0 - LdotV01 * LdotV01) + LdotV01 * LdotV01), PI)), exp2(-sunE * saturate(Density * Density * 3.0 + 0.1) * rLOG2 * 2.0) * 1.3) + 0.05)			

			 //* phase_mie(sEtfexp * 0.8 * exp(-sn * 12.0) * L_R_S, LdotV01, LdotV01 * LdotV01)
			 //* mix(phase_mie(sEtfexp * exp(-sn * 10.0) * 0.95, LdotV01, LdotV01 * LdotV01), phase_mie(-sEtfexp * 0.5, LdotV, LdotV * LdotV), 0.0)
			 //* mix(phase_mie(sEtfexp * 0.8, LdotV, LdotV * LdotV), phase_mie(-sEtfexp * 0.5, LdotV, LdotV * LdotV), 0.5)		 
			 //* curve(sE * sE)
			 //* (pow(powder, sEtfexp) + 0.05)
			 
			 //* powder
			 //* saturate(sn)
			 //* max((sn * 1.0 - 0.0) / (1.0 - 0.0), 0.0) * pow(sE, 0.0) * pow(Density, 0.0)
			 //* sEtfexp
             //* (pow(sn, sEtfexp * (1.0 - LdotV01)) + 0.05)			 	
			 //* mix(min(sn * 2.545, 1.0) + 0.05, phase_mie(sE * 0.95, LdotV01, LdotV01 * LdotV01), sE)
			 //* ((pow(1.0 - exp(-sn * 1.0), 1.0) + 0.05) * (1.0 - LdotV01 * LdotV01) * (3.0 + (sn - sE) * 0.0) + LdotV01 * LdotV01)
			 //* (((1.0 - exp(-sn * 34.0) * sEtfexp * sEtfexp * 0.8) / (2.0 + exp(-sn * 34.0) * sEtfexp * sEtfexp * 0.8) * pow(1.0 + exp(-sn * 34.0) * sEtfexp * sEtfexp * 0.8, -1.5) * 1.5 + 0.05)
			 //* (1.0 - LdotV01 * LdotV01) + LdotV01 * LdotV01
			 //)
			 * Halo
			 //+ LdotV01 * 0.45 * sEtfexp
			 ;	
			 
             //if(texcoord.s > 0.5){
			 //  colorDirect *= trueDensity;			 
			 //}else{
			 //  colorDirect *= saturate(Density * 1.0);			 
			 //}			 
			 //colorDirect *= phase_mie(pow(sEtfexp, sqrt(Density) * 0.8 + 0.2) * 0.95, LdotV01, LdotV01 * LdotV01) * Halo;
			 
		 /*
		  if(texcoord.s > 0.5)
		  {	 
	         sE = 0.0f;
			 float cn = 1.0;	 
			 float cn1 = 1.0;
			 float cn2 = 1.0;			 
             float Phases = 0.0f;
			 const int plq = 1024;
	         for (int i = 1; i <= plq; i++)
             {	   
               Phases = mix(phase_mie(0.8 * cn2, LdotV, LdotV * LdotV), phase_mie(-0.5 * cn2, LdotV, LdotV * LdotV), 0.5)
			   //* cn
			   ;		
               //Phases = 1.0
			   //;				   
	           sE += exp2(-sunE * cn * rLOG2) * cn1 * Phases;
	           cn *= 0.5;
	           cn1 *= 0.5;
	           cn2 *= 0.5;			   
	         }
	         //sE /= float(plq);		
	         colorDirect *= sE
			 //* vec3(1.0, .0,.0)
			 ;
		 }
		 */
		 /*
		  if(texcoord.s > 0.5)
		  {	 
	         sE = 0.0f;
			 float cn = 1.0;	 
			 float cn1 = 1.0;
			 float cn2 = 1.0;			 
             float Phases = 0.0f;
			 const int plq = 1024;
	         for (int i = 1; i <= plq; i++)
             {	   
               Phases = mix(phase_mie(0.8 * cn2, LdotV, LdotV * LdotV), phase_mie(-0.5 * cn2, LdotV, LdotV * LdotV), 0.5)
			   //* cn
			   ;		
               //Phases = 1.0
			   //;				   
	           sE += exp(-sunE * cn) * cn1 * Phases;
	           cn *= 0.5;
	           cn1 *= 0.5;
	           cn2 *= 0.5;			   
	         }
	         //sE /= float(plq);		
	         colorDirect *= sE
			 //* vec3(1.0, .0,.0)
			 ;
		 }
		 */		 
	    #else			 
			 //sE = sqrt(mix(sEf, exp(-sn) * sE, sE));
			 colorDirect *= sEtfexp;	 
			 colorDirect *= MiePhaseFunction(sE * L_R_S * 0.95, LdotV01)
			 //* (pow(saturate((Density - 0.07) * 6.0 * sEtfexp + 1.0 - sEtfexp * 0.9), 0.8) * (1.0 - LdotV01 * LdotV01) + LdotV01 * LdotV01)
			 //* (2.5 * (1.0 - LdotV01 * LdotV01) * sE + LdotV01 * LdotV01) * ((1.0 - LdotV01) * 5.0 + LdotV01) * 0.5
			 ;				 
		#endif
		
	    //#ifdef HQ_S				 
		//	 colorDirect *= 0.5;				 
		//	 sE = pow(1.+sunE*.4, -1.);		 
		//	 colorDirect += sE * phase_mie(exp(-sn) * L_R_S, LdotV01 * sE, LdotV01 * LdotV01 * sE) * 0.5 * ((Density * sE * 0.9 + 1.0 - sE * 0.9) * LdotV01 * LdotV01 * sE + 1.0 - LdotV01 * LdotV01);	 
	    //#endif		
		
        //float balllimit = mix(pow(LdotV * 0.45 + 0.55, 2.0), 1.0, 1.0 / (max(worldDir.y + cameraPosition.y * worldscale, 0.0) / worldscale * 1e-4 * pow(max(cameraPosition.y * 0.015, 0.0f), 2.0) * 0.1 + 1.0f));
   		float balllimit = 1.0;
			 colorDirect *= CloudSunlightColor * sunlightmlut;			 
			 
		vec3 CSL = mix(colorSkylight, vec3(1.0) * Luminance(colorSkylight), saturate(wetness) * rainModefactor * 0.0f); 
			 //CSL = mix(CSL * exp2(-wetness*2.), CloudSunlightColor * exp(-wetness), 1.-exp2(-wetness*2.));
			 //CSL = mix(CSL, CSL * 0.01f, saturate(timeMidnight));			 
             CSL *= 1.0
			 * slE
			 //* sqrt(1.0 - sn) * exp((1.0 - Density) * -2.0)
			 //* (0.9 + 0.1 * min(sn * 8.0, PI))
			 //* 0.75 * (1.0 + LdotV01 * LdotV01)
			 //* fakeAO
			 //* rPI * 2.0
			 //* phase_mie(sn, L_R_S, L_R_S * L_R_S)
			 //* (1.0 - wetness * 0.2)
			 ;

		
		vec3 GI = vec3(0.0f);
	#ifdef C_GI	
		//GI comes from the sunlight reflection between clouds...		
		     GI += max(sunGIE, 0.0f)
			 //* fakeAO
			 //* limit
			 * CloudSunlightColor * sunlightmlut * CBL * 0.1
			 * (1.0 - wetness * 0.65); 
	#endif
	
	
	float ggiclv = 1.0 / (12.56 + cloudHeight * cloudHeight * (1.0 + timeSunriseSunset * 0.4) / 36e6);
	#ifdef G_GI
		//GI comes from the ground...	
	    #ifdef LQ_G_GI	 
			 GI += ggiclv
			 * colorSunlight * CBL * sunlightmlut 
             //* exp2(-Density * cloudDepth * 1e-3)		
             * saturate((1.0 - Density - 0.02) * 5.0 + 0.1)			 
			 * exp2(-lodod * 4.0 * L_A_C / 0.07)				 
			 * (1.0 - wetness * 0.5); 		
 	    #else   
			 GI += ggiclv
			 //* (exp2(-(cloudHeight / C_S_W + Density * cloudDepth / C_S_W * 0.0f) * 2e-3) * 0.5 + 0.5)
			 * colorSunlight * CBL * sunlightmlut 
			 //* fakeAO		 
			 * pow(1.0 + groE * 1.3, -0.98)
			 * (1.0 - wetness * 0.5); 		
	    #endif

	#endif	
	
	    //GI *= (0.9 + 0.3 * min(sn * 8.0, PI));
		
		float AD = dist * 8e-4; 
			 
    	//if (worldDir.y < 0.0f){
		//	worldDir *= vec3(-1.0, -1.0, -1.0);
		//}		
		
	    //atmosphere = AtmosphericScattering( normalize(worldDir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), worldSunVector, 1.0, min(AD, 80.0));			
	    //atmosphere += AtmosphericScattering( normalize(worldDir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), -worldSunVector, 1.0, min(AD, 80.0)) * 4e-4;	
	    atmosphere = AtmosphericScattering(worldDir, worldSunVector, 1.0, min(AD, 80.0));			
	    atmosphere += AtmosphericScattering(worldDir, -worldSunVector, 1.0, min(AD, 80.0)) * 4e-4;			
		//vec3 absorb = AtmosphereAbsorption(normalize(worldDir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), AD * (1.0 + wetness));	
		vec3 absorb = AtmosphereAbsorption(worldDir, AD * (1.0 + wetness));			
		     //absorb *= SunAbsorptionAtAltitude(normalize(worldDir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), AD);	
		
	    //float CloudVolumeShadow = TraceShadowVC(worldPosition.xyz, worldPosition.xyz, worldLightVector, worldDir, 0.0f, noise, dist, worldLightVector, 1.0f);
		//float CloudVolumeShadow = exp(-sunE * pow(1.6, L_Q) * L_A_C * L_L);	
		//float CloudVolumeShadow = exp(-sunE * 60.0);		
             //atmosphere *= mix(1.0, CloudVolumeShadow, exp(-dist * 1e-3));	
		     //atmosphere = mix(atmosphere, vec3(20.0) * Luminance(colorSkylight), saturate(wetness) * rainModefactor);			
		 
		vec3 color = vec3(0.0);	
		
			 color += CSL * S_L_L;	
             color += GI;
	              			 
			 color += colorDirect * D_L_L
			 //* abs(sin(frameTimeCounter * VOLUMETRIC_CLOUD_SPEED * 50.0))
			 ;	
			 //color = CloudSunlightColor * sunlightmlut;
			 
             color *= absorb;	
			 
			 //if(length(color) < 0.0001) color *= 0.0f;
			 //sE = mix(1.0, sE, exp(-dist * 2e-4));
			 
             //color = GI;
             //color = colorDirect;			
			 
	         color += atmosphere * (1.0 - 0.8 * wetness * (1.0 - Density * Density * 0.6)) * 1.0f
			 //* mix(1.0, exp(-sunE * 80.0) * 0.6 + 0.4, pow(LdotV01, 5.0))
			 ;	
			 
			 //if(color.r < 0.00004) return vec4(vec3(0.0f, color.gb), noise);
			 //if(color.g < 0.00004) return vec4(vec3(color.r, 0.0f, color.b), noise);			 
			 //if(color.b < 0.00004) return vec4(vec3(color.r, color.g, 0.0f), noise);					 
			 
             //if(length(color) < 0.0001)	return vec4(vec3(0.0f), noise);			 
			 //color = CloudSunlightColor * 5.0;
			 //if(texcoord.s > 0.5) color = vec3(Phases) * CloudSunlightColor * 20.0 * 4.0;	
			 // color = vec3(co);
			 // color = vec3(sunGISE);	
			 
 			 //color = vec3(20.0)
			 //* max(GetSNGIWay(worldPosition.xyz, worldLightVector, worldDir, cloudHeight, cloudDepth, Detail, co), 0.0f) 
 			 //* exp2(-GetSNGIHit(worldPosition.xyz, worldLightVector, worldDir, cloudHeight, cloudDepth, Detail, co) * L_A_C) * fakeAO
			 //* limit
			 //;			
			 //color = (1.0 - sn * sn) / (2.0 - sn * sn) * 1.5 / (1.0 + sn * sn) * CloudSunlightColor * 20.0;
			 
			 //color = 20.0 / (1.0 + (1.-C_R1) * pow(LdotV01, 400.0) - 1.0 * (1.-C_R1) * pow(LdotV01, 20.0));
			 //color = Halo * 20.0;
			 //color = vec3(powder * 50.0);
			 
			 //color = 50.0
			 //* sunE * sEtfexp * sn
			 //* (pow(sqrt(min(sn * 8.0 * saturate(Density * Density * 3.0 + 0.1), PI)), exp2(-sunE * saturate(Density * Density * 3.0 + 0.1) * rLOG2) * (1.0 - LdotV01 * LdotV01) + LdotV01 * LdotV01 * 0.5) + 0.05)
			 //* (pow(min(sn * 8.0, PI), max((Density - 0.3) * 1.72 + 1.0, 0.0) * sE) + 0.05)
			 //* (pow(clamp((Density - 0.07) * 4.0 * sE + 1.0 - sE * 1.0, 0.0, 1.0), 0.8) * (1.0 - LdotV01 * LdotV01) + LdotV01 * LdotV01)	
			 //* CloudSunlightColor;
			 
			 //color = vec3(0.0, 1.0, 0.0)
			 //* saturate(pow((Density - 0.07) * 4.5 + 0.1, 0.8))
			 //* sn
			 //* max(pow(Hchit * 1.5, 1.4), 0.2) * 2.0
			 //* (1.0 - Density)
			 //* Density		 
			 //;
			 //if(color.g == 1.0){
			 //  color = vec3(1.0, 0.0, 0.0);
			 //}
			 //if(texcoord.s > 0.0) color = vec3(20.0) * powder;
			 //if(worldPosition.y > 1600.0 && worldPosition.y < 3200.0) color = vec3(0.0, 1.0, 0.0) * fakeAO;
			 //if(worldPosition.y > 3200.0) color = vec3(1.0, 0.0, 0.0) * fakeAO;
			 //if(noise * noise == 1.0) color = vec3(0.0f);
			 //noise = innersatterGI;
		vec4 result = vec4(color.rgb * balllimit, noise);
		
		return result;
}

vec3 IntersectXZPlane(vec3 rayDir, float planeHeight)
{
	  return rayDir * (planeHeight - cameraPosition.y) / rayDir.y;	  
}

void CloudPlane2(inout vec3 color, vec3 viewDir, vec3 worldVector, float linearDepth, MaterialMask mask, vec3 worldLightVector, vec3 lightVector, in vec3 worldDir, float gbufferdepth, inout float cloudAlpha, vec3 worldPos)
{
       	float cloudsAltitude = Cloud3Height * C_S_W;
       	float cloudsThickness = Cloud3thick * C_S_W;  
 
		const int raySteps = C_Q;
		
		worldDir += cameraPosition.y * vec3(0.0f, 1.0, 0.0f) * worldscale;		
		worldDir = normalize(worldDir);	
		
	    vec3 rayStartPos = IntersectXZPlane(worldDir, cloudsAltitude) + cameraPosition;
		
	    vec3 rayIncrement = (worldDir * cloudsThickness / raySteps) / abs(worldDir.y);	
	    float rayIncrementLength = length(rayIncrement);
		
	    float eyeLength = length(worldPos - cameraPosition);
				
	    vec4 cloudAccum = vec4(0.0);
		float CloudVolumeShadow = 0.0f;	 
	    float visibilityAccum = 1.0;
	    vec3 rayPos = rayStartPos;
		float debug = 0.0;
		//if(texcoord.s>0.5) debug = 1.0;

		//  //float fi = float(1) + CalculateNoisePattern1(vec2(0.0f), 4).x * 2.5;  	
		//  float fi = float(1) + BlueNoise(texcoord.st + 0.156) * 0.1; 		
		//  float fiN = fi;
		//  float lon = 1.62 * 19.2 * fi;
		//  float lat = asin(fiN * 2.0 - 1.0) * 1.0;
		//  vec3 kernel;
		//  kernel.x = cos(lat) * cos(lon);
		//  kernel.z = cos(lat) * sin(lon);
  	    //  kernel.y = sin(lat);		
    		  
		#ifdef TAA_ENABLED	
		//if(texcoord.s > 0.5){
	    //  rayPos += rayIncrement	
		//  * BlueNoise(texcoord.st);
		//  }
	      rayPos += rayIncrement
		  //* LDdither(texcoord.st / vec2(viewWidth, viewHeight) / 4e-5 + frameTimeCounter * 1e-4) * 0.9
		  * BlueNoiseStatic(texcoord.st + BlueNoise(vec2(0.0)))
		  //* (kernel.x + 1.0) * 0.5
		  //* mix(1.0, BlueNoise(texcoord.st), saturate(500.0/rayIncrementLength))	
		  //* (CalculateNoisePattern1(vec2(frameTimeCounter*25.0,frameTimeCounter*20.0), 4+sin(frameTimeCounter*1e-1) * 0.0f).rgb * 1.0 - 0.5) * 1.9
		  //* BlueNoiseTemporal(texcoord.st).x
		  //* CalculateNoisePattern1(vec2(0.0f), 4 + sin(frameCounter * 0.75) * 0.05 * debug).bbb * 2.8	
          ;		  
		//  if(texcoord.s <= 0.5){
		//  rayPos += rayIncrement	
		//  * BlueNoiseStatic(texcoord.st + vec2(sin(PI * 2.0 * BlueNoiseStatic(frameTimeCounter * vec2(0.75))), cos(PI * 2.0 * BlueNoiseStatic(frameTimeCounter * vec2(0.75)))))
		//  ;
		//  }	  	  
		  	
		#else
	      rayPos += rayIncrement
		  //* BlueNoiseStatic(texcoord.st)		  
		  //* (CalculateNoisePattern1(vec2(frameTimeCounter*25.0,frameTimeCounter*20.0), 4+sin(frameTimeCounter*1e-1) * 0.0f).rgb * 2.5 - 1.25)	  
		  * CalculateNoisePattern1(vec2(0.0f), 4 + sin(frameCounter * 0.75) * 0.05 * debug).bbb * 2.5
		  //* mix(1.0, BlueNoiseStatic(texcoord.st), 1.0/rayIncrementLength)
		  //* LDdither(texcoord.st / vec2(viewWidth, viewHeight) / 4e-5 + frameTimeCounter * 1e-4 * debug) * 1.25
		  ;	
		#endif

        vec4 cloudSample = vec4(0.0f);
	    for (int j = 0; j < raySteps; j++)
	    {
		    if (length(rayPos - cameraPosition) > length(worldPos) || visibilityAccum < 0.0001 || worldDir.y < 0.0f)
		    {
			    break;
		    }

		    cloudSample = CloudColor3(vec4(rayPos, 1.0f), 1.0f, worldLightVector, worldDir, vec3(0.0f), cloudsAltitude, cloudsThickness, eyeLength);
		    cloudAccum.rgb += (cloudSample.rgb * cloudSample.a) * visibilityAccum;
			
		    visibilityAccum *= 1.0 - cloudSample.a;
			
		    rayPos += rayIncrement;  
			
			//cloudSample.a *= visibilityAccum;
			
		    //CloudVolumeShadow += TraceShadowVC(rayPos.xyz, rayPos.xyz, worldLightVector, worldDir, 0.0f, 0.0f, rayIncrementLength, worldLightVector, 1.0f);			
			// CloudVolumeShadow += mix(1.0, TraceShadowVC(rayPos.xyz, rayPos.xyz, worldLightVector, worldDir, 0.0f, 0.0f, rayIncrementLength, worldLightVector, 1.0f), pow(dot(worldDir, worldLightVector) * 0.5 + 0.5, 5.0));	
	    }
		
		CloudVolumeShadow /= float(raySteps);	 
		//if(worldDir.y > 0.0f)
		//{
		//  //CloudVolumeShadow = TraceShadowVC(rayPos.xyz, rayPos.xyz, worldLightVector, worldDir, 0.0f, 0.0f, rayIncrementLength, worldLightVector, 1.0f);	
		//  //color *= exp(-(1.0 - CloudVolumeShadow) * C_R1 * 70.0);	
		//  //color += CloudVolumeShadow * CloudSunlightColor * 2.0 * pow(dot(worldDir, worldLightVector) * 0.5 + 0.5, 5.0);	
		//  float miel = phase_mie(0.6, dot(worldDir, worldLightVector) * 0.5 + 0.5, pow(dot(worldDir, worldLightVector) * 0.5 + 0.5, 2.0)) * 0.03
		//  + phase_mie(0.9, dot(worldDir, worldLightVector) * 0.5 + 0.5, pow(dot(worldDir, worldLightVector) * 0.5 + 0.5, 2.0)) * 0.01;
        //  color += CloudVolumeShadow * CloudSunlightColor * miel * 20.0;		  
		//}

		
		cloudAlpha = 1.0 - visibilityAccum;
	    color = color * saturate(visibilityAccum) + cloudAccum.rgb;		
}

void CloudPlane3(inout vec3 color, vec3 viewDir, vec3 worldVector, float linearDepth, MaterialMask mask, vec3 worldLightVector, vec3 lightVector, in vec3 worldDir, float gbufferdepth, inout float cloudAlpha, vec3 worldPos)
{
       	float cloudsAltitude = Cloud3Height * C_S_W;
       	float cloudsThickness = Cloud3thick * C_S_W;
		//cloudsThickness *= saturate(0.5 + pow((dot(-worldDir, worldSunVector) * 0.5 + 0.5), 2.0) * 0.5);
	
	    float eyeLength = length(worldPos - cameraPosition);
		
	const int raySteps = C_Q;
	const float rayExtent = 9500.0 * C_S_W;
	const float rayStepSize = rayExtent / (raySteps + 0);

	vec4 cloudAccum = vec4(0.0);
	float visibilityAccum = 1.0;

	float rayDepth = BlueNoise(texcoord.st) * rayStepSize;

	for (int i = 0; i < raySteps + 0; i++)
	{
		vec3 rayPos = (worldDir + cameraPosition.y * vec3(0.0f, 1.0, 0.0f) * worldscale) * rayDepth + cameraPosition;
		//cloudsThickness -= length(rayPos - cameraPosition) * 0.015 / C_S_W;
		cloudsAltitude = Cloud3Height + 48.88889 * C_S_W - length(rayPos - cameraPosition) * 0.0118125 / C_S_W;		
		//When fully opaque, stop
		if (length(rayPos - cameraPosition) > length(worldPos) || visibilityAccum < 0.00001)
		{
			break;
		}

		//early out if not in correct altitude range
		if (worldPos.y < cloudsAltitude &&  worldPos.y> cloudsAltitude + cloudsThickness)
		{
			rayDepth += rayStepSize;
			continue;
		}
		
		vec4 cloudSample = CloudColor3(vec4(rayPos, 1.0f), 1.0f, worldLightVector, worldDir, vec3(0.0f), cloudsAltitude, cloudsThickness, eyeLength);
		cloudAccum.rgb += (cloudSample.rgb * cloudSample.a) * visibilityAccum;
		visibilityAccum *= 1.0 - cloudSample.a;

		rayDepth += rayStepSize;
	}
		cloudAlpha = 1.0 - visibilityAccum;
	color = (color * visibilityAccum) + cloudAccum.rgb;	

}

void CloudPlane4(inout vec3 color, vec3 viewDir, vec3 worldVector, float linearDepth, MaterialMask mask, vec3 worldLightVector, vec3 lightVector, in vec3 worldDir, float gbufferdepth, inout float cloudAlpha, vec3 worldPos)
{
    if (cameraPosition.y > Cloud3Height * C_S_W + Cloud3thick * C_S_W)
	{
	   Ray viewRay;
	   viewRay.dir = normalize(worldVector.xyz + cameraPosition.y * vec3(0.0f, 1.0, 0.0f) * worldscale);
	   viewRay.origin = vec3(0.0);	
	   float cloudsAltitude = Cloud3Height * C_S_W;
	   float cloudsThickness = Cloud3thick * C_S_W;
	   float cloudsUpperLimit = cloudsAltitude;
	   float planeHeight = cloudsUpperLimit;	
	   const int numSamples = C_Q;	

	   #ifdef TAA_ENABLED	
 	      float dither = BlueNoise(texcoord.st);		
		#else
 	      float dither = CalculateNoisePattern1(vec2(0.0f), 4 + sin(frameCounter * 0.75) * 0.05).b * 2.5;	
		#endif
	   planeHeight -= dither * (cloudsThickness / numSamples);
	   for (int j = 0; j < numSamples; j++)
	   {
	       Plane pl;
		   pl.origin = vec3(0.0f, cameraPosition.y - planeHeight, 0.0f);
		   pl.normal = vec3(0.0f, 1.0f, 0.0f);		
		   Intersection intersection = RayPlaneIntersectionWorld(viewRay, pl);
		   if (intersection.angle < 0.0f)
		   {
			   if (intersection.distance < linearDepth || linearDepth <= far - 0.1)
			   {			    
				   vec4 cloudSample = CloudColor3(vec4(intersection.pos.xyz, 1.0f), 1.0f, worldLightVector, vec3(1.0, -1.0, 1.0) * worldDir, vec3(0.0f), cloudsAltitude, cloudsThickness, 1.0f);
			       float cloudDist = length(intersection.pos.xyz-cameraPosition.xyz);
				   color.rgb = mix(color.rgb, cloudSample.rgb * 1.0f, cloudSample.a);
			   }
		   }
		     planeHeight += cloudsThickness / numSamples;		
	   }
	}	
}

float CloudShadow3(vec4 worldPos, vec3 worldLightVector)
{
	Ray ray;
	ray.dir = worldLightVector;
	ray.origin = worldPos.xyz + cameraPosition.xyz;

	Plane plane;
	plane.normal = vec3(0.0, 1.0, 0.0);
	plane.origin = vec3(0.0, Cloud3Height * C_S_W + Cloud3thick * 0.1 * C_S_W, 0.0);
	
	vec3 cloudCheckPos = RayPlaneIntersection(ray, plane).pos;
	float cloudDensity = GetCN(cloudCheckPos, true, 0.8f, 0.0f + wetness * 0.0, Cloud3Height, Cloud3thick * C_S_W, 4);
	//float cloudDensity = GetCN(cloudCheckPos, true, 0.9f, Cloud3thick * 0.00002f * C_S_W, Cloud3Height, Cloud3thick * C_S_W, max(co - 3, 0));
	
	#ifdef cloud_shadow	
 	      return exp(-cloudDensity * cloudDensity * 300.0) * 0.9 + 0.1;
	      //return exp(-cloudDensity * cloudDensity * 10.0) * 0.9 + 0.2;		
	#else
 	      return 1.0f;
	#endif

}