const float Nb1 = 0.4f;
const int Nc1 = 3;
float cloudForwardG = 0.8;
float cloudBackwardG = -0.5;
float cloudMixG = 0.5;
const float CPH = 4000.0;

float MiePhaseFunction(float g, float nu){
    float gg = g * g;
    return (1.0 - gg) * pow(-2.0 * (g * nu) + gg + 1.0, -1.0) / (1.0 + gg);
}

float PhaseGDualLobe(float VoL, const float g0, const float g1, const float m){
    float p1 = MiePhaseFunction(g0, VoL);
    float p2 = MiePhaseFunction(g1, VoL);

    return mix(p2, p1, m);
}

float CalculateMultipleScatteringCloudPhases(float VoL){
	float phases = 0.0;
	float cn = 1.0;

    for (int i = 0; i < 2; i++, cn *= 0.3){
        phases += PhaseGDualLobe(VoL, cloudForwardG * cn, cloudBackwardG * cn, cloudMixG) * cn;
    }
	return phases;
}

const float scaleforplane = 1.0;
float CloudDensity1(vec3 p, vec3 worldDir, const int level, const float lunacrity, vec3 worldLightVector, float R)
{		
	float t = frameTimeCounter * VOLUMETRIC_CLOUD_SPEED;	
    if(cameraPosition.y > CPH)
	{
	  worldDir *= vec3(1.0f, -1.0f, 1.0f);
	}
	p /= scaleforplane * (length(p - cameraPosition) * 1e-5 / scaleforplane + 1.0);		 	
	float lC = 1.0f;
		lC = texture2D(noisetex, (p.xz + vec2(t,.0f)/1e-4)*125e-8).x;
		lC = saturate(lC * 3.0 - 0.8) * 0.5 + 0.5;	
		if (lC < 0.02)
		{
		  return 0.0f;
		}		
	float LdotV = dot(worldDir, -worldLightVector) * 0.5 + 0.5;		
    p *= 0.002;

	float n = 0.0;		
	p.x += t;		
			
	p -= Get2DNoise(p * 5e-1) * 0.7;		
   	p.z += p.x * 0.5;
	p.x /= 1.2;	     		  	                                     	    
	n += Get2DNoise(p * 0.125);                                  p.x += t * 0.8;	       	p -= Get2DNoise(p * 15e-1) * 0.2;	            		
	n += Get2DNoise(p * 0.375) * lunacrity;                      p.x += t * 1.2;                               
	n += Get2DNoise(p * 1.125) * lunacrity * lunacrity;
	n += Get2DNoise(p * 3.375) * lunacrity * lunacrity * lunacrity;	
	n *= 1.5 / (1.0 + lunacrity + lunacrity * lunacrity + lunacrity * lunacrity * lunacrity) * (1.0 + wetness*.56); 
	n -= abs(worldDir.y) * 0.4 - 0.2;	
	n *= mix(1.0, pow(-LdotV * 0.5 + 0.5 + wetness, 0.2), saturate(worldLightVector.y * 10.0));
	n *= lC;	
	n -= 0.44;
	n *= 0.6 - wetness * 0.3;	
	return saturate(n);
}

float TraceCloudDensity1(vec3 pos, vec3 lightDir, vec3 worldDir, float perturbNoise, float cloudDensity, float cloudDist, vec3 worldLightVector)
{
	float shadowFactor = 0.0;
	const int LQnum = 2;
	float dither = BlueNoise(texcoord.st + 0.142) - 0.5;		
	float R = 1.0;
	for (int i = 1; i <= LQnum; i++)
	{
		vec3 sp = pos + 400.0 * scaleforplane * lightDir * (i + dither);
		float d = max(0.0, CloudDensity1(sp, worldDir, Nc1, Nb1, worldLightVector, R) - cloudDist * 5e-6);
        //R *= 0.3;
		shadowFactor += d;
	}
	return shadowFactor;
}

vec4 CloudColor1(in vec4 worldPosition, in float sunglow, in vec3 worldLightVector, in float altitude, in float thickness, const bool isShadowPass, vec3 dir, vec3 atmosphere)
{
    float dist = length(worldPosition.xyz-cameraPosition) / scaleforplane;
	float cloudHeight = altitude;
	float cloudDepth  = thickness;
	float cloudUpperHeight = cloudHeight + (cloudDepth / 2.0f);
	float cloudLowerHeight = cloudHeight - (cloudDepth / 2.0f);
	float LdotV = dot(dir, -worldLightVector);	
	float LdotV01 = LdotV * 0.5 + 0.5;
	vec3 p = worldPosition.xyz;	
	float noise = CloudDensity1(p, dir, Nc1, Nb1, worldLightVector, 1.0);	
	vec3 motion = vec3(-frameTimeCounter * 0.3, 0, 0) * VOLUMETRIC_CLOUD_SPEED;
	vec3 ppos = dir + noise * min(abs(dir.y) + 0.001, 1.0) * 0.4;
		ppos += Get3DNoise(dir * 20.0) * 0.02;
		ppos += Get3DNoise(dir * 10.0) * 0.04;								
	const float noiselack = 1.0f; 
	float perturbNoise = (Get3DNoise((ppos + motion) * 50.0) - noiselack) * 2.0 / (dist * 2e-4 + 1.0); 
		 perturbNoise += (Get3DNoise((ppos + motion) * 100.0) - noiselack) / (dist * 1e-4 + 1.0);
		 perturbNoise += (Get3DNoise((ppos + motion) * 200.0) - noiselack) * 0.5 / (dist * 5e-5 + 1.0);
		 perturbNoise += (Get3DNoise((ppos + motion) * 400.0) - noiselack) * 0.25 / (dist * 25e-6 + 1.0);
		 perturbNoise += (Get3DNoise((ppos + motion) * 800.0) - noiselack) * 0.125 / (dist * 125e-7 + 1.0);		 
        perturbNoise *= dist * 15e-4 + 1.0;			
	noise = saturate(noise + perturbNoise * 2e-3 + 2e-3);							
	noise = saturate(noise + perturbNoise * 2e-3 + 2e-3);	
	float fakeCLP = saturate(noise * .4 + .1) * (0.8 - perturbNoise * 0.1);	
    float forupperlight = 1.0;	
	if(cameraPosition.y > cloudHeight)
	{	
	  forupperlight = 0.0;
	}
	vec3 lightDir = worldLightVector + dir;	 
		 lightDir += dir * dist * 2e-4; 		
		 lightDir *= fakeCLP;
	vec3 lightDir2 = dir;	
		 lightDir2 += dir * dist * 2e-4; 		
		 lightDir2 *= fakeCLP; 		 
	float sundiff = TraceCloudDensity1(p + noise * dir * dist * .1, lightDir, dir, perturbNoise, noise, dist, worldLightVector);		
		 sundiff /= abs(worldLightVector.y) * .4 + 1.0;
		 sundiff += perturbNoise * 2e-4;	 
         sundiff = max(0.0f, sundiff) * forupperlight;   
		 //sundiff *= pow(LdotV01, 20.0f) * 2.0 + 1.0;		 
	float sundiff2 = TraceCloudDensity1(p + noise * dir * dist * .1, lightDir2, dir, perturbNoise, noise, dist, worldLightVector) * forupperlight;			 
	float Order = pow(sundiff * 12. + 1.0, -0.9);
	float Order2 = pow(sundiff * 3. + 1.0, -0.9);
	float DN = noise;
	float sEm = saturate(pow(Order,.5));
	     DN = exp2(-DN * 5.);
		 
	float AD = dist * 6e-4; 
		 AD = min(AD, 80.0);	 
		 
	vec3 colorDirect = upperCloudSunlightColor;
		 colorDirect = mix(colorDirect, colorDirect, vec3(wetness));	
         colorDirect *= Order;
	     colorDirect *= MiePhaseFunction(DN * exp2(-wetness*2.), LdotV01);	 		 
		 colorDirect *= CalculateMultipleScatteringCloudPhases(LdotV);		 
	vec3 colorAmbient = mix(colorSkylight, vec3(1.0) * Luminance(colorSkylight), saturate(wetness) * rainModefactor); 
		 //colorAmbient = mix(colorAmbient*exp2(-wetness*2.), upperCloudSunlightColor*exp(-wetness), 1.-exp2(-wetness*2.));		
		 colorAmbient = mix(colorAmbient, colorAmbient * 0.001f, timeMidnight);	
		 colorAmbient *= Order2;
	     atmosphere += AtmosphericScattering(normalize(-dir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), worldSunVector, 1.0, AD);
		 atmosphere = mix(atmosphere, vec3(1.0) * Luminance(colorSkylight), saturate(wetness) * rainModefactor);		 
    vec3 absorb = AtmosphereAbsorption(normalize(-dir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), AD);	
	vec3 color = colorDirect;
    color += colorAmbient;		 
    color *= absorb;
	color += atmosphere;
	noise /= min(dist * 1e-5 + 0.25, 2.0);
	noise = 1.0 - exp(-noise * noise * 40.0);
	vec4 result = vec4(color.rgb, noise);
	return result;
}

void CloudPlane1(inout vec3 color, vec3 viewDir, vec3 worldVector, float linearDepth, MaterialMask mask, vec3 worldLightVector, vec3 lightVector, float gbufferdepth)
{
	//Initialize view ray
	// vec4 worldPos = gbufferModelViewInverse * (vec4(-GetViewPosition(texcoord.st, gbufferdepth).xyz, 1.0));
	// worldVector = normalize(worldPos.xyz);


	Ray viewRay;

	viewRay.dir = normalize(worldVector.xyz - cameraPosition.y * vec3(0.0f, 1.0, 0.0f) * worldscale);
	// viewRay.origin = (gbufferModelViewInverse * vec4(0.0, 0.0, 0.0, 1.0)).xyz;
	viewRay.origin = vec3(0.0);

	float sunglow = CalculateSunglow(viewDir, lightVector);

	float cloudsAltitude = CPH;
	float cloudsThickness = 150.0f;

	float cloudsUpperLimit = cloudsAltitude;

	float density = 1.0f;

	float planeHeight = cloudsUpperLimit;

	Plane pl;
	pl.origin = vec3(0.0f, cameraPosition.y - planeHeight, 0.0f);
	pl.normal = vec3(0.0f, 1.0f, 0.0f);
	
    if(cameraPosition.y > cloudsAltitude)
	{
	  pl.normal = vec3(0.0f, -1.0f, 0.0f);	
	  worldVector *= vec3(1.0f, -1.0f, 1.0f);
	}
	
	Intersection intersection = RayPlaneIntersectionWorld(viewRay, pl);

	vec3 original = color.rgb;

	if (intersection.angle < 0.0f)
	{
		//if (intersection.distance < linearDepth || mask.sky > 0.5 || linearDepth >= far - 0.1)
		//{

			vec4 cloudSample = CloudColor1(vec4(intersection.pos.xyz, 1.0f), sunglow, worldLightVector, cloudsAltitude, cloudsThickness, false, worldVector, vec3(0.0f));
			 	 cloudSample.a = min(1.0f, cloudSample.a * density);


			float cloudDist = length(intersection.pos.xyz - cameraPosition.xyz);


			color.rgb = mix(color.rgb, cloudSample.rgb, cloudSample.a);

		//}
	}
}


float CloudShadow4(vec4 worldPos, vec3 worldLightVector)
{
	Ray ray;
	ray.dir = worldLightVector;
	ray.origin = worldPos.xyz + cameraPosition.xyz;

	Plane plane;
	plane.normal = vec3(0.0, 1.0, 0.0);
	plane.origin = vec3(0.0, 6400.0f, 0.0);

	vec3 cloudCheckPos = RayPlaneIntersection(ray, plane).pos;

	float cloudDensity = CloudDensity1 (cloudCheckPos, vec3(0.0f), 3, 0.23, worldLightVector, 1.0);
                  //(vec3 p, vec3 worldDir, const int level, const float lunacrity, vec3 worldLightVector, float R)
	return 1.0 - saturate(cloudDensity * 16.0) * 0.8;
}