
vec3 ScreenPos_From_ViewPos_Raw(vec3 viewPos){
	vec3 screenPos = vec3(gbufferProjection[0].x, gbufferProjection[1].y, gbufferProjection[2].z) * viewPos + gbufferProjection[3].xyz;
	return screenPos * (0.5 / -viewPos.z) + 0.5;
}

#define RAYTRACE_QUALITY 10 //[0 2 4 6 8 16 24 32 64 128 256 512]
#define RAYTRACE_REFINEMENT //Improves ray trace quality by refining the rays with minimal performance overhead.

bool rayTrace(vec3 rayOrigin, vec3 rayDir, float NoV, float jitter, bool isHand, inout vec3 rayPosition) {
    const int steps = RAYTRACE_QUALITY + 3;
    const float maxLength = 1.0 / RAYTRACE_QUALITY;
    float minLength = maxLength * 0.01;
    const float zThicknessThreshold = 0.2;

    float maxDist = ExpToLinearDepth(1.0);

    float rayLength = ((rayOrigin.z + rayDir.z * maxDist) > -near) ?
      	 			  (-near - rayOrigin.z) / rayDir.z : maxDist;

	vec3 direction = normalize(ScreenPos_From_ViewPos_Raw(rayDir * rayLength + rayOrigin) - rayPosition);
    float stepWeight = 1.0 / abs(direction.z);

	float stepLength = mix(minLength, maxLength, NoV);
    vec3 increment = direction * vec3(max(1.0 / vec2(viewWidth, viewHeight), stepLength), stepLength);

	rayPosition = rayPosition + increment * jitter;

	float depth = texture2D(depthtex1, rayPosition.xy).x;

    bool isRayExit = false;

	for(int i = 0; i <= steps; i++){
		if (saturate(rayPosition.xy) != rayPosition.xy) return false;

        if (depth < rayPosition.z) {

	#ifdef RAYTRACE_REFINEMENT

                if (rayPosition.z >= 1.0){
                    isRayExit = true;
                    break;
                }

                vec3 newDir = direction * stepLength;

                for (int j = 0; j < 6; j++) {
                    newDir *= 0.5;

                    if (rayPosition.z > depth) {
                        rayPosition -= newDir;
                    } else {
                        rayPosition += newDir;
                    }

                }
                depth = texture(depthtex1, rayPosition.xy).x;
                if (rayPosition.z < depth) {
                    continue;
                }

   #endif

            float linearZ = ExpToLinearDepth(rayPosition.z);
            float linearD = ExpToLinearDepth(depth);

            float dist = abs(linearD - linearZ) / linearZ;

            if (dist < zThicknessThreshold
             && linearZ > 0.0
             && linearZ < maxDist)
            return true;
        }
		/*
			if (rayPosition.x < 0 || rayPosition.x > 1 ||
				rayPosition.y < 0 || rayPosition.y > 1 ||
				rayPosition.z < 0 || rayPosition.z > 1)
			{
				break;
			}
		*/
        stepLength = clamp(abs(depth - rayPosition.z) * stepWeight, minLength, maxLength);
		rayPosition += direction * stepLength;
		depth = texture(depthtex1, rayPosition.xy).x;
	}
  
	return depth >= 1.0 && isRayExit;
	//return true;	
}

//float SignExtract(float x) {
//	return uintBitsToFloat((floatBitsToUint(x) & 0x80000000u) | floatBitsToUint(1.0));
//}

vec3 sampleGGXVNDF(vec3 Ve, float alpha, vec2 Xi) {
    Xi.y = mix(Xi.y, 0.0, 1.0);

    // Section 3.2: transforming the view direction to the hemisphere configuration
    vec3 Vh = normalize(vec3(alpha * Ve.x, alpha * Ve.y, Ve.z));

    // Section 4.1: orthonormal basis (with special case if cross product is zero)
    float lensq = Vh.x * Vh.x + Vh.y * Vh.y;
    vec3 T1 = lensq > 0.0 ? vec3(-Vh.y, Vh.x, 0.0) * inversesqrt(lensq) : vec3(1.0, 0.0, 0.0);
    vec3 T2 = cross(Vh, T1);

    // Section 4.2: parameterization of the projected area
    float r = sqrt(Xi.y);
    float phi = radians(360.0) * Xi.x;

    float s = 0.5 * (1.0 + Vh.z);

    float t1 = r * cos(phi);
    float t2 = r * sin(phi);
        t2 = (1.0 - s) * sqrt(1.0 - t1 * t1) + s * t2;

    // Section 4.3: reprojection onto hemisphere
    vec3 Nh = t1 * T1 + t2 * T2 + sqrt(max(1.0 - t1 * t1 - t2 * t2, 0.0)) * Vh;

    // Section 3.4: transforming the normal back to the ellipsoid configuration
    vec3 Ne = normalize(vec3(alpha * Nh.x, alpha * Nh.y, max(Nh.z, 0.0)));

    return Ne;
}

mat3 GetRotationMatrix(vec3 from, vec3 to) {
	float cosine = dot(from, to);

	float tmp = sign(cosine);
	      tmp = 1.0 / (tmp + cosine);

	vec3 axis = cross(to, from);
	vec3 tmpv = axis * tmp;

	return mat3(
		axis.x * tmpv.x + cosine, axis.x * tmpv.y - axis.z, axis.x * tmpv.z + axis.y,
		axis.y * tmpv.x + axis.z, axis.y * tmpv.y + cosine, axis.y * tmpv.z - axis.x,
		axis.z * tmpv.x - axis.y, axis.z * tmpv.y + axis.x, axis.z * tmpv.z + cosine
	);
}
