
const float scale = C_S_W;

float GetCN(vec3 wp, bool forCL, float lr, float Detail, float cloudHeight, float cloudDepth, int co)
{		
	float t = frameTimeCounter * VOLUMETRIC_CLOUD_SPEED;		
	float lC = 1.0f;
	
	#ifdef CLC
	  lC = texture2D(noisetex, (wp.xz - vec2(t,.0f)/3e-5*VOLUMETRIC_CLOUD_SPEED)*4e-6/C_S_W).x;
	  lC = saturate(lC*3.-.75+wetness*.3)*.5+.5;
	  //lC *= saturate(texture2D(noisetex, (wp.xz - vec2(t,.0f)/3e-5*VOLUMETRIC_CLOUD_SPEED)*14e-7/C_S_W).x * 3.0 - 0.7)*.5+.5;  
	  if (lC < 0.02)
	  {
	    return 0.0f;
	  } 
	#endif	
	
	float normalizedHeight = saturate((wp.y-cloudHeight)/cloudDepth);
	float normalizedHeight2 = saturate(1.-normalizedHeight); 
	float heightAttenuation = saturate(normalizedHeight * 5.0) * saturate(normalizedHeight2 * 5.0);  	
	float densityAttenuation = mix(1.0, 1.5, heightAttenuation) * mix(1.0, 2., normalizedHeight);  	
	vec3 p = wp.xyz*45e-5/C_S_W;  p.xy -= vec2(t,-t);
    float G = 1.0;	
    float T = 1.0;	

	float noise = mix(Get3DNoise(p), 1., wetness*.2);		
	const int octaves = C_O_S; 	
	float octScale = 2.7f; 	
	for (int j = 1; j < octaves + co; j++)
    {	      	    
	    p *= octScale;		
		G *= VC_R / octScale * lr;
    	noise += Get3DNoise(p)*G;	
		T += G;
        octScale *= 1.1;
    } 		
	    noise /= T;	
		noise += Detail;
		noise *= heightAttenuation*lC*Vol_Cloud_Coverage;			
		noise -= .9*heightAttenuation+normalizedHeight*.5;
	//if(!forCL) noise *= mix(1.,10.,heightAttenuation);	
	//if(!forCL) 
	  noise = 1.0 - exp2(-noise * 10. * densityAttenuation);
	return saturate(noise);
}

float TraceRayVC(vec3 pos, vec3 pos2, vec3 lightDir, vec3 worldDir, float Detail, float cloudDensity, float cloudDist, vec3 worldLightVector, float RDMap)
{
	float shadowFactor = 0.0;
	const int LQnum = 0;
	float dither = BlueNoise(texcoord.st + 0.111) - 0.5;	
	float r = 1.0;
	float LdotV = dot(-worldDir, -worldLightVector);		
	lightDir = lightDir - worldDir / abs(worldDir.y) * timeNoon * 0.4;		
	for (int i = 1; i <= LQnum; i++)
	{
	    float fi = pow((float(i) + dither * 0.0f) / float(LQnum), 1.5);
		vec3 spos = pos + 200.0 * lightDir * fi;
		float d = GetCN(spos, true, r, 0.0f, Cloud3Height, Cloud3thick, 0);
		shadowFactor += d * 2.0 / float(LQnum);		
	}
	return shadowFactor;
}

float TraceShadowVC(vec3 pos, vec3 pos2, vec3 lightDir, vec3 worldDir, float Detail, float cloudDensity, float cloudDist, vec3 worldLightVector, float RDMap)
{
	float LdotV = dot(worldDir, -worldLightVector);
	float sundiff = TraceRayVC(pos, pos2, lightDir, worldDir, 0.0f, 1.0f, 0.0f, worldLightVector, 0.0);		 
	float Order = exp2(-sundiff * 10.0);
    float dist = length(pos - cameraPosition) * 0.0002;
		 dist = 1.0 / (1.0 + dist);	
		 Order = mix(1.0, Order, dist);
	return Order;
}

float GetSN(vec3 wp, vec3 l, vec3 wd, float ch, float cd, float Detail, int co)
{
	    float se = 0.0;
	    float r = 1.0;				
		const int q = L_Q;				
		float dither = BlueNoise(texcoord.st+0.112)-.5;
			  //dither = CalculateNoisePattern1(vec2(0.0f), 2).b;	  
	    for (int i = 1; i <= q; ++i)
	    {	
    		if(wp.y > Cloud3Height + Cloud3thick && wp.y < Cloud3Height) break;	  
            float fi = pow(1.6, float(i)+dither*.7) * C_S_W * L_L;  		
				wp += l * fi;
		    float densityCheck = GetCN(wp, true, r, 0.0,ch,cd, co);
		        se += densityCheck * fi;
	
		        //r *= mix(1.0, L_R_S, saturate(se * 0.1));
		        r *= pow(L_R_S, 3.0 / float(q));
	    }

	return se;
}

float GetSkyN(vec3 wp, vec3 l, vec3 wd, float ch, float cd, float Detail, int co)
{
	    float se = 0.0;
	    float r = 1.0;
		const int q = 3;			
		float dither = BlueNoise(texcoord.st+0.111)-.5;		
		vec3 lv = mix(l, vec3(0.0, 1.0, 0.0), saturate(l.y*200.0));
	    for (int j = 1; j <= q; ++j)
	    {
		    if(wp.y > Cloud3Height + Cloud3thick && wp.y < Cloud3Height) break;			
		    float fi = pow(1.5, float(j)+dither*.9) * 100.0 * C_S_W;
		
		    float densityCheck = GetCN(wp, true, r, 0.0, ch, cd, co);
		    wp += fi * lv;		
		        se += densityCheck * fi * 0.5;
	    }
		
	return se;
}

float GetBN(vec3 wp, vec3 l, vec3 wd, float ch, float cd, float Detail, int co)
{
	    float se = 0.0;
	    float r = 1.0;
		const int q = 2;			
		float dither = BlueNoise(texcoord.st+0.112)-.5;		
		vec3 lv = -mix(l, vec3(0.0, 1.0, 0.0), saturate(l.y*200.0));
	    for (int j = 1; j <= q; ++j)
	    {
		    if(wp.y > Cloud3Height + Cloud3thick && wp.y < Cloud3Height) break;			
		    float fi = pow(1.5, float(j)+dither*.9) * 100.0 * C_S_W;
		    wp += fi * lv;
		    float densityCheck = GetCN(wp, true, r, 0.0, ch, cd, co);
				
		        se += densityCheck * fi * 2.0;			
	    }
		
	return se;
}

float DirectDetail(vec3 worldDir, float dist, vec3 WindDir)
{	
    float pnoise = 0.0f;
	#ifdef C_D
	
      vec3 pos = worldDir + WindDir;

	    pos += Get3DNoise(worldDir*60.0)*.25*Micro_airflow_Strength*min(abs(worldDir.y),1.);	  
	    pos += Get3DNoise(worldDir*30.0)*.5*Micro_airflow_Strength*min(abs(worldDir.y),1.);
	    pos += Get3DNoise(worldDir*15.0)*Micro_airflow_Strength*min(abs(worldDir.y),1.);		

	  pnoise += (0.5 - Get3DNoise(pos * 200.0)) * 5e-1 / (1.0 + dist * 2e-4);			
	  pnoise += (0.6 - Get3DNoise(pos * 400.0)) * 25e-2 / (1.0 + dist * 1e-4);			
	  pnoise += (0.6 - Get3DNoise(pos * 800.0)) * 125e-3 / (1.0 + dist * 5e-5);			
	  pnoise *= 1e-1 * VC_R * mix(1.0, 0.0, exp(-dist * 1e-3)) / (1.0 + A_C_O_S);
	#endif	
	  pnoise += mix(9e-2 / (1.0 + C_Q), 0.0, exp(-dist * 4e-5));	  	  	
	return pnoise;	
}		

vec4 CloudColor3(vec4 worldPosition, float sunglow, vec3 worldLightVector, vec3 worldDir, vec3 atmosphere, float cloudHeight, float cloudDepth, float eyeLength)
{	
    float dist = length(worldPosition.xyz - cameraPosition) / C_S_W;
    const float AC = A_C_O_S;	
	int co = int(clamp(AC - floor(sqrt(dist) * 7e-3), 0.0, AC));	
		float LdotV = dot(worldDir, worldLightVector);	
	    float LdotV2 = LdotV * LdotV;	
		float LdotV01 = LdotV * 0.5 + 0.5;			
	float highPoint = cloudHeight + cloudDepth;
	float lowPoint =  cloudHeight;
	float Detail = 0.0f;
	float t = frameTimeCounter * VOLUMETRIC_CLOUD_SPEED * .4;
	vec3 motion = vec3(-t,t,.0f);	
	vec3 ppos = worldDir;
		 Detail = DirectDetail(ppos, dist, motion); 
    float noise = GetCN(worldPosition.xyz, false, 1.0, Detail, cloudHeight, cloudDepth, co);
	
	     noise = smoothstep(.0,.9,noise);	 	
		 
 		if (noise < 0.0001f){
		  return vec4(0.0f);
		}		 
 
	float DN = 1.0f;			
	float sunE = GetSN(worldPosition.xyz, worldLightVector, worldDir, cloudHeight, cloudDepth, Detail, co);		
	float skyE = GetSkyN(worldPosition.xyz, worldLightVector, worldDir, cloudHeight, cloudDepth, Detail, co);
	float BE = GetBN(worldPosition.xyz, worldLightVector, worldDir, cloudHeight, cloudDepth, Detail, co);	
	float sE = 0.0f;
    //sE = saturate(sunE * 10.0);
	//sE = pow(1.+sunE*.234*0.17*rLOG2, -1.176); 
	//sE = pow(1.+sunE*.41*L_A_C*rLOG2, -1.34); 	
    //sE = pow(1.+sunE*L_A_C*rLOG2, -2.); 		
	//sE = pow(1.+sunE*L_A_C*rLOG2*.4, -1.9); 			
	sE = pow(1.+sunE*L_A_C*rLOG2*8e-1, -1.1); 	
    //sE = pow(1.+sunE*L_A_C*rLOG2*1., -1.); 	
	//if(texcoord.s > 0.5) sE = pow(1.+sunE*L_A_C*rLOG2, -1.); 			
	/*
	if(texcoord.s > 0.5){
	  sE = 0.f;
	  float cn = 1.0f;
	  float T = 0.0f;
	  for (int j = 1; j <= 10; j++)
      {	      	
	    sE += exp2(-sunE*L_A_C*rLOG2) * cn;
	    T += cn;
	    cn *= 0.6;
	    sunE *= 0.5;
	  }
	  sE /= T;		
	}
    */

	float slE = pow(1.+skyE*L_A_C*rLOG2*8e-1, -1.1);
	float sbE = pow(1.+BE*L_A_C*rLOG2*8e-1, -1.1);	
	float sEc1 = sE;
	      DN = exp2(-GetCN(worldPosition.xyz, false, 1.0, Detail, cloudHeight, cloudDepth, co));
    float Phases = CalculateMultipleScatteringCloudPhases(LdotV);			
	    vec3 colorDirect = CloudSunlightColor;
		     colorDirect = mix(colorDirect, colorDirect * 0.01, vec3(wetness));	
		     colorDirect *= sE;
			 colorDirect *= MiePhaseFunction(DN*sEc1, LdotV01);
			 colorDirect *= Phases;	
			 //colorDirect = DN;	
			 
		vec3 CSL = mix(colorSkylight, vec3(1.0) * Luminance(colorSkylight), saturate(wetness) * rainModefactor); 
			 //CSL = mix(CSL * exp2(-wetness*2.), CloudSunlightColor * exp(-wetness), 1.-exp2(-wetness*2.));
			 CSL = mix(CSL, CSL * 0.01f, timeMidnight);		 
		 	 CSL = CSL * slE;	
			 
		vec3 EB = colorSunlight * CBL; 
			 EB = mix(EB, vec3(0.0f), wetness);
			 EB = mix(EB, EB * 0.01f, timeMidnight);		 
		 	 EB = EB
			 * (1.0 - DN * DN)
			 / (1.0 + DN * DN)
			 // * exp2(-saturate((worldPosition.y - Cloud3Height) / Cloud3thick))
			 ;	
				
		float AD = dist * 6e-4; 
		     AD = min(AD, 80.0);
			 
	    atmosphere += AtmosphericScattering( normalize(worldDir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), worldSunVector, 1.0, AD);			
	    atmosphere = mix(atmosphere, vec3(Luminance(colorSkylight)), saturate(wetness) * rainModefactor);
    	if (worldDir.y < 0.0f){
			worldDir *= vec3(1.0, -1.0, 1.0);
		}		
		vec3 absorb = AtmosphereAbsorption(normalize(worldDir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), AD);	
		//float CloudVolumeShadow = TraceShadowVC(worldPosition.xyz, worldPosition.xyz, worldLightVector, worldDir, 0.0f, noise, dist, worldLightVector, 1.0f);	 
              //atmosphere *= CloudVolumeShadow;	
		 atmosphere = mix(atmosphere, vec3(1.0) * Luminance(colorSkylight), saturate(wetness) * rainModefactor);				  
		vec3 color = vec3(0.0);	
			 color += CSL;		
			 color += EB;		
			 color += colorDirect;	
             color *= absorb;	
	         color += atmosphere;	
			 // color = vec3(co);
			 // color = vec3(1.0);		
		vec4 result = vec4(color.rgb, noise);
		return result;
}

vec3 IntersectXZPlane(vec3 rayDir, float planeHeight)
{
	  return rayDir * (planeHeight - cameraPosition.y) / rayDir.y;	  
}

void CloudPlane2(inout vec3 color, vec3 viewDir, vec3 worldVector, float linearDepth, MaterialMask mask, vec3 worldLightVector, vec3 lightVector, in vec3 worldDir, float gbufferdepth, inout float cloudAlpha, vec3 worldPos)
{
       	float cloudsAltitude = Cloud3Height;
       	float cloudsThickness = Cloud3thick;  
 
		const int raySteps = C_Q;
		worldDir += cameraPosition.y * vec3(0.0f, 1.0, 0.0f) * worldscale;		
		worldDir = normalize(worldDir);				
	    vec3 rayStartPos = IntersectXZPlane(worldDir, cloudsAltitude) + cameraPosition;
		
	    vec3 rayIncrement = (worldDir * cloudsThickness / raySteps) / abs(worldDir.y);	
	    float rayIncrementLength = length(rayIncrement);
		
	    float eyeLength = length(worldPos - cameraPosition);
				
	    vec4 cloudAccum = vec4(0.0);
		float CloudVolumeShadow = 0.0f;	 
	    float visibilityAccum = 1.0;
        //float CloudVolumeShadow = 0.0f;
	    vec3 rayPos = rayStartPos;
	    rayPos += rayIncrement * BlueNoise(texcoord.st);	
        vec4 cloudSample = vec4(0.0f);
	    for (int j = 0; j < raySteps; j++)
	    {
		    if (length(rayPos - cameraPosition) > length(worldPos) || visibilityAccum < 0.00001 || worldDir.y < 0.0f || rayPos.y >= Cloud3Height + Cloud3thick)
		    {
			    break;
		    }

		    cloudSample = CloudColor3(vec4(rayPos, 1.0f), 1.0f, worldLightVector, worldDir, vec3(0.0f), cloudsAltitude, cloudsThickness, eyeLength);
		    cloudAccum.rgb += (cloudSample.rgb * cloudSample.a) * visibilityAccum;
		    visibilityAccum *= 1.0 - cloudSample.a;

		    rayPos += rayIncrement;
			//CloudVolumeShadow += TraceShadowVC(rayPos.xyz, rayPos.xyz, worldLightVector, worldDir, 0.0f, cloudSample.a, rayIncrementLength, worldLightVector, 1.0f);	
	    }
		//CloudVolumeShadow /= float(raySteps);	 
		 //color *= CloudVolumeShadow;
		cloudAlpha = 1.0 - visibilityAccum;
	    color = color * visibilityAccum + cloudAccum.rgb;		
}

void CloudPlane3(inout vec3 color, vec3 viewDir, vec3 worldVector, float linearDepth, MaterialMask mask, vec3 worldLightVector, vec3 lightVector, in vec3 worldDir, float gbufferdepth, inout float cloudAlpha, vec3 worldPos)
{
       	float cloudsAltitude = Cloud3Height;
       	float cloudsThickness = Cloud3thick;
		//cloudsThickness *= saturate(0.5 + pow((dot(-worldDir, worldSunVector) * 0.5 + 0.5), 2.0) * 0.5);
	
	    float eyeLength = length(worldPos - cameraPosition);
		
	const int raySteps = C_Q;
	const float rayExtent = 2100.0f * C_S_W;
	const float rayStepSize = rayExtent / raySteps;

	vec4 cloudAccum = vec4(0.0);
	float visibilityAccum = 1.0;

	float rayDepth = BlueNoise(texcoord.st) * rayStepSize;

	for (int i = 0; i < raySteps; i++)
	{
		vec3 rayPos = (worldDir + cameraPosition.y * vec3(0.0f, 1.0, 0.0f) * worldscale) * rayDepth + cameraPosition;
		cloudsThickness -= length(rayPos - cameraPosition) * 0.001;
		//When fully opaque, stop
		if (length(rayPos - cameraPosition) > length(worldPos) || visibilityAccum < 0.00001)
		{
			break;
		}

		//early out if not in correct altitude range
		if (worldPos.y < cloudsAltitude &&  worldPos.y> cloudsAltitude + cloudsThickness)
		{
			rayDepth += rayStepSize;
			continue;
		}
		
		vec4 cloudSample = CloudColor3(vec4(rayPos, 1.0f), 1.0f, worldLightVector, worldDir, vec3(0.0f), cloudsAltitude, cloudsThickness, eyeLength);
		cloudAccum.rgb += (cloudSample.rgb * cloudSample.a) * visibilityAccum;
		visibilityAccum *= 1.0 - cloudSample.a;

		rayDepth += rayStepSize;
	}
		cloudAlpha = 1.0 - visibilityAccum;
	color = (color * visibilityAccum) + cloudAccum.rgb;	

}

void CloudPlane4(inout vec3 color, vec3 viewDir, vec3 worldVector, float linearDepth, MaterialMask mask, vec3 worldLightVector, vec3 lightVector, in vec3 worldDir, float gbufferdepth, inout float cloudAlpha, vec3 worldPos)
{
    if (cameraPosition.y > Cloud3Height + Cloud3thick)
	{
	   Ray viewRay;
	   viewRay.dir = normalize(worldVector.xyz + cameraPosition.y * vec3(0.0f, 1.0, 0.0f) * worldscale);
	   viewRay.origin = vec3(0.0);	
	   float cloudsAltitude = Cloud3Height;
	   float cloudsThickness = Cloud3thick;
	   float cloudsUpperLimit = cloudsAltitude;
	   float planeHeight = cloudsUpperLimit;	
	   const int numSamples = C_Q;	
	   float dither = BlueNoise(texcoord.st);
	   planeHeight -= dither * (cloudsThickness / numSamples);
	   for (int j = 0; j < numSamples; j++)
	   {
	       Plane pl;
		   pl.origin = vec3(0.0f, cameraPosition.y - planeHeight, 0.0f);
		   pl.normal = vec3(0.0f, 1.0f, 0.0f);		
		   Intersection intersection = RayPlaneIntersectionWorld(viewRay, pl);
		   if (intersection.angle < 0.0f)
		   {
			   if (intersection.distance < linearDepth || linearDepth <= far - 0.1)
			   {			    
				   vec4 cloudSample = CloudColor3(vec4(intersection.pos.xyz, 1.0f), 1.0f, worldLightVector, vec3(1.0, -1.0, 1.0) * worldDir, vec3(0.0f), cloudsAltitude, cloudsThickness, 1.0f);
			       float cloudDist = length(intersection.pos.xyz-cameraPosition.xyz);
				   color.rgb = mix(color.rgb, cloudSample.rgb * 1.0f, cloudSample.a);
			   }
		   }
		     planeHeight += cloudsThickness / numSamples;		
	   }
	}	
}

float CloudShadow3(vec4 worldPos, vec3 worldLightVector)
{
	Ray ray;
	ray.dir = worldLightVector;
	ray.origin = worldPos.xyz + cameraPosition.xyz;

	Plane plane;
	plane.normal = vec3(0.0, 1.0, 0.0);
	plane.origin = vec3(0.0, Cloud3Height + Cloud3thick * 0.2, 0.0);

	vec3 cloudCheckPos = RayPlaneIntersection(ray, plane).pos;

	float cloudDensity = GetCN(cloudCheckPos, true, 0.6f, Cloud3thick * 0.0001f, Cloud3Height, Cloud3thick, 3);

	return exp2(-cloudDensity * cloudDensity * 20.0) * 0.8 + 0.2;
}