
float GetFogCN(vec3 wp, float sunglow, vec3 worldLightVector, bool forCL, vec3 worldDir, float lightingRoughness, float Detail, int NS, vec2 O, float cloudHeight, float cloudDepth, int co)
{
    float dist = length(wp.xyz-cameraPosition);

	vec3 p = wp.xyz * 0.01;
    //p += worldDir * 0.5;
	
	p.x -= frameTimeCounter * 0.01;
	p.y += frameTimeCounter * 0.005;
	
    //cloudDepth *= saturate(0.5 + pow((dot(-worldDir, worldLightVector) * 0.5 + 0.5), 2.0) * 0.5);

	float normalizedHeight  = saturate((wp.y - cloudHeight) / cloudDepth);
	float heightAttenuation = saturate(normalizedHeight / 0.15) * saturate((1.0 - normalizedHeight) / (1.0 - 0.5));
	
	float takeAway = 0.0
	    + wetness * 0.55
		- pow((dot(-worldDir, worldLightVector) * 0.5 + 0.5), 2.0) * 0.2
		 * mix(0.0f, 1.0f, wetness) 
		;
		
	float t = frameTimeCounter * VOLUMETRIC_CLOUD_SPEED;	
    float num = 0.05 + wetness * 0.0;	
    float num2 = 20.0 - wetness * 10.0;		
	
	//float dither = CalculateDitherPattern1() - 0.5;	   	
		//p += (Get3DNoise3((p * 0.5f * num2 + dither)) * 2.0f - 1.0f) * 0.10f * num;
		//p.z -= (Get3DNoise3((p * 0.25f * num2 + dither)) * 2.0f - 1.0f) * 0.25f * num;
		//p.x -= (Get3DNoise3((p * 0.125f * num2 + dither)) * 2.0f - 1.0f) * 2.2f * num;
		//p.xz -= (Get3DNoise3((p * 0.0525f * num2 + dither)) * 2.0f - 1.0f) * 2.7f * num;
	
	float noise = Get3DNoise2(p);				
	
	float S = 3.0;	
	float N = 1.2 / S;	
    const float num3 = 0.0;
	float G = lightingRoughness;
	float T = 1.0;	
	
        //p += vec3(vec2(-Get3DNoise2(p * num2)), Get3DNoise3(p * num2) * (0.5 + wetness * 0.5)) * num;		
			
	int octaves = 0;
	
	octaves += co;

    float octShift = (N / S) / octaves;
	for (int i = 1; i < octaves; i++)
    {	
	    p *= S;
		G *= N;
		noise += Get3DNoise2(p) * G;  
	 		
    }
        noise *= 0.23 / N / (0.5 + lightingRoughness * 0.5);	
        noise += octShift;						 
	    noise *= heightAttenuation;     
		noise -= Detail;
		noise *= 1.9;
		noise -= 0.9 * heightAttenuation + 0.1 + normalizedHeight * 0.5;	
		noise -= saturate(takeAway);				
		//noise = smoothstep(0.35 - O.x, 0.85 + O.y, noise);	
				
		if(!forCL)
        { 
            //noise *= pow(heightAttenuation, 2.0) * 25.0 + 1.0;  
            noise *= 2.0; 			
        }
		
	return saturate(noise * 5.0);
}

float GetFogSN(vec3 worldPosition, vec3 worldLightVector, vec3 worldDir, float cloudHeight, float cloudDepth, float Detail, int co)
{
	    float sunlightExtinction = 0.0;
	    float lightingRoughness = 1.0;
	    float RoughnessStep = 0.9;		
		const int LightQ = 1;		
		float dither = BlueNoise(texcoord.st + frameTimeCounter * 0.0001) - 0.5;
	    for (int i = 1; i <= LightQ; i++)
	    {		    
		    float fi = float(i) + dither;
			    fi /= float(LightQ);
		        fi = pow(fi * 1.5, 1.5);
			if (LightQ < 2)
		    {
		    	lightingRoughness = 0.8;
		    }	
		    vec3 checkPos = worldPosition.xyz + fi * 150.0 * worldLightVector;

		    float densityCheck = GetFogCN(checkPos, 0.0f, worldLightVector, true, worldDir, lightingRoughness, 0.0f, i, vec2(0.0, 0.2), cloudHeight, cloudDepth, co);
		        sunlightExtinction += densityCheck / float(LightQ) * 3.0;
		        lightingRoughness *= pow(RoughnessStep, 3.0 / float(LightQ));
	    }
		
	if (sunlightExtinction < 0.0001f)
	{
		return 0.0f;
	}		
	
	return sunlightExtinction;
}

float GetFogSkyN(vec3 worldPosition, vec3 worldLightVector, vec3 worldDir, float cloudHeight, float cloudDepth, float Detail, int co)
{
	    float skylightExtinction = 0.0;
	    float lightingRoughness = 1.0;
	    float RoughnessStep = 0.9;		
		const int LightQ = 1;
		float dither = BlueNoise(texcoord.st + frameTimeCounter * 0.0001) - 0.5;		
	    for (int j = 1; j <= LightQ; j++)
	    {
		    float fi = float(j) + dither * 0.5;
		    fi = fi / float(LightQ);
		    fi = pow(fi, 1.5);	
			
			//if (LightQ < 2)
		    //{
		    //	lightingRoughness = 0.8;
		    //}			
			
		    vec3 checkPos2 = worldPosition.xyz + fi * vec3(0.0f, 50.0f, 0.0f) / float(LightQ);
			
		    float densityCheck = GetFogCN(checkPos2, 0.0f, worldLightVector, true, worldDir, lightingRoughness, 0.0f, j, vec2(0.1f, 0.0f), cloudHeight, cloudDepth, co);		
                lightingRoughness *= pow(RoughnessStep, 1.0 / float(LightQ));
		        skylightExtinction += densityCheck / float(LightQ);
	    }
		
	if (skylightExtinction < 0.0001f)
	{
		return 0.0f;
	}		
	
	return skylightExtinction;
}


		
vec4 CloudColor5(vec4 worldPosition, float sunglow, vec3 worldLightVector, vec3 worldDir, vec3 atmosphere, float cloudHeight, float cloudDepth, float eyeLength)
{	
    float dist = length(worldPosition.xyz - cameraPosition);
	int co = 3;
	
	float LdotV = dot(worldDir, worldSunVector);
	float LdotV01 = LdotV * 0.5 + 0.5;
	float LdotV2 = LdotV * LdotV;

	float cloudUpperHeight = cloudHeight + cloudDepth;
	float cloudLowerHeight = cloudHeight - (cloudDepth / 2.0f);
	

	
	float highPoint = cloudHeight + cloudDepth;
	float lowPoint =  cloudHeight;
	
	float Detail = 0.0f;
	float t = frameTimeCounter * 0.005f;
	vec3 motion = vec3(-t, t, 0.0f);
	
	vec3 ppos = worldDir + Get3DNoise3(worldDir * 30.0) * 0.01f;
		ppos += motion;
	const float nm = 1.0f;	
		 Detail += Get3DNoise3(ppos * 50.0 * nm) * 2.0
		  / (1.0 + dist * 0.02)
		 ;	
		 Detail -= Get3DNoise3(ppos * 100.0 * nm) * 2.0
		  / (1.0 + dist * 0.01)
		 ;			
		 Detail += Get3DNoise3(ppos * 200.0 * nm)
		  / (1.0 + dist * 0.005)
		 ;	
		 Detail -= Get3DNoise3(ppos * 400.0 * nm) * 0.5
		  / (1.0 + dist * 0.0025)
		 ;			
		 
         Detail *= dist * 0.001;		 
         //Detail += mix(0.0f, 0.5f, 1.0 / (1.0 + dist * 0.00005)) * 0.5 - 0.25;
		 
	float vgrad = remap(lowPoint, highPoint, worldPosition.y + Detail);
		 		
    float noise = GetFogCN(worldPosition.xyz, sunglow, worldSunVector, false, worldDir, 1.0, Detail, 0, vec2(0.0f), cloudHeight, cloudDepth, co); 			
	float DN = noise;	
	
		noise = smoothstep(0.0, 0.6, noise);
		
 		if (noise < 0.0001f)
		{
			return vec4(0.0f, 0.0f, 0.0f, 0.0f);
		}							
	float sunlightExtinction = GetFogSN(worldPosition.xyz, worldSunVector, worldDir, cloudHeight, cloudDepth, Detail, co);
		
	float skylightExtinction = GetFogSkyN(worldPosition.xyz, worldSunVector, worldDir, cloudHeight, cloudDepth, Detail, co);

	float sunlightEnergy = pow(1.0 / (1.0 + sunlightExtinction * 7.0), 1.0);	
	float skylightEnergy = pow(1.0 / (1.0 + skylightExtinction * 2.0), 1.0);	
		
	    vec3 colorDirect = mix(upperCloudSunlightColor * 9.0f, vec3(5.0) * Luminance(colorSunlight), timeMidnight);
		      //colorDirect = mix(colorDirect, colorDirect * 0.5, saturate(wetness));
		      colorDirect *= sunlightEnergy
		      * PhaseMie(
			  saturate(sunlightEnergy * sunlightEnergy * 2.2)
			  * 0.95
			  * exp(-DN)
			  , LdotV, LdotV2)
		      ;

		vec3 CSL = mix(colorSkylight, vec3(1.0) * Luminance(colorSkylight), saturate(wetness) * rainModefactor); 
			 //CSL = mix(CSL * skylightEnergy, CSL * sunlightEnergy * 0.5, timeMidnight);
			 CSL = CSL * skylightEnergy * (1.0 - 0.9 * timeMidnight)
			 //* PhaseMie(skylightEnergy, LdotV, LdotV2)
			 ;
		vec3 color = vec3(0.0f);
		//color += timeMidnight * sunlightEnergy * PhaseMie(0.95 * exp(-DN) * sunlightEnergy * mix(1.0, 0.5, wetness), LdotV, LdotV2) * colorSunlight;
	    //color += mix(colorSkylight * skylightEnergy, atmosphere * 0.5 + colorSkylight * 1., vec3(exp2(-DN * 10.0)));
        color += CSL;	
        color += colorDirect;		
	    //color += vec3(colorSunlight * max(0.0, 1.0 - skylightEnergy) * 0.5) * (1.0 - wetness);	
	    color *= exp2(-dist * mix(vec3(0.15, 0.4, 1.0), vec3(1.0), vec3(wetness * 1.0)) * 0.00038);
	    color += atmosphere * (1.0 - exp2(-dist * 0.00038 * mix(1.0, 0.45, wetness) * mix(1.0, sunlightEnergy * 0.9 + 0.1, sunglow)));      
		vec4 result = vec4(color.rgb, noise);

		return result;
	
}

void Fog(inout vec3 color, vec3 viewDir, vec3 worldVector, float linearDepth, MaterialMask mask, vec3 worldLightVector, vec3 lightVector, in vec3 worldDir, float gbufferdepth, inout float cloudAlpha, vec3 worldPos)
{

       	vec3 jitteredCoord = vec3(texcoord.st, 0.0);

       	float sunglow = min(CalculateSunglow(viewDir, lightVector), 2.0);

       	float cloudsAltitude = Cloud5Height;
       	float cloudsThickness = Cloud5thick;
		//cloudsThickness *= saturate(0.5 + pow((dot(-worldDir, worldSunVector) * 0.5 + 0.5), 2.0) * 0.5);
		//cloudsThickness *= mix(1.0, 1.6, wetness);
		
		vec3 atmosphere = AtmosphericScattering(worldDir, worldSunVector, 1.0);
			atmosphere = mix(atmosphere, vec3(1.0) * Luminance(colorSkylight), saturate(wetness) * rainModefactor);
			
	    float eyeLength = length(worldPos - cameraPosition);
		
	const int raySteps = 5;
	const float rayExtent = 400.0f;
	const float rayStepSize = rayExtent / raySteps;

	vec4 cloudAccum = vec4(0.0);
	float visibilityAccum = 1.0;

	float rayDepth = 0.0 + BlueNoise(texcoord.st + frameTimeCounter * 0.00001) * rayStepSize;

	for (int i = 0; i < raySteps; i++)
	{
		vec3 rayPos = (worldDir * rayDepth) + cameraPosition;
		cloudsThickness = Cloud5thick
		//+ 255.0f * wetness
		+ 21.0f
		- length(rayPos - cameraPosition) * 0.02
		;
		//When fully opaque, stop
		if (length(rayPos - cameraPosition) > length(worldPos) || visibilityAccum < 0.00001)
		{
			break;
		}

		//early out if not in correct altitude range
		if (worldPos.y < cloudsAltitude &&  worldPos.y> cloudsAltitude + cloudsThickness)
		{
			rayDepth += rayStepSize;
			continue;
		}

		vec4 cloudSample = CloudColor3(vec4(rayPos, 1.0f) * 5.0, sunglow, worldLightVector, worldDir, atmosphere, cloudsAltitude, cloudsThickness, eyeLength);
		cloudAccum.rgb += (cloudSample.rgb * cloudSample.a) * visibilityAccum;
		visibilityAccum *= 1.0 - cloudSample.a;

		rayDepth += rayStepSize;
	}
	
	color = (color * visibilityAccum) + cloudAccum.rgb;	

}