#version 120

/*
 _______ _________ _______  _______  _
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the LICENSE.txt contained in the root directory of this shaderpack!

*/

/////////////////////////CONFIGURABLE VARIABLES////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////CONFIGURABLE VARIABLES////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////END OF CONFIGURABLE VARIABLES/////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////END OF CONFIGURABLE VARIABLES/////////////////////////////////////////////////////////////////////////////////////////////////////////////



#include "Common.inc"


#define SHADOW_MAP_BIAS 0.9

#define RAYLEIGH_AMOUNT 1.0 // Density of atmospheric scattering. [0.5 1.0 1.5 2.0 3.0 4.0]

#define SUNLIGHT_INTENSITY 1.0 // Intensity of sunlight. [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

#define VOLUMETRIC_LIGHT                        //True GodRays, not 2D ScreenSpace

//#define HQ_VOLUMETRIC_LIGHT                        

#define VOLUMETRIC_LIGHT_Density          0.005 //[0.0001 0.00025 0.0005 0.00075 0.001 0.002 0.003 0.004 0.005 0.006 0.007 0.008 0.009 0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.2 1.5 1.75 2.0 2.5 3.0 3.5 4.0 5.0 6.0 8.0 10.0]   
                  
//#define Volumetric_CloudShadow

#define Volumetric_Clouds

#define Cloud3Height 3000.0						//[100.0 120.0 140.0 160.0 180.0 200.0 220.0 240.0 250.0 270.0 300.0 310.0 320.0 330.0 340.0 350.0 360.0 370.0 400.0 500.0 550.0 600.0 650.0 700.0 800.0 900.0 1000.0 1500.0 1600.0 2000.0 2500.0  3000.0 4000.0 5000.0 6000.0 7000.0 8000.0 9000.0 10000.0] //Sets the Volumetric clouds3 Height

#define Cloud3thick 1600.0						//[100.0 120.0 140.0 160.0 180.0 200.0 220.0 240.0 250.0 270.0 300.0 310.0 320.0 330.0 340.0 350.0 360.0 370.0 400.0 500.0 550.0 600.0 650.0 700.0 800.0 900.0 1000.0 1500.0 1600.0 2000.0 2500.0  3000.0 4000.0 5000.0 6000.0 7000.0 8000.0 9000.0 10000.0] //Sets the Volumetric clouds3 Height

#define airflow_Strength 1.0                    //[0.0 0.05 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0]

#define upprtairflow_Strength 1.0               //[0.0 0.05 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0]

#define VOLUMETRIC_CLOUD_SPEED 0.02             //[0.0 0.001 0.0025 0.005 0.006 0.007 0.008 0.009 0.01 0.0125 0.015 0.02 0.025 0.03 0.04 0.05 0.06 0.07 0.075 0.08 0.09 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.4 1.6 1.8 2.0 2.5 3.0 3.5 4.0 4.5 5.0 5.5 6.0 6.5 7.0 7.5 8.0] //Default is 0.01f, Lower number to slow speed, Higher number to increase speed 

#define VC_R                  0.5               //[0.3 0.33 0.4 0.42 0.43 0.44 0.45 0.46 0.48 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95]

#define C_S_W                 0.2               //[0.005 0.0075 0.01 0.015 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.25 1.5 1.75 2.0 2.25 2.5 3.0 3.5 4.0 4.5 5.0 6.0 7.0 8.0 9.0 10.0]

#define C_O_S                 3                 //[0 1 2 3 4 5 6 7 8 9 10]     
           
#define A_C_O_S               3.0               //[0.0 1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0]         

#define Vol_Cloud_Coverage    2.0               //[1.3 1.4 1.5 2.0 2.1 2.2 2.3 2.4 2.5 3.0 3.5 4.0 4.5 5.0]

#define CLC   

#define TAA_ENABLED // Temporal Anti-Aliasing. Utilizes multiple rendered frames to reconstruct an anti-aliased image similar to supersampling. Can cause some artifacts.

#define L_A_C                 0.07              //[0.0 0.00025 0.0005 0.0006 0.0007 0.00075 0.0008 0.0009 0.001 0.0015 0.002 0.0022 0.0025 0.003 0.004 0.005 0.006 0.007 0.0075 0.008 0.009 0.01 0.011 0.012 0.013 0.014 0.0l5 0.016 0.017 0.018 0.019 0.02 0.021 0.025 0.03 0.04 0.05 0.06 0.07 0.075 0.08 0.09 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.86 0.9 0.95 0.99 1.0 1.25 1.5 1.75 2.0 2.5 3.0 3.5 4.0 4.5 5.0 6.0 7.0 8.0 9.0 10.0]
 
#define Density_Curve_C       1.0               //[1.0 1.1 1.2 1.3 1.4 1.5 2.0 2.1 2.2 2.3 2.4 2.5 3.0 3.5 4.0 4.3 4.5 4.7 5.0 5.2 5.7 6.0 6.5 7.0 8.0 9.0 10.0 15.0 20.0 50.0 100.0 200.0 400.0 800.0 1000.0]

#define cloud_shadow

//#define SSPTGI

#define HCCURVE               1.0               //[0.0 0.05 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.2 1.25 1.3 1.5 2.0 2.5 3.0 2.75 4.0 5.0 6.0 7.0 8.0]

//#define PWNOISE

const int 		noiseTextureResolution  = 64;


/* DRAWBUFFERS:6 */

const bool gnormalMipmapEnabled = true;
const bool gaux3MipmapEnabled = true;

uniform sampler2D gcolor;
uniform sampler2D gdepth;
uniform sampler2D depthtex1;
uniform sampler2D gdepthtex;
uniform sampler2D gnormal;
uniform sampler2D composite;
uniform sampler2D gaux1;
uniform sampler2D gaux2;
uniform sampler2D gaux3;
uniform sampler2D gaux4;
uniform sampler2D noisetex;

uniform sampler2DShadow shadow;


varying vec4 texcoord;
varying vec3 lightVector;
varying vec3 sunVector;

uniform int worldTime;

uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float aspectRatio;
uniform float frameTimeCounter;
uniform sampler2D shadowcolor;
uniform sampler2D shadowcolor1;
uniform sampler2D shadowtex1;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;
uniform mat4 gbufferModelView;

uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;

uniform int   isEyeInWater;
uniform float eyeAltitude;
uniform ivec2 eyeBrightness;
uniform ivec2 eyeBrightnessSmooth;
uniform int   fogMode;

varying float timeSunriseSunset;
varying float timeNoon;
varying float timeMidnight;
uniform int frameCounter;
varying vec3 colorSunlight;
varying vec3 colorSkylight;
varying vec3 colorTorchlight;
varying vec3 upperCloudSunlightColor;
varying vec3 CloudSunlightColor;

varying vec3 worldSunVector;
varying vec3 worldLightVector;

varying vec4 skySHR;
varying vec4 skySHG;
varying vec4 skySHB;

uniform float blindness;
uniform float nightVision;

#define ANIMATION_SPEED 1.0f
float SCLE = 1.0 / pow(2.0f, (1.0 + cos(frameTimeCounter * 2000.0) * 0.) * .0);
#define FRAME_TIME frameTimeCounter * ANIMATION_SPEED

/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

vec2 rot(vec2 p, float angle)
{
    vec2 po = p;
	
    mat2 mat = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    p = mat * p;

    return p;
}

vec2 WeylNth(int n)
{
	return fract(vec2(n * 12664745, n*9560333) / exp2(24.0));
}

vec2 JitterSampleOffset(int frameOffset)
{
	return (WeylNth((frameCounter + frameOffset) % 16) * 2.0 - 1.0);
}

void TemporalJitterProjPos(inout vec4 pos)
{
	#ifdef TAA_ENABLED

	 pos.xy -= (JitterSampleOffset(0) * 0.5) / vec2(viewWidth, viewHeight);

	#else

	 pos.xy -= (JitterSampleOffset(0) * 0.5) / vec2(viewWidth, viewHeight);	
	
	#endif
}

void TemporalJitterProjPos(inout vec3 pos)
{
	#ifdef TAA_ENABLED
	
	 pos.xy -= (JitterSampleOffset(0) * 0.5) / vec2(viewWidth, viewHeight);

	#else
 
 	 pos.xy -= (JitterSampleOffset(0) * 0.5) / vec2(viewWidth, viewHeight);
	 
	#endif
}

vec4 GetViewPosition(in vec2 coord, in float depth) 
{	
	vec4 fragposition = gbufferProjectionInverse * vec4(coord.s * 2.0f - 1.0f, coord.t * 2.0f - 1.0f, 2.0f * depth - 1.0f, 1.0f);
		 fragposition /= fragposition.w;
	
	return fragposition;
}

float 	ExpToLinearDepth(in float depth)
{
	return 2.0f * near * far / (far + near - (2.0f * depth - 1.0f) * (far - near));
}

float GetDepth(vec2 coord)
{
	return texture2D(depthtex1, coord).x;
}

float GetMaterialMask(const in int ID, in float matID) 
{
	//Catch last part of sky
	if (matID > 254.0f) 
	{
		matID = 0.0f;
	}

	if (matID == ID) 
	{
		return 1.0f;
	} 
	else 
	{
		return 0.0f;
	}
}

float CurveBlockLightSky(float blockLight)
{
	blockLight = pow(blockLight, 3.5);

	//blockLight = InverseSquareCurve(1.0 - blockLight, 0.2);
	//blockLight = 1.0 - pow(1.0 - blockLight, 0.45);
	//blockLight *= blockLight * blockLight;

	return blockLight;
}

float CurveBlockLightTorch(float blockLight)
{

///*
	float falloff = 10.0;

	blockLight = exp(-(1.0 - blockLight) * falloff);
	blockLight = max(0.0, blockLight - exp(-falloff));
//*/

/*
	float lightmap = blockLight;

	//Apply inverse square law and normalize for natural light falloff
	lightmap 		= clamp(lightmap * 1.22f, 0.0f, 1.0f);
	lightmap 		= 1.0f - lightmap;
	lightmap 		*= 5.6f;
	lightmap 		= 1.0f / pow((lightmap + 0.8f), 2.0f);
	lightmap 		-= 0.02435f;

	// if (lightmap <= 0.0f)
		// lightmap = 1.0f;

	lightmap 		= max(0.0f, lightmap);
	lightmap 		*= 0.008f;
	lightmap 		= clamp(lightmap, 0.0f, 1.0f);
	lightmap 		= pow(lightmap, 0.9f);


	blockLight = lightmap * 10.0;
*/
	return blockLight;
}

vec3 	CalculateNoisePattern1(vec2 offset, float size) 
{
	vec2 coord = texcoord.st;

	coord *= vec2(viewWidth, viewHeight);
	coord = mod(coord + offset, vec2(size));
	coord /= noiseTextureResolution;

	return texture2D(noisetex, coord).xyz;
}

vec3 BlueNoiseTemporal(vec2 coord)
{
	vec2 noiseCoord = vec2(coord.st * vec2(viewWidth, viewHeight)) / 64.0;

	//noiseCoord = (floor(noiseCoord * 64.0) + 0.5) / 64.0;
	
	vec3 irrationals = vec3(sqrt(1.0 / 5.0), sqrt(2.0), 1.61803398) * 1.0;

	vec3 n = vec3(texture2D(noisetex, noiseCoord).b);

	n = mod(n + irrationals * mod(frameCounter, 11.0f), vec3(1.0));

	return n;
}

vec3 BlueNoiseL(vec2 coord)
{
	vec2 noiseCoord = vec2(coord.st * vec2(viewWidth, viewHeight)) / 64.0;
	noiseCoord += vec2(sin(frameCounter * 0.75), cos(frameCounter * 0.75));

	noiseCoord = (floor(noiseCoord * 64.0) + 0.5) / 64.0;

	vec3 blueNoise = texture2DLod(noisetex, noiseCoord.st, 0).xyz;

	return blueNoise;
}

float BlueNoises(vec2 coord)
{
	vec2 noiseCoord = vec2(coord.st * vec2(viewWidth, viewHeight)) / 64.0;

	noiseCoord = (floor(noiseCoord * 64.0) + 0.5) / 64.0;

	float blueNoise = texture2DLod(noisetex, noiseCoord.st, 0).b;

	return blueNoise;
}


float BlueNoise(vec2 coord)
{
	vec2 noiseCoord = vec2(coord.st * vec2(viewWidth, viewHeight)) / 64.0;
	
	noiseCoord += vec2(sin(frameCounter * 0.75), cos(frameCounter * 0.75));
	
	noiseCoord = (floor(noiseCoord * 64.0) + 0.5) / 64.0;

	float blueNoise = texture2DLod(noisetex, noiseCoord.st, 0).b;

	return blueNoise;
}

float GetDepthLinear(in vec2 coord) 
{					
	return (near * far) / (texture2D(depthtex1, coord).x * (near - far) + far);
}

float GetDepthLinear2(float depth){
	return (2.0 * near) / (far + near - depth * (far - near));
}

vec3 GetNormals(vec2 coord)
{
	return DecodeNormal(texture2D(gnormal, coord * SCLE).xy);
}

/////////////////////////STRUCTS///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////STRUCTS///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

struct GbufferData
{
	vec3 albedo;
	vec3 normal;
	float depth;
	vec2 mcLightmap;
	float smoothness;
	float metallic;
	float emissive;
	float materialID;
	float rainMask;
};


struct MaterialMask
{
	float sky;
	float land;
	float grass;
	float leaves;
	float hand;
	float entityPlayer;
	float water;
	float stainedGlass;
	float ice;
};


/////////////////////////STRUCT FUNCTIONS//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////STRUCT FUNCTIONS//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

struct Ray {
	vec3 dir;
	vec3 origin;
};

struct Plane {
	vec3 normal;
	vec3 origin;
};

struct Intersection {
	vec3 pos;
	float distance;
	float angle;
};

GbufferData GetGbufferData()
{
	GbufferData data;

	vec4 tex2 = texture2DLod(gnormal, texcoord.st, 0);
	vec3 gbuffer0 = texture2D(gcolor, texcoord.st * SCLE).rgb;
	vec3 gbuffer1 = texture2D(gdepth, texcoord.st).rgb;
	vec2 gbuffer2 = texture2D(gnormal, texcoord.st * SCLE).rg;
	vec3 gbuffer3 = texture2D(composite, texcoord.st).rgb;
	float depth = texture2D(gdepthtex, texcoord.st).x;


	data.albedo = GammaToLinear(gbuffer0);

	data.mcLightmap = gbuffer3.rg;
	data.mcLightmap.g = CurveBlockLightSky(data.mcLightmap.g);
	data.mcLightmap.r = CurveBlockLightTorch(data.mcLightmap.r);
	data.emissive = gbuffer1.b;

	data.normal = DecodeNormal(gbuffer2);

	data.smoothness = gbuffer3.r;
	data.metallic = gbuffer3.g;
	data.materialID = gbuffer3.b;

	data.depth = depth;

	data.rainMask = tex2.a;
	
	return data;
}

MaterialMask CalculateMasks(float materialID)
{
	MaterialMask mask;

	materialID *= 255.0;

	if (isEyeInWater > 0)
		mask.sky = 0.0f;
	else
		mask.sky = GetMaterialMask(0, materialID);

	mask.land 			= GetMaterialMask(1, materialID);
	mask.grass 			= GetMaterialMask(2, materialID);
	mask.leaves 		= GetMaterialMask(3, materialID);
	mask.hand 			= GetMaterialMask(4, materialID);
	mask.entityPlayer 	= GetMaterialMask(5, materialID);
	mask.water 			= GetMaterialMask(6, materialID);
	mask.stainedGlass	= GetMaterialMask(7, materialID);
	mask.ice 			= GetMaterialMask(8, materialID);

	return mask;
}

float GetMaterialIDs(vec2 coord)
{
	return texture2D(composite, coord).b;
}

vec3  	GetWaterNormals(in vec2 coord) {				//Function that retrieves the screen space surface normals. Used for lighting calculations
	return DecodeNormal(texture2D(gaux1, coord).xy);
}

bool 	GetSkyMask(in vec2 coord)
{
	float matID = GetMaterialIDs(coord);
	matID = floor(matID * 255.0f);

	if (matID < 1.0f || matID > 254.0f)
	{
		return true;
	} else {
		return false;
	}
}

vec4 GetViewPositionRaw(in vec2 coord, in float depth) 
{	
	vec4 tcoord = vec4(coord.xy, 0.0, 0.0);
	//TemporalJitterProjPos(tcoord);
	//TemporalJitterProjPos(tcoord);
	//tcoord.x += 1.1;
	//tcoord.x = 0.0;

	vec4 fragposition = gbufferProjectionInverse * vec4(tcoord.s * 2.0f - 1.0f, tcoord.t * 2.0f - 1.0f, 2.0f * depth - 1.0f, 1.0f);
		 fragposition /= fragposition.w;

	
	return fragposition;
}


vec4 BilateralUpsample(const in float scale, in vec2 offset, in float depth, in vec3 normal, in float cloudAlpha)
{
	vec2 recipres = vec2(1.0f / viewWidth, 1.0f / viewHeight);

	vec4 light = vec4(0.0f);
	float weights = 0.0f;
	const float maxF = 0.5f;
    float SF = 0.5f;		
	float angle = BlueNoise(texcoord.st + 0.113) * PI * 2.0;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));
	float X2 = 0.0f;
	for (float i = -maxF; i <= maxF; i += SF)
	{
		for (float j = -maxF; j <= maxF; j += SF)
		{
			vec2 coord = vec2(i + BlueNoiseL(texcoord.st).b - 0.5, j + BlueNoiseL(texcoord.st).b - 0.5) * 1.32 / vec2(viewWidth, viewHeight);
            X2 = cloudAlpha;
			
			float weight = 1.0;
				  weight *= X2;				  
			//weight = 1.0f;
			light += pow(texture2DLod(gaux3, texcoord.st * exp2(-scale) + coord * 0.0f, 0), vec4(2.2f, 2.2f, 2.2f, 1.0f)) * weight;
			weights += weight;
		}
	}


	light /= max(0.00001f, weights);

	if (weights < 0.01f)
	{
		light =	pow(texture2DLod(gaux3, (texcoord.st) * (1.0f / exp2(scale 	)) + offset, 1), vec4(2.2f, 2.2f, 2.2f, 1.0f));
	}


	//light.rgb = vec3(X2 * 0.0001);


	return light;
}




void FixNormals(inout vec3 normal, in vec3 viewPosition)
{
	vec3 V = normalize(viewPosition.xyz);
	vec3 N = normal;

	float NdotV = dot(N, V);

	N = normalize(mix(normal, -V, clamp(pow((NdotV * 1.0), 1.0), 0.0, 1.0)));
	N = normalize(N + -V * 0.1 * clamp(NdotV + 0.4, 0.0, 1.0));

	normal = N;
}

vec4 textureLodSmooth(in sampler2D tex, in vec2 coord, in float level)
{
	vec2 res = vec2(viewWidth, viewHeight);
	coord = coord * res + 0.5f;
	vec2 i = floor(coord);
	vec2 f = fract(coord);
	f = f * f * (3.0f - 2.0f * f);
	coord = i + f;
	coord -= 0.5f;
	coord /= res;
	return texture2D(tex, coord, level);
}

vec4 textureSmooth(in sampler2D tex, in vec2 coord)
{
	vec2 res = vec2(64.0f, 64.0f);

	coord *= res;
	coord += 0.5f;

	vec2 whole = floor(coord);
	vec2 part  = fract(coord);

	part.x = part.x * part.x * (3.0f - 2.0f * part.x);
	part.y = part.y * part.y * (3.0f - 2.0f * part.y);
	// part.x = 1.0f - (cos(part.x * 3.1415f) * 0.5f + 0.5f);
	// part.y = 1.0f - (cos(part.y * 3.1415f) * 0.5f + 0.5f);

	coord = whole + part;

	coord -= 0.5f;
	coord /= res;

	return texture2D(tex, coord * SCLE);
}

float AlmostIdentity(in float x, in float m, in float n)
{
	if (x > m) return x;

	float a = 2.0f * n - m;
	float b = 2.0f * m - 3.0f * n;
	float t = x / m;

	return (a * t + b) * t * t + n;
}

float GetWaves(vec3 position, float frameTimeCounter) 
{
	float speed = 0.9f;

  vec2 p = position.xz / 20.0f;

  p.xy -= position.y / 20.0f;

  p.x = -p.x;

  p.x += (frameTimeCounter / 40.0f) * speed;
  p.y -= (frameTimeCounter / 40.0f) * speed;

  float weight = 1.0f;
  float weights = weight;

  float allwaves = 0.0f;

  float wave = textureSmooth(noisetex, (p * vec2(2.0f, 1.2f))  + vec2(0.0f,  p.x * 2.1f) ).x; 			p /= 2.1f; 	/*p *= pow(2.0f, 1.0f);*/ 	p.y -= (FRAME_TIME / 20.0f) * speed; p.x -= (FRAME_TIME / 30.0f) * speed;
  allwaves += wave;

  weight = 4.1f;
  weights += weight;
      wave = textureSmooth(noisetex, (p * vec2(2.0f, 1.4f))  + vec2(0.0f,  -p.x * 2.1f) ).x;	p /= 1.5f;/*p *= pow(2.0f, 2.0f);*/ 	p.x += (FRAME_TIME / 20.0f) * speed;
      wave *= weight;
  allwaves += wave;

  weight = 17.25f;
  weights += weight;
      wave = (textureSmooth(noisetex, (p * vec2(1.0f, 0.75f))  + vec2(0.0f,  p.x * 1.1f) ).x);		p /= 1.5f; 	p.x -= (FRAME_TIME / 55.0f) * speed;
      wave *= weight;
  allwaves += wave;

  weight = 15.25f;
  weights += weight;
      wave = (textureSmooth(noisetex, (p * vec2(1.0f, 0.75f))  + vec2(0.0f,  -p.x * 1.7f) ).x);		p /= 1.9f; 	p.x += (FRAME_TIME / 155.0f) * speed;
      wave *= weight;
  allwaves += wave;

  weight = 29.25f;
  weights += weight;
      wave = abs(textureSmooth(noisetex, (p * vec2(1.0f, 0.8f))  + vec2(0.0f,  -p.x * 1.7f) ).x * 2.0f - 1.0f);		p /= 2.0f; 	p.x += (FRAME_TIME / 155.0f) * speed;
      wave = 1.0f - AlmostIdentity(wave, 0.2f, 0.1f);
      wave *= weight;
  allwaves += wave;

  weight = 15.25f;
  weights += weight;
      wave = abs(textureSmooth(noisetex, (p * vec2(1.0f, 0.8f))  + vec2(0.0f,  p.x * 1.7f) ).x * 2.0f - 1.0f);
      wave = 1.0f - AlmostIdentity(wave, 0.2f, 0.1f);
      wave *= weight;
  allwaves += wave;

  allwaves /= weights;

  return allwaves;
}

vec3 GetWavesNormal2(vec3 position, float time) 
{

	float WAVE_HEIGHT = 1.0;

	const float sampleDistance = 11.0f;

	position -= vec3(0.005f, 0.0f, 0.005f) * sampleDistance;

	float wavesCenter = GetWaves(position, time);
	float wavesLeft = GetWaves(position + vec3(0.01f * sampleDistance, 0.0f, 0.0f), time);
	float wavesUp   = GetWaves(position + vec3(0.0f, 0.0f, 0.01f * sampleDistance), time);

	vec3 wavesNormal;
		 wavesNormal.r = wavesCenter - wavesLeft;
		 wavesNormal.g = wavesCenter - wavesUp;

		 wavesNormal.r *= 10.0f * WAVE_HEIGHT / sampleDistance;
		 wavesNormal.g *= 10.0f * WAVE_HEIGHT / sampleDistance;

		 wavesNormal.b = sqrt(1.0f - wavesNormal.r * wavesNormal.r - wavesNormal.g * wavesNormal.g);
		 wavesNormal.rgb = normalize(wavesNormal.rgb);



	return wavesNormal.rgb;
}

vec3 GetWavesNormal(vec3 position, float time) {

	vec2 coord = position.xz / 50.0;
	coord.xy -= position.y / 50.0;
	//coord -= floor(coord);

	coord = mod(coord, vec2(1.0));


	float texelScale = 1.0;

	//to fix color error with GL_CLAMP
	//coord.x = coord.x * ((viewWidth - 1 * texelScale) / viewWidth) + ((0.5 * texelScale) / viewWidth);
	//coord.y = coord.y * ((viewHeight - 1 * texelScale) / viewHeight) + ((0.5 * texelScale) / viewHeight);


	coord.xy = clamp(coord.xy, (0.5 / vec2(viewWidth, viewHeight)), 1.0 - (0.5 / vec2(viewWidth, viewHeight)));

	vec3 normal;
	//normal.xyz = ((texture2DLod(gaux4, coord, 0).xyz) * 2.0 - 1.0);
	normal.xyz = DecodeNormal(texture2DLod(gaux1, coord, 0).zw);

	return normal;
}


void WaterRefraction(inout vec3 color, MaterialMask mask, vec4 worldSpacePosition, float waterDepth, float opaqueDepth, out vec2 refractionCoord)
{
	refractionCoord = texcoord.st * SCLE;

	if (mask.water > 0.5 || mask.ice > 0.5 || mask.stainedGlass > 0.5)
	{
		vec3 wavesNormal;
		if (mask.water > 0.5)
			 wavesNormal = GetWavesNormal(worldSpacePosition.xyz + cameraPosition.xyz, frameTimeCounter).xzy;
		else if (mask.ice > 0.5 || mask.stainedGlass > 0.5)
		{
			 wavesNormal = vec3(0.0, 1.0, 0.0);
		}

		if (mask.stainedGlass > 0.5)
		{
			if (texture2D(gaux2, texcoord.st).a >= 0.99)
			{
				return;
			}
		}


		float waterDeep = opaqueDepth - waterDepth;

		float refractAmount = saturate(waterDeep / 1.0) * 0.125;

		if (mask.ice > 0.5 || mask.stainedGlass > 0.5)
		{
			refractAmount *= 0.5;
		}

		if (isEyeInWater > 0)
		{
			refractAmount *= 2.0;
		}

		vec4 wnv = gbufferModelView * vec4(wavesNormal.xyz, 0.0);
		vec3 wavesNormalView = normalize(wnv.xyz);
		vec4 nv = gbufferModelView * vec4(0.0, 1.0, 0.0, 0.0);
			   nv.xyz = normalize(nv.xyz);
				 wavesNormalView.xy -= nv.xy;
		float aberration = 0.2;
		float refractionAmount = 1.82;
		vec2 refractCoord0 = texcoord.st - wavesNormalView.xy * refractAmount * (refractionAmount) / (waterDepth + 0.0001);
		vec2 refractCoord1 = texcoord.st - wavesNormalView.xy * refractAmount * (refractionAmount + aberration) / (waterDepth + 0.0001);
		vec2 refractCoord2 = texcoord.st - wavesNormalView.xy * refractAmount * (refractionAmount + aberration * 2.0) / (waterDepth + 0.0001);




		if (refractCoord0.x > 1.0 || refractCoord0.x < 0.0 || refractCoord0.y > 1.0 || refractCoord0.y < 0.0)
			refractCoord0 = texcoord.st;

		if (refractCoord1.x > 1.0 || refractCoord1.x < 0.0 || refractCoord1.y > 1.0 || refractCoord1.y < 0.0)
			refractCoord1 = texcoord.st;

		if (refractCoord2.x > 1.0 || refractCoord2.x < 0.0 || refractCoord2.y > 1.0 || refractCoord2.y < 0.0)
			refractCoord2 = texcoord.st;
		// vec2 refractCoord = texcoord.st - wavesNormal.xy * 1.72 / (surface.linearDepth + 0.0001);


		// vec3 fakeViewVector = vec3(texcoord.st * 2.0 - 1.0, 0.1);
		// vec3 fakeRefractCoord = refract(fakeViewVector, surface.normal.xyz, 1.0 / 1.00001);
		
		/*
		surface.color.r = pow(texture2DLod(gcolor, refractCoord0.xy, 1).r, (2.2));
		surface.color.g = pow(texture2DLod(gcolor, refractCoord1.xy, 1).g, (2.2));
		surface.color.b = pow(texture2DLod(gcolor, refractCoord2.xy, 1).b, (2.2));
		*/


		///*

		float fogDensity = 0.40;
		float visibility = 1.0f / (pow(exp(waterDeep * fogDensity), 1.0f));


		vec4 blendWeights = vec4(1.0, 0.5, 0.25, 0.125);
		blendWeights = pow(blendWeights, vec4(visibility));

		float blendWeightsTotal = dot(blendWeights, vec4(1.0));

		color.r = 
					(
					    pow(texture2DLod(gaux3, refractCoord0.xy * SCLE, 1).r, (2.2)) * blendWeights.x
					  + pow(texture2DLod(gaux3, refractCoord0.xy * SCLE, 2).r, (2.2)) * blendWeights.y
					  + pow(texture2DLod(gaux3, refractCoord0.xy * SCLE, 3).r, (2.2)) * blendWeights.z
					  + pow(texture2DLod(gaux3, refractCoord0.xy * SCLE, 4).r, (2.2)) * blendWeights.w
					) / blendWeightsTotal;

					color.g = 
					(
					    pow(texture2DLod(gaux3, refractCoord1.xy * SCLE, 1).g, (2.2)) * blendWeights.x
					  + pow(texture2DLod(gaux3, refractCoord1.xy * SCLE, 2).g, (2.2)) * blendWeights.y
					  + pow(texture2DLod(gaux3, refractCoord1.xy * SCLE, 3).g, (2.2)) * blendWeights.z
					  + pow(texture2DLod(gaux3, refractCoord1.xy * SCLE, 4).g, (2.2)) * blendWeights.w
					) / blendWeightsTotal;

					color.b = 
					(
					    pow(texture2DLod(gaux3, refractCoord2.xy * SCLE, 1).b, (2.2)) * blendWeights.x
					  + pow(texture2DLod(gaux3, refractCoord2.xy * SCLE, 2).b, (2.2)) * blendWeights.y
					  + pow(texture2DLod(gaux3, refractCoord2.xy * SCLE, 3).b, (2.2)) * blendWeights.z
					  + pow(texture2DLod(gaux3, refractCoord2.xy * SCLE, 4).b, (2.2)) * blendWeights.w
					) / blendWeightsTotal;
		//*/

		//color = vec3(refractAmount * 0.00001);

		refractionCoord = refractCoord0.xy;
	}
}

vec3 convertScreenSpaceToWorldSpace(vec2 co) {
    vec4 fragposition = gbufferProjectionInverse * vec4(vec3(co, texture2DLod(gdepthtex, co, 0).x) * 2.0 - 1.0, 1.0);
    fragposition /= fragposition.w;
    return fragposition.xyz;
}

vec3 convertCameraSpaceToScreenSpace(vec3 cameraSpace) {
    vec4 clipSpace = gbufferProjection * vec4(cameraSpace, 1.0);
    vec3 NDCSpace = clipSpace.xyz / clipSpace.w;
    vec3 screenSpace = 0.5 * NDCSpace + 0.5;
		 screenSpace.z = 0.1f;
    return screenSpace;
}

#include "lib/sspt.glsl"

vec2 GetNearFragment(vec2 coord, float depth, out float minDepth)
{

	vec2 texel = 1.0 / vec2(viewWidth, viewHeight);

	float step = 2.0;

	vec4 depthSamples;
	depthSamples.x = texture2D(gdepthtex, coord + texel * vec2(step, step)).x;
	depthSamples.y = texture2D(gdepthtex, coord + texel * vec2(step, -step)).x;
	depthSamples.z = texture2D(gdepthtex, coord + texel * vec2(-step, step)).x;
	depthSamples.w = texture2D(gdepthtex, coord + texel * vec2(-step, -step)).x;

	vec2 targetFragment = vec2(0.0, 0.0);

	if (depthSamples.x < depth)
		targetFragment = vec2(step, step);
	if (depthSamples.y < depth)
		targetFragment = vec2(step, -step);
	if (depthSamples.z < depth)
		targetFragment = vec2(-step, step);
	if (depthSamples.w < depth)
		targetFragment = vec2(-step, -step);


	minDepth = min(min(min(depthSamples.x, depthSamples.y), depthSamples.z), depthSamples.w);

	return coord + texel * targetFragment;
}

float RenderSunDisc(vec3 worldDir, vec3 sunDir)
{
	float d = dot(worldDir, sunDir);

	float disc = 0.0;

	//if (d > 0.99)
	//	disc = 1.0;

	float size = 0.0001;
	float hardness = 10000.0;

	disc = pow(curve(saturate((d - (1.0 - size)) * hardness)), 2.0);

	float visibility = curve(saturate(worldDir.y * 400.0));

	disc *= visibility;

	return disc;
}

vec4 ComputeFakeSkyReflection(vec3 dir, vec3 normal, MaterialMask mask, float metallic)
{
	float nightBrightness = 4e-4 * (1.0 + 32.0 * nightVision);


	vec3 worldDir = normalize((gbufferModelViewInverse * vec4(dir.xyz, 0.0)).xyz);

	vec3 sky = AtmosphericScattering(normalize(worldDir + cameraPosition.y * vec3(0.0f, worldscale, 0.0f)), worldSunVector, 1.0);
	//sky = mix(sky, vec3(0.1) * Luminance(colorSkylight), vec3(rainStrength * 0.95));
	vec3 skyNight = AtmosphericScattering(normalize(worldDir + cameraPosition.y * vec3(0.0f, worldscale, 0.0f)), -worldSunVector, 1.0) * nightBrightness;
	//skyNight = mix(skyNight, vec3(0.1) * nightBrightness, vec3(rainStrength * 0.95));

	float fresnel = pow(saturate(dot(-dir, normal) + 1.0), 4.5) * 0.9 + 0.1;


	vec3 sunDisc = vec3(RenderSunDisc(normalize(worldDir + cameraPosition.y * vec3(0.0f, worldscale, 0.0f)), worldSunVector));
	sunDisc *= normalize(sky + 0.000001);
	sunDisc /= 2e-8;
	
	vec3 moonDisc = vec3(RenderSunDisc(normalize(worldDir + cameraPosition.y * vec3(0.0f, worldscale, 0.0f)), -worldSunVector));
	moonDisc *= normalize(sky + 0.000001);
	moonDisc *= 6.25;
	
	//if (mask.water > 0.5)

	sunDisc *= saturate(mask.water + metallic);
	sky += sunDisc;
	moonDisc *= saturate(mask.water + metallic);
	sky += moonDisc;


	return vec4((sky + skyNight) * 0.0001, fresnel);
	//return vec4(vec3(0.0001), fresnel);
}


vec4 ComputeFakeSkyReflection2(vec3 dir, vec3 normal, MaterialMask mask, float metallic)
{
	float nightBrightness = 4e-4 * (1.0 + 32.0 * nightVision);


	vec3 worldDir = normalize((gbufferModelViewInverse * vec4(dir.xyz, 0.0)).xyz);

	vec3 sky = AtmosphericScattering(normalize(worldDir + cameraPosition.y * vec3(0.0f, worldscale, 0.0f)), worldSunVector, 1.0);
	//sky = mix(sky, vec3(0.5) * Luminance(colorSkylight), vec3(rainStrength * 0.95));
	vec3 skyNight = AtmosphericScattering(normalize(worldDir + cameraPosition.y * vec3(0.0f, worldscale, 0.0f)), -worldSunVector, 1.0) * nightBrightness;
	//skyNight = mix(skyNight, vec3(0.5) * nightBrightness, vec3(rainStrength * 0.95));

	//float fresnel = pow(saturate(dot(-dir, normal) + 1.0), 5.0) * 0.02 + 0.98;
	float fresnel = 1.0;
	
	vec3 sunDisc = vec3(RenderSunDisc(normalize(worldDir + cameraPosition.y * vec3(0.0f, worldscale, 0.0f)), worldSunVector));
	//sunDisc *= normalize(sky + 0.001);
	//sunDisc *= 10000.0 * pow(1.0 - rainStrength, 5.0);

	//if (mask.water > 0.5)

	//sunDisc *= saturate(mask.water + metallic);
	//sky += sunDisc;



	return vec4((sky + skyNight) * 0.0001, fresnel);
	//return vec4(vec3(0.0001), fresnel);
}

void 	CalculateSpecularReflections(inout vec3 color, vec3 normal, MaterialMask mask, vec3 albedo, float smoothness, float metallic, float skylight, float torchlight, vec3 viewVector, vec3 viewPosTransparent, vec2 refractionCoord, vec3 skyClight) {
	float depth = texture2D(gdepthtex, texcoord.st).x;
	float specularity = smoothness * smoothness * smoothness;
	      specularity = max(0.0f, specularity * 1.15f - 0.15f);
	      //specularity = 1.0f;		  
	vec3 specularColor = vec3(1.0f);
	//surface.specularity = 1.0f;
	//surface.roughness *= surface.roughness;

	metallic = pow(metallic, 2.2);

	bool defaultItself = true;

	//surface.rDepth = 0.0f;

	if (mask.sky > 0.5)
		specularity = 0.0f;

             /*
			 float minDepth;
			 vec2 nearFragment = GetNearFragment(texcoord.st, depth, minDepth);
			 float nearDepth = texture2D(gdepthtex, nearFragment).x;
			 vec4 projPos = vec4(texcoord.st * 2.0 - 1.0, nearDepth * 2.0 - 1.0, 1.0);
			 vec4 viewPos = gbufferProjectionInverse * projPos;
			 viewPos.xyz /= viewPos.w;
			 vec4 worldP = gbufferModelViewInverse * vec4(viewPos.xyz, 1.0);
			 vec4 worldPosPrev = worldP;
			   worldPosPrev.xyz += (cameraPosition - previousCameraPosition);
			 vec4 viewPosPrev = gbufferPreviousModelView * vec4(worldPosPrev.xyz, 1.0);
			 vec4 projPosPrev = gbufferPreviousProjection * vec4(viewPosPrev.xyz, 1.0);
			 projPosPrev.xyz /= projPosPrev.w;
			 vec2 motionVector = (projPos.xy - projPosPrev.xy);

			 vec2 reprojCoord = texcoord.st - motionVector.xy * 0.5;

			 vec4 prevColor = texture2D(gaux4, reprojCoord.st);
			 float prevMinDepth = prevColor.a;
	         float dynamicWeight = max(0.0, 
							  1.0 - distance(GetDepthLinear2(nearDepth), 
											 GetDepthLinear2((projPosPrev.z * 0.5 + 0.5))) * far * 0.5);
			 float blendWeight = (1.0-exp2(-(5.0)));
	         vec2 lowerScreenBound = 1.0 / vec2(viewWidth, viewHeight);
	         vec2 upperScreenBound = 1.0 - lowerScreenBound;

	         if (reprojCoord.x < lowerScreenBound.x || reprojCoord.x > upperScreenBound.x ||
		     reprojCoord.y < lowerScreenBound.y || reprojCoord.y > upperScreenBound.y)
	         {
		       blendWeight = (0.0);
	         }
			 
		     prevColor = vec4(GammaToLinear(prevColor.rgb), prevColor.a);
			 prevColor = clamp(prevColor, vec4(0.0), vec4(1.0));
			 */
	if (mask.water > 0.5 || mask.ice > 0.5)
	{
		defaultItself = false;
		specularity = 1.0f;
		metallic = 0.0;
		//surface.roughness = 0.0f;
		//surface.fresnelPower = 6.0f;
		//surface.baseSpecularity = 0.02f;
	}
	else
	{
		skylight = CurveBlockLightSky(texture2D(gdepth, texcoord.st).g);
	}

	if (mask.stainedGlass > 0.5)
	{
		specularity = 1.0;
	}


	vec3 original = color.rgb;

	if (specularity > 0.0f) 
	{
		if (isEyeInWater > 0 && mask.water > 0.5)
		{
			    float totalInternalReflectionMask = texture2D(gnormal, refractionCoord.st * SCLE).b;
			    bool hit;
				vec3 snormal = normal;
	            vec3 sviewVector = normalize(viewVector);

			    float NdotV = max(1e-12, dot(-sviewVector, snormal));
			    vec3 rayDirection = reflect(sviewVector, snormal);
			    float MdotV = dot(snormal, -sviewVector);			
			    float NdotL = abs(dot(snormal, rayDirection));	
  			    vec3 screenPos = vec3(texcoord.st, depth);
				
    		    float noise = BlueNoise(texcoord.st + 0.1125);	
	
			    hit = rayTrace(sviewVector, rayDirection, NdotV, noise, false, screenPos) && NdotL > 0.0; 
				
				vec3 fakeSkyC = ComputeFakeSkyReflection(rayDirection, snormal, mask, metallic).rgb * saturate(skylight * 16.0 - 5.0);		 
	            vec3 SSRTGI = pow(texture2DLod(gaux3, screenPos.st * SCLE, 0).rgb, vec3(2.2f));
			    color = mix(color, SSRTGI, vec3(totalInternalReflectionMask));			
			    //color = mix(vec3(0.0, 1.0, 0.0), vec3(1.0, 0.0, 0.0), vec3(totalInternalReflectionMask)) * 0.01;	      
		}
		else
		{
			    bool hit;
				vec3 snormal = normal;
	            vec3 sviewVector = normalize(viewVector + (rand(texcoord.st) * 2.0 - 1.0) * metallic * 5e-2);

			    float NdotV = max(1e-12, dot(-sviewVector, snormal));
			    vec3 rayDirection = reflect(sviewVector, snormal);
			    float MdotV = dot(snormal, -sviewVector);			
			    float NdotL = abs(dot(snormal, rayDirection));	
  			    vec3 screenPos = vec3(texcoord.st, depth);
				
    		    float noise = BlueNoise(texcoord.st + 0.1125);	
	
			    hit = rayTrace(sviewVector, rayDirection, NdotV, noise, false, screenPos) && NdotL > 0.0; 
				
				vec3 fakeSkyC = ComputeFakeSkyReflection(rayDirection, snormal, mask, metallic).rgb * saturate(skylight * 16.0 - 5.0);		 
	            vec3 SSRTGI = pow(texture2DLod(gaux3, screenPos.st * SCLE, 0).rgb, vec3(2.2f));
				
			    SSRTGI *= mix(vec3(1.0), albedo.rgb, vec3(metallic));
			    SSRTGI = hit ? SSRTGI : fakeSkyC;
			    color = mix(color, SSRTGI, vec3(ComputeFakeSkyReflection(rayDirection, snormal, mask, metallic).a));							
		}
	}

    #ifdef SSPTGI 
	float waterDepth = 0.0;
	if (mask.water > 0.5 || isEyeInWater > 0 || mask.ice > 0.5)
	{
		waterDepth = distance(viewPosTransparent.xyz, viewVector.xyz);	
		if (isEyeInWater > 0)
		{
			waterDepth = length(viewPosTransparent.xyz) * 0.5;		
			if (mask.water > 0.5 || mask.ice > 0.5)
			{
				waterDepth = length(viewPosTransparent.xyz) * 0.5;		
			}	
		}
    }
	
	float visibility = exp2(-waterDepth * 0.5);			
	const int numRays = 8;
	float displacement = BlueNoises(frameCounter * vec2(1.0,1.0) * 0.075) * .0f;	
	for (int i = 0; i < numRays; i++)
	{
	    vec3 coord = vec3(texcoord.st, 1.0);	 
		float fi = float(i) + BlueNoise(coord.st);  				
		float fiN = fi / float(numRays);
		float lon = 1.618033988 * PI * 1.0003 * fi * 6.0;
		float lat = asin(fiN * 2.0 - 1.0) * 1.0;
		vec3 kernel;
		kernel.x = cos(lat) * cos(lon);
		kernel.z = cos(lat) * sin(lon);
		kernel.y = sin(lat);	
	    if (mask.sky < 0.5)
	    {
                vec3 rotnoise = kernel;				
			    bool hit;
	            //vec3 snormal = normalize(normal + (rotnoise.xyz * 2.0 - 1.0) * 0.9);
				vec3 snormal = normal;
	            vec3 sviewVector = normalize(viewVector + (rotnoise.xyz * 2.0 - 1.0) * 1.0);

			    float NdotV = max(1e-12, dot(-sviewVector, snormal));
			    vec3 rayDirection = reflect(sviewVector, snormal);
			    float MdotV = dot(snormal, -sviewVector);			
			    float NdotL = abs(dot(snormal, rayDirection));	
  			    vec3 screenPos = vec3(texcoord.st, depth);
			
    		    float noise = BlueNoise(coord.st + 0.1115);	
			    hit = rayTrace(sviewVector, rayDirection, NdotV, noise, false, screenPos) && NdotL > 0.0; 						
				vec3 fakeSkyC = ComputeFakeSkyReflection2(rayDirection, snormal, mask, metallic).rgb * albedo.rgb / float(numRays) * curve(saturate(skylight));	
				vec3 nofakeSky = vec3(0.0f);			 
	            vec3 SSRTGI = pow(texture2DLod(gaux3, screenPos.st * SCLE, 0).rgb, vec3(2.2f)) * albedo.rgb / float(numRays);

				SSRTGI = hit ? SSRTGI : fakeSkyC * 0.6;
				SSRTGI *= visibility;				
		        color += SSRTGI;
	    }
	}
	#endif	
 	//color.rgb = mix(color.rgb, original, vec3(surface.cloudAlpha));
}


void FakeSSGI(inout vec3 color, vec3 albedo, float skylight, float torchlight, vec3 normal, float depth, float ao) {
    ///*
	    const int step = 400; 
		float stepCount = 1.0; 
		vec3 ssgi = vec3(0.0f);
        depth = ExpToLinearDepth(depth);
        float LightRayLength = 1.0;
		vec2 pos = texcoord.st;
	   for(int i; i < step; i++){ 
		  vec2 offsetDir = (normal.st + (rand(texcoord.st + sin(frameTimeCounter)).xy - 0.5) * 0.0) / vec2(viewWidth, viewHeight)
		  //* saturate(1.0 - depth)
		  * LightRayLength;	
		  pos += offsetDir;
		  ssgi += GammaToLinear(texture2DLod(gaux3, pos * SCLE, 0).rgb);
		  stepCount += 1.0;
		  LightRayLength *= 1.0;
        }			
		color += ssgi
		/ stepCount * albedo * ao
		// * 10.05
		;
        //color += ssgi * albedo;
	//*/
	//color += (GammaToLinear(texture2DLod(gaux3, texcoord.st + normal.xy * .5 * saturate(1.0 - depth * 0.0f), 8).rgb)
    //+ GammaToLinear(texture2DLod(gaux3, texcoord.st + normal.xy * .8 * saturate(1.0 - depth * 0.0f), 9).rgb) * 0.4)	
	//* exp(-GammaToLinear(texture2DLod(gaux3, texcoord.st + normal.xy * 0.4 * saturate(1.0 - depth * 0.0f), 2).rgb))
	//* albedo * 0.02 * ao
	;		
}

void TransparentAbsorption(inout vec3 color, MaterialMask mask, vec4 worldSpacePosition, float waterDepth, float opaqueDepth)
{
	if (mask.stainedGlass > 0.5)
	{
		vec4 transparentAlbedo = texture2D(gaux2, texcoord.st);

		transparentAlbedo.rgb = GammaToLinear(transparentAlbedo.rgb);

		transparentAlbedo.rgb = pow(length(transparentAlbedo.rgb), 0.5) * normalize(transparentAlbedo.rgb + 0.00001);

		color *= transparentAlbedo.rgb * 2.0;
	}

}


void LandAtmosphericScattering(inout vec3 color, in vec3 viewPos, in vec3 viewDir, vec3 worldDir)
{
	float dist = length(viewPos);
    vec3 atmosphere = AtmosphericScattering( normalize(worldDir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), worldSunVector, 1.0, 2e-3 * dist);			
	//atmosphere = mix(atmosphere, (vec3(Luminance(colorSkylight)) * 20.0f, 0.0f, exp(-2e-3 * dist)), saturate(wetness) * 0.9);	
    vec3 absorb = AtmosphereAbsorption(normalize(worldDir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), 1e-3 * dist);	
	color *= mix(vec3(1.0), absorb, saturate(pow(eyeBrightnessSmooth.y / 240.0f, 6.0)));
	color += mix(vec3(0.0), atmosphere, saturate(pow(eyeBrightnessSmooth.y / 240.0f, 6.0)));
}

void RainFog(inout vec3 color, in vec3 worldPos)
{

	float dist = length(worldPos);
	vec3 worldDir = worldPos / dist;

	float fogDensity = 0.006;
		  fogDensity *= mix(0.0f, 1.0f, pow(eyeBrightnessSmooth.y / 240.0f, 6.0f));
		  fogDensity *= rainStrength + 1.0 - timeNoon;
	
	float fogFactor = pow(1.0 - exp(-dist * fogDensity), 2.0);

	vec3 fogColor = vec3(dot(colorSkylight, vec3(0.18)));

	fogColor *= saturate(worldDir.y * 0.5 + 0.5);

	color = mix(color, fogColor, vec3(fogFactor));

	// vec3 absorption = vec3(0.2, 0.45, 1.0);

	// color *= exp(-dist * absorption * fogDensity * 0.27);
	// color += max(vec3(0.0), vec3(1.0) - exp(-fogFactor * absorption)) * mix(colorSunlight, vec3(dot(colorSunlight, vec3(0.33333))), vec3(0.9)) * 2.0;

	// float VdotL = dot(viewDir, sunVector);

	// float g = 0.72;
	// 			//float g = 0.9;
	// float g2 = g * g;
	// float theta = VdotL * 0.5 + 0.5;
	// float anisoFactor = 1.5 * ((1.0 - g2) / (2.0 + g2)) * ((1.0 + theta * theta) / (1.0 + g2 - 2.0 * g * theta)) + g * theta;

	

	// color += colorSunlight * fogFactor * 0.2 * anisoFactor;

}

void BlindnessFog(inout vec3 color, in vec3 viewPos, in vec3 viewDir)
{
	if (blindness < 0.001)
	{
		return;
	}
	float dist = length(viewPos);

	float fogDensity = 1.0 * blindness;
	
	float fogFactor = pow(1.0 - exp(-dist * fogDensity), 2.0);

	vec3 fogColor = vec3(0.0);

	color = mix(color, fogColor, vec3(fogFactor));
}

float G1V(float dotNV, float k)
{
	return 1.0 / (dotNV * (1.0 - k) + k);
}

vec3 SpecularGGX(vec3 N, vec3 V, vec3 L, float roughness, float F0)
{
	float alpha = roughness * roughness;

	vec3 H = normalize(V + L);

	float dotNL = saturate(dot(N, L));
	float dotNV = saturate(dot(N, V));
	float dotNH = saturate(dot(N, H));
	float dotLH = saturate(dot(L, H));

	float F, D, vis;

	float alphaSqr = alpha * alpha;
	float pi = 3.14159265359;
	float denom = dotNH * dotNH * (alphaSqr - 1.0) + 1.0;
	D = alphaSqr / (pi * denom * denom);

	float dotLH5 = pow(1.0f - dotLH, 5.0);
	F = F0 + (1.0 - F0) * dotLH5;

	float k = alpha / 2.0;
	vis = G1V(dotNL, k) * G1V(dotNV, k);

	vec3 specular = vec3(dotNL * D * F * vis) * colorSunlight;

	//specular = vec3(0.1);
	specular *= saturate(pow(1.0 - roughness, 0.7) * 2.0);

	return specular;
}

void SmoothSky(inout vec3 color, MaterialMask mask, vec3 normal)
{
    float cloudAlpha = saturate(texture2DLod(gaux3, texcoord.st, 2).a * 1.0 - 0.0);
 
    if (mask.sky > 0.5 || cloudAlpha == 0.0)
    {
        //color = mix(BilateralUpsample(0.0f, vec2(0.0f), texture2DLod(depthtex1, texcoord.st, 0).x, normal, cloudAlpha).rgb
		//,
		//GammaToLinear(texture2DLod(gaux3, texcoord.st, 0.0).rgb),
		//vec3(timeMidnight * 0.5 + 0.9 * (1.0 - rainStrength * 0.8)))
		//;
		//color += GammaToLinear(texture2DLod(gaux3, texcoord.st, 1.0).rgb) * 0.1;
		//color += GammaToLinear(texture2DLod(gaux3, texcoord.st, 2.0).rgb) * 0.1;
		//color += GammaToLinear(texture2DLod(gaux3, texcoord.st, 3.0).rgb) * 0.1;
		//color += GammaToLinear(texture2DLod(gaux3, texcoord.st, 4.0).rgb) * 0.1;		
		//color += GammaToLinear(texture2DLod(gaux3, texcoord.st, 5.0).rgb) * 0.1;
		//color += GammaToLinear(texture2DLod(gaux3, texcoord.st, 6.0).rgb) * 0.1;		
		//color = BilateralUpsample(0.0f, vec2(0.0f), texture2DLod(depthtex1, texcoord.st, 0).x, normal, cloudAlpha).rgb;
		color = GammaToLinear(texture2DLod(gaux3, texcoord.st, 1).rgb);
    }
}

/*
vec3 PhaseMieCol( vec3 g, float LdotV, float LdotV2 ) {
	vec3 gg = g * g;
	
	vec3 a = ( 1.0 - gg ) * ( 1.0 + LdotV2 );

	vec3 b = 1.0 + gg - 2.0 * g * LdotV;
	b *= sqrt( b );
	b *= 2.0 + gg;	
	
	return 1.5 * a / b;
}

float PhaseMie( float g, float LdotV, float LdotV2 ) {
	float gg = g * g;
	
	float a = ( 1.0 - gg ) * ( 1.0 + LdotV2 );

	float b = 1.0 + gg - 2.0 * g * LdotV;
	b *= sqrt( b );
	b *= 2.0 + gg;	
	
	return 1.5 * a / b;
}


vec3 GetCrepuscularRays (inout vec3 color, vec3 viewDir, vec3 lightVector, vec3 worldDir, vec3 viewPos, MaterialMask mask, vec3 worldPos) {
  if (isEyeInWater > 0.99) {
    return vec3(0.0);
  } else 
  //if (rainStrength > 0.9) {
  //return vec3(0.0);
  //} else
  {
  float dist = length(viewPos);
  vec3 atmosphere = AtmosphericScattering( normalize(worldDir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), worldSunVector, 1.0, 3e-4 * dist);
  float LdotV = dot(normalize(worldDir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), worldSunVector);
  float LdotV01 = LdotV * 0.5 + 0.5;
  float LdotV2 = LdotV * LdotV;
  float vlSample = texture2DLod(gnormal, texcoord.st * SCLE, 1).a;  //this will filter the volumetric light
  vec3 ray = vec3(0.0f)
  //+ PhaseMieCol( saturate(C_R1 + 0.05), LdotV, LdotV2 ) * colorSunlight
  + PhaseMie(0.9, LdotV, LdotV2) * colorSunlight * 1e-6
  //+ colorSkylight
  ;
  ray += atmosphere * 1e-4;  
  ray *= vlSample / (max(worldDir.y + cameraPosition.y * worldscale, 0.0) / worldscale * 1e-4 * pow(max(cameraPosition.y * 0.015, 0.0f), 2.0) * 0.1 + 1.0f);
  //ray *= vlSample * 1e-3 / (max(worldDir.y + cameraPosition.y * worldscale, 0.0) / worldscale * 1e-4 * pow(max(cameraPosition.y * 0.015, 0.0f), 2.0) * 0.1 + 1.0f);
        return ray;

 }
}
*/

///*
Intersection RayPlaneIntersection(in Ray ray, in Plane plane)
{
	float rayPlaneAngle = dot(ray.dir, plane.normal);

	float planeRayDist = 100000000.0f;
	vec3 intersectionPos = ray.dir * planeRayDist;

	if (rayPlaneAngle > 0.0001f || rayPlaneAngle < -0.0001f)
	{
		planeRayDist = dot((plane.origin - ray.origin), plane.normal) / rayPlaneAngle;
		intersectionPos = ray.origin + ray.dir * planeRayDist;
		// intersectionPos = -intersectionPos;

		// intersectionPos += cameraPosition.xyz;
	}

	Intersection i;

	i.pos = intersectionPos;
	i.distance = planeRayDist;
	i.angle = rayPlaneAngle;

	return i;
}
//*/

float Get3DNoise(in vec3 pos)
{ 
    pos += 0.5;
	vec3 p = floor(pos);
	vec3 f = fract(pos);
	f = curve(f);
	vec2 uv =  p.xy + p.z * vec2(-17.0f) + f.xy;
	vec2 uv1 =  p.xy + (p.z + 0.0) * vec2(-17.0f) + f.xy;	
	vec2 coord = (uv + 0.5f) / 64.0;
	vec2 coord1 = (uv1 + 0.5f) / 64.0;	
	float rr = texture2D(noisetex, coord).x;	
	float gg = texture2D(noisetex, coord1).y;		
	return mix(rr, gg, f.z);
}

float Get3DNoise2(in vec3 pos)
{
    pos += 0.5;
	vec3 p = floor(pos);
	vec3 f = fract(pos);
	//f = curve(f);
	vec2 uv =  p.xy + p.z * vec2(17.0f) + f.xy;
	vec2 uv1 =  p.xy + (p.z + 1.0) * vec2(17.0f) + f.xy;	
	vec2 coord = (uv + 0.5f) / 64.0;
	vec2 coord1 = (uv1 + 0.5f) / 64.0;	
	float rr = texture2D(noisetex, coord).x;	
	float gg = texture2D(noisetex, coord1).x;		
	return mix(rr, gg, f.z);
}

float Get3DPWNoise(in vec3 pos)
{   
    float PN = Get3DNoise2(pos);
    float WN = 1.0 - Get3DNoise(pos);	
	return (PN + WN) * 0.53;	
	//return saturate((PN - WN) / (1.0 - WN) * 0.2 + 0.57);
}

float Get2DNoise(in vec3 pos)
{
	pos.xy = pos.xz;
	pos.xy += 0.5f;

	vec2 p = floor(pos.xy);
	vec2 f = fract(pos.xy);
	//f = smoothstep(vec2(0.0), vec2(1.0), f);
	f = curve(f);
	vec2 uv = p.xy + f.xy;

	 //uv -= 0.5f;

	vec2 coord = (uv + 0.5f) / noiseTextureResolution;
	float xy1 = texture2D(noisetex, coord).x;
	return xy1;
}

float Get2DNoisel(in vec3 pos)
{
	pos.xy = pos.xz;
	pos.xy += 0.5f;

	vec2 p = floor(pos.xy);
	vec2 f = fract(pos.xy);

	vec2 uv = p.xy + f.xy;

	 //uv -= 0.5f;

	vec2 coord = (uv + 0.5f) / noiseTextureResolution;
	float xy1 = texture2D(noisetex, coord).x;
	return xy1;
}

float Get2DNoise2(in vec2 pos)
{

	vec2 p = floor(pos);
	vec2 f = curve(fract(pos));

	vec2 uv =  p.xy + f.xy;
	
	vec2 coord =  (uv + 0.5f) / noiseTextureResolution;
	//float xy1 = mix(rand(coord.st).x, rand(coord.ts).y, rand(coord.st).x);
	float xy1 = texture2D(noisetex, coord).x;
	return xy1;
}

float Get2DPWNoise(in vec3 pos)
{   
    float PN = Get2DNoise(pos);
    float WN = 1.0 - Get2DNoisel(pos);	
	return (PN + WN) * 0.52;		
	//return (PN + WN);
}

vec3 WorldToShadowProjPos(vec3 worldPos)
{
	vec4 shadowPos = vec4(worldPos, 1.0);

	shadowPos = shadowModelView * shadowPos;	//Transform from world space to shadow space
	float comparedepth = -shadowPos.z;				//Surface distance from sun to be compared to the shadow map

	shadowPos = shadowProjection * shadowPos;
	shadowPos /= shadowPos.w;

	float dist = sqrt(shadowPos.x * shadowPos.x + shadowPos.y * shadowPos.y);
	float distortFactor = (1.0f - SHADOW_MAP_BIAS) + dist * SHADOW_MAP_BIAS;
	shadowPos.xy *= 0.95f / distortFactor;
	shadowPos.z = mix(shadowPos.z, 0.5, 0.8);
	shadowPos = shadowPos * 0.5f + 0.5f;		//Transform from shadow space to shadow map coordinates

	return shadowPos.xyz;
}

///*

float GetCN(vec3 wp, bool forCL, float lr, float Detail, float cloudHeight, float cloudDepth, int co)
{		
	float t = frameTimeCounter * VOLUMETRIC_CLOUD_SPEED * C_S_W;		
	float lC = 1.0f;
	float dist = length(wp - cameraPosition);
    //const float AC = A_C_O_S;	
	//int cloudos = int(clamp(AC - floor(sqrt(dist) * 0.01), 0.0, AC)) + co;
	
	float Hc = saturate((wp.y-cloudHeight)/(cloudDepth));	
    //float Hc2 = Hc * Hc;
	const float DS1 = 5.0;
	const float DS2 = 5.0;

	const float DSa = 5.0;
	const float DSb = 2.0;

	const float DSj = 1.0;
	      float DSi = 3.0 - wetness * 2.0;	
	//float HchitDen = (Hc - (Hc2 * 1.3 - 0.3)) / 0.492;
	//float Hchit = (Hc - Hc2) / 0.3 * Hc;	
	//float FHchit = Hc * 0.0 + Hchit * 0.5;		
	float Hcf = saturate(1.-Hc); 
	
	float HA = (Hc * DS1 / (1.0 + Hc * DS1)) * (Hcf * DS2 / (1.0 + Hcf * DS2)) / ((0.5 * DS1 / (1.0 + 0.5 * DS1)) * (0.5 * DS2 / (1.0 + 0.5 * DS2))); 
	float HA2 = (Hc * DSa / (1.0 + Hc * DSa)) * (Hcf * DSb / (1.0 + Hcf * DSb)) / ((0.5 * DSa / (1.0 + 0.5 * DSa)) * (0.5 * DSb / (1.0 + 0.5 * DSb))); 	
	float HA3 = (Hc * DSj / (1.0 + Hc * DSj)) * (Hcf * DSi / (1.0 + Hcf * DSi)) / ((0.5 * DSj / (1.0 + 0.5 * DSj)) * (0.5 * DSi / (1.0 + 0.5 * DSi))); 
	HA = saturate(HA);
	HA2 = saturate(HA2);
	HA3 = saturate(HA3);	
	
	wp += 600.0 * vec3(1.0, 0.0, 0.0) * Hc * airflow_Strength * C_S_W;		
	vec3 p = wp.xyz * 0.00045 / C_S_W;  	
	
	#ifdef CLC
	  lC = texture2D(noisetex, (wp.xz - t * 2000.0) /C_S_W * 0.0000013 + 0.5).g;
	  lC = mix(saturate(lC * 3.0 - 0.75), 1.0, saturate(0.5 + wetness * 0.4));
	  if (lC < 0.02)
	  {
	    return 0.0f;
	  } 
	#endif	

	float octScale = 3.0;	
    float G = 1.0;	
    float T = 1.0;	
	
	    p.xz -= saturate(Hc * 2.4 - 1.0) * vec2(0.3, 0.3) * upprtairflow_Strength * C_S_W;
			
	float largernoise = 1.0;	

	float topwindshape = 0.0;
	if(wetness > 0.0) topwindshape = saturate(Get2DNoise(p * 0.3) * 2.5 - 0.8);	
	
		p += t * vec3(1.0, 0.0, 0.0);	
				
    #ifdef PWNOISE
	    float noise = mix(Get3DPWNoise(p * vec3(1.0, 1.0, 1.0)), 1.0, saturate(0.0 + wetness * 0.48));	
	#else
	   float noise = mix(Get3DNoise(p * vec3(1.0, 1.0, 1.0)), 1.0, saturate(0.0 + wetness * 0.48));
	#endif
	
	for (int j = 1; j < co; ++j)
    {	  
		p = (p + t * vec3(0.2, 0.0, 0.0)) * octScale;		
		G *= VC_R * lr;	
		#ifdef PWNOISE
	        noise += Get3DPWNoise(p)*G; 	
	    #else
	        noise += Get3DNoise(p)*G; 
	    #endif
		T += G;	
    } 		 
	    noise += 0.5 - T * 0.532;
		noise += Detail;	
        noise = noise * (1.0 + Hc * largernoise * HCCURVE) - Hc * largernoise * HCCURVE;	
        noise *= Vol_Cloud_Coverage * lC * (1.0 + saturate(Hc * Hc * 1.2 - 0.5) * 0.3 * topwindshape * wetness); 	
	    //noise *= Vol_Cloud_Coverage * (1.0 + wetness * (0.1 + saturate(Hc * Hc * 1.2 - 0.5) * 1.2)) * (1.0 - HA3 * 0.3 * (1.0 - wetness * 0.15)) * lC; 		
		noise = HA * (noise - 0.9) - 0.1; 
    if(noise < 0.0001){
	    return 0.0f;
	}
	return saturate(noise * Density_Curve_C * 1.0);	
}

float CloudShadow3(vec4 worldPos, vec3 worldLightVector)
{		 
	#ifdef cloud_shadow
          vec3 wd = normalize(normalize(worldPos.xyz - cameraPosition.xyz) + cameraPosition.y * vec3(0.0f, 1.0, 0.0f) * worldscale);
	      Ray ray;
	      //ray.dir = normalize(normalize(worldPos.xyz - cameraPosition.xyz) + cameraPosition.y * vec3(0.0f, 1.0, 0.0f) * worldscale + worldLightVector);
		  //ray.dir = normalize(wd / (abs(wd.y) + 1e-9) + worldLightVector);
	      ray.dir = worldLightVector;		  
	      ray.origin = worldPos.xyz + cameraPosition.xyz * 0.0;

	      Plane plane;
	      plane.normal = vec3(0.0, 1.0, 0.0);
	      plane.origin = vec3(0.0, Cloud3Height * C_S_W, 0.0);
     
	    vec3 cloudCheckPos = RayPlaneIntersection(ray, plane).pos;
		//vec3 cloudCheckPos = worldPos.xyz;
        float cloudshadow = 1.0;
		//float dither = CalculateNoisePattern1(vec2(0.0), 64).x;
		float dither = 1.0;		
		const int steps = 2;
	    float rSteps = Cloud3thick * C_S_W / steps;
        float stepSize = rSteps / (abs(worldLightVector.y) + 1e-20);	
        vec3 increment = worldLightVector.xyz * stepSize * dither;		  
        float fade = smoothstep(0.125, 0.075, abs(worldLightVector.y)) * 1.0f;		
		
        cloudCheckPos.xyz += cloudCheckPos.y <= Cloud3Height * C_S_W ? worldLightVector * (Cloud3Height * C_S_W - cloudCheckPos.y) / worldLightVector.y : vec3(0.0);
		
        float cloudDensity = 0.0;
        //if(length(cloudCheckPos - cameraPosition) > length(worldPos.xyz - cameraPosition) || worldPos.y < (Cloud3Height + Cloud3thick) * C_S_W)
		for (int i = 0; i < steps; ++i, cloudCheckPos.xyz += increment)
		{
            if(cloudCheckPos.y > (Cloud3Height + Cloud3thick * 1.0) * C_S_W)
			{
			  break;
			}
                cloudDensity += GetCN(cloudCheckPos.xyz, true, 1.0f, 0.0f, Cloud3Height * C_S_W, Cloud3thick * C_S_W, C_O_S);
            	
		}

	           
	    cloudshadow = (exp(-cloudDensity * L_A_C * stepSize) * (1.0 - fade) + fade * 0.0);
        return cloudshadow;			  

		//return 1.0f;
	#else
 	      return 1.0f;
	#endif
	
}

//*/

void CrepuscularRays(inout vec3 color, vec3 worldPos, vec3 worldDir, MaterialMask mask, inout float diff)
{
	vec3 originPos = GetViewPosition(texcoord.st, 0.5).xyz;
	originPos = (gbufferModelViewInverse * vec4(originPos.xyz, 1.0)).xyz;

	vec3 camPos = (gbufferModelViewInverse * vec4(0.0, 0.0, 0.0, 1.0)).xyz;

	float sum = 0.0;
	float stepSize = 4.0;

	// float dither = dot(rand(texcoord.st + sin(frameTimeCounter)).xyz, vec3(0.33333)) * 4.0;
	float dither = BlueNoise(texcoord.st);
	//float dither = 0.0;
	//float dither = rand(texcoord.st + sin(frameTimeCounter)).x * 1.0;

	float HeigthD = exp2(-max(normalize(normalize(worldPos.xyz) + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale).y, 0.0f) * worldscale / 1e-4 * max(cameraPosition.y * 0.15, 0.0f));
	float LdotV = dot(normalize(worldDir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), worldLightVector);	
	float LdotV2 = LdotV * LdotV;	
	float LdotV01 = LdotV * 0.5 + 0.5; 
	
	float LdotVo = dot(normalize(worldDir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), -worldLightVector);	
	float LdotVo2 = LdotVo * LdotVo;	
	float LdotVo01 = LdotVo * 0.5 + 0.5;
			 float test = abs(sin(frameTimeCounter * VOLUMETRIC_CLOUD_SPEED * 50.0));
			 const float af = 0.83;				 
			 const float agc1 = 1.0;
			 const float agc2 = 1.0;	
			 float Lagc2 = pow(LdotV * 0.5 + 0.5, 1.2);	
			 float Lagco2 = pow(LdotVo * 0.5 + 0.5, 1.2);	
			 float Ldagc = pow(1.0 + (VOLUMETRIC_LIGHT_Density + wetness * 60.0) * 1.3, -1.0);
	float MA = af * max(0.0, 0.0		
			 + phase_mie(-0.3 * Lagco2 * Ldagc, LdotV * agc2, LdotV * LdotV * agc2 * agc2) 
			 + phase_mie( 0.8 * Lagc2 * Ldagc, LdotV * agc1, LdotV * LdotV * agc1 * agc1)		
             )			 
			 ;	
     			 
	// rainMask = 1.0;
	float sparkliness = mix(2.0, 3.0, dot(worldDir, worldLightVector) * 0.5 + 0.5);
	float sparkleNoise = Get3DNoise(worldDir * 170.0 * vec3(1.0, 0.1, 1.0) + vec3(frameTimeCounter * 310.0) * vec3(1.0, 0.5, 0.25));
	float rainSparkleSunlight = 0.25 / (pow(sparkleNoise, sparkliness) * 40.0 + 0.001) * 1.0 * diff;
	float visibility = 1.0;
	float visibilitysum = 1.0;	
	//#if 0
    float CloudsShadow = 1.0f;
	   //#ifdef Volumetric_Clouds	
	   //   float fade = smoothstep(0.125, 0.075, abs(worldLightVector.y)) * .0f;	
       //      CloudsShadow = saturate(CloudShadow3(vec4(worldPos.xyz, 1.0), worldLightVector) * (1.0 - fade) + fade); 				  
	   //#endif		
	int raystep = 0;
	#ifdef HQ_VOLUMETRIC_LIGHT
		raystep = 16;
    #else 
		raystep = 8;
	#endif
    float Density = (1.0 - timeNoon * 0.2 + timeNoon * wetness * 0.4) * VOLUMETRIC_LIGHT_Density;	

	for (int i = 0; i < raystep; i++)
	{
		float step = (i * dither + dither * 40.0) * stepSize;
		
		//dither /= 1.2;
		
		vec3 rayPos = (originPos - camPos) * step + camPos;
		float rl = length(normalize(rayPos) / abs(normalize(rayPos)));
		vec3 rayPosShadow = WorldToShadowProjPos(rayPos);

		float depthDiff = length(worldPos - camPos) - length(rayPos - camPos);
		if (depthDiff < 0.0 || visibility < 0.0001)
		{
			break;
		}

		
		float shadowSample = shadow2DLod(shadow, vec3(rayPosShadow.xy, rayPosShadow.z), 0).x;
		float noiseSample = HeigthD;		
		/*
		float noiseSample = Get3DNoise((rayPos + cameraPosition + frameTimeCounter * 2.4) * 0.02) * 1.0;
		 noiseSample += Get3DNoise((rayPos + cameraPosition + frameTimeCounter * 2.4) * 0.06) * 0.3;
		 noiseSample += Get3DNoise((rayPos + cameraPosition + frameTimeCounter * 2.4) * 0.12) * 0.1;
		 noiseSample /= 1.4;
		 noiseSample = noiseSample * 1.2 - 0.2;		
        */		 
		/*
		float noiseSample = Get3DNoise((rayPos + cameraPosition + frameTimeCounter * 0.4) * 2.0) * 1.0;
		 noiseSample += Get3DNoise((rayPos + cameraPosition + frameTimeCounter * 0.4) * 6.0) * 0.4;
		 noiseSample /= 1.3;
		 //noiseSample *= 0.0;		 
		 noiseSample *= saturate(Get3DNoise((rayPos + cameraPosition + frameTimeCounter * 0.6) * 0.015) * 2.0 - 0.35) * 0.5 + 0.5;		
		 //noiseSample = saturate(noiseSample);
		 //noiseSample += rainSparkleSunlight * 15.0;
        */
		float groundDensity = saturate((Cloud3Height * C_S_W * 0.9 - (rayPos + cameraPosition).y) * 0.03 / (wetness * 2.0 + 1.0));
		
        float dist = length(rayPos.xyz - cameraPosition);		
		float AD = dist * VOLUMETRIC_LIGHT_Density * 1e-1; 		
		//if(mask.sky > 0.5)
		//{
		//  AD *= 1e-3; 
		//}
	    vec3 atmosphere = vec3(0.0f);
	    //atmosphere += AtmosphericScattering(normalize(worldDir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), worldSunVector, 1.0, min(AD, 80.0));			
	    //atmosphere += AtmosphericScattering(normalize(worldDir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), -worldSunVector, 1.0, min(AD, 80.0)) * 4e-4;	
	    //vec3 absorb = AtmosphereAbsorption(normalize(worldDir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), AD * (1.0 + wetness));        
	    atmosphere += AtmosphericScattering(worldDir, worldSunVector, 1.0, min(AD, 80.0));			
	    atmosphere += AtmosphericScattering(worldDir, -worldSunVector, 1.0, min(AD, 80.0)) * 4e-4;	
	    vec3 absorb = AtmosphereAbsorption(worldDir, AD * (1.0 + wetness));        

	    #ifdef Volumetric_Clouds
		   #ifdef Volumetric_CloudShadow
               CloudsShadow = CloudShadow3(vec4((rayPos + cameraPosition * 1.0).xyz, 1.0), worldLightVector); 
		   #endif
	    #endif	
	    float lightdiff = exp(-((saturate(1.0 - abs(worldLightVector.y)) * 10.0) + 1.0) * Density * saturate(1.0 - max((rayPos - vec3(0.0, Cloud3Height * C_S_W, 0.0) * 0.9 + cameraPosition).y, 0.0) / (Cloud3Height * C_S_W * 0.9)) * 4.0 * groundDensity);
		sum = noiseSample * Density * groundDensity;	
		float sumdl = (1.0 - noiseSample / float(raystep)) * Density * groundDensity;
		float sumd = saturate(1.0 - exp(-sum));
		visibilitysum *= saturate(1.0 - sum);

		visibility *= saturate(1.0 - sumd);
		//diff *= saturate(1.0 - sumd);
		#ifdef HQ_VOLUMETRIC_LIGHT		
	    color *= visibility;
		//sum *= visibility;
		
		//float MA2 = phase_mie( 0.8 * Lagc2 * Ldagc, LdotV * agc1, LdotV * LdotV * agc1 * agc1);	

        color += (colorSunlight * 50.0 * MA + colorSkylight * (1.0 + LdotV01 * LdotV01))
		* CloudsShadow
		* shadowSample

		* lightdiff
		* visibility * sumd		
		;
		
		#else 
		//if(shadowSample < 0.0001){break;}
        color += (colorSunlight * 50.0 * MA + colorSkylight * (1.0 + LdotV01 * LdotV01))
		* CloudsShadow
		* shadowSample * sum
		;		
		#endif
		#ifdef HQ_VOLUMETRIC_LIGHT
		stepSize *= 2.0;
		#else 
		stepSize *= 4.0;
		#endif

	}
    //CloudsShadow /= 2.0;
	//sum /= 2.0;  
	//CloudsShadow = CloudShadow3(vec4(worldPos, 1.0), worldLightVector); 
	
    //color += CloudsShadow * vec3(10.0);
	
		
	 //color += rainSparkleSunlight * colorSunlight * 50.0;

	float anisoFactor = phase_mie((1.0 - saturate(sum / 8.0)), LdotV01, LdotV01 * LdotV01);
	//color *= exp(-sum * Density);
	//color *= visibility;
    //color += sum * (colorSunlight * anisoFactor * 50.0 + colorSkylight * (1.0 + LdotV01 * LdotV01)) * 0.07
	// / (max(worldDir.y + cameraPosition.y * worldscale, 0.0) / worldscale * 1e-4 * pow(max(cameraPosition.y * 0.015, 0.0f), 2.0) * 0.1 + 1.0f) * (1.0 - timeNoon * 0.8)
	//;
	//color = sum * colorSunlight;
}

vec3 ProjectBack(vec3 cameraSpace) 
{
    vec4 clipSpace = gbufferProjection * vec4(cameraSpace, 1.0);
    vec3 NDCSpace = clipSpace.xyz / clipSpace.w;
    vec3 screenSpace = 0.5 * NDCSpace + 0.5;
		 //screenSpace.z = 0.1f;
    return screenSpace;
}

float ScreenSpaceAO(vec3 origin, vec3 worldPos, vec3 normal, MaterialMask mask, vec3 worldDir)
{
	if (mask.sky > 0.5
	)
	{
		return 1.0;
	}

	if (isEyeInWater > 0.5)
	{
		origin.xy /= 0.82;
	}
	
	//origin.z *= 2.0;
	const float phi = 1.618;
	const float gAngle = phi *  3.143;
	float dither = BlueNoise(texcoord.st + 0.118);
	float f = float(1) + dither;
	float fiN = f / float(2);
	float lon = gAngle * f * 6.0;
	float lat = asin(fiN * 2.0 - 1.0) * 1.0;

	vec3 kernel;
	kernel.x = cos(lat) * cos(lon);
	kernel.z = cos(lat) * sin(lon);
	kernel.y = sin(lat);
	
	vec3 viewDir = normalize(origin.xyz);

	float nearCutoff = 0.50;
	float traceBias = 0.015;


	//Prevent self-intersection issues
	float viewDirDiff = dot(fwidth(viewDir), vec3(0.333));


	vec3 rayPos = origin;
	vec3 rayDir = normalize(normal.xyz + kernel.xyz * 1.0f) * 0.5;
	rayDir *= viewDirDiff * 1500.001;
	rayDir *= -origin.z * 0.025 + nearCutoff;


	rayPos += rayDir * -origin.z * 0.000037 * traceBias;

	float randomness = BlueNoise(texcoord.st + 0.117);

	rayPos += rayDir * randomness;



	float zThickness = 0.25
	* -origin.z
	;

	float shadow = 1.0;

	float numSamplesf = 64.0;
	//numSamplesf /= -origin.z * 0.125 + nearCutoff;

	int numSamples = int(numSamplesf);


	float shadowStrength = 0.9;

	for (int i = 0; i < 0; i++)
	{
		float fi = float(i) / float(1);

		rayPos += rayDir;

		vec3 rayProjPos = ProjectBack(rayPos);

		//rayProjPos *= -1.0;
		//TemporalJitterProjPos(rayProjPos);
		//rayProjPos *= -1.0;

		vec3 samplePos = GetViewPositionRaw(rayProjPos.xy, GetDepth(rayProjPos.xy)).xyz;

		float depthDiff = samplePos.z
		- rayPos.z - 0.02 * -origin.z * traceBias
		;

		if (depthDiff > 0.0 && depthDiff < zThickness)
		{
			shadow *= 1.0 - shadowStrength;
		}
	}
             float depth = texture2D(gdepthtex, texcoord.st).x;
			 float minDepth;
			 vec2 nearFragment = GetNearFragment(texcoord.st, depth, minDepth);
			 float nearDepth = texture2D(gdepthtex, nearFragment).x;
			 vec4 projPos = vec4(texcoord.st * 2.0 - 1.0, nearDepth * 2.0 - 1.0, 1.0);
			 vec4 viewPos = gbufferProjectionInverse * projPos;
			 viewPos.xyz /= viewPos.w;
			 vec4 worldP = gbufferModelViewInverse * vec4(viewPos.xyz, 1.0);
			 vec4 worldPosPrev = worldP;
			   worldPosPrev.xyz += (cameraPosition - previousCameraPosition);
			 vec4 viewPosPrev = gbufferPreviousModelView * vec4(worldPosPrev.xyz, 1.0);
			 vec4 projPosPrev = gbufferPreviousProjection * vec4(viewPosPrev.xyz, 1.0);
			 projPosPrev.xyz /= projPosPrev.w;
			 vec2 motionVector = (projPos.xy - projPosPrev.xy);

			 vec2 reprojCoord = texcoord.st - motionVector.xy * 0.5;

			 vec4 prevColor = texture2D(gaux4, reprojCoord.st);
			 float prevMinDepth = prevColor.a;
	         float dynamicWeight = max(0.0, 
							  1.0 - distance(GetDepthLinear2(nearDepth), 
											 GetDepthLinear2((projPosPrev.z * 0.5 + 0.5))) * far * 0.5);
			 float blendWeight = (1.0-exp2(-(1.1)));
	         vec2 lowerScreenBound = 1.0 / vec2(viewWidth, viewHeight);
	         vec2 upperScreenBound = 1.0 - lowerScreenBound;

	         if (reprojCoord.x < lowerScreenBound.x || reprojCoord.x > upperScreenBound.x ||
		     reprojCoord.y < lowerScreenBound.y || reprojCoord.y > upperScreenBound.y)
	         {
		       blendWeight = (0.0);
	         }
			 
		     prevColor = vec4(GammaToLinear(prevColor.rgb), prevColor.a);
			 prevColor = clamp(prevColor, vec4(0.0), vec4(1.0));
			 vec3 result = mix(vec3(shadow) * 0.00001, prevColor.rgb, blendWeight);		
	return length(result);
}

void 	CalculateEysMode(inout vec3 color, vec3 normal, MaterialMask mask, vec3 albedo, float smoothness, float metallic, float skylight, vec3 viewVector, vec2 refractionCoord) {
	const float phi = 1.618033988;
	const float gAngle = phi * 3.14159265 * 1.0003;
    const int numRays = 1;
    float num = 0.0f;	
    float dither = rand(texcoord.st+vec2(sin(frameTimeCounter),cos(frameTimeCounter))).x;
	
	float specularity = 1.0f - smoothness * smoothness * smoothness;
	      //specularity = max(0.0f, specularity * 1.15f - 0.15f);

	metallic = pow(metallic, 2.2);

	bool defaultItself = true;

	if (mask.sky > 0.5)
		specularity = 0.0f;

	if (mask.water > 0.5 || mask.ice > 0.5)
	{
		defaultItself = false;
		specularity = 0.0f;
		metallic = 0.0;
	}
	else
	{
		skylight = CurveBlockLightSky(texture2D(gdepth, texcoord.st).g);
	}

	if (mask.stainedGlass > 0.5)
	{
		specularity = 0.0;
	}


	vec3 b = vec3(0.0f)
    //+vec3(BlueNoiseTemporal(texcoord.st+sin(frameCounter*.75)).s,
	//BlueNoiseTemporal(texcoord.st + 16.0 / vec2(viewWidth, viewHeight)+sin(frameCounter*.75)).s,
	//BlueNoiseTemporal(texcoord.st + 32 / vec2(viewWidth, viewHeight)+sin(frameCounter*.75)).s)
	;
    b = vec3(BlueNoise(texcoord.st+vec2(sin(frameCounter*.75),cos(frameCounter*.75))),
	BlueNoise(texcoord.st + 16.0 / vec2(viewWidth, viewHeight)),
	BlueNoise(texcoord.st + 32 / vec2(viewWidth, viewHeight)));
	//b = rand(texcoord.st+vec2(sin(frameCounter*.75),cos(frameCounter*.75))*10.);
	vec3 original = color.rgb;
             float depth = texture2D(gdepthtex, texcoord.st).x;
			 float minDepth;
			 vec2 nearFragment = GetNearFragment(texcoord.st, depth, minDepth);
			 float nearDepth = texture2D(gdepthtex, nearFragment).x;
			 vec4 projPos = vec4(texcoord.st * 2.0 - 1.0, nearDepth * 2.0 - 1.0, 1.0);
			 vec4 viewPos = gbufferProjectionInverse * projPos;
			 viewPos.xyz /= viewPos.w;
			 vec4 worldP = gbufferModelViewInverse * vec4(viewPos.xyz, 1.0);
			 vec4 worldPosPrev = worldP;
			   worldPosPrev.xyz += (cameraPosition - previousCameraPosition);
			 vec4 viewPosPrev = gbufferPreviousModelView * vec4(worldPosPrev.xyz, 1.0);
			 vec4 projPosPrev = gbufferPreviousProjection * vec4(viewPosPrev.xyz, 1.0);
			 projPosPrev.xyz /= projPosPrev.w;
			 vec2 motionVector = (projPos.xy - projPosPrev.xy);

			 vec2 reprojCoord = texcoord.st - motionVector.xy * 0.5*BlueNoise(texcoord.st);

			 vec4 prevColor = texture2D(gaux4, reprojCoord.st);
			 float prevMinDepth = prevColor.a;
	         float dynamicWeight = max(0.0, 
							  1.0 - distance(GetDepthLinear2(nearDepth), 
											 GetDepthLinear2((projPosPrev.z * 0.5 + 0.5))) * far * 0.5);
			 float blendWeight = (1.0-exp2(-(1.5 * length(color.rgb / 1e-4))));
	         vec2 lowerScreenBound = 1.0 / vec2(viewWidth, viewHeight);
	         vec2 upperScreenBound = 1.0 - lowerScreenBound;

	         if (reprojCoord.x < lowerScreenBound.x || reprojCoord.x > upperScreenBound.x ||
		     reprojCoord.y < lowerScreenBound.y || reprojCoord.y > upperScreenBound.y)
	         {
		       blendWeight = (0.0);
	         }
			 
		     prevColor = vec4(GammaToLinear(prevColor.rgb), prevColor.a);
			 prevColor = clamp(prevColor, vec4(0.0), vec4(1.0));
	//if (specularity > 0.0f) 
	{
	  //color.rgb = mix(color.rgb, prevColor.rgb, blendWeight); 
	}
	//color.rgb = mix(color.rgb, original, vec3(surface.cloudAlpha));
}

vec3 GetFGI(vec2 coord, vec3 normal, float dither, float ln, vec3 worldNormal)
{
	const int numRays = 0;

	const float phi = 1.62;
	const float gAngle = phi * 3.1416;

	float depth = GetDepth(coord);
	float linDepth = ExpToLinearDepth(depth);
	vec3 origin = GetViewPosition(coord, depth).xyz;
	vec3 light = vec3(0.0f);
	float aoAccum = 0.0;

	float radius = origin.z * 0.15;
		radius = mix(radius, 0.8, 0.5);
	float zThickness = 0.15 * -origin.z;
		zThickness = mix(zThickness, 1.0, 0.5);			  
	  

	
	for (int i = 0; i < numRays; i++)
	{
		float fi = float(i) + dither;
		float fiN = fi / float(numRays);
		float lon = gAngle * fi * 6.0;
		float lat = asin(fiN * 2.0 - 1.0) * 1.0;

		vec3 kernel;
		kernel.x = cos(lat) * cos(lon);
		kernel.z = cos(lat) * sin(lon);
		kernel.y = sin(lat);

		kernel.xyz = normalize(kernel.xyz * 0.0f + normal.xyz);
		
    	vec2 screenSpacePosition2D = texcoord.st;
    	vec3 cameraSpacePosition = convertScreenSpaceToWorldSpace(screenSpacePosition2D);
		vec3 ppos = vec3(0.0f);
    	vec3 cameraSpaceNormal = kernel.xyz;
    	vec3 cameraSpaceViewDir = normalize(cameraSpacePosition);	
    	vec3 cameraSpaceVector = normalize(reflect(cameraSpaceViewDir,cameraSpaceNormal));	
		vec3 oldPosition = cameraSpacePosition;
    	vec3 cameraSpaceVectorPosition = oldPosition + cameraSpaceVector;
    	vec3 currentPosition = convertCameraSpaceToScreenSpace(cameraSpaceVectorPosition);			
        vec3 rayPos = currentPosition;
        float sampleDepth = convertScreenSpaceToWorldSpace(rayPos.st).z;

		float sampleLength = radius * mod(fiN, 0.07) / 0.07;
		
		rayPos += cameraSpaceVector / pow(2.0f, 1.0f);
        //cameraSpaceVector *= 1.37f;	//Each step gets bigger
		//currentPosition = convertCameraSpaceToScreenSpace(cameraSpaceVectorPosition);
		
		vec3 samplePos = origin
		//+ sampleLength
		//* kernel.xyz
		//* normal.xyz	
		;

		vec3 samplePosProj = ProjectBack(samplePos);

		vec3 actualSamplePos = GetViewPosition(samplePosProj.xy, GetDepth(samplePosProj.xy)).xyz;
		
			//ppos += normalize(reflect(cameraSpaceViewDir,cameraSpaceNormal)) / numRays * saturate(1.0 * exp2(origin.z * 0.05)) * 0.1;
			
		float depthDiff = actualSamplePos.z - samplePos.z;
		
		//if (depthDiff > 0.0 && depthDiff < 1.0)
		{
			aoAccum += 1.0;
            light += pow(texture2DLod(gaux3, 
            rayPos.st
			//actualSamplePos.st
			//texcoord.st
			//+ kernel.xy		
			//* saturate(1.0 * exp2(origin.z * 0.05)) * 0.1
			//* min(max(depthDiff, 0.0), zThickness)
			//* kernel.xy
			//* 1.0
			, 0).rgb, vec3(2.2f));
		}
	}

	aoAccum /= numRays;
    light /= numRays;
	float ao = 1.0 - saturate(aoAccum - 0.0);
	ao = pow(ao, 1.5);
    vec3 GI = vec3(0.0f);
	GI += light;
	//if(worldNormal.x>0.0)GI += vec3(0.00001, 0.0, 0.0);
	//if(saturate(worldNormal.y-0.5)>0.0)GI += vec3(0.0000, 0.00001, 0.0);	
	//if((worldNormal.y-0.)<0.0)GI += vec3(0.00001, 0.0000, 0.0);		
	//GI += saturate(1.0 * exp2(origin.z * 0.05)) * 0.0001;
	return GI;
}
/////////////////////////MAIN//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////MAIN//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void main() 
{

	GbufferData gbuffer 			= GetGbufferData();



	MaterialMask materialMask 		= CalculateMasks(gbuffer.materialID);
	vec4 viewPos 					= GetViewPosition(texcoord.st, gbuffer.depth);
	vec4 worldPos					= gbufferModelViewInverse * vec4(viewPos.xyzw);
	vec3 viewDir 					= normalize(viewPos.xyz);

	vec3 worldDir 					= normalize(worldPos.xyz);
	vec3 worldNormal 				= normalize((gbufferModelViewInverse * vec4(gbuffer.normal, 0.0)).xyz);
	vec3 worldTransparentNormal 	= normalize((gbufferModelViewInverse * vec4(GetWaterNormals(texcoord.st), 0.0)).xyz);


	//gbuffer.normal = normalize(gbuffer.normal - viewDir.xyz * (1.0 / (saturate(dot(gbuffer.normal, -viewDir.xyz)) + 0.01) ) * 0.0025);


	vec3 color = GammaToLinear(texture2D(gaux3, texcoord.st * SCLE).rgb);

	if (materialMask.water > 0.5 || materialMask.ice > 0.5)
	{
		gbuffer.normal = DecodeNormal(texture2D(gaux1, texcoord.st).xy);

		FixNormals(gbuffer.normal, viewPos.xyz);
	}

	float opaqueDepth = ExpToLinearDepth(texture2D(depthtex1, texcoord.st).x);
	float waterDepth = ExpToLinearDepth(gbuffer.depth);

	vec2 refractionCoord;

	WaterRefraction(color, materialMask, worldPos, waterDepth, opaqueDepth, refractionCoord);

	TransparentAbsorption(color, materialMask, worldPos, waterDepth, opaqueDepth);

	
    //void 	CalculateSpecularReflections(inout vec3 color, vec3 normal, MaterialMask mask, float smoothness, float skylight, vec3 viewVector) {
	
	//vec3 skylight = colorSkylight;
	vec3 skylight = FromSH(skySHR, skySHG, skySHB, worldNormal);
    //float AO = pow(texture2DLod(gnormal, texcoord.st, 0).a, 4.0);
    float AO = 1.0;			
	skylight *= pow(gbuffer.mcLightmap.g, 0.9 - isEyeInWater * 0.5) * (1.0 - wetness * 0.5);
	skylight *= AO * 1.3;
	
	vec3 viewPosTransparent = GetViewPosition(texcoord.st / SCLE, texture2D(gdepthtex, texcoord.st / SCLE).x).xyz;
	
	//if (isEyeInWater == 0)
	{
		CalculateSpecularReflections(color, gbuffer.normal, materialMask, gbuffer.albedo, gbuffer.smoothness, gbuffer.metallic, gbuffer.mcLightmap.g, gbuffer.mcLightmap.r, viewDir, viewPosTransparent, refractionCoord, skylight);
		//CalculateSpecularHighlight(color, gbuffer.normal, gbuffer.albedo, gbuffer.smoothness, gbuffer.metallic, gbuffer.mcLightmap.g, 
		// float sunlightMult = 12.0 * (1.0 - rainStrength) * SUNLIGHT_INTENSITY;
	    // vec3 specularGGX = SpecularGGX(worldNormal, -worldDir, worldLightVector, pow(1.0 - pow(gbuffer.smoothness, 1.0), 1.0), gbuffer.metallic * 0.98 + 0.02) * sunlightMult * 0.0001;
	    // color += specularGGX;
		//color += SpecularGGX(worldNormal, worldDir, worldLightVector, )
        //CalculateEysMode(color, gbuffer.normal, materialMask, gbuffer.albedo, gbuffer.smoothness, gbuffer.metallic, gbuffer.mcLightmap.g, viewDir, refractionCoord);			
	}
	

	//if (materialMask.sky < 0.5 || isEyeInWater < 0 ||  materialMask.water < 0.5 || materialMask.ice < 0.5 || materialMask.sky < 0.5)
	//{	
	//  FakeSSGI(color, gbuffer.albedo, gbuffer.mcLightmap.g, gbuffer.mcLightmap.r, gbuffer.normal.xyz, gbuffer.depth, AO);
	//}
	//if(materialMask.sky < 0.5)
	//{	
	//  FakeSSGI(color, gbuffer.albedo, gbuffer.mcLightmap.g, gbuffer.mcLightmap.r, gbuffer.normal.xyz, gbuffer.depth, AO);
	//}	
    //SmoothSky(color, materialMask, gbuffer.normal);
	
     //#ifdef VOLUMETRIC_LIGHT
     //color.rgb += GetCrepuscularRays(color, viewDir, lightVector, worldDir, viewPos.xyz, materialMask, worldPos.xyz);
     //#endif	

    //color.rgb += (GammaToLinear(texture2DLod(gaux3, texcoord.st, 10.0f).rgb)
	//+ GammaToLinear(texture2DLod(gaux3, texcoord.st, 8.0f).rgb)
	//+ GammaToLinear(texture2DLod(gaux3, texcoord.st, 6.0f).rgb)	
	//)
	//* isEyeInWater * gbuffer.albedo.rgb * 0.333;
	
	//if (materialMask.leaves > 0.5 || materialMask.grass > 0.5)
	//	worldNormal = vec3(0.0, 1.0, 0.0);		
		

	
	//skylight = mix(skylight, colorSunlight * (worldNormal.y * 0.5 + 0.5), vec3(0.0 + rainStrength * 0.0));
			
	//if (materialMask.sky < 0.5)	
	//{	
	//   color.rgb += ScreenSpaceAO(viewPos.xyz, worldPos.xyz, gbuffer.normal.xyz, materialMask, worldDir.xyz);
	//}	
	//if (materialMask.sky < 0.5)
	//{	
	//	color.rgb += GetFGI(texcoord.st, gbuffer.normal.xyz, rand(texcoord.st).x, 1.0f, worldNormal);
	//}
	color /= 0.0001;

	if (materialMask.sky < 0.5)
	{
	    //LandAtmosphericScattering(color, viewPos.xyz, viewDir, worldDir);

	//	//RainFog(color, worldPos.xyz);
	}
	if (gbuffer.depth > 0.99999)
	{
	    worldPos.xyz *= 10000.0;
	}			
	float diff = gbuffer.rainMask;
	#ifdef VOLUMETRIC_LIGHT
     	CrepuscularRays(color.rgb, worldPos.xyz, worldDir.xyz, materialMask, diff);
    #endif
	
	//if (materialMask.sky < 0.5 || isEyeInWater < 0 ||  materialMask.water < 0.5 || materialMask.ice < 0.5 || materialMask.sky < 0.5)
	//{	
	//  color *= diff;
    //}	
	BlindnessFog(color, viewPos.xyz, viewDir);

	color *= 0.0001;
	//color += saturate(dot(viewDir, gbuffer.normal) + 1.0) * 0.0001;


	//color = texture2D(gaux2, texcoord.st).aaa * 0.0001;

	color = LinearToGamma(color);

	gl_FragData[0] = vec4(color.rgb, 1.0f);
}
