#version 120

/*
 _______ _________ _______  _______  _
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the LICENSE.txt contained in the root directory of this shaderpack!

*/



#include "Common.inc"


/////////////////////////CONFIGURABLE VARIABLES////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////CONFIGURABLE VARIABLES////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define TAA_SOFTNESS 0.0 // Softness of temporal anti-aliasing. Default 0.0 [0.0 0.2 0.4 0.6 0.8 1.0]
#define SHARPENING 4.0 // Sharpening of the image. Default 0.0 [0.0 0.2 0.4 0.8 1.0 1.5 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0]

#define TAA_ENABLED // Temporal Anti-Aliasing. Utilizes multiple rendered frames to reconstruct an anti-aliased image similar to supersampling. Can cause some artifacts.
//#define TAA_AGGRESSIVE // Makes Temporal Anti-Aliasing more generously blend previous frames. This results in a more stable and smoother image, but causes more noticeable artifacts with movement.

/////////////////////////END OF CONFIGURABLE VARIABLES/////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////END OF CONFIGURABLE VARIABLES/////////////////////////////////////////////////////////////////////////////////////////////////////////////

/* DRAWBUFFERS:467 */



uniform sampler2D gcolor;
uniform sampler2D gdepth;
uniform sampler2D gdepthtex;
uniform sampler2D gnormal;
uniform sampler2D composite;
uniform sampler2D gaux1;
uniform sampler2D gaux3;
uniform sampler2D gaux4;
uniform sampler2D noisetex;

varying vec4 texcoord;
varying vec3 lightVector;

uniform int worldTime;

uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float aspectRatio;
uniform float frameTimeCounter;
uniform sampler2D shadowcolor;
uniform sampler2D shadowcolor1;
uniform sampler2D shadowtex1;

uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;

uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;

uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;

uniform int   isEyeInWater;
uniform float eyeAltitude;
uniform ivec2 eyeBrightness;
uniform ivec2 eyeBrightnessSmooth;
uniform int   fogMode;

varying float timeSunriseSunset;
varying float timeNoon;
varying float timeMidnight;

varying vec3 colorSunlight;
varying vec3 colorSkylight;
uniform int frameCounter;
uniform float frameTime;

#include "lib/FXAASimple.inc"

vec2 rot(vec2 p, float angle)
{
    vec2 po = p;
	
    mat2 mat = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    p = mat * p;

    return p;
}

vec2 WeylNth(int n)
{
	return fract(vec2(n * 12664745, n*9560333) / exp2(24.0));
	
	// vec2 v = vec2(n % 2, (n / 2) % 2).yx / 2.0;
	// return v;

	const int bayerMatrix[16] = int[16](
		0,  8,  2, 10,
		12, 4,  14, 6, 
		3,  11, 1,  9,
		15, 7,  13, 5
	);
	int i = bayerMatrix[n];
	return vec2(i % 4, (i / 4) % 4).yx / 4.0;


	const vec2 m[8] = vec2[8](
		vec2(0.0, 0.0)
		,vec2(0.5, 0.5)
		,vec2(0.5, 0.0)
		,vec2(0.0, 0.5)
		,vec2(0.24, 0.24) 
		,vec2(0.74, 0.74)
		,vec2(0.74, 0.24) 
		,vec2(0.24, 0.74)
	);
	return m[n % 8];
}

vec2 JitterSampleOffset(int frameOffset)
{
	return (WeylNth((frameCounter + frameOffset) % 16) * 2.0 - 1.0);
	
}

void TemporalJitterProjPos(inout vec4 pos)
{
	#ifdef TAA_ENABLED

	 pos.xy -= (JitterSampleOffset(0) * 0.5) / vec2(viewWidth, viewHeight);

	#else

	 pos.xy -= (JitterSampleOffset(0) * 0.5) / vec2(viewWidth, viewHeight);	
	
	#endif
}

void TemporalJitterProjPos(inout vec3 pos)
{
	#ifdef TAA_ENABLED
	
	 pos.xy -= (JitterSampleOffset(0) * 0.5) / vec2(viewWidth, viewHeight);

	#else
 
 	 pos.xy -= (JitterSampleOffset(0) * 0.5) / vec2(viewWidth, viewHeight);
	 
	#endif
}

vec3 GetColor(vec2 coord)
{
	return GammaToLinear(texture2D(gnormal, coord).rgb);
}

vec3 BlueNoiseTemporal(vec2 coord)
{
	vec2 noiseCoord = vec2(coord.st * vec2(viewWidth, viewHeight)) / 64.0;

	noiseCoord = (floor(noiseCoord * 64.0) + 0.5) / 64.0;
	
	vec3 irrationals = vec3(sqrt(1.0 / 5.0), sqrt(2.0), 1.61803398) * 1.0;

	vec3 n = vec3(texture2D(noisetex, noiseCoord).b);

	n = mod(n + irrationals * mod(frameCounter, 12.0f) + vec3(vec2(sin(frameCounter * 0.75), cos(frameCounter * 0.75)), 0.0), vec3(1.0));

	return n;
}

vec3 BlurV(vec2 coord)
{

	vec3 color = vec3(0.0);

	vec2 texel = 1.0 / vec2(viewWidth, viewHeight);

	float weights[5] = float[5](0.27343750, 0.21875000, 0.10937500, 0.03125000, 0.00390625);
	float offsets[5] = float[5](0.00000000, 1.00000000, 2.00000000, 3.00000000, 4.00000000);
	
	color += GetColor(coord) * weights[0];

	for (int i = 1; i < 5; i++)
	{
		color += GetColor(coord + vec2(0.0, offsets[i] * 1.0) * texel) * weights[i];
		color += GetColor(coord - vec2(0.0, offsets[i] * 1.0) * texel) * weights[i];
	}

	return color;

	//return GetColor(coord);
}

float 	ExpToLinearDepth(in float depth)
{
	return 2.0f * near * far / (far + near - (2.0f * depth - 1.0f) * (far - near));
}

vec2 GetNearFragment(vec2 coord, float depth, out float minDepth)
{
	
	const float num = 2.0;
	vec2 texel = 1.0 / vec2(viewWidth, viewHeight);
	vec4 depthSamples;
	depthSamples.x = texture2D(gdepthtex, coord + texel * vec2(num, num)).x;
	depthSamples.y = texture2D(gdepthtex, coord + texel * vec2(num, -num)).x;
	depthSamples.z = texture2D(gdepthtex, coord + texel * vec2(-num, num)).x;
	depthSamples.w = texture2D(gdepthtex, coord + texel * vec2(-num, -num)).x;

	vec2 targetFragment = vec2(0.0, 0.0);

	if (depthSamples.x < depth)
		targetFragment = vec2(num, num);
	if (depthSamples.y < depth)
		targetFragment = vec2(num, -num);
	if (depthSamples.z < depth)
		targetFragment = vec2(-num, num);
	if (depthSamples.w < depth)
		targetFragment = vec2(-num, -num);


	minDepth = min(min(min(depthSamples.x, depthSamples.y), depthSamples.z), depthSamples.w);

	return coord + texel * targetFragment;
}

vec3 RGBToYUV(vec3 color)
{
	mat3 mat = 		mat3( 0.2126,  0.7152,  0.0722,
				 	-0.09991, -0.33609,  0.436,
				 	 0.615, -0.55861, -0.05639);
				 	
	return color * mat;
}

vec3 YUVToRGB(vec3 color)
{
	mat3 mat = 		mat3(1.000,  0.000,  1.28033,
				 	1.000, -0.21482, -0.38059,
				 	1.000,  2.12798,  0.000);
				 	
	return color * mat;
}

vec3 ClipAABB(vec3 aabbMin, vec3 aabbMax, vec3 p, vec3 q)
{
	vec3 pClip = 0.5 * (aabbMax + aabbMin);
	vec3 eClip = 0.5 * (aabbMax - aabbMin);

	vec3 vClip = q - pClip;
	vec3 vUnit = vClip / eClip;
	vec3 aUnit = abs(vUnit);
	float maxUnit = max(aUnit.x, max(aUnit.y, aUnit.z));

	if (maxUnit > 1.0)
	{
		return pClip + vClip / maxUnit;
	}
	else
	{
		return q;
	}
}

float AverageExposure()
{
	float avglod = int(log2(min(viewWidth, viewHeight)));
	//return pow(texture2DLod(gaux3, texcoord.st, 0).a, 1.0);
	return pow(dot(texture2DLod(gaux3, vec2(0.5, 0.5), avglod).rgb, vec3(0.33333)), 2.0);
}

#define COLORPOW 1.0

/////////////////////////MAIN//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////MAIN//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void main() {

	//vec3 color = GammaToLinear(texture2D(gaux3, texcoord.st).rgb);

	vec3 bloomColor = vec3(0.0);

	bloomColor = BlurV(texcoord.st);

	bloomColor = LinearToGamma(bloomColor);


	//color += rand(texcoord.st) * (1.0 / 255.0);
	
	vec3 unjitteredCoord = vec3(texcoord.st, 0.0) * -1.0;
	TemporalJitterProjPos(unjitteredCoord);
	unjitteredCoord /= -1.0;
	//Combine TAA here...
	vec3 color = pow(DoFXAASimple(gaux3, unjitteredCoord.st, 1.0 / vec2(viewWidth, viewHeight)).rgb, vec3(COLORPOW));	//Sample color texture
	vec3 origColor = color;

	float minDepth;
	#ifdef TAA_ENABLED


	float depth = texture2D(gdepthtex, texcoord.st).x;

/*
	vec4 fragposition = gbufferProjectionInverse * currentPosition;
	fragposition = gbufferModelViewInverse * fragposition;
	fragposition /= fragposition.w;
	fragposition.xyz += cameraPosition;

	vec4 previousPosition = fragposition;
	previousPosition.xyz -= previousCameraPosition;
	previousPosition = gbufferPreviousModelView * previousPosition;
	previousPosition = gbufferPreviousProjection * previousPosition;
	previousPosition /= previousPosition.w;
*/



	vec2 nearFragment = GetNearFragment(texcoord.st, depth, minDepth);

	float nearDepth = texture2D(gdepthtex, nearFragment).x;

	vec4 projPos = vec4(texcoord.st * 2.0 - 1.0, nearDepth * 2.0 - 1.0, 1.0);
	vec4 viewPos = gbufferProjectionInverse * projPos;
	viewPos.xyz /= viewPos.w;
	if (nearDepth > 0.99999)
	{
		viewPos.xyz *= 100.01;
	}
	// if (length(viewPos.xyz) > far * 0.9)
	// {
	// 	viewPos.xyz *= 0.1;
	// }

	vec4 worldPos = gbufferModelViewInverse * vec4(viewPos.xyz, 1.0);
	//worldPos.xyz += cameraPosition;

	vec4 worldPosPrev = worldPos;
	//worldPosPrev.xyz -= previousCameraPosition;
	// if (length(viewPos.xyz) < far * 1.0)
	{
		worldPosPrev.xyz += (cameraPosition - previousCameraPosition);
	}

	vec4 viewPosPrev = gbufferPreviousModelView * vec4(worldPosPrev.xyz, 1.0);
	vec4 projPosPrev = gbufferPreviousProjection * vec4(viewPosPrev.xyz, 1.0);
	projPosPrev.xyz /= projPosPrev.w;

	vec2 motionVector = projPos.xy - projPosPrev.xy;

	float motionVectorMagnitude = length(motionVector) * 10.0;
	float pixelMotionFactor = clamp(motionVectorMagnitude * 500.0, 0.0, 1.0);

	vec2 reprojCoord = texcoord.st - motionVector.xy * 0.5;


	vec2 pixelError = 1.0 - abs((fract(abs(texcoord.st - reprojCoord.xy) * vec2(viewWidth, viewHeight)) * 2.0 - 1.0));
	vec2 pixelErrorFactor = pow(pixelError, vec2(1.1));
	
	vec4 prevColor = pow(texture2D(gaux4, reprojCoord.st), vec4(COLORPOW, COLORPOW, COLORPOW, 1.0));
	float prevMinDepth = prevColor.a;

	float motionVectorDiff = (abs(motionVectorMagnitude - prevColor.a));


	vec3 minColor = vec3(1000000.0,1000000.0,1000000.0);
	vec3 maxColor = vec3(0.0,0.0,0.0);
	vec3 avgColor = vec3(0.0,0.0,0.0);
	vec3 avgX = vec3(0.0);
	vec3 avgY = vec3(0.0);

	int c = 0;

	vec3 m1 = vec3(0.0);
	vec3 m2 = vec3(0.0);

	///*
	for (int i = -1; i <= 1; i++)
	{
		for (int j = -1; j <= 1; j++)
		{
			vec2 offs = (vec2(float(i), float(j)) / vec2(viewWidth, viewHeight)) * 0.7;
			vec3 samp = pow(DoFXAASimple(gaux3, unjitteredCoord.xy + offs, 1.0 / vec2(viewWidth, viewHeight)).rgb, vec3(COLORPOW));
			minColor = min(minColor, samp);
			maxColor = max(maxColor, samp);
			avgColor += samp;

			if (j == 0)
			{
				avgX += samp;
			}

			if (i == 0)
			{
				avgY += samp;
			}

			samp = (RGBToYUV(samp));

			m1 += samp;
			m2 += samp * samp;
			c++;
		}
	}
	avgColor /= c;

	avgX /= 3.0;
	avgY /= 3.0;

#ifdef TAA_AGGRESSIVE
	float colorWindow = 1.9;
#else
	float colorWindow = 1.5;
#endif

	vec3 mu = m1 / c;
	vec3 sigma = sqrt(max(vec3(0.0), m2 / c - mu * mu));
	vec3 minc = mu - (colorWindow) * sigma;
	vec3 maxc = mu + (colorWindow) * sigma;

	//adaptive blur
	color = mix(color, avgColor, vec3(vec2(0.25) - pixelErrorFactor * 0.25,.0));

#ifdef TAA_AGGRESSIVE
	vec3 blendWeight = vec3(0.015);
#else
	vec3 blendWeight = vec3(0.05);
#endif

    //blendWeight = vec3(1.0);
	if (reprojCoord.x < 0.0 || reprojCoord.x > 1.0 || reprojCoord.y < 0.0 || reprojCoord.y > 1.0)
	{
		blendWeight = vec3(1.0);
	}
	
	//adaptive sharpen
	vec3 sharpen = (vec3(1.0) - exp(-(color - avgColor) * 15.0)) * 0.06;
	vec3 sharpenX = (vec3(1.0) - exp(-(color - avgX) * 15.0)) * 0.06;
	vec3 sharpenY = (vec3(1.0) - exp(-(color - avgY) * 15.0)) * 0.06;
	color += sharpenX * (0.8 / blendWeight) * pixelErrorFactor.x;
	color += sharpenY * (0.8 / blendWeight) * pixelErrorFactor.y;

	//color += clamp(sharpen, -vec3(0.002), vec3(0.002)) * SHARPENING;
	
	color = mix(color, avgColor, vec3(TAA_SOFTNESS));
    
	//prevColor.rgb = YUVToRGB(clamp(RGBToYUV(prevColor.rgb), minc, maxc));
	prevColor.rgb = YUVToRGB(ClipAABB(minc, maxc, color.rgb, RGBToYUV(prevColor.rgb)));

	blendWeight = clamp(blendWeight, vec3(0.0), vec3(1.0));

	//if (depth < 0.7)
	//{
	//	blendWeight = vec3(1.0);
	//	color = origColor;
	//}

	vec3 taa = mix(prevColor.rgb, color, blendWeight);
	
	vec2 pixelCoord = texcoord.st * vec2(viewWidth, viewHeight);
	if (distance(pixelCoord, vec2(0.0, 0.0)) < 1.0)
	{
		float avgExposure = AverageExposure() * 100.0;
		float prevAvgExposure = texture2DLod(gaux4, texcoord.st, 0).a;
		avgExposure = mix(prevAvgExposure, avgExposure, avgExposure > prevAvgExposure ? 0.002 : 0.1);

		minDepth = avgExposure;
	}
	
	//if (distance(pixelCoord, vec2(0.0, 0.0)) < 1.0)
	//{
	//	float avgExposure2 = AverageExposure() * 100.0;
	//	float prevAvgExposure2 = texture2DLod(gaux4, texcoord.st, 0).a;
	//	avgExposure2 = mix(prevAvgExposure2, avgExposure2, avgExposure2 > prevAvgExposure2 ? 0.01 : 0.1);
	//    //minDepth += avgExposure2;
    //}
	
	taa = pow(taa, vec3(1.0 / COLORPOW));

	#else 

	vec3 taa = color.rgb;
	     minDepth = 1.0f;
	#endif

	gl_FragData[0] = vec4(bloomColor.rgb, 1.0f);
	gl_FragData[1] = vec4(taa, minDepth);
	gl_FragData[2] = vec4(vec3(0.0), 1.0f);

}
