#version 120
#include "Common.inc"
//#define DOF //Toggle Depth of Field (DoF).
#define BLUR_AMOUNT 0.1 //Adjust the maximum Blur Amount. [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
#define BIAS 0.16 //Adjust the Aperture. Bigger values cause a shallower Depth of Field. [0.04 0.06 0.08 0.10 0.12 0.14 0.15 0.16 0.18 0.20 0.22 0.24]

/* DRAWBUFFERS:6 */

uniform sampler2D noisetex;
uniform sampler2D gdepthtex;
uniform sampler2D gaux3;
varying vec4 texcoord;
uniform float centerDepthSmooth;
uniform float aspectRatio;
uniform int frameCounter;
uniform float viewWidth;
uniform float viewHeight;

float BlueNoise(vec2 coord)
{
	vec2 noiseCoord = vec2(coord.st * vec2(viewWidth, viewHeight)) / 64.0;
	noiseCoord += vec2(sin(frameCounter * 0.75), cos(frameCounter * 0.75));

	noiseCoord = (floor(noiseCoord * 64.0) + 0.5) / 64.0;

	float blueNoise = texture2DLod(noisetex, noiseCoord.st, 0).b;

	return blueNoise;
}

vec3 GetColorTexture(vec2 coord, vec2 blur) {
	return pow(texture2DLod(gaux3, coord, length(blur * 0.0)).rgb, vec3(2.2));
}

void DepthOfField(inout vec3 color) {
	float depth = texture2D(gdepthtex, texcoord.st).x;
	
	if(depth < 0.7) {
		depth += 0.45f;
	}
    const float phi = 3.1416;
	float dither = BlueNoise(texcoord.st + 16.0 / vec2(viewWidth, viewHeight));
	float angle = BlueNoise(texcoord.st + 32.0 / vec2(viewWidth, viewHeight)) * phi * 1.6;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));	
	vec2 aspectcorrect = vec2(1.0, aspectRatio) * 1.5;
	vec2 dofblur = vec2((depth - centerDepthSmooth) * BIAS) * BLUR_AMOUNT;
    const float step = 1.0f;
	vec3 col = vec3(0.0);
	float count = 0.0f;
	for (float i = -1.0f; i <= 1.0f; i += step)
	{
		for (float j = -1.0f; j <= 1.0f; j += step)
		{
	      col += GetColorTexture(texcoord.st
		  + (vec2(i + (dither - 0.5) * 1.0, j + (dither - 0.5) * 1.0) * rot)
		  * dofblur
		  * aspectcorrect
		  //* vec2(1.0f / viewWidth, 1.0f / viewHeight)
		  , aspectcorrect * dofblur);
		  count += 1.0;
        }
	}	
	
	color = col / count; 	
}

void main() {
	vec3 color = vec3(0.0);

	#ifdef DOF
		DepthOfField(color);
	#else
	 	color = GetColorTexture(texcoord.st, vec2(0.0f));
	#endif

	color = pow(color, vec3(1.0 / 2.2));
	gl_FragData[0] = vec4(color, 1.0);
}