#version 120

/*
 _______ _________ _______  _______  _
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the LICENSE.txt contained in the root directory of this shaderpack!

*/



#include "Common.inc"



/////////////////////////CONFIGURABLE VARIABLES////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////CONFIGURABLE VARIABLES////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#define TAA_ENABLED

#define TONEMAP_CURVE 1.5 // Controls the intensity of highlights. Lower values give a more filmic look, higher values give a more vibrant/natural look. Default: 5.0 [0.2 0.25 0.5 0.8 1.0 1.5 2.0 2.5 3.0 4.0 5.0 6.0]

//#define HDR 

#define EXPOSURE 1.0 // Controls overall brightness/exposure of the image. Higher values give a brighter image. Default: 1.0 [0.01 0.05 0.1 0.2 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

#define GAMMA 1.0 // Gamma adjust. Lower values make shadows darker. Higher values make shadows brighter. Default: 1.0 [0.7 0.8 0.9 1.0 1.1 1.2 1.3]

#define LUMA_GAMMA 1.0 // Gamma adjust of luminance only. Preserves colors while adjusting contrast. Lower values make shadows darker. Higher values make shadows brighter. Default: 1.0 [0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.4]

#define SATURATION 1.0 // Saturation adjust. Higher values give a more colorful image. Default: 1.0 [-2.0 -1.5 -1.3 -1.25 -1.2 -1.15 -1.1 -1.0 -0.9 -0.8 -0.7 -0.6 -0.5 -0.4 -0.3 -0.2 -0.1 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5]

#define VibranceC 1.0 // Saturation adjust. Higher values give a more colorful image. Default: 1.0 [-2.0 -1.5 -1.3 -1.25 -1.2 -1.15 -1.1 -1.0 -0.9 -0.8 -0.7 -0.6 -0.5 -0.4 -0.3 -0.2 -0.1 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5]

#define WHITE_CLIP 0.0 // Higher values will introduce clipping to white on the highlights of the image. [0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5]

#define BLOOM_AMOUNT 1.0 // Amount of bloom to apply to the image. [0.0 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

//#define MICRO_BLOOM // Very fine-scale bloom. Very bright areas will have a fine-scale bleed-over to dark areas.

#define TONEMAP_OPERATOR ACESTonemap // Each tonemap operator defines a different way to present the raw internal HDR color information to a color range that fits nicely with the limited range of monitors/displays. Each operator gives a different feel to the oveonemap HableTonemap ACESTonemap ACESTonemaprall final image. [UchimuraTonemap RTonemap DAVTonemap AgxTonemap FilmicTonemap LANDTonemap SEUSTonemap HableTonemap ACESTonemap ACESTonemap2]

#define BLACK_DEPTH 0.0  //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5]

#define BLACK_DEPTH 0.0  //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5]

#define SHARPENING 4.0 // Sharpening of the image. Default 0.0 [0.0 0.2 0.4 0.8 1.0 1.5 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0]

/////////////////////////END OF CONFIGURABLE VARIABLES/////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////END OF CONFIGURABLE VARIABLES/////////////////////////////////////////////////////////////////////////////////////////////////////////////


uniform sampler2D gcolor;
uniform sampler2D gdepth;
uniform sampler2D gdepthtex;
uniform sampler2D gnormal;
uniform sampler2D composite;
uniform sampler2D gaux1;
uniform sampler2D gaux3;
uniform sampler2D gaux4;
uniform sampler2D noisetex;

varying vec4 texcoord;
varying vec3 lightVector;

uniform int worldTime;

uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float aspectRatio;
uniform float frameTimeCounter;
uniform sampler2D shadowcolor;
uniform sampler2D shadowcolor1;
uniform sampler2D shadowtex1;

uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;

uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;

uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;

uniform int   isEyeInWater;
uniform float eyeAltitude;
uniform ivec2 eyeBrightness;
uniform ivec2 eyeBrightnessSmooth;
uniform int   fogMode;

varying float timeSunriseSunset;
varying float timeNoon;
varying float timeMidnight;

varying vec3 colorSunlight;
varying vec3 colorSkylight;

varying float avgSkyBrightness;

uniform vec3 skyColor;
uniform int frameCounter;

uniform float nightVision;

const float overlap = 1.9;

const float rgOverlap = 0.0 * overlap;
const float rbOverlap = 0.0 * overlap;
const float gbOverlap = 0.0 * overlap;

const mat3 coneOverlap = mat3(1.0, 			rgOverlap, 	rbOverlap,
							  rgOverlap, 	1.0, 		gbOverlap,
							  rbOverlap, 	rgOverlap, 	1.0);

const mat3 coneOverlapInverse = mat3(	1.0 + (rgOverlap + rbOverlap), 			-rgOverlap, 	-rbOverlap,
									  	-rgOverlap, 		1.0 + (rgOverlap + gbOverlap), 		-gbOverlap,
									  	-rbOverlap, 		-rgOverlap, 	1.0 + (rbOverlap + rgOverlap));

#include "lib/FXAASimple.inc"

float 	ExpToLinearDepth(in float depth)
{
	return 2.0f * near * far / (far + near - (2.0f * depth - 1.0f) * (far - near));
}

vec3 TransformOutputColor(vec3 c)
{
	// return c;
	return c * mat3(vec3(1.2, -0.2, 0.0),
				    vec3(0.0, 1.0, 0.0),
					vec3(0.0, 0.0, 1.0));
}

float BlueNoise(vec2 coord)
{
	vec2 noiseCoord = vec2(coord.st * vec2(viewWidth, viewHeight)) / 64.0;
	noiseCoord += vec2(sin(frameCounter * 0.75), cos(frameCounter * 0.75));

	noiseCoord = (floor(noiseCoord * 64.0) + 0.5) / 64.0;

	float blueNoise = texture2DLod(noisetex, noiseCoord.st, 0).b;

	return blueNoise;
}

vec2 BlueNoiseXY(vec2 coord)
{
	return vec2(BlueNoise(coord.st), BlueNoise(coord.st + 32.0 / vec2(viewWidth, viewHeight)));
}

float BlueNoiseStatic(vec2 coord)
{
	vec2 noiseCoord = vec2(coord.st * vec2(viewWidth, viewHeight)) / 64.0;

	noiseCoord = (floor(noiseCoord * 64.0) + 0.5) / 64.0;

	float blueNoise = texture2DLod(noisetex, noiseCoord.st, 0).b;

	return blueNoise;
}

float almostIdentity( float x, float m, float n )
{
    if( x>m ) return x;

    float a = 2.0*n - m;
    float b = 2.0*m - 3.0*n;
    float t = x/m;

    return (a*t + b)*t*t + n;
}

vec3 almostIdentity(vec3 x, vec3 m, vec3 n)
{
	return vec3(
		almostIdentity(x.x, m.x, n.x),
		almostIdentity(x.y, m.y, n.y),
		almostIdentity(x.z, m.z, n.z)
		);
}

vec3 BlackDepth(vec3 color, vec3 blackDepth)
{
	vec3 m = blackDepth;
	vec3 n = blackDepth * 0.5;
	return (almostIdentity(color, m, n) - n);// * (vec3(1.0) - n);
}

float GetDepthLinear2(float depth){
	return (2.0 * near) / (far + near - depth * (far - near));
}

vec3 RTonemap(vec3 t)
{ 
	const float hl = 10.0;
    vec3 t1 = t;
	if(t1.r >= 0.5)
	{
	 //t1.r = mix(t1.r, Luminance(t1), saturate(t1.r));
	 //t.r = length(t.r / (0.7 + t.r) * 1.0) * normalize(t1 + 1e-6).r * mix(normalize(t1 + 1e-6).r, (t.r / (0.5 + t.r) * 1.0), length(t.r / (0.5 + t.r) * 1.0));
	 t.r = t.r / (0.5 + t.r);
	}
	
	if(t1.g >= 0.5)
	{
	 //t1.g = mix(t1.g, Luminance(t1), saturate(t1.g));
	 //t.g = length(t.g / (0.7 + t.g) * 1.0) * normalize(t1 + 1e-6).g * mix(normalize(t1 + 1e-6).g, (t.g / (0.5 + t.g) * 1.0), length(t.g / (0.5 + t.g) * 1.0));
	 t.g = t.g / (0.5 + t.g);	 
	}
	
	if(t1.b >= 0.5)	
	if(t1.b >= 0.5)
	{
	 //t1.b = mix(t1.b, Luminance(t1), saturate(t1.b));
	 //t.b = length(t.b / (0.7 + t.b) * 1.0) * mix(normalize(t1 + 1e-6).b, (t.b / (0.5 + t.b) * 1.0), length(t.b / (0.5 + t.b) * 1.0));
	 t.b = t.b / (0.5 + t.b);	 
	}	
	
	//t = length(t / (0.7 + t) * 1.0) * normalize(t1 + 1e-6);
	//t.x /= length(hl / (0.7 + hl) * 1.0) * mix(normalize(vec3(hl) + 1e-6).x, (hl / (0.7 + hl) * 1.0), length(hl / (0.7 + hl) * 1.0));
	//t.y /= length(hl / (0.7 + hl) * 1.0) * mix(normalize(vec3(hl) + 1e-6).y, (hl / (0.7 + hl) * 1.0), length(hl / (0.7 + hl) * 1.0));
	//t.z /= length(hl / (0.7 + hl) * 1.0) * mix(normalize(vec3(hl) + 1e-6).z, (hl / (0.7 + hl) * 1.0), length(hl / (0.7 + hl) * 1.0));	
	//t = mix(t, vec3(Luminance(t)), vec3(0.5));
	//t = saturate(t * coneOverlapInverse);
    //if(texcoord.s > 0.5 ) t = saturate(vec3(Luminance(t1)));
	return t;
}

vec3 ft(vec3 x, float p)
{
  return pow(x / (x + p), vec3(1.0 / log2(p + 1.0) * 0.0 + 1.0));
}

vec3 AITonemap(vec3 t)
{ 
	const float a = 2.51;
	const float b = 0.03;
	const float c = 2.43;
	const float d = 0.59;
	const float e = 0.14;
	t = max(t, vec3(1e-10)); // Prevent division by zero
    vec3 x = t;
    vec3 y = a * x + b;
    vec3 z = y / (y + c * x + d);
    vec3 tonemapped = pow(z, vec3(1.0 / e)) - 0.004;
	return tonemapped;
}

vec3 AgxDefaultContrastApprox(vec3 x){
	return (((((15.5 * x - 40.14) * x + 31.96) * x - 6.868) * x + 0.4298) * x + 0.1191) * x - 0.00232;			 
}

const float AGX_EV = 14.0f;
vec3 AgxTonemap(vec3 color) {

	color *= 2.3;
	color *= mat3(0.99999976, -1.26657e-7, -1.29064e-9, 1.67316e-8, 0.99999976, -5.32026e-9, -0.00725587, 6.47740e-9, 1.00725580);
	
    color *= mat3(0.842479062253094, 0.0784335999999992, 0.0792237451477643, 0.0423282422610123, 0.878468636469772, 0.0791661274605434, 0.0423756549057051, 0.0784336, 0.879142973793104);

	const float hev = AGX_EV * 0.5;
	const float middle_grey = 0.18;	
	color = clamp(log2(color / middle_grey), -hev, hev);	
	color = (color + hev) / AGX_EV;
	
    //const float minEv = -8.0;
    //const float maxEv = 4.0;
    //color = clamp(log2(color * 3.0), minEv, maxEv);
    //color = (color - minEv) / (maxEv - minEv);
	
	color = AgxDefaultContrastApprox(color);	
	

	
	color *= mat3(1.19687900512017, -0.0980208811401368, -0.0990297440797205, -0.0528968517574562, 1.15190312990417, -0.0989611768448433, -0.0529716355144438, -0.0980434501171241, 1.15107367264116);
	
	//color = mix(color, vec3(Luminance(color)), vec3(-0.1));		
	/*
	const float a = 0.2;
	float l = a * a * (3.0 - 2.0 * a);
	vec3 c = color * (1.0 - a) + a;
	color = c * c * (3.0 - 2.0 * c);
	color -= l;
	color /= 1.0 - l;
	color = max(vec3(0.0), color);
    color = mix(color, color * color * (3.0 - 2.0 * color), vec3(0.1));	
	*/
    color = pow(color, vec3(2.2));				
	return color;
}

vec3 UchimuraTonemap(vec3 color) {
    const float maxDisplayBrightness = 0.95;   // max display brightness Default:1.2
    const float contrast             = 1.0;   // contrast Default:0.625
    const float linearStart          = 0.175;  // linear section start Default:0.1
    const float linearLength         = 0.25;    // linear section length Default:0.0
    const float black                = 1.66;  // black Default:1.33
    const float pedestal             = 0.0;    // pedestal

    float l0 = ((maxDisplayBrightness - linearStart) * linearLength) / contrast;
    float L0 = linearStart - linearStart / contrast;
    float L1 = linearStart + (1.0 - linearStart) / contrast;
    float S0 = linearStart + l0;
    float S1 = linearStart + contrast * l0;
    float C2 = (contrast * maxDisplayBrightness) / (maxDisplayBrightness - S1);
    float CP = -C2 / maxDisplayBrightness;

    vec3 w0 = 1.0 - smoothstep(0.0, linearStart, color);
    vec3 w2 = step(linearStart + l0, color);
    vec3 w1 = 1.0 - w0 - w2;

	vec3 T = linearStart * pow(color / vec3(linearStart), vec3(black)) + vec3(pedestal);
    vec3 S = maxDisplayBrightness - (maxDisplayBrightness - S1) * exp(CP * (color - S0));
    vec3 L = linearStart + contrast * (color - linearStart);

	//color = color * coneOverlap;

    color = T * w0 + L * w1 + S * w2;

	// Clamp to [0, 1]
	//color = color * coneOverlapInverse;
	//color = mix(color, vec3(Luminance(color)), vec3(-0.1));	
    color = saturate(color);
	return color;
}
/*
vec3 FilmicTonemap(vec3 x)
{

    x = pow(saturate((x*(x*6.2+0.5))/(x*(x*6.2+1.7)+0.06)), vec3(2.2));
	x = saturate(x);	
    return x;
}
*/
const float startCompression = 0.8 - 0.04;
const float desaturation = 0.15; 

vec3 tonemapping_PBR_Neutral(vec3 color)
{
    float x = min(color.r, min(color.g, color.b));
    float offset = x < 0.08 ? x - 6.25 * x * x : 0.04;
    color -= offset;

    float peak = max(color.r, max(color.g, color.b));
    if (peak < startCompression) return color;

    float d = 1. - startCompression;
    float newPeak = 1. - d * d / (peak + d - startCompression);
    color *= newPeak / peak;

    float g = 1. - 1. / (desaturation * (peak - newPeak) + 1.);
    return mix(color, newPeak * vec3(1, 1, 1), g);
}

vec3 LANDTonemap(vec3 t)
{ 
    t = t * coneOverlap;		
	t = pow(1.0 + t * 1.2, vec3(-0.98)) * t;
	{
	const float a = 0.2;
	float l = a * a * (3.0 - 2.0 * a);
	vec3 c = t * (1.0 - a) + a;
	t = c * c * (3.0 - 2.0 * c);
	t -= l;
	t /= 1.0 - l;
	t = max(vec3(0.0), t);
    t = mix(t, t * t * (3.0 - 2.0 * t), vec3(0.1));	
	}	
	t = t * coneOverlap;	
    t = TransformOutputColor(t);		
	return t;
}

vec3 DAVTonemaptttt(vec3 color)
{ 
	color *= 1.5;
	const float p = TONEMAP_CURVE;
	
	vec3 x = color;	
	color = pow(color, vec3(p));  
	float l = Luminance(color);
    vec3 tonemapped = pow(l, 0.5) * color / (pow(l, 0.5) * color + 1.0);
    tonemapped = pow(tonemapped, vec3(1.0 / p));
	tonemapped = mix(tonemapped, vec3(Luminance(tonemapped)), vec3(-0.3));

	return tonemapped;
	
}

vec3 DAVTonemapttt(vec3 t)
{ 
	const float p = TONEMAP_CURVE;
	float avgLum = texture2DLod(gaux4, vec2(0.0, 0.0), 0).a;
	const float HL = 1.0;
	float Lm = (avgLum + 1.0 / HL) * HL;
	float l = Luminance(t);		
	t = t * 5.0
	//* pow(p / 2.0, 0.5)
	;	
	vec3 t1 = t;	
	//t = pow(t / (t + 1.0), vec3(1.0 / log2(2 * (t + 1.0))));	
    //t = t / (0.0 + Lm);
    //t = pow(t / Lm, vec3(1.0 / log2(2 * Lm)));	
    //t = pow(t, vec3(Lm + 1));		
	//t *= 2.0;
	//t = t / (t + 1.0);	
	//t = pow(t, vec3(0.8));	
    //t = pow(t, vec3(1.0 / (Lm + 1)));	
	//t = mix(t, vec3(Luminance(t)), vec3(-1.0));	
	///*
	t = pow(t, vec3(1.7));  	
	t = pow(vec3(0.1), vec3(1.0 / log2(2 * (t + 1.0))));
	t -= 0.1;	
	t = t * 1.5;	
    //t = pow(t, vec3(1.0));	
	t = saturate(t * coneOverlapInverse);
    //t = mix(length(t) * normalize(t1 + 0.0001), t, saturate(t * 1.01) * 0.5 + 0.5);	
	//*/
	//t = pow(t / (t+1.0), vec3(t / (t+1.0) / log2(2 * (t / (t+1.0) + 1.0))));	
	return t;
}

vec3 DAVTonemaptt(vec3 color)
{ 
	const float p = TONEMAP_CURVE;
	
	float l = Luminance(color);	
	
    vec3 t = pow(color, vec3(color / (color + 1) + 1.0));  
    t = pow(t, vec3(-t / (t + 1.0) + 2.0)) / 1.323;
	t /= t + 1.0;
	t = pow(t, vec3(0.5));

	return t;
}

vec3 DAVTonemapt(vec3 color)
{ 
	const float p = TONEMAP_CURVE;

	float l = Luminance(color);	
	const float lmt = 2.7183;
	const float lmt2 = 3.1415926;	
	float n = 0.0
	+ saturate(sin(frameCounter * lmt2)) * lmt * rand(texcoord.st).x / frameTimeCounter
	;		
    vec3 t = color;  
    t = pow(t, vec3(p - pow(n * n / (l * l + 1.0), 0.5) + n));	
	t /= t + 1.0;
	t /= pow(n * n / (l * l + 1.0), 0.5) + 1.0 / (n + 1.0);	
	t = pow(t, vec3(1.0 / p));
	//t = pow(t, vec3(1.1));	
	t = mix(t, vec3(Luminance(t)), vec3(-pow(n * n / (l * l + 1.0), 0.5) + 1.0 / (n + 1.0) - 1.0));	

	return t;
}

vec3 DAVTonemap(vec3 t)
{ 
	const float p = TONEMAP_CURVE;

	vec3 t1 = t;
	t *= 0.9;
	t /= t + 1.0;
	t = pow(t, vec3(-pow(t, vec3(0.5)) * 0.86 + 1.0));
	t = pow(t, vec3(pow(1.0 - t, vec3(1.0)) * 0.4 + 0.6));
	t = pow(t, vec3(0.4 / (1.0 + t1) + 1.1));	
	float t0 = length(t);
    //t = mix(normalize(1e-9 + t) * t0, normalize(1e-9 + pow(t, vec3(1.1))) * t0, saturate(t));	
    //t = normalize(1e-9 + pow(t, vec3(1.0 + t0 * t0 * 0.5))) * t0;	
    //if(texcoord.s > 0.5) t = t1 / (1.0 + t1);

	t = saturate(t);
	return t;	
}

vec3 DAVTonemap2(vec3 color)
{ 
	//const float p = TONEMAP_CURVE;
	//color = color * coneOverlap;
	
	//vec3 tonemapped = color;

    //float l = Luminance(color);
	//tonemapped *= l;
	//tonemapped /= 1.0 + l * (l * 0.1 + color * 0.9);
	//tonemapped = pow(tonemapped, vec3(0.5));
	//tonemapped = tonemapped * 0.5 + 0.5;
	//tonemapped = mix(tonemapped, tonemapped * tonemapped * (3.0 - 2.0 * tonemapped), vec3(0.8));
	//tonemapped = saturate(tonemapped * 2.0 - 1.0);
	////tonemapped += rand(texcoord.st + frameTimeCounter * 0.01) * 0.05 - 0.04;
	//tonemapped = mix(tonemapped, vec3(Luminance(tonemapped)), vec3(-1.0));
	//tonemapped = saturate(tonemapped * coneOverlapInverse);
	color *= 1.5;
	const float p = TONEMAP_CURVE;
	
	vec3 x = color;	
	//color = pow(color, vec3(p));  
	float l = Luminance(color);
    vec3 tv = color / (1.0f + color);
    vec3 tonemapped = color;
    //tonemapped = pow(tonemapped, vec3(1.0 / p));
	//tonemapped = BlackDepth(tonemapped, vec3(0.001));

	return tonemapped;
}

vec3 SEUSTonemap(vec3 color)
{
	color = color * coneOverlap;		
	const float p = TONEMAP_CURVE;
	color = pow(color, vec3(p));
	color = color / (1.0 + color);
	color = pow(color, vec3(1.0 / p));

	{
	const float a = 0.3;
	float l = a * a * (3.0 - 2.0 * a);
	vec3 c = color * (1.0 - a) + a;
	color = c * c * (3.0 - 2.0 * c);
	color -= l;
	color /= 1.0 - l;
	color = max(vec3(0.0), color);
    color = mix(color, color * color * (3.0 - 2.0 * color), vec3(0.2));	
	}
	// color = mix(color, color * color * (3.0 - 2.0 * color), vec3(0.0));

	//color = pow(color, vec3(1.0 / 2.0));
	//color = mix(color, color * color * (3.0 - 2.0 * color), vec3(0.1));
	//color = pow(color, vec3(2.0));

	//color = color * 0.5 + 0.5;
	//color = mix(color, color * color * (3.0 - 2.0 * color), vec3(0.8));
	//color = saturate(color * 2.0 - 1.0);

	// color.r = almostIdentity(color.r, 0.05, 0.0);
	// color.g = almostIdentity(color.g, 0.05, 0.0);
	// color.b = almostIdentity(color.b, 0.05, 0.0);
	color = color * coneOverlap;	
    color = TransformOutputColor(color);		
	return color;
}



/////////////////////////////////////////////////////////////////////////////////
// Tonemapping by John Hable
vec3 HableTonemap(vec3 x)
{

	//x *= 1.5;

	const float A = 0.15;
	const float B = 0.50;
	const float C = 0.10;
	const float D = 0.20;
	const float E = 0.00;
	const float F = 0.30;

	x = pow(x, vec3(TONEMAP_CURVE));

   	vec3 result = pow((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F), vec3(1.0 / TONEMAP_CURVE))-E/F;
   	result = saturate(result);

   	return result;
}
/////////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////////////////
//	ACES Fitting by Stephen Hill
vec3 RRTAndODTFit(vec3 v)
{
    vec3 a = v * (v + 0.0245786f) - 0.000090537f;
    vec3 b = v * (1.0f * v + 0.4329510f) + 0.238081f;
    return a / b;
}

vec3 ACESTonemap2(vec3 color)
{
	color *= 1.5;

    // Apply RRT and ODT
    color = RRTAndODTFit(color);


    // Clamp to [0, 1]
    color = saturate(color);

    return color;
}
/////////////////////////////////////////////////////////////////////////////////








const mat3 ACESInputMat = mat3(
    0.59719, 0.35458, 0.04823,
    0.07600, 0.90834, 0.01566,
    0.02840, 0.13383, 0.83777
);

// ODT_SAT => XYZ => D60_2_D65 => sRGB
const mat3 ACESOutputMat = mat3(
     1.60475, -0.53108, -0.07367,
    -0.10208,  1.10813, -0.00605,
    -0.00327, -0.07276,  1.07602
);
/*
vec3 ACESTonemap(vec3 color)
{
	color = color * 1.5;
    //color = color * ACESInputMat;
    color = RRTAndODTFit(color);
    //color = color * ACESOutputMat;
    color = clamp(color, 0.0, 1.0);
	return color;
}
*/
vec3 Tonemap2(vec3 color)
{
	color *= 1.3;

	const float p = 2.9;
	color = pow(color, vec3(p));
	color = color / (1.0 + color);
	color = pow(color, vec3(1.0 / p));

	color = mix(color, color * color * (3.0 - 2.0 * color), vec3(0.0));

	color = pow(color, vec3(1.0 / 2.0));
	color = mix(color, color * color * (3.0 - 2.0 * color), vec3(0.1));
	color = pow(color, vec3(2.0));

	//color = color * 0.5 + 0.5;
	//color = mix(color, color * color * (3.0 - 2.0 * color), vec3(0.8));
	//color = saturate(color * 2.0 - 1.0);

	return color;
}



vec3 	CalculateNoisePattern1(vec2 offset, float size) 
{
	vec2 coord = texcoord.st;

	coord *= vec2(viewWidth, viewHeight);
	coord = mod(coord + offset, vec2(size));
	coord /= 64.0;

	return texture2D(noisetex, coord).xyz;
}

vec4 cubic(float x)
{
    float x2 = x * x;
    float x3 = x2 * x;
    vec4 w;
    w.x =   -x3 + 3*x2 - 3*x + 1;
    w.y =  3*x3 - 6*x2       + 4;
    w.z = -3*x3 + 3*x2 + 3*x + 1;
    w.w =  x3;
    return w / 6.f;
}

vec4 BicubicTexture(in sampler2D tex, in vec2 coord)
{
	vec2 resolution = vec2(viewWidth, viewHeight);

	coord *= resolution;

	float fx = fract(coord.x);
    float fy = fract(coord.y);
    coord.x -= fx;
    coord.y -= fy;

    fx -= 0.5;
    fy -= 0.5;

    vec4 xcubic = cubic(fx);
    vec4 ycubic = cubic(fy);

    vec4 c = vec4(coord.x - 0.5, coord.x + 1.5, coord.y - 0.5, coord.y + 1.5);
    vec4 s = vec4(xcubic.x + xcubic.y, xcubic.z + xcubic.w, ycubic.x + ycubic.y, ycubic.z + ycubic.w);
    vec4 offset = c + vec4(xcubic.y, xcubic.w, ycubic.y, ycubic.w) / s;

    vec4 sample0 = texture2D(tex, vec2(offset.x, offset.z) / resolution);
    vec4 sample1 = texture2D(tex, vec2(offset.y, offset.z) / resolution);
    vec4 sample2 = texture2D(tex, vec2(offset.x, offset.w) / resolution);
    vec4 sample3 = texture2D(tex, vec2(offset.y, offset.w) / resolution);

    float sx = s.x / (s.x + s.y);
    float sy = s.z / (s.z + s.w);

    return mix( mix(sample3, sample2, sx), mix(sample1, sample0, sx), sy);
}

vec3 GetBloomTap(vec2 coord, const float octave, const vec2 offset)
{
	float scale = exp2(octave);

	coord /= scale;
	coord -= offset;

	return (BicubicTexture(gaux1, coord).rgb);
}

vec2 CalcOffset(float octave)
{
    vec2 offset = vec2(0.0);
    
    vec2 padding = vec2(30.0) / vec2(viewWidth, viewHeight);
    
    offset.x = -min(1.0, floor(octave / 3.0)) * (0.25 + padding.x);
    
    offset.y = -(1.0 - (1.0 / exp2(octave))) - padding.y * octave;

	offset.y += min(1.0, floor(octave / 3.0)) * 0.35;
    
 	return offset;   
}


vec3 PhaseMieCol( vec3 g, vec3 LdotV, vec3 LdotV2 ) {
	vec3 gg = g * g;
	
	vec3 a = ( 1.0 - gg ) * ( 1.0 + LdotV2 );

	vec3 b = 1.0 + gg - 2.0 * g * LdotV;
	b *= sqrt( b );
	b *= 2.0 + gg;	
	
	return 1.5 * a / b;
}

vec3 GetBloom(vec2 coord)
{
	vec3 bloom = vec3(0.0);

	//bloom += GetBloomTap(coord, 1.0, CalcOffset(0.0)) * 2.0 * vec3(0.0, 0.0, 2.0);
	//bloom += GetBloomTap(coord, 2.0, CalcOffset(1.0)) * 1.5 * vec3(0.1, 0.4, 1.0);
	//bloom += GetBloomTap(coord, 3.0, CalcOffset(2.0)) * 1.2 * vec3(0.4, 0.8, 0.9);
	//bloom += GetBloomTap(coord, 4.0, CalcOffset(3.0)) * 1.3 * vec3(0.6, 0.7, 0.6);
	//bloom += GetBloomTap(coord, 5.0, CalcOffset(4.0)) * 1.4 * vec3(0.99, 0.9, 0.8);
	//bloom += GetBloomTap(coord, 6.0, CalcOffset(5.0)) * 1.5 * vec3(0.7, 0.32, 0.08);
	//bloom += GetBloomTap(coord, 7.0, CalcOffset(6.0)) * 1.6 * vec3(0.3, 0.68, 0.92);
	//bloom += GetBloomTap(coord, 8.0, CalcOffset(7.0)) * 1.7 * vec3(0.01, 0.1, 0.2);
	//bloom += GetBloomTap(coord, 9.0, CalcOffset(8.0)) * 0.4 * vec3(0.4, 0.3, 0.4);
	
	//bloom += GetBloomTap(coord, 1.0, CalcOffset(0.0));
	//bloom += GetBloomTap(coord, 3.0, CalcOffset(2.0));
	//bloom += GetBloomTap(coord, 4.0, CalcOffset(3.0));
	//bloom += GetBloomTap(coord, 5.0, CalcOffset(4.0));
	//bloom += GetBloomTap(coord, 6.0, CalcOffset(5.0));
	//bloom /= 5.0;
	
	//bloom += GetBloomTap(coord, 1.0, CalcOffset(0.0)) * 0.8;
	//bloom += GetBloomTap(coord, 2.0, CalcOffset(1.0)) * 1.1;
	//bloom += GetBloomTap(coord, 3.0, CalcOffset(2.0)) * 1.3;
	//bloom += GetBloomTap(coord, 4.0, CalcOffset(3.0)) * 0.25;   
	//bloom += GetBloomTap(coord, 1.0, CalcOffset(0.0)) * 0.25;
	//bloom += GetBloomTap(coord, 6.0, CalcOffset(5.0)) * 0.5;   
	//bloom += GetBloomTap(coord, 7.0, CalcOffset(6.0)) * 4.0;
	
	//bloom /= 0.25;
	
	bloom += GetBloomTap(coord, 1.0, CalcOffset(0.0)) * 1.5;
	bloom += GetBloomTap(coord, 2.0, CalcOffset(1.0)) * 1.5;
	bloom += GetBloomTap(coord, 3.0, CalcOffset(2.0)) * 1.2;
	bloom += GetBloomTap(coord, 4.0, CalcOffset(3.0)) * 1.3;
	bloom += GetBloomTap(coord, 5.0, CalcOffset(4.0)) * 1.4;
	bloom += GetBloomTap(coord, 6.0, CalcOffset(5.0)) * 1.5;
	bloom += GetBloomTap(coord, 7.0, CalcOffset(6.0)) * 1.6;

	bloom /= 10.0;
	
	//bloom = GetBloomTap(coord, 7.0, CalcOffset(6.0));
	//bloom = mix(bloom, vec3(dot(bloom, vec3(0.3333))), vec3(-0.1));
	//bloom = mix(bloom, vec3(dot(bloom, vec3(0.3333))), vec3(0.1));
    //bloom *= exp(-length(bloom + 1.0) * (vec3(1.0) - C_R1)); 
	//bloom *= PhaseMieCol(length(bloom) * vec3(0.9), length(bloom) * normalize(bloom + 0.00001), length(bloom * bloom) * normalize(bloom + 0.00001) * normalize(bloom + 0.00001)) * 2.0;	
	//bloom = length(bloom) * pow(normalize(bloom + 0.00001), vec3(1.5));

	return bloom;
}

void CalculateExposureEyeBrightness(inout vec3 color) 
{
	float exposureMax = 1.55f;
		  //exposureMax *= mix(1.0f, 0.25f, timeSunriseSunset);
		  //exposureMax *= mix(1.0f, 0.0f, timeMidnight);
		  //exposureMax *= mix(1.0f, 0.25f, rainStrength);
		  exposureMax *= avgSkyBrightness * 2.0;
	float exposureMin = 0.07f;
	float exposure = pow(eyeBrightnessSmooth.y / 240.0f, 6.0f) * exposureMax + exposureMin;

	//exposure = 1.0f;

	color.rgb /= vec3(exposure);
	color.rgb *= 350.0;
}

void AverageExposure(inout vec3 color)
{
	float avgLum = texture2DLod(gaux4, vec2(0.0, 0.0), 0).a * 0.01;
	color /= avgLum * 23.9 + 0.0001;
}

void AverageExposureColor(inout vec3 color)
{
	float avgLum = texture2DLod(gaux4, vec2(0.0, 0.0), 0).a * 0.02;
	//color = pow(color, vec3(1.0 / (color * 1.0 + 1.0)));
	//color = pow(color, vec3(1.0 / (avgLum * 100.0 + 1.0)));
	color /= avgLum * 145.0 + 0.0001;
	//color *= 0.8;
	
}

void AverageExposure2(inout vec3 color)
{
	float avglod = int(log2(min(viewWidth, viewHeight))) - 0.0;

	float avgLumPow = 1.96;
	float exposureMax = 23.9;
	float exposureMin = 0.0001;

	color /= pow(pow(Luminance(texture2DLod(gaux3, vec2(0.65, 0.65), avglod).rgb), avgLumPow) * exposureMax + exposureMin, 1.0);
	//color *= 5.04;
}

void MicroBloom(inout vec3 color, in vec2 uv)
{
	/*
	vec2 texel = vec2(1.0 / viewWidth, 1.0 / viewHeight);
	vec3 sum = GetColorTexture(texcoord.st + vec2(0.5, -0.5) * texel * 0.9).rgb;
		 sum += GetColorTexture(texcoord.st + vec2(0.5, 0.5) * texel * 0.9).rgb;
		 sum += GetColorTexture(texcoord.st + vec2(-0.5, 0.5) * texel * 0.9).rgb;
		 sum += GetColorTexture(texcoord.st + vec2(-0.5, -0.5) * texel * 0.9).rgb;

	vec3 sum2 = GetColorTexture(texcoord.st + vec2(0.5, -0.5) * texel * 1.9).rgb;
		 sum2 += GetColorTexture(texcoord.st + vec2(0.5, 0.5) * texel * 1.9).rgb;
		 sum2 += GetColorTexture(texcoord.st + vec2(-0.5, 0.5) * texel * 1.9).rgb;
		 sum2 += GetColorTexture(texcoord.st + vec2(-0.5, -0.5) * texel * 1.9).rgb;

	color += sum * 0.1 * 0.75;
	color += sum2 * 0.05 * 0.75;
	*/

	vec3 bloom = vec3(0.0);
	float allWeights = 0.0f;

	for (int i = 0; i < 4; i++) 
	{
		for (int j = 0; j < 4; j++) 
		{
			float weight = 1.0f - distance(vec2(i, j), vec2(2.5f)) / 2.5;
				  weight = clamp(weight, 0.0f, 1.0f);
				  weight = 1.0f - cos(weight * 3.1415 / 2.0f);
				  weight = pow(weight, 2.0f);
			vec2 coord = vec2(i - 2.5, j - 2.5);
				 coord.x /= viewWidth;
				 coord.y /= viewHeight;
				 //coord *= 0.0f;

				 //coord.x -= 0.5f / viewWidth;
				 //coord.y -= 0.5f / viewHeight;

			vec2 finalCoord = (uv.st + coord.st * 1.0);

			if (weight > 0.0f)
			{
				bloom += pow(clamp(texture2DLod(gaux3, finalCoord, 0).rgb, vec3(0.0f), vec3(1.0f)), vec3(2.2f)) * weight;
				allWeights += 1.0f * weight;
			}
		}
	}
	bloom /= allWeights;

	color = mix(color, bloom, vec3(0.35));
}

void 	Vignette1(inout vec3 color) {
	float dist = distance(texcoord.st, vec2(0.5f));
		  dist /= 1.6f;

	color.rgb *= 1.0f - dist;

}

void 	Vignette2(inout vec3 color) {
	float dist = distance(texcoord.st, vec2(0.5f)) * 2.0f;
		  //dist /= 1.5142f;

		  //dist = pow(dist, 1.1f);

	color.rgb *= 1.0f - dist * 0.5;

}

void 	Vignette3(inout vec3 color) {
	float dist = distance(texcoord.st, vec2(0.5f)) * 2.0f;
		  dist /= 1.5142f;

		  //dist = pow(dist, 1.1f);

	color.rgb *= 1.0f - dist * 1.0;

}

void DoNightEye(inout vec3 color)
{
	float lum = Luminance(color * vec3(1.0, 1.0, 1.0));
	float mixSize = 1250000.0;
	float mixFactor = 0.01 / (pow(lum * mixSize, 2.0) + 0.01);


	vec3 nightColor = mix(color, vec3(lum), vec3(0.95)) * vec3(0.8, 0.85, 1.0) * 200.0;

	color = mix(color, nightColor, mixFactor);
}

void Overlay(inout vec3 color, vec3 overlayColor)
{
	vec3 overlay = vec3(0.0);

	for (int i = 0; i < 3; i++)
	{
		if (color[i] > 0.5)
		{
			float valueUnit = (1.0 - color[i]) / 0.5;
			float minValue = color[i] - (1.0 - color[i]);
			overlay[i] = (overlayColor[i] * valueUnit) + minValue;
		}
		else
		{
			float valueUnit = color[i] / 0.5;
			overlay[i] = overlayColor[i] * valueUnit;
		}
	}

	color = overlay;
}

vec2 GetNearFragment(vec2 coord, float depth, out float minDepth)
{

	vec2 texel = 1.0 / vec2(viewWidth, viewHeight);

	float step = 2.0;

	vec4 depthSamples;
	depthSamples.x = texture2D(gdepthtex, coord + texel * vec2(step, step)).x;
	depthSamples.y = texture2D(gdepthtex, coord + texel * vec2(step, -step)).x;
	depthSamples.z = texture2D(gdepthtex, coord + texel * vec2(-step, step)).x;
	depthSamples.w = texture2D(gdepthtex, coord + texel * vec2(-step, -step)).x;

	vec2 targetFragment = vec2(0.0, 0.0);

	if (depthSamples.x < depth)
		targetFragment = vec2(step, step);
	if (depthSamples.y < depth)
		targetFragment = vec2(step, -step);
	if (depthSamples.z < depth)
		targetFragment = vec2(-step, step);
	if (depthSamples.w < depth)
		targetFragment = vec2(-step, -step);


	minDepth = min(min(min(depthSamples.x, depthSamples.y), depthSamples.z), depthSamples.w);

	return coord + texel * targetFragment;
}

vec3 LogContrast(const vec3 x, const float contrast) {
	const float contrastEpsilon = 1e-5;
	const float logMidpoint = log2(0.18);

	vec3 logX = log2(x + contrastEpsilon);
	vec3 adjX = (logX - logMidpoint) * contrast + logMidpoint;

	return max(exp2(adjX) - contrastEpsilon, vec3(0.0));
}

vec3 Vibrance(const vec3 color, float vibrance) {
	float maxColor = max(color.r, max(color.g, color.b));
	float minColor = min(color.r, min(color.g, color.b));

	float colorSaturation = maxColor - minColor;

	return mix(vec3(length(color)), vec3(color), 1.0 + vibrance * (1.0 - sign(vibrance) * colorSaturation));
}

#include "lib/FilmicTonemap.glsl"

#include "lib/fullACES.glsl"
vec3 ACESTonemap(vec3 color)
{
  //color = FilmicTonemap(color);
    color = sRGB_to_ACES(color);
    color = LMT(color);
    color = RRT(color);
    color = ODT_pre(color); 
    color = ODT_Rec709_100nits_dim(color);	
	color = pow(color, vec3(2.2));
  return color;
}
/////////////////////////MAIN//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////MAIN//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void main() {		
	float dist = distance(texcoord.st, vec2(0.5f)) * 1.0f;
    vec2 dither = vec2(BlueNoise(texcoord.st) * 1.0f - 0.5f);
    const float n1 = 1.0;   
	float linDepth = ExpToLinearDepth(texture2D(gdepthtex, texcoord.st).x);	
	vec2 coord = (floor(texcoord.st * vec2(viewWidth, viewHeight) * n1) + 0.5) / (vec2(viewWidth, viewHeight) * n1);	
	
	
	vec3 sampleB = DoFXAASimple(gaux3, coord.st + vec2( 0, -1) / vec2(viewWidth, viewHeight), 1.0 / vec2(viewWidth, viewHeight)).rgb;
	vec3 sampleD = DoFXAASimple(gaux3, coord.st + vec2(-1,  0) / vec2(viewWidth, viewHeight), 1.0 / vec2(viewWidth, viewHeight)).rgb;
	vec3 sampleE = DoFXAASimple(gaux3, coord.st + vec2( 0,  0) / vec2(viewWidth, viewHeight), 1.0 / vec2(viewWidth, viewHeight)).rgb;	
	vec3 sampleF = DoFXAASimple(gaux3, coord.st + vec2( 1,  0) / vec2(viewWidth, viewHeight), 1.0 / vec2(viewWidth, viewHeight)).rgb;
	vec3 sampleH = DoFXAASimple(gaux3, coord.st + vec2( 0,  1) / vec2(viewWidth, viewHeight), 1.0 / vec2(viewWidth, viewHeight)).rgb;
	float lumB = Luminance(sampleB);
	float lumD = Luminance(sampleD);
	float lumE = Luminance(sampleE);
	float lumF = Luminance(sampleF);
	float lumH = Luminance(sampleH);	
	float minCross = min(lumB, min(lumD, min(lumE, min(lumF, lumH))));
	float maxCross = max(lumB, max(lumD, max(lumE, max(lumF, lumH))));

	float weight = sqrt(saturate(min(minCross, 2.0 - maxCross) / maxCross)) * (-0.1 - 0.12 * (0.1 + 0.2 * SHARPENING));	
	
	float noise = lumB * 0.25 + lumD * 0.25 + lumF * 0.25 + lumH * 0.25 - lumE;
	noise = saturate(abs(noise) / (maxCross - minCross));
	weight *= 1.0 - 0.5 * noise;	
	
	vec3 sharpen = (sampleB * weight + sampleD * weight + sampleF * weight + sampleH * weight + sampleE) / (1.0 + 4.0 * weight);
	vec3 color = sharpen;   	
 	//vec3 color = texture2DLod(gaux3, coord.st, 0).rgb; 	
	//vec3 color = DoFXAASimple(gaux3, coord.st, 1.0 / vec2(viewWidth, viewHeight)).rgb;
	vec3 colorEdge = vec3(0.0);	
	vec2 texel = 1.0 / vec2(viewWidth, viewHeight);
	//if(texcoord.s > 0.5){
	//    colorEdge += DoFXAASimple(gaux3, coord.st + vec2( texel.x,  texel.y), 1.0 / vec2(viewWidth, viewHeight)).rgb;
	//    colorEdge += DoFXAASimple(gaux3, coord.st + vec2( texel.x, -texel.y), 1.0 / vec2(viewWidth, viewHeight)).rgb;
	//   colorEdge += DoFXAASimple(gaux3, coord.st + vec2(-texel.x,  texel.y), 1.0 / vec2(viewWidth, viewHeight)).rgb;
	//    colorEdge += DoFXAASimple(gaux3, coord.st + vec2(-texel.x, -texel.y), 1.0 / vec2(viewWidth, viewHeight)).rgb;		
	//}else{
	//    texel *= 1.0;
	    colorEdge += texture2DLod(gaux3, coord.st + vec2( texel.x,  texel.y), 0.0).rgb;
	    colorEdge += texture2DLod(gaux3, coord.st + vec2( texel.x, -texel.y), 0.0).rgb;
	    colorEdge += texture2DLod(gaux3, coord.st + vec2(-texel.x,  texel.y), 0.0).rgb;
	    colorEdge += texture2DLod(gaux3, coord.st + vec2(-texel.x, -texel.y), 0.0).rgb;	
	//}
	    colorEdge /= 4.0;    
	    colorEdge -= color;
		
	    //color -= SHARPENING * colorEdge;
		//    color = texture2DLod(gaux3, coord.st, 1).rgb;	
		
    float atb = (1.0 - exp(-linDepth * 0.01));
	atb *= wetness * pow(saturate(eyeBrightnessSmooth.y / 240.0f * 1.2 - 0.2), 6.0f);
	atb *= saturate(1.0 - isEyeInWater);
    atb = saturate(atb);

	/*
	vec2 texel = 1.0 / vec2(viewWidth, viewHeight);
	float angle = BlueNoise(texcoord.st) * PI * 2.0;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));	
	
	vec3 cs = (DoFXAASimple(gaux3, coord.st + vec2( texel.x,  texel.y)
	* rot
	, 1.0 / vec2(viewWidth, viewHeight)).rgb);
	cs += 	(DoFXAASimple(gaux3, coord.st + vec2( texel.x, -texel.y)
	* rot
	, 1.0 / vec2(viewWidth, viewHeight)).rgb);
	cs += 	(DoFXAASimple(gaux3, coord.st + vec2(-texel.x,  texel.y)
	* rot
	, 1.0 / vec2(viewWidth, viewHeight)).rgb);
	cs += 	(DoFXAASimple(gaux3, coord.st + vec2(-texel.x, -texel.y)
	* rot
	, 1.0 / vec2(viewWidth, viewHeight)).rgb);	
	cs -= color;
	cs /= 3.0;

	float hcc = mix(1.0, 0.1, exp(-Luminance(color)));
		hcc = 0.25;
		hcc = 1.0
		 * pow(Luminance(color), hcc)
		;

	color += clamp(dot(color - cs, vec3(.3333333)), -4e-3, 4e-3) * SHARPENING * hcc * normalize(color.rgb + 1e-9); 
	
	//color = mix(color, GetBloom(coord.st), saturate(BLOOM_AMOUNT * 0.2 + (1.0 - exp(-linDepth * 0.1)) * (0.0 * wetness * pow(saturate(eyeBrightnessSmooth.y / 240.0f * 1.2 - 0.2), 6.0f) * saturate(1.0 - isEyeInWater) + isEyeInWater * 0.7)));			
	//color = mix(color, GetBloom(coord.st), pow(GetBloom(coord.st) * 5.0 / (1.0 + GetBloom(coord.st) * 5.0), vec3(0.3 - isEyeInWater * 0.2)));		
	*/
	vec3 bloom = GammaToLinear(GetBloom(coord.st));
    //color = mix(GammaToLinear(color), bloom, saturate(length(pow(bloom / (bloom * BLOOM_AMOUNT * 110.0 + 1.0) * BLOOM_AMOUNT * 110.0))));		
	//color += pow(GetBloom(coord.st), vec3(2.0)) * 1.0;						
 	//color = GammaToLinear(color); 	
	//color *= mat3(0.99999976, -1.26657e-7, -1.29064e-9, 1.67316e-8, 0.99999976, -5.32026e-9, -0.00725587, 6.47740e-9, 1.00725580);   
	
    color = GammaToLinear(color);	
	color = BlackDepth(color, vec3(0.000015 * BLACK_DEPTH * BLACK_DEPTH));
		
#ifdef MICRO_BLOOM
	MicroBloom(color, coord);
#endif

    vec3 len = GammaToLinear(texture2DLod(gaux3, curve(coord.st), dist * 4.0 + 2.0).rgb) * vec3(1.0, 0.5, 0.0) + GammaToLinear(texture2DLod(gaux3, curve(curve(coord.st)), dist * 4.0 + 2.0).rgb) * vec3(0.0, 0.5, 1.0);
	len /= 2.0;
	
    //color = mix(color, len, vec3(3e-3));
	
	Vignette1(color);
	
	const float Gstart = 5e-7;
	float colCh = exp(-length(color / (Gstart * 2.0)));
	vec3 BJH = mix(vec3(1.0), vec3(1.0, 2.0, 16.0) / 16.0, vec3(colCh)); 
	color = length(color) * normalize(color * BJH + colCh * 0.000001);
	//bloom = length(bloom) * normalize(bloom * BJH + colCh * 0.000001);
	color += (rand(texcoord.st + sin(frameTimeCounter) * 0.1) * 2.0 - 1.0) * Gstart;	
	color = max(vec3(0.0), color);
	///*
	#ifdef TAA_ENABLED	
	//if(texcoord.s < 0.5)
	AverageExposure(color); 
	AverageExposure(bloom); 	
	#else 
	//if(texcoord.s > 0.5) 
	AverageExposure2(color);	
	AverageExposure2(bloom);
	#endif
	color /= 100.0;	 
	bloom /= 100.0;
    //*/	
	color *= 1200.0 * EXPOSURE;	 
	bloom *= 1200.0 * EXPOSURE;
	
	//color = mix(color, bloom, saturate( + isEyeInWater * 0.6 + atb * 0.8));		
	color = mix(color, bloom, saturate(pow(bloom * 0.01 / (bloom * 0.01 * BLOOM_AMOUNT + 0.7) * BLOOM_AMOUNT, vec3(1.0))+ isEyeInWater * 0.6 + atb * 0.) * 1.0);	

	
#ifdef HDR
	//color *= 0.5;	
#endif

    vec3 x = color;
	#ifdef TAA_ENABLED
	float avgLum = texture2DLod(gaux4, vec2(0.0, 0.0), 0).a * 0.01;
	float avgL = avgLum * 23.9 + 0.0001;
	#else 
	float avglod = int(log2(min(viewWidth, viewHeight))) - 0.0;
	float avgL = pow(Luminance(texture2DLod(gaux3, vec2(0.65, 0.65), avglod).rgb), 1.96) * 23.9 + 0.0001;
	#endif
	//color = pow(color, vec3(1.0 * saturate(avgL)));		
	//color = color * coneOverlap;	
	//color = color * ACESInputMat;
    //color = FilmicTonemap(color);

	color = TONEMAP_OPERATOR(color);
	
	/*
	if(texcoord.s > 0.5)
	{
	    //color = LANDTonemap(color);
	    //color = DAVTonemap(color);		
		//color = ACESTonemap2(color / 1.39);
		color = AgxTonemap(color);		
		color = ACESTonemap(color);
		color /= ACESTonemap(vec3(1.0)) * AgxTonemap(vec3(1.0)) * 1.4;		
	}
	else
	{
	    color = ACESTonemap(color);	
	}
	*/
	
    /*  
	//if(texcoord.s > 0.5)
	{
	const float a = 0.3;
	float l = a * a * (3.0 - 2.0 * a);
	vec3 c = color * (1.0 - a) + a;
	color = c * c * (3.0 - 2.0 * c);
	color -= l;
	color /= 1.0 - l;
	color = max(vec3(0.0), color);
    color = mix(color, color * color * (3.0 - 2.0 * color), vec3(0.2));	
	}
    */
	//color *= coneOverlapInverse;
    //color = color * ACESOutputMat;	

	//if(length(color.r)
	//+length(color.g)
	//+length(color.b)	
	//> 3.0) color = vec3(.0,1.0,.0);
	
	color = saturate(color);	


	
	//color = TransformOutputColor(color);	 
	
	
	
	color = pow(length(color), 1.0 / LUMA_GAMMA) * normalize(color + 1e-9);
	color = saturate(color * (1.0 + WHITE_CLIP));
	color = pow(color, vec3(1.0 / 2.2));
	color = pow(color, vec3((1.0 / GAMMA)));
	color = mix(color, vec3(Luminance(color)), vec3(1.0 - SATURATION));
	color = Vibrance(color, VibranceC - 1.0);	
	//if(texcoord.s > 0.5) color = LogContrast(color, 1.0);
	//color += (rand(coord.st + sin(frameCounter)) - 0.95) * 3.0 / 225.0f;

	gl_FragColor = vec4(color.rgb, Luminance(color));

}
