const float GTAO_QUALITY = 4.0;
const float GTAO_SLICE_QUALITY = 4.0;

float remapSaturate(float x, float e0, float e1){
	return saturate((x - e0) / (e1 - e0));
}

float GroundTruthBasedAmbientOcclusion(vec3 viewPos, vec3 viewDir, vec3 normal, vec2 coord){
	//vec2 noise = vec2(BlueNoise();
	vec2 noise = rand(texcoord.st).xy;
	const float steps = GTAO_QUALITY;
	const float rSteps = 1.0 / steps;

	const float sliceSteps = GTAO_SLICE_QUALITY;
	const float rSliceSteps = 1.0 / sliceSteps;		



	const float falloffStart = 0.16;
	const float maxSampleRadius = 4.0;	
	
    const float falloffZoffset = 1.7;
    //const float falloffZoffset = 0.001;
	
	float projFactor = 0.125 * gbufferProjection[1][1];	
	float radius = 2.0 - viewPos.z * 0.01;
	
	//radius *= 0.1;
	
	float sampleRadiusRaw = radius * projFactor / -viewPos.z;
	float sampleRadius = min(sampleRadiusRaw, maxSampleRadius);
	float falloff = sampleRadius * radius / sampleRadiusRaw;	
	
	float ao = 0.0;

	for (float i = 0.0; i < steps; i++){
		float sliceAngle = (i + noise.x) * rSteps * PI;
		vec3 sliceDir = vec3(cos(sliceAngle), sin(sliceAngle), 0.0);
		vec3 orthoSliceDir = sliceDir - dot(sliceDir, viewDir) * viewDir;
		vec3 axis = cross(sliceDir, viewDir);
		vec3 projNormal = normal - dot(normal, axis) * axis;
		float rProjNormalLength = inversesqrt(dot(projNormal, projNormal));
		float cosNormalAngle = saturate(dot(projNormal, viewDir) * rProjNormalLength);
		float normalAngle = sign(dot(orthoSliceDir, projNormal)) * acos(cosNormalAngle);

		vec2 minCosHorizonAngle = cos(vec2(normalAngle + HPI, normalAngle - HPI));		
		vec2 maxCosHorizonAngle = minCosHorizonAngle;
	
	
		for (float j = 0.0; j < sliceSteps; j++){
			float stepNoise = (i + j * sliceSteps) * 0.61803399;
			stepNoise = fract(stepNoise + noise.y);

			float offset = (j + stepNoise) * rSliceSteps;
			offset *= offset;
			vec2 sampleOffset = offset * sliceDir.xy * sampleRadius;
			sampleOffset.y *= 1.5;

			{
				vec2 sampleCoord = coord.st + sampleOffset;
				float sampleDepth = textureLod(depthtex1, sampleCoord, 0.0).x;

				vec3 sampleVector = (GetScreenSpacePosition(sampleCoord, sampleDepth) - vec4(viewPos, 0.0)).xyz;

				float rSampleDist = inversesqrt(dot(sampleVector, sampleVector));

			    float cosHorizonAngle = dot(sampleVector, viewDir) * rSampleDist;

					float offsetDist = length(vec3(sampleVector.xy, sampleVector.z * falloffZoffset));
					float falloffWeight = remapSaturate(offsetDist, falloff * falloffStart, falloff);

				cosHorizonAngle = mix(cosHorizonAngle, minCosHorizonAngle.x, falloffWeight);

				maxCosHorizonAngle.x = max(cosHorizonAngle, maxCosHorizonAngle.x);
			}{
				vec2 sampleCoord = coord.st - sampleOffset;
				float sampleDepth = textureLod(depthtex1, sampleCoord, 0.0).x;

				vec3 sampleVector = (GetScreenSpacePosition(sampleCoord, sampleDepth) - vec4(viewPos, 0.0)).xyz;


				float rSampleDist = inversesqrt(dot(sampleVector, sampleVector));

				float cosHorizonAngle = dot(sampleVector, viewDir) * rSampleDist;
				
					float offsetDist = length(vec3(sampleVector.xy, sampleVector.z * falloffZoffset));
					float falloffWeight = remapSaturate(offsetDist, falloff * falloffStart, falloff);
			
			    cosHorizonAngle = mix(cosHorizonAngle, minCosHorizonAngle.y, falloffWeight);

				maxCosHorizonAngle.y = max(cosHorizonAngle, maxCosHorizonAngle.y);
			}
		}
		maxCosHorizonAngle = vec2(-acos(maxCosHorizonAngle.y), acos(maxCosHorizonAngle.x)) * 2.0;

		float horizonAngleIntegra = 2.0 * cosNormalAngle + (maxCosHorizonAngle.x + maxCosHorizonAngle.y) * sin(normalAngle) - cos(maxCosHorizonAngle.x - normalAngle) - cos(maxCosHorizonAngle.y - normalAngle);

		ao += horizonAngleIntegra / rProjNormalLength;
	}
	ao *= 0.25 * rSteps;
	return saturate(mix(1.0, ao, 0.95));
	
//return 1.0;
}

vec3 GTAOMultiBounce(float ao, vec3 albedo){
	vec3 a =  2.0404 * albedo - 0.3324;
	vec3 b = -4.7951 * albedo + 0.6417;
	vec3 c =  2.7552 * albedo + 0.6903;

	return max(vec3(ao), ((ao * a + b) * ao + c) * ao);
}