
float GetCN(vec3 wp, bool forCL, float lr, float Detail, float cloudHeight, float cloudDepth, int co)
{		
	float t = frameTimeCounter * VOLUMETRIC_CLOUD_SPEED * C_S_W;		
	float lC = 1.0f;
	

	float Hc = saturate((wp.y-cloudHeight)/(cloudDepth));	
    //float Hc2 = Hc * Hc;
	const float DS1 = 5.0;
	const float DS2 = 5.0;

	const float DSa = 5.0;
	const float DSb = 2.0;

	const float DSj = 1.0;
	      float DSi = 3.0 - wetness * 2.0;	
	//float HchitDen = (Hc - (Hc2 * 1.3 - 0.3)) / 0.492;
	//float Hchit = (Hc - Hc2) / 0.3 * Hc;	
	//float FHchit = Hc * 0.0 + Hchit * 0.5;		
	float Hcf = saturate(1.-Hc); 
	
	float HA = (Hc * DS1 / (1.0 + Hc * DS1)) * (Hcf * DS2 / (1.0 + Hcf * DS2)) / ((0.5 * DS1 / (1.0 + 0.5 * DS1)) * (0.5 * DS2 / (1.0 + 0.5 * DS2))); 
	float HA2 = (Hc * DSa / (1.0 + Hc * DSa)) * (Hcf * DSb / (1.0 + Hcf * DSb)) / ((0.5 * DSa / (1.0 + 0.5 * DSa)) * (0.5 * DSb / (1.0 + 0.5 * DSb))); 	
	float HA3 = (Hc * DSj / (1.0 + Hc * DSj)) * (Hcf * DSi / (1.0 + Hcf * DSi)) / ((0.5 * DSj / (1.0 + 0.5 * DSj)) * (0.5 * DSi / (1.0 + 0.5 * DSi))); 
	HA = saturate(HA);
	HA2 = saturate(HA2);
	HA3 = saturate(HA3);	
	
	wp -= 600.0 * vec3(1.0, 0.0, 0.0) * Hc * C_S_W * airflow_Strength;		
	vec3 p = wp.xyz * 0.00045 / C_S_W;  	
	
	#ifdef CLC
	  lC = texture2D(noisetex, (wp.xz + t * vec2(2000.0, 0.0)) /C_S_W * 0.0000013 + 0.5).g;
	  lC = mix(saturate(lC * 3.0 - 0.75), 1.0, saturate(0.5 + wetness * 0.4));
	  //lC *= saturate(texture2D(noisetex, (wp.xz + vec2(t * 3.0,.0f)/6e-5*VOLUMETRIC_CLOUD_SPEED)*14e-7/C_S_W).x * 3.-.75)*.5+.5;  
	  if (lC < 0.02)
	  {
	    return 0.0f;
	  } 
	#endif	

	float octScale = 3.0;	
    float G = 1.0;	
    float T = 1.0;	
	
	    p.xz += saturate(Hc * 2.4 - 1.0) * vec2(0.3, 0.3) * upprtairflow_Strength * C_S_W;
		
 	//float largernoise = Get3DPWNoise(vec3(p.x, p.y + p.z * 0.0 + p.x * 0.0, p.z) * vec3(2.5, 3.5, 2.5) + t * vec3(0.0, -20.0, 0.0));			
	//float largernoise = saturate(Get3DPWNoise(p * vec3(3.0, 2.0, 3.0) + t * vec3(0.0, -2.0, 0.0)) * 1.5 - 0.5);	
	float largernoise = 1.0;	
	//if(texcoord.s>0.5) largernoise = 1.0;		
	
	float topwindshape = 0.0;
	if(wetness > 0.0) topwindshape = saturate(Get2DNoise(p * 0.3) * 2.5 - 0.8);	
	
	//float topwindshape = (0.0 + Get3DNoise(p * 2.0) * 1.3 + Get3DNoise(p * 6.0) * VC_R);
	
		p -= t * vec3(1.0, 0.0, 0.0);	
	
	    //p.xz -= saturate(Hc * Hc * 1.2 - 0.5) * vec2(0.2, 0.1) * topwindshape; 		

	//co = 5;	
	//co = int(floor(abs(sin(frameTimeCounter * 2.0)) * 10.0));
			
    #ifdef PWNOISE
	    float noise = mix(Get3DPWNoise(p - t * vec3(0.4, 0.0, 0.0)), 1.0, saturate(0.0 + wetness * 0.48));	
	#else
	   float noise = mix(Get3DNoise3(p - t * vec3(0.4, 0.0, 0.0)), 1.0, saturate(0.0 + wetness * 0.48));
	#endif
	
	//p += noise * 10.0 * Micro_airflow_Strength;
	
	for (int j = 1; j < co; ++j)
    {	  
		//p = (p + t * vec3(0.2, 0.0, 0.0)) * octScale;	
		p *= octScale;				
		G *= VC_R * lr;	
		#ifdef PWNOISE
	        noise += Get3DPWNoise(p)*G; 	
	    #else
	        noise += Get3DNoise3(p)*G; 
	    #endif
		T += G;	
    } 		 
	    noise += 0.5 - T * 0.532;
		noise += Detail;
        noise = noise * (1.0 + Hc * largernoise * HCCURVE) - Hc * largernoise * HCCURVE;	
        noise *= Vol_Cloud_Coverage * lC * (1.0 + saturate(Hc * Hc * 1.2 - 0.5) * 0.3 * topwindshape * wetness); 	
	    //noise *= Vol_Cloud_Coverage * (1.0 + wetness * (0.1 + saturate(Hc * Hc * 1.2 - 0.5) * 1.2)) * (1.0 - HA3 * 0.3 * (1.0 - wetness * 0.15)) * lC; 		
		noise = HA * (noise - 0.9) - 0.1; 
		
		//noise = HA * (2.0 * lC - 0.9) - 0.1; 	
		
	//if(texcoord.s>0.5)noise = (1.0 - saturate(lC * 3.0 - 0.75));
	
	if(forCL){
	  noise *= Density_Curve_C;
	}
	
 	if (noise < 0.0001f){
	  return 0.0;
	}	
	
	return saturate(noise);	
}
//summon as @e[type=bat] at @s run summon arrow ~ ~ ~
//summon as @e[type=snowball] at @s run summon bat ~ ~1 ~

//scoreboard players add @e[type=snowball] 雪球 1
//execute as @e[type=snowball,scores={雪球=3..}] at run damage @e[r=2,type=snowball,c=1] 10 contact entity @s

//execute at @e[type=snowball,scores={雪球=3..}] as @e[r=2,type=!snowball] run damage @e 2

float CalculatePowderEffect(float od){
    return 1.0 - exp(-od * 2.0);
}

float CalculatePowderEffect(float powder, float vDotL){
    return mix(powder, 1.0, pow(vDotL * 0.5 + 0.5, 1.0));
}

float TraceRayVC(vec3 pos, vec3 pos2, vec3 lightDir, vec3 worldDir, float Detail, float cloudDensity, float cloudDist, vec3 worldLightVector, float RDMap)
{
    float dist = length(pos - cameraPosition) * 0.0002;
	float shadowFactor = 0.0;
	const int LQnum = 0;
	float dither = BlueNoise(texcoord.st + 0.111) - 0.5;	
	float r = 1.0;
	float LdotV = dot(-worldDir, -worldLightVector);		
	lightDir = lightDir - worldDir / abs(worldDir.y) * timeNoon;		
	for (int i = 1; i <= LQnum; i++)
	{
	    float fi = exp2(float(i) + dither);
		vec3 spos = pos + 100.0 * lightDir * fi;
		float d = GetCN(spos, true, r, 0.0f, Cloud3Height, Cloud3thick, 0);
		shadowFactor += d * 100.0 * fi;		
	}
	return shadowFactor;
}

float TraceShadowVC(vec3 pos, vec3 pos2, vec3 lightDir, vec3 worldDir, float Detail, float cloudDensity, float cloudDist, vec3 worldLightVector, float RDMap)
{
	//float LdotV = dot(worldDir, -worldLightVector);
	//float sundiff = TraceRayVC(pos, pos2, lightDir, worldDir, 0.0f, 1.0f, 0.0f, worldLightVector, 0.0);		 
	//float Order = exp(-sundiff * 80.0);
    //float dist = length(pos - cameraPosition) * 0.0002;
		 //dist = 1.0 / (1.0 + dist);	
		 //Order = mix(1.0, Order, dist);
	return 1.0f;
}

float GetSNGIWay(vec3 wp, vec3 l, vec3 wd, float ch, float cd, float Detail, int co)
{
        vec3 lv = vec3(-l.x, -l.y, -l.z);
	    float se = 0.0;
	    float r = 1.0;					
		int q = 0;
        #ifdef C_GI	
            q = 4;
		#endif		
		float spread = 0.0;
		float dither = 0.0f;	
		#ifdef TAA_ENABLED
		  dither = BlueNoiseTemporal(texcoord.st+frameTimeCounter*1e-3).x - 0.5;			
		#else
	      dither = CalculateNoisePattern1(vec2(0.566483f), 4).b * 2.5 - 1.25;	
		#endif	
	    for (int i = 1; i <= q; ++i)
	    {	
    		if(wp.y > ch + cd || wp.y < ch) break;	  
            float fi = pow(1.5, float(i)+dither);  
			wp -= l * fi * 200.0 * C_S_W;					
		    //float densityCheck = saturate(GetCN(wp, true, r, 0.4 * spread,ch,cd, co));
		    float densityCheck = saturate(GetCN(wp, true, r, spread,ch,cd, max(co - 1, 0)));			
		           se += densityCheck * fi * 200.0;		
                   spread += fi * 5e-2;				   
		           //r *= exp2(-L_R_S * fi / float(q) * L_L * 1e-1);
	    }
		
        //se -= 2.0;
		//se /= 100.0;
		//float distancediff = pow(max(se - 50.0, 0.0f) * 2e-4 + 1.0f, -2.0);
	    float distancediff = exp2(-max(se - 50.0, 0.0) * 0.01);
		se = 1.0 * distancediff * saturate(se - 50.0);
		//se = max(1.0 - se, 0.0f);			
	    //se = 1.0 - se;
		//se *= distancediff;
	return se;
}

float GetSNGIHit(vec3 wp, vec3 l, vec3 wd, float ch, float cd, float Detail, int co)
{
        float Density = 2.0 * saturate((wp.y - ch) / cd) + 0.1;

	    float se = 0.0;
	    float r = 1.0;			
		int q = 0;
        #ifdef C_GI	
            q = 2;
		#endif					
		vec3 dither = vec3(0.0f);	
		#ifdef TAA_ENABLED
		  dither = vec3(BlueNoise(texcoord.st+2.0 / vec2(viewWidth, viewHeight)) - 0.5,
		  BlueNoise(texcoord.st+4.0 / vec2(viewWidth, viewHeight)) - 0.5,
          BlueNoise(texcoord.st+16.0 / vec2(viewWidth, viewHeight)) - 0.5		  
		  );		
	      //dither = CalculateNoisePattern1(vec2(0.566483f), 4).b * 2.5 - 1.25;		  
		#else
	      dither = CalculateNoisePattern1(vec2(0.566483f), 4).rgb * 2.5 - 1.25;	
		#endif		  			     
		vec3 lv = vec3(-l.x, -l.y, -l.z) + dither * 2.0;
	    for (int i = 1; i <= q; ++i)
	    {	
    		if(wp.y > ch + cd || wp.y < ch) break;	   
            float fi = pow(2.0, float(i));  
			wp += lv * fi * 20.0 * C_S_W;					
		    float densityCheck = GetCN(wp, true, r, 0.0f, ch, cd, co);
		           se += densityCheck * fi * 20.0;				
		        //r *= exp2(-L_R_S * fi / float(q) * 25.0);
				co = 0;
	    }
	return se;
}

float GetSNScatterway(vec3 wp, vec3 l, vec3 wd, float ch, float cd, float Detail, int co, float sEcheck)
{
        float Density = 2.0 * saturate((wp.y - ch) / cd) + 0.1;	
	    float se = 0.0;
	    float r = 1.0;		
        float rl = L_L;		
		const int q = 0;				
		vec3 dither = vec3(0.0f);	
		#ifdef TAA_ENABLED
		  dither = vec3(BlueNoise(texcoord.st+2.0 / vec2(viewWidth, viewHeight)) - 0.5,
		  BlueNoise(texcoord.st+4.0 / vec2(viewWidth, viewHeight)) - 0.5,
          BlueNoise(texcoord.st+16.0 / vec2(viewWidth, viewHeight)) - 0.5		  
		  );		
	      //dither = CalculateNoisePattern1(vec2(0.566483f), 4).b * 2.5 - 1.25;		  
		#else
	      dither = CalculateNoisePattern1(vec2(0.566483f), 4).rgb * 2.5 - 1.25;	
		#endif	

	    for (int i = 1; i <= q; ++i)
	    {	
    		if(wp.y > ch + cd || wp.y < ch) break;	    
            float fi = pow(1.6, float(i));  		

			wp += l * fi * rl * C_S_W;					
		    float densityCheck = GetCN(wp, true, r, 0.0f, ch, cd, co) * L_A_C / i * sEcheck;
		           se += densityCheck;
				   l += dither * se;
            //r *= exp2(-L_L * fi * 1e-3);   			
	    }
		
		//if(1.0 - se == 1.0){
		//   se = 0.0f;
		//}
		
		se = saturate(se * 1.0);
	return se;
}

float GetSNScatterwayDen(vec3 wp, vec3 l, vec3 wd, float ch, float cd, float Detail, int co)
{
        float Density = 2.0 * saturate((wp.y - ch) / cd) + 0.1;	
	    float se = 0.0;
	    float r = 1.0;		
        float rl = L_L;		
		const int q = 0;				
		vec3 dither = vec3(0.0f);	
		#ifdef TAA_ENABLED
		  dither = vec3(BlueNoise(texcoord.st+2.0 / vec2(viewWidth, viewHeight)) - 0.5,
		  BlueNoise(texcoord.st+4.0 / vec2(viewWidth, viewHeight)) - 0.5,
          BlueNoise(texcoord.st+16.0 / vec2(viewWidth, viewHeight)) - 0.5		  
		  );		
	      //dither = CalculateNoisePattern1(vec2(0.566483f), 4).b * 2.5 - 1.25;		  
		#else
	      dither = CalculateNoisePattern1(vec2(0.566483f), 4).rgb * 2.5 - 1.25;	
		#endif
        l += dither;		
	    for (int i = 1; i <= q; ++i)
	    {	
    		if(wp.y > ch + cd || wp.y < ch) break;	    
            float fi = pow(1.6, float(i));  		

			wp += l * fi * rl * C_S_W;					
		    float densityCheck = GetCN(wp, true, r, 0.0f, ch, cd, co) * L_A_C * fi;
		           se += densityCheck * rl;	
            //r *= exp2(-L_L * fi * 1e-3);   			
	    }
		
	return se;
}

float GetSNShadow(vec3 wp, vec3 l, vec3 wd, float ch, float cd, float Detail, int co, vec3 kernel)
{
	    float se = 0.0;
	    float r = 1.0;				
		const int q = L_Q;				
		vec3 dither = vec3(0.0f);	
		#ifdef TAA_ENABLED
		  dither = vec3(BlueNoise(texcoord.st+2.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5,
		  BlueNoise(texcoord.st+4.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5,
          BlueNoise(texcoord.st+16.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5		  
		  );				
	      //dither = CalculateNoisePattern1(vec2(0.0), 4 + sin(frameTimeCounter * 1.0) * 1.0f).rgb * 2.5 - 1.25;	  		  
		#else
	      dither = CalculateNoisePattern1(vec2(0.566483f), 4).rgb * 2.5 - 1.25;	
	      //dither = rand(texcoord.st).rgb - .5;			  
		#endif
		
		//if(texcoord.s > 0.5){
        //  dither = vec3(0.0);	
	    //}	
		//float densitytouchCheck = GetCN(wp, true, r, 0.0f, ch, cd, co);

	    for (int i = 1; i <= q; ++i)
	    {	
 
    		if(wp.y > ch + cd || wp.y < ch) break;	  
            float fi = exp2(float(i) - 1.0			
	        #ifdef D_L_D	
		      + dither.x
			#else 
		      //+ dither.x * saturate(float(i - 5))			
	        #endif		
			);  	
			//vec3 cwp = wp + dither * L_L * fi;
	   
			#ifdef RP_RS	
				#ifdef S_GI	
				
				#else
				    kernel = vec3(0.0);
                #endif	
		        vec3 lv = normalize(l) + kernel * ((se + 1.0)
				//+ L_L * 0.04 * (1.0 - min(float(i), 1.0))
				);
			#else 
			   	vec3 lv = l + kernel * D_L_S;
	        #endif	
		
			//lv.y = abs(lv.y);
			//#ifdef S_GI
			//   lv = l; 
	        //#endif	
			wp += lv * fi * L_L * C_S_W;  
           
		    #ifdef RP_RS	
		        float densityCheck = GetCN(wp, true, r, 0.0f, ch, cd, co) * L_A_C * L_L * fi;	
			#else 
			    float densityCheck = GetCN(wp, true, r, 0.0f, ch, cd, max(co - int(floor(max(fi - 1.0, 0.0) * L_L * 15e-3 * C_S_W * co)), 0)) * L_A_C * L_L * fi;	
	        #endif				

  			 se += densityCheck;
	    }
	return se;
}

/*
float GetSNShadow(vec3 wp, vec3 l, vec3 wd, float ch, float cd, float Detail, int co)
{
	    float dse = 0.0;
	    float ase = 0.0;		
	    float r = 1.0;				
		const int q = 0;				
		vec3 dither = vec3(0.0f);	
		#ifdef TAA_ENABLED	
	      dither = CalculateNoisePattern1(vec2(0.0), 64 + sin(frameTimeCounter * 2.0) * 0.001f).rgb * 1.0 - 0.5;		  
		#else
	      dither = CalculateNoisePattern1(vec2(0.566483f), 7).rgb * 1.0 - 0.5;	
		#endif	
        vec3 l2 = vec3(1.0, 0.0, 0.0);		
		l = vec3(1.0, 0.0, 0.0) + (dither + 0.0) * 0.0;
		float densitytouchCheck = GetCN(wp, true, r, 0.0f, ch, cd, co);
		vec3 SatterVector = l;
	
		vec3 wpd = wp;
		vec3 wpa = wp;
	    for (int i = 1; i <= q; ++i)
	    {	
    		if(wpd.y > ch + cd || wpd.y < ch) break;	  
            float fi = pow(1.6, float(i) - 1.0			
	        #ifdef D_L_D	
		      + dither.x
			  //+ mix(dither, 1.0, 1.0 / (float(i) + 1.0))
	        #endif		
			);  		
						
			wpd += l * fi * L_L * C_S_W;  
					    
		    float densityCheck = GetCN(wpd, true, r, 0.0f, ch, cd, co) * L_A_C * L_L;
            dse += densityCheck;			
	    }
		
	    for (int i = 1; i <= q; ++i)
	    {	
    		if(wpa.y > ch + cd || wpa.y < ch) break;	  
            float fi = pow(1.6, float(i) - 1.0			
	        #ifdef D_L_D	
		      + dither.x
			  //+ mix(dither, 1.0, 1.0 / (float(i) + 1.0))
	        #endif		
			);  		
						
			wpa += l2 * fi * L_L * C_S_W;
				    
		    float SatterDistance = GetCN(wpa, true, r, 0.0f, ch, cd, co) * L_A_C * L_L * (1.0 - exp(-dse));
			ase += SatterDistance;
            l2 += SatterDistance * dither;
			//if(se * densitytouchCheck > 0.0){
			//	l += dither * D_L_S * 2.0;
			//}
 			
	    }			
	return ase;
}
*/

float GetSkyN(vec3 wp, vec3 l, vec3 wd, float ch, float cd, float Detail, int co)
{      
    #ifdef LQ_S_L_S	 
	    return 0.0f;
	#else   
	    float se = 0.0;
	    float r = 1.0;
		const int q = L_Q;

	    float spread = 0.0;		
		vec3 dither = vec3(0.0f);	
		#ifdef TAA_ENABLED
		  dither = vec3(BlueNoise(texcoord.st+2.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5,
		  BlueNoise(texcoord.st+4.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5,
          BlueNoise(texcoord.st+16.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5		  
		  );		
	      //dither = CalculateNoisePattern1(vec2(0.566483f), 4).b * 2.5 - 1.25;		 
		  //dither = vec3(LDdither(texcoord.st / vec2(viewWidth, viewHeight) / 4e-5 + frameTimeCounter * 1e-4+2.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5,
		  //LDdither(texcoord.st / vec2(viewWidth, viewHeight) / 4e-5 + frameTimeCounter * 1e-4+4.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5,
		  //LDdither(texcoord.st / vec2(viewWidth, viewHeight) / 4e-5 + frameTimeCounter * 1e-4+8.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5)
		  //;		  
		#else
	      dither = CalculateNoisePattern1(vec2(0.566483f), 4).rgb * 2.5 - 1.25;	
		#endif	
		//vec3 lv = mix(l, vec3(0.0, 1.0, 0.0), saturate(l.y*100.0)) + dither * 2.0;
		vec3 lv = vec3(0.0, 1.0, 0.0) + dither * 2.0 * S_L_S;		
		
	    for (int j = 1; j <= q; ++j)
	    {
    		if(wp.y > ch + cd || wp.y < ch) break;	  		
		    float fi = exp2(float(j) - 1.0
	        #ifdef S_L_D	
		      + dither.x
			  //+ mix(dither, 1.0, 1.0 / (float(i) + 1.0))
	        #endif	
			);
			    
				wp += lv * fi * L_L * C_S_W;	
				
		    float densityCheck = GetCN(wp, true, r, 0.0f, ch, cd, co) * L_A_C;	
		    //float densityCheck = GetCN(wp, true, r, -spread, ch, cd, max(co - i + 1, 0)) * L_A_C;	
		    //float densityCheck = GetCN(wp, true, r, 0.0f, ch, cd, max(co - int(floor(max(fi - 1.0, 0.0) * L_L * D_L_S * 15e-3 * C_S_W * co)), 0)) * L_A_C;			
                //if(texcoord.s>0.5)
				//spread += fi * 0.01;		
		        se += densityCheck * fi;
                //r *= exp2(-L_L * L_R_S * fi * 200.0 * C_S_W); 				
	    }
        se *= L_L * 20.0;		
	    return se;
    #endif	
}

float GetGN(vec3 wp, vec3 l, vec3 wd, float ch, float cd, float Detail, int co)
{        
    #ifdef LQ_S_L_S	 
	    return 0.0f;
	#else		
	    float se = 0.0;
	    float r = 1.0;
		const int q = L_Q;
	
	    float spread = 0.0;		
		vec3 dither = vec3(0.0f);	
		#ifdef TAA_ENABLED
		  dither = vec3(BlueNoise(texcoord.st+2.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5,
		  BlueNoise(texcoord.st+4.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5,
          BlueNoise(texcoord.st+16.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5		  
		  );		
	      //dither = CalculateNoisePattern1(vec2(0.566483f), 4).b * 2.5 - 1.25;		  
		  //dither = vec3(LDdither(texcoord.st / vec2(viewWidth, viewHeight) / 4e-5 + frameTimeCounter * 1e-4+2.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5,
		  //LDdither(texcoord.st / vec2(viewWidth, viewHeight) / 4e-5 + frameTimeCounter * 1e-4+4.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5,
		  //LDdither(texcoord.st / vec2(viewWidth, viewHeight) / 4e-5 + frameTimeCounter * 1e-4+8.0 / vec2(viewWidth, viewHeight) + 0.111) - 0.5)
		  //;	
		#else
	      dither = CalculateNoisePattern1(vec2(0.566483f), 4).rgb * 2.5 - 1.25;	
		#endif	
		vec3 lv = vec3(0.0, -1.0, 0.0) + dither * 2.0;
		
	    for (int j = 1; j <= q; ++j)
	    {
    		if(wp.y > ch + cd || wp.y < ch) break;	  		
		    float fi = exp2(float(j) - 1.0
	        #ifdef G_GI_L_D	
		      + dither.x
			  //+ mix(dither, 1.0, 1.0 / (float(i) + 1.0))
	        #endif	
			);
			    
				wp += lv * fi * L_L * C_S_W;	
				
		    //float densityCheck = GetCN(wp, true, r, 0.0f, ch, cd, max(co - int(floor(max(fi - 1.0, 0.0) * L_L * D_L_S * 15e-3 * C_S_W * co)), 0)) * L_A_C;	
		    float densityCheck = GetCN(wp, true, r, -spread, ch, cd, co) * L_A_C;			
                //if(texcoord.s>0.5)
				//spread += fi * 0.002;		
		        se += densityCheck * fi;
                //r *= exp2(-L_L * L_R_S * fi * 200.0 * C_S_W); 					
	    }
	    return se;
    #endif	
}

float DirectDetail(vec3 worldDir, float dist, vec3 WindDir)
{	
    float pnoise = 0.0f;
	
	#ifdef C_D	
      vec3 pos = worldDir + WindDir;

	    pos += Get3DNoise3(worldDir*60.0)*.25*Micro_airflow_Strength*min(abs(worldDir.y),1.);	  
	    pos += Get3DNoise3(worldDir*30.0)*.5*Micro_airflow_Strength*min(abs(worldDir.y),1.);
	    pos += Get3DNoise3(worldDir*15.0)*Micro_airflow_Strength*min(abs(worldDir.y),1.);		
		
	  pnoise += (-0.5 + Get3DNoise3(pos * 80.0)) * 4e-1 / (1.0 + dist* 4e-1);			
	  pnoise += (-0.5 + Get3DNoise3(pos * 160.0)) * 2e-1 / (1.0 + dist* 2e-1);
		
	  pnoise += (-0.5 + Get3DNoise3(pos * 320.0)) * 1e-1 / (1.0 + dist* 1e-1);	
	  pnoise += (-0.5 + Get3DNoise3(pos * 640.0)) * 5e-2 / (1.0 + dist* 5e-2);	  

	  pnoise *= VC_R * dist * 4e-2 / (C_O_S + A_C_O_S + 1.0);
	  //pnoise += mix(9e-2 / (1.0 + C_Q), 0.0, exp(-dist * 4e-5));	  
	#endif	
	
	return pnoise;	
}		

const float llscale = 1.0;
vec4 CloudColor3(vec4 worldPosition, float sunglow, vec3 worldLightVector, vec3 worldDir, vec3 atmosphere, float cloudHeight, float cloudDepth, float eyeLength, vec3 viewDir)
{	
    float dist = length(worldPosition.xyz - cameraPosition) / C_S_W;
    float DirDensity = saturate(((worldPosition.xyz + normalize(worldLightVector + worldDir)).y - cloudHeight) / cloudDepth);	
    float Density = saturate((worldPosition.y - cloudHeight) / cloudDepth);
	float obDensity = 1.0 - Density;
	
	//worldPosition.xyz += Get3DNoise3(worldDir.xyz * 80.0) * vec3(1.0);
	
	//const float DSa = 0.1;
	//const float DSb = 0.1;
    //float trueDensity = saturate((Density * DSa / (1.0 + Density * DSa)) * (obDensity * DSb / (1.0 + obDensity * DSb)) / ((0.5 * DSa / (1.0 + 0.5 * DSa)) * (0.5 * DSb / (1.0 + 0.5 * DSb)))); 		
	//const float mixc = 2.0;
	//const float DSa = mixc;	
	//const float DSb = 1.0 / (1.0 - 1.0 / mixc);
	const float DSa = 1.0;
	const float DSb = 3.0;	
    float trueDensity = saturate(Density * DSa)
	//* saturate(obDensity * DSb)
	; 		
	
    const float AC = A_C_O_S;	
	int co = int(clamp(AC - floor(sqrt(dist) * 0.01), 0.0, AC)) + C_O_S;	
		float LdotV = dot(worldDir, worldLightVector);	
	    float LdotV2 = LdotV * LdotV;	
		float LdotV01 = LdotV * 0.5 + 0.5;	
		
		float LdotVo = dot(worldDir, -worldLightVector);	
	    float LdotVo2 = LdotVo * LdotVo;	
		float LdotVo01 = LdotVo * 0.5 + 0.5;	
		
	float Detail = 0.0f;
	float t = frameTimeCounter * VOLUMETRIC_CLOUD_SPEED;
	vec3 motion = vec3(-t,.0,.0);	
	vec3 ppos = worldDir;
		 Detail = DirectDetail(ppos, dist, motion);
		 
    float noise = GetCN(worldPosition.xyz, true, 1.0, Detail, cloudHeight, cloudDepth, co);

		 float Dirlength = length(Cloud3thick / C_Q * worldDir / abs(worldDir.y));

		 float sn = noise;
		 noise = mix(saturate(1.0 - exp(-noise * L_A_C * Dirlength)), 1.0, saturate(noise * 5.0 - 0.1));
		 
	 	 //if (texcoord.s > 0.5){
		 // noise = saturate(sn * 5.0 - 0.1);
		 //}		 
		 
		 //noise = mix(saturate(1.0 - exp2(-noise * rLOG2 * L_A_C * 1.0 * Dirlength)), 1.0, saturate((noise - 0.03) * noise * 1.0));	
		 //noise = saturate(noise * 100000.0);
		 
 		if (noise < 0.0001f){
		  return vec4(0.0f, 0.0f, 0.0f, 0.0f);
		}		 
 			
	float sunGIE = max(GetSNGIWay(worldPosition.xyz, worldLightVector, worldDir, cloudHeight, cloudDepth, Detail, co), 0.0f);
	    sunGIE *= exp(-GetSNGIHit(worldPosition.xyz, worldLightVector, worldDir, cloudHeight, cloudDepth, Detail, co) * L_A_C * llscale);
	float sunE = 0.0;
	//float viewSE = GetSNShadow(worldPosition.xyz, viewDir, worldDir, cloudHeight, cloudDepth, Detail, co, vec3(0.0)) * llscale;	
	//      viewSE = (1.0 - exp(-viewSE)) * exp(-viewSE);		
	#ifdef RP_RS
	    vec3 Kdither = vec3(0.0);
		#ifdef TAA_ENABLED	
	      Kdither = vec3(BlueNoise(texcoord.st+2.0 / vec2(viewWidth, viewHeight) + 0.118) - 0.5,
		  BlueNoise(texcoord.st+4.0 / vec2(viewWidth, viewHeight) + 0.118) - 0.5,
          BlueNoise(texcoord.st+16.0 / vec2(viewWidth, viewHeight) + 0.118) - 0.5		  
		  );			        
		  Kdither = CalculateNoisePattern1(vec2(0.2451f), 4).xyz * 2.0 - 1.0;
		#else
          Kdither = CalculateNoisePattern1(vec2(0.2451f), 3).xyz * 2.0 - 1.0;
		#endif	
	    //float DepthD = 1.0;	
	    //float inerE = pow(clamp((saturate(Density * 1.0) - 0.07) * 6.0 * DepthD + 1.0 - DepthD * 0.9, 0.05, 1.0), 0.8);
		//Kdither *= inerE;		
		//Kdither *= 0.0;
	//raytracing inerscatter...
	float lighthitprobability = 0.0;	
	const int numRays = RP_RS_Q;	
	for (int i = 0; i < numRays; i++)
	{
		//float fi = float(i);  		
		float fi = float(i) + (Kdither.x + 1.0) * 0.5;  	
		//float fi = float(i) + (BlueNoiseStatic(texcoord.st + 0.156 + BlueNoise(vec2(0.0))) + 0.0) * 1.0; 	
		//float fi = float(i) + BlueNoise(texcoord.st + 0.1195); 		
		float fiN = fi / float(numRays);
		float lon = 1.62 * 19.2 * fi;
		float lat = asin(fiN * 2.0 - 1.0) * 1.0;
		vec3 kernel;
		kernel.x = cos(lat) * cos(lon);
		kernel.z = cos(lat) * sin(lon);
  	    kernel.y = sin(lat);
		//kernel *= 0.0;
		//kernel = CalculateNoisePattern1(vec2(0.0f), 4).xyz * 2.0 - 1.0;
        kernel = mix(Kdither * 2.0, kernel, saturate(float(i-1)));
  	    //kernel = vec3(BlueNoiseStatic(texcoord.st+2.0 / vec2(viewWidth, viewHeight) + 0.111 + BlueNoise(vec2(0.0))) - 0.5,
		//BlueNoiseStatic(texcoord.st+4.0 / vec2(viewWidth, viewHeight) + 0.111 + BlueNoise(vec2(0.0))) - 0.5,
        //BlueNoiseStatic(texcoord.st+16.0 / vec2(viewWidth, viewHeight) + 0.111 + BlueNoise(vec2(0.0))) - 0.5		  
		//) * 2.0;	
		
		sunE += GetSNShadow(worldPosition.xyz, worldLightVector, worldDir, cloudHeight, cloudDepth, Detail, co, normalize(kernel + vec3(0.0, RP_RS_min, 0.0))) * llscale / float(numRays);	
		lighthitprobability += max(dot(
		worldDir
		// / abs(worldDir.y)
		,
		normalize(worldLightVector + ((sunE + 1.0)
		//+ L_L * 0.04
		) * normalize(kernel + vec3(0.0, RP_RS_min, 0.0)))
		) * 16.0 - 15.0
        , 0.0) / float(numRays);
	}	
	#else 
	    sunE += GetSNShadow(worldPosition.xyz, worldLightVector, worldDir, cloudHeight, cloudDepth, Detail, co, vec3(0.0)) * llscale;		
	#endif	

	//float sunE2 = GetSNShadow(worldPosition.xyz, -worldLightVector, worldDir, cloudHeight, cloudDepth, Detail, co, vec3(0.0)) * llscale;
	
	float sE = exp(-sunE);	
	//float sE2 = exp(-sunE2);		


	float sunGISEd = GetSNScatterwayDen(worldPosition.xyz, worldLightVector, worldDir, cloudHeight, cloudDepth, Detail, co);
	     sunGISEd = exp(-sunGISEd);
    float sscheck = sunGISEd;
	if(texcoord.s > 0.5){
     sscheck = 1.0;	
	}	
	float sunGISEw = GetSNScatterway(worldPosition.xyz, worldLightVector, worldDir, cloudHeight, cloudDepth, Detail, co, sscheck);
	float innersatterGI = sunGISEw
	* exp(-sunGISEd) * 1.0
	;	
	
	float skyE = GetSkyN(worldPosition.xyz, worldLightVector, worldDir, cloudHeight, cloudDepth, Detail, co) * llscale;
	float groE = GetGN(worldPosition.xyz, worldLightVector, worldDir, cloudHeight, cloudDepth, Detail, co) * llscale;	
	
    //float sEf = pow(1.0 + sunE, -.8);
    //float sEf = max(sE, (exp(-sunE * 0.25) * 0.7));	
	//float sEtfexp = pow(1.0 + sunE, -1.);
	//float sEtfexp = pow(1.0 + sunE * 0.5, -1.5);	
	//float sEtfexp = pow(1.0 + sunE * 0.38, -.9);
	float sEtfexp = sE;
	
	//if(texcoord.s > 0.5) sE = pow(1.0 + sunGISE * 0.5, -1.5 - 25.0 / L_L * 6.0);	
	//if(texcoord.s > 0.5) sEtfexp = pow(1.+sunE*.23, -1.9); 		
	
	const float sunlightmlut = 50.0f;
	
	#ifdef S_GI	
	    #ifdef RP_RS	
	
	    #else 
               sEtfexp = pow(1.0 + sunE * 1.2, -0.93);	
	    #endif	
	#endif	
	
	float lodod1 = GetCN(worldPosition.xyz, false, 1.0, 0.01, cloudHeight, cloudDepth, min(co, 2));	
	float lodod2 = GetCN(worldPosition.xyz, false, 1.0, 0.02, cloudHeight, cloudDepth, min(co, 1));	
	float lodod3 = GetCN(worldPosition.xyz, true, 1.0, 0.0, cloudHeight, cloudDepth, min(co,5));
	
	#ifdef LQ_D_L_L
			 sEtfexp = 1.0
			 * saturate((Density - 0.02) * 4.0 + 0.1)			 
			 * exp2(-lodod1 * 4.0 * L_A_C / 0.07)
			 * exp2(-lodod2 * 3.0 * L_A_C / 0.07)			 
			 ;		

			 sE = 1.0
			 * saturate((Density - 0.02) * 5.0 + 0.1)			 
			 * exp2(-lodod1 * 4.0 * L_A_C / 0.07)
			 * exp2(-lodod2 * 3.0 * L_A_C / 0.07)			 
			 ;			 
	#endif		
	
	float limit = pow(saturate((Density - 0.1) * 4.0 + 0.1), 0.9);
	float fakeAO = 1.0 - exp2(-sn * 300.0);
	//float slE = pow(1.0 + skyE * 0.63, -5.215); 
	float slE = pow(1.0 + skyE * 1.3, -0.98);	
	//float slE = 1.0 / (1.0 + skyE);	
	
		#ifdef LQ_S_L_S 
		     float slp = 1.0
			 * saturate(Density * 5.0 + 0.0)			 			 
			 * mix(pow(lodod1 * 600.0 + 1.0, -2.0)
			 , (1.0 - 2.0 * lodod2 + lodod2 * lodod2)
			 , 1.0 - lodod2)	
			 ;
	         slE = 1.0 
			 //* pow(1.0 + (1.0 - Density) * cloudDepth * 1.3 * L_A_C * 0.005, -0.98)
			 //* saturate((Density - 0.02) * 3.0 + 0.1)	
             //* exp2(-sn * 2.0 * L_A_C / 0.07)			 
			 //* exp2(-lodod1 * 4.0 * L_A_C / 0.07)
			 //* exp2(-lodod2 * 3.0 * L_A_C / 0.07)			
	         * slp
			 * pow(lodod3 * 780.0 * L_A_C + 1.0, -0.98)
			 ;			
	    #endif

	#ifdef HALO	
	    vec3 Halo = mix(vec3(1.0), pow(1.0 + pow(1.0 - C_R1, vec3(1.0)) * pow(LdotV01, 100.0) - 1.0 * pow(LdotV01, 50.0) * (1.0 - C_R1), vec3(-1.5)) * (1.0 + C_R1 * pow(LdotV01, 100.0)), vec3(sE));	
	#else
	    vec3 Halo = vec3(1.0);				
	#endif
			
	vec3 colorDirect = vec3(1.0 - wetness * 0.2);
	
	#ifdef RP_RS	
	    float Anglecheck = LdotV01;			 
	    float bias = 0.0;	
	    float DepthD = 0.4 + (0.6 - sE * 0.0) * Anglecheck;	
	    float inerE = pow(clamp((saturate(Density * 1.0) - 0.07) * 6.0 * DepthD + 1.0 - DepthD * 0.9, 0.05, 1.0), 0.8);
			 colorDirect *= 1.0				       			 
             * sEtfexp		 
             * (clamp(max(lighthitprobability
			 * inerE
			 ,
			 bias) * 320.0 * RP_RS_L, 0.0, 50000.0)) * 1.0	 
			 * Halo
			 ;	
	#else 
	    #ifdef HQ_S	

		  //if(texcoord.s <= 0.5)
		  {		
			 ///*
			 float test = abs(sin(frameTimeCounter * VOLUMETRIC_CLOUD_SPEED * 50.0));
			 const float af = 0.83;				 
			 const float agc1 = 1.0;
			 const float agc2 = 1.0;	
			 float Lagc2 = pow(LdotV * 0.5 + 0.5, 1.2);	
			 float Lagco2 = pow(LdotVo * 0.5 + 0.5, 1.2);	
			 float Ldagc = 1.0 / (1.0 + sunE * 1.3);	
			 //  float Ldagc2 = 1.0 - 1.0 / (1.0 + sunE2 * 1.3);				 
			 //if(texcoord.s <= 0.5){
			 //  Ldagc2 = 1.0;	
			 //}
			 
			 colorDirect = 1.0 * vec3(1.0) * af * max(0.0, 0.0		
			 //+ MiePhaseFunction(-Lagco2 * (1.0 - Ldagc) * 0.95 * L_R_S, LdotV * agc2)
			 //+ MiePhaseFunction( Lagc2 * Ldagc * L_R_S * 0.95, LdotV * agc1)	

			 + MiePhaseFunction( Lagco2 * (1.0 - Ldagc) * 0.4 * L_R_S, LdotVo * agc2)
			 + MiePhaseFunction( Lagc2 * Ldagc * L_R_S * 0.7, LdotV * agc1)			  			 
			 //+ phase_mie(-Lagco2 * Ldagc2 * L_R_S * 0.7, LdotV * agc2, LdotV2 * agc2 * agc2)
			 //+ phase_mie( Lagc2 * Ldagc * L_R_S * 0.9, LdotV * agc1, LdotV2 * agc2 * agc2)			  
             )
			 //* sEtfexp
             //+ (1.0 - sEtfexp) * 0.0	 
			 ;	
             //*/				 
          }		
             //float sv = saturate(1.0 - exp(-sn * 10.0 * L_A_C * pow(Dirlength, 0.3))) * PI;
             //float sv = saturate(1.0 - exp(-lodod3 * 40.0 * L_A_C)) * PI;	
			 float DENL = 1.0 - saturate(sunE * 0.05 * L_A_C);
		     float sv = min(sn * 80.0 * L_A_C, PI);			    
			 //float Anglecheck = saturate(MiePhaseFunction( 0.95 * L_R_S, LdotV));
			 //float Anglecheck = pow(LdotV01, 1.2);
			 float Anglecheck = LdotV01 * LdotV01;			 
		     //float sv = saturate(lodod3 * 80.0 * L_A_C) * PI;
			 //float sv = noise * PI * 0.5;	
			 //float sv = min(sn * 10.0 / 0.07 * L_A_C, 1.0);
			 float bias = 0.05;	
			 //float DepthD = 1.0;
			 float DepthD = sE + (0.3 - sE * 1.0) * Anglecheck;	
			 //float inerA = max(pow(sv, max((trueDensity - 0.3) * 2. + 0.5, 0.0)) + bias, sEtfexp - sE);
			 float inerA = pow(sv, max((saturate(DENL * 1.0) - 0.3) * 2. + 0.5, 0.0));
             //float inerB = 0.0;	 		 
             float inerB = saturate(sunE * 0.08);
             //float inerB = 0.0;
			       //inerB = inerB + (1.0 - inerB * 1.8) * LdotV01 * sqrt(LdotV01);
				   
			 float inerC = inerA + (1.0 - inerA) * inerB;	 
                   inerC = max(inerC * (1.0 - Anglecheck) + Anglecheck, saturate(sEtfexp - sE)) + bias;			 
			       //inerC = inerC * (1.0 - LdotV01 * LdotV01) + bias + LdotV01 * LdotV01 * saturate(1.0 - inerC / pow(PI, max((trueDensity - 0.3) * 2.727273 + 0.5, 0.0)));	
				   
			 float inerE = pow(clamp((saturate(Density * 1.0) - 0.07) * 6.0 * DepthD + 1.0 - DepthD * 0.9, 0.05, 1.0), 0.8)
			       //* (1.0 - LdotV01 * LdotV01) + LdotV01 * LdotV01
			       ;  
                   //inerE = max(inerE + bias, sEtfexp - sE);	
				   //if(texcoord.s > 0.5) inerC = inerA + bias;
			 float inerF = mix((1.0 - sE * sE) * 2.0, sv, sEtfexp - sE);
			//if(texcoord.s <= 0.5)
		    //{ 
			 colorDirect *= 1.0	
             //* DENL
             * sEtfexp
			 
			 //* phase_mie(sEtfexp * 0.95, LdotV, LdotV * LdotV)
             //* (clamp(lighthitprobability, 0.01, 10.0) + 0.0) * 32.0	 
			 //* max(exp(1.0 - exp(-sn * 0.3) * 1.0 - sunE * 1.0), exp((1.0 - exp(-sn * 0.3)) * 2.0 - sunE * 0.25))
			 //* inerA
			 //* viewSE
             * inerC
			 
			 //* inerE	
			 //* inerF
			 * Halo
			 ;	
			
			//}
		 /*
		  if(texcoord.s > 0.5)
		  {	 
	         sE = 0.0f;
			 float cn = 1.0;	 
			 float cn1 = 1.0;
			 float cn2 = 1.0;			 
             float Phases = 0.0f;
			 const int plq = 1024;
	         for (int i = 1; i <= plq; i++)
             {	   
               Phases = mix(phase_mie(0.8 * cn2, LdotV, LdotV * LdotV), phase_mie(-0.5 * cn2, LdotV, LdotV * LdotV), 0.5)
			   //* cn
			   ;		
               //Phases = 1.0
			   //;				   
	           sE += exp2(-sunE * cn * rLOG2) * cn1 * Phases;
	           cn *= 0.5;
	           cn1 *= 0.5;
	           cn2 *= 0.5;			   
	         }
	         //sE /= float(plq);		
	         colorDirect *= sE * 0.5
			 //* vec3(1.0, .0,.0)
			 ;
		 }
		 */
		 /*
		  if(texcoord.s > 0.5)
		  {	 
	         sE = 0.0f;
			 float cn = 1.0;	 
			 float cn1 = 1.0;
			 float cn2 = 1.0;			 
             float Phases = 0.0f;
			 const int plq = 1024;
	         for (int i = 1; i <= plq; i++)
             {	   
               Phases = mix(phase_mie(0.8 * cn2, LdotV, LdotV * LdotV), phase_mie(-0.5 * cn2, LdotV, LdotV * LdotV), 0.5)
			   //* cn
			   ;		
               //Phases = 1.0
			   //;				   
	           sE += exp(-sunE * cn) * cn1 * Phases;
	           cn *= 0.5;
	           cn1 *= 0.5;
	           cn2 *= 0.5;			   
	         }
	         //sE /= float(plq);		
	         colorDirect *= sE
			 //* vec3(1.0, .0,.0)
			 ;
		 }
		 */		 
	    #else			 
			 //sE = sqrt(mix(sEf, exp(-sn) * sE, sE));
			 colorDirect *= sEtfexp;	 
			 colorDirect *= mix(MiePhaseFunction(sE * L_R_S * 0.7, LdotV), MiePhaseFunction((1.0-sE) * 0.3 * L_R_S, LdotVo) * (1.0 - sE), 0.5) * 1.5
			 //* (pow(saturate((Density - 0.07) * 6.0 * sEtfexp + 1.0 - sEtfexp * 0.9), 0.8) * (1.0 - LdotV01 * LdotV01) + LdotV01 * LdotV01)
			 //* (2.5 * (1.0 - LdotV01 * LdotV01) * sE + LdotV01 * LdotV01) * ((1.0 - LdotV01) * 5.0 + LdotV01) * 0.5
			 ;				 
		#endif
	#endif	   		
	    //#ifdef HQ_S				 
		//	 colorDirect *= 0.5;				 
		//	 sE = pow(1.+sunE*.4, -1.);		 
		//	 colorDirect += sE * phase_mie(exp(-sn) * L_R_S, LdotV01 * sE, LdotV01 * LdotV01 * sE) * 0.5 * ((Density * sE * 0.9 + 1.0 - sE * 0.9) * LdotV01 * LdotV01 * sE + 1.0 - LdotV01 * LdotV01);	 
	    //#endif		
		
        //float balllimit = mix(pow(LdotV * 0.45 + 0.55, 2.0), 1.0, 1.0 / (max(worldDir.y + cameraPosition.y * worldscale, 0.0) / worldscale * 1e-4 * pow(max(cameraPosition.y * 0.015, 0.0f), 2.0) * 0.1 + 1.0f));
	   float HeigthH = 1.0 - exp2(-300.0 * worldscale * max(cameraPosition.y, 0.0f));	
	   float balllimit = dot(worldDir, -worldLightVector + worldDir * 0.5);
	   balllimit = (saturate(1.0 - mix(balllimit * HeigthH, 0.0, saturate(worldLightVector.y))) * 0.996 + 0.004);
	   balllimit = 1.0;	   
			 colorDirect *= CloudSunlightColor * sunlightmlut * balllimit;			 
			 
		vec3 CSL = mix(colorSkylight, vec3(1.0) * Luminance(colorSkylight), saturate(wetness) * rainModefactor * 0.0f); 
			 //CSL = mix(CSL * exp2(-wetness*2.), CloudSunlightColor * exp(-wetness), 1.-exp2(-wetness*2.));
			 //CSL = mix(CSL, CSL * 0.01f, saturate(timeMidnight));			 
             CSL *= 1.0
			 * slE
			 //* (1.0 - exp(-sn * 2.0) * 0.5)
			 //* (0.9 + 0.1 * min(sn * 8.0, PI))
			 //* 0.75 * (1.0 + LdotV01 * LdotV01)
			 //* fakeAO
			 //* rPI * 2.0
			 //* phase_mie(sn, L_R_S, L_R_S * L_R_S)
			 //* (1.0 - wetness * 0.2)
			 ;

		
		vec3 GI = vec3(0.0f);
	#ifdef C_GI	
		//GI comes from the sunlight reflection between clouds...		
		     GI += max(sunGIE, 0.0f)
			 //* fakeAO
			 //* limit
			 * CloudSunlightColor * sunlightmlut * CBL * 0.1
			 * (1.0 - wetness * 0.65); 
	#endif
	
	
	//float ggiclv = 1.0 / (1.0 + cloudHeight * cloudHeight / C_S_W / C_S_W * (1.0 + timeSunriseSunset * 0.4) / 3e7);
	float ggiclv = abs(worldLightVector.y) * 0.15;	
	#ifdef G_GI
		//GI comes from the ground...	
	    #ifdef LQ_G_GI	 
             float slp2 = 1.0
			 / (1.0 + Density * Density * 3.0)			 			 
			 * mix(pow(lodod1 * 600.0 + 1.0, -2.0)
			 , (1.0 - 2.0 * lodod2 + lodod2 * lodod2)
			 , 1.0 - lodod2)	
			 ;
	         GI += colorSunlight * ggiclv * CBL * sunlightmlut * (1.0 - wetness * 0.6)
			 //* pow(1.0 + (1.0 - Density) * cloudDepth * 1.3 * L_A_C * 0.005, -0.98)
			 //* saturate((Density - 0.02) * 3.0 + 0.1)	
             //* exp2(-sn * 2.0 * L_A_C / 0.07)			 
			 //* exp2(-lodod1 * 4.0 * L_A_C / 0.07)
			 //* exp2(-lodod2 * 3.0 * L_A_C / 0.07)			
	         * slp2
			 * pow(lodod3 * 780.0 * L_A_C + 1.0, -0.98)
			 ;			
 	    #else   
			 GI += ggiclv
			 //* (exp2(-(cloudHeight / C_S_W + Density * cloudDepth / C_S_W * 0.0f) * 2e-3) * 0.5 + 0.5)
			 * colorSunlight * CBL * sunlightmlut 
			 //* fakeAO		 
			 * pow(1.0 + groE * 1.3, -0.98)
			 * (1.0 - wetness * 0.5); 		
			 
	    #endif

	#endif	
	
	    //GI *= (0.9 + 0.3 * min(sn * 8.0, PI));
		//GI *= (1.0 - exp(-sn * 2.0) * 0.5);
		
		float AD = dist * 6e-4; 
		//float AD = 1.0 / (abs(worldDir.y) + 0.00001); 		 
    	if (worldDir.y < 0.0f){
			worldDir *= vec3(1.0, -1.0, 1.0);
		}		
		
	    //atmosphere = AtmosphericScattering( normalize(worldDir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), worldSunVector, 1.0, min(AD, 80.0));			
	    //atmosphere += AtmosphericScattering( normalize(worldDir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), -worldSunVector, 1.0, min(AD, 80.0)) * 4e-4;	
	    atmosphere = AtmosphericScattering(worldDir, worldSunVector, 1.0, min(AD, 80.0));			
	    atmosphere += AtmosphericScattering(worldDir, -worldSunVector, 1.0, min(AD, 80.0)) * 4e-4;			
		//vec3 absorb = AtmosphereAbsorption(normalize(worldDir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), AD * (1.0 + wetness));	
		vec3 absorb = AtmosphereAbsorption(worldDir, AD);			
		     //absorb *= SunAbsorptionAtAltitude(normalize(worldDir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), AD);	
		
	    //float CloudVolumeShadow = TraceShadowVC(worldPosition.xyz, worldPosition.xyz, worldLightVector, worldDir, 0.0f, noise, dist, worldLightVector, 1.0f);
		//float CloudVolumeShadow = exp(-sunE * pow(1.6, L_Q) * L_A_C * L_L);	
		//float CloudVolumeShadow = exp(-sunE * 60.0);		
             //atmosphere *= mix(1.0, CloudVolumeShadow, exp(-dist * 1e-3));	
		     //atmosphere = mix(atmosphere, vec3(20.0) * Luminance(colorSkylight), saturate(wetness) * rainModefactor);			
		 
		vec3 color = vec3(0.0);	
		
			 color += CSL * S_L_L;	
             color += GI;
	              			 
			 color += colorDirect * D_L_L
			 //* abs(sin(frameTimeCounter * VOLUMETRIC_CLOUD_SPEED * 50.0))
			 ;	
			 //color = CloudSunlightColor * sunlightmlut;
			 
             color *= absorb;	
			 
			 //if(length(color) < 0.0001) color *= 0.0f;
			 //sE = mix(1.0, sE, exp(-dist * 2e-4));
			 
             //color = GI;
             //color = colorDirect;			
			 
	         color += atmosphere
			 * (1.0 - wetness * 0.8)
			 //* (sEtfexp + (1.0 - sEtfexp) * wetness * 0.8 + (1.0 - LdotV01 * LdotV01 * 0.95 * exp(-dist * 0.00001 * (timeNoon * 9.0 + 1.0))) * (1.0 - sE))
			 //* (1.0 - 0.8 * wetness * (1.0 - Density * Density * 0.6)) * 1.0f
			 //* mix(1.0, exp(-sunE * 80.0) * 0.6 + 0.4, pow(LdotV01, 5.0))
			 ;	
			 
			 //if(color.r < 0.00004) return vec4(vec3(0.0f, color.gb), noise);
			 //if(color.g < 0.00004) return vec4(vec3(color.r, 0.0f, color.b), noise);			 
			 //if(color.b < 0.00004) return vec4(vec3(color.r, color.g, 0.0f), noise);					 
			 
             //if(length(color) < 0.0001)	return vec4(vec3(0.0f), noise);			 
			 //color = CloudSunlightColor * 5.0;
			 //if(texcoord.s > 0.5) color = vec3(Phases) * CloudSunlightColor * 20.0 * 4.0;	
			 // color = vec3(co);
			 // color = vec3(sunGISE);	
			 
 			 //color = vec3(20.0)
			 //* max(GetSNGIWay(worldPosition.xyz, worldLightVector, worldDir, cloudHeight, cloudDepth, Detail, co), 0.0f) 
 			 //* exp2(-GetSNGIHit(worldPosition.xyz, worldLightVector, worldDir, cloudHeight, cloudDepth, Detail, co) * L_A_C) * fakeAO
			 //* limit
			 //;			
			 //color = (1.0 - sn * sn) / (2.0 - sn * sn) * 1.5 / (1.0 + sn * sn) * CloudSunlightColor * 20.0;
			 
			 //color = 20.0 / (1.0 + (1.-C_R1) * pow(LdotV01, 400.0) - 1.0 * (1.-C_R1) * pow(LdotV01, 20.0));
			 //color = Halo * 20.0;
			 //color = vec3(powder * 50.0);
			 
			 //color = 50.0
			 //* sunE * sEtfexp * sn
			 //* (pow(sqrt(min(sn * 8.0 * saturate(Density * Density * 3.0 + 0.1), PI)), exp2(-sunE * saturate(Density * Density * 3.0 + 0.1) * rLOG2) * (1.0 - LdotV01 * LdotV01) + LdotV01 * LdotV01 * 0.5) + 0.05)
			 //* (pow(min(sn * 8.0, PI), max((Density - 0.3) * 1.72 + 1.0, 0.0) * sE) + 0.05)
			 //* (pow(clamp((Density - 0.07) * 4.0 * sE + 1.0 - sE * 1.0, 0.0, 1.0), 0.8) * (1.0 - LdotV01 * LdotV01) + LdotV01 * LdotV01)	
			 //* CloudSunlightColor;
			 
			 //color = vec3(0.0, 1.0, 0.0)
			 //* saturate(pow((Density - 0.07) * 4.5 + 0.1, 0.8))
			 //* sn
			 //* max(pow(Hchit * 1.5, 1.4), 0.2) * 2.0
			 //* (1.0 - Density)
			 //* Density		 
			 //;
			 //if(color.g == 1.0){
			 //  color = vec3(1.0, 0.0, 0.0);
			 //}
			 //if(texcoord.s > 0.0) color = vec3(20.0) * powder;
			 //if(worldPosition.y > 1600.0 && worldPosition.y < 3200.0) color = vec3(0.0, 1.0, 0.0) * fakeAO;
			 //if(worldPosition.y > 3200.0) color = vec3(1.0, 0.0, 0.0) * fakeAO;
			 //if(noise * noise == 1.0) color = vec3(0.0f);
			 //noise = innersatterGI;
		vec4 result = vec4(color.rgb * balllimit, noise);
		
		return result;
}

vec3 IntersectXZPlane(vec3 rayDir, float planeHeight)
{
	  return rayDir * (planeHeight - cameraPosition.y) / rayDir.y;	  
}

void CloudPlane2(inout vec3 color, vec3 viewDir, vec3 worldVector, float linearDepth, MaterialMask mask, vec3 worldLightVector, vec3 lightVector, in vec3 worldDir, float gbufferdepth, inout float cloudAlpha, vec3 worldPos)
{
       	float cloudsAltitude = Cloud3Height * C_S_W;
       	float cloudsThickness = Cloud3thick * C_S_W;  
 
		const int raySteps = C_Q;
		
		worldDir += cameraPosition.y * vec3(0.0f, 1.0, 0.0f) * worldscale;		
		worldDir = normalize(worldDir);	
		
	    vec3 rayStartPos = IntersectXZPlane(worldDir, cloudsAltitude) + cameraPosition;
		
	    vec3 rayIncrement = (worldDir * cloudsThickness / raySteps) / abs(worldDir.y);	
	    float rayIncrementLength = length(rayIncrement);
		
	    float eyeLength = length(worldPos - cameraPosition);
				
	    vec4 cloudAccum = vec4(0.0);
		float CloudVolumeShadow = 0.0f;	 
	    float visibilityAccum = 1.0;
	    vec3 rayPos = rayStartPos;
		float debug = 0.0;
		//if(texcoord.s>0.5) debug = 1.0;

		//  //float fi = float(1) + CalculateNoisePattern1(vec2(0.0f), 4).x * 2.5;  	
		//  float fi = float(1) + BlueNoise(texcoord.st + 0.156) * 0.1; 		
		//  float fiN = fi;
		//  float lon = 1.62 * 19.2 * fi;
		//  float lat = asin(fiN * 2.0 - 1.0) * 1.0;
		//  vec3 kernel;
		//  kernel.x = cos(lat) * cos(lon);
		//  kernel.z = cos(lat) * sin(lon);
  	    //  kernel.y = sin(lat);		
		//float dither = 1.0;
    	//  if(texcoord.s > 0.5)
		//  {
		//    dither = LDdither(texcoord.st + frameTimeCounter * 1e-4);
		//  }
		#ifdef TAA_ENABLED	
		//if(texcoord.s > 0.5){
	    //  rayPos += rayIncrement	
		//  * BlueNoise(texcoord.st);
		//  }
	      rayPos += rayIncrement
          //* dither
		  //* BlueNoiseStatic(texcoord.st + BlueNoise(vec2(0.0)))
		  * BlueNoise(texcoord.st)
		  //* CalculateNoisePattern1(vec2(0.0f), 4 + sin(frameCounter * 0.75) / sqrt(length(vec2(viewWidth, viewHeight))) * debug).bbb * 2.5
		  //* (kernel.x + 1.0) * 0.5
		  //* mix(1.0, BlueNoise(texcoord.st), saturate(500.0/rayIncrementLength))	
		  //* (CalculateNoisePattern1(vec2(frameTimeCounter*25.0,frameTimeCounter*20.0), 4+sin(frameTimeCounter*1e-1) * 0.0f).rgb * 1.0 - 0.5) * 1.9
		  //* BlueNoiseTemporal(texcoord.st).x
		  //* CalculateNoisePattern1(vec2(0.0f), 4 + sin(frameCounter * 0.75) * 0.05 * debug).bbb * 2.8	
          ;		  
		//  if(texcoord.s <= 0.5){
		//  rayPos += rayIncrement	
		//  * BlueNoiseStatic(texcoord.st + vec2(sin(PI * 2.0 * BlueNoiseStatic(frameTimeCounter * vec2(0.75))), cos(PI * 2.0 * BlueNoiseStatic(frameTimeCounter * vec2(0.75)))))
		//  ;
		//  }	  	  
		  	
		#else
	      rayPos += rayIncrement
		  //* BlueNoiseStatic(texcoord.st)		  
		  //* (CalculateNoisePattern1(vec2(frameTimeCounter*25.0,frameTimeCounter*20.0), 4+sin(frameTimeCounter*1e-1) * 0.0f).rgb * 2.5 - 1.25)	  
		  * CalculateNoisePattern1(vec2(0.0f), 4 + sin(frameCounter * 0.75) * 0.05 * debug).bbb * 2.5
		  //* mix(1.0, BlueNoiseStatic(texcoord.st), 1.0/rayIncrementLength)
		  //* LDdither(texcoord.st / vec2(viewWidth, viewHeight) / 4e-5 + frameTimeCounter * 1e-4 * debug) * 1.25
		  ;	
		#endif

        vec4 cloudSample = vec4(0.0f);
	    for (int j = 0; j < raySteps; j++)
	    {
		    if (length(rayPos - cameraPosition) > length(worldPos) || visibilityAccum < 0.0001 || worldDir.y < 0.0f)
		    {
			    break;
		    }

		    cloudSample = CloudColor3(vec4(rayPos, 1.0f), 1.0f, worldLightVector, worldDir, vec3(0.0f), cloudsAltitude, cloudsThickness, eyeLength, viewDir);
		    cloudAccum.rgb += (cloudSample.rgb * cloudSample.a) * visibilityAccum;
			
		    visibilityAccum *= 1.0 - cloudSample.a;
			
		    rayPos += rayIncrement;  
			
			//cloudSample.a *= visibilityAccum;
			
		    //CloudVolumeShadow += TraceShadowVC(rayPos.xyz, rayPos.xyz, worldLightVector, worldDir, 0.0f, 0.0f, rayIncrementLength, worldLightVector, 1.0f);			
			// CloudVolumeShadow += mix(1.0, TraceShadowVC(rayPos.xyz, rayPos.xyz, worldLightVector, worldDir, 0.0f, 0.0f, rayIncrementLength, worldLightVector, 1.0f), pow(dot(worldDir, worldLightVector) * 0.5 + 0.5, 5.0));	
	    }
		
		CloudVolumeShadow /= float(raySteps);	 
		//if(worldDir.y > 0.0f)
		//{
		//  //CloudVolumeShadow = TraceShadowVC(rayPos.xyz, rayPos.xyz, worldLightVector, worldDir, 0.0f, 0.0f, rayIncrementLength, worldLightVector, 1.0f);	
		//  //color *= exp(-(1.0 - CloudVolumeShadow) * C_R1 * 70.0);	
		//  //color += CloudVolumeShadow * CloudSunlightColor * 2.0 * pow(dot(worldDir, worldLightVector) * 0.5 + 0.5, 5.0);	
		//  float miel = phase_mie(0.6, dot(worldDir, worldLightVector) * 0.5 + 0.5, pow(dot(worldDir, worldLightVector) * 0.5 + 0.5, 2.0)) * 0.03
		//  + phase_mie(0.9, dot(worldDir, worldLightVector) * 0.5 + 0.5, pow(dot(worldDir, worldLightVector) * 0.5 + 0.5, 2.0)) * 0.01;
        //  color += CloudVolumeShadow * CloudSunlightColor * miel * 20.0;		  
		//}

		
		cloudAlpha = 1.0 - visibilityAccum;
	    color = color * saturate(visibilityAccum) + cloudAccum.rgb;		
}

void CloudPlane3(inout vec3 color, vec3 viewDir, vec3 worldVector, float linearDepth, MaterialMask mask, vec3 worldLightVector, vec3 lightVector, in vec3 worldDir, float gbufferdepth, inout float cloudAlpha, vec3 worldPos)
{
       	float cloudsAltitude = Cloud3Height * C_S_W;
       	float cloudsThickness = Cloud3thick * C_S_W;
		//cloudsThickness *= saturate(0.5 + pow((dot(-worldDir, worldSunVector) * 0.5 + 0.5), 2.0) * 0.5);
	
	    float eyeLength = length(worldPos - cameraPosition);
		worldDir += cameraPosition.y * vec3(0.0f, 1.0, 0.0f) * worldscale;		
		worldDir = normalize(worldDir);	
		
	int raySteps = C_Q * 2;
	const float rayExtent = 1e4 * C_S_W;
	float rayStepSize = rayExtent / raySteps;

	vec4 cloudAccum = vec4(0.0);
	float visibilityAccum = 1.0;
	   #ifdef TAA_ENABLED	
 	      float dither = BlueNoise(texcoord.st);		
		#else
 	      float dither = CalculateNoisePattern1(vec2(0.0f), 4 + sin(frameCounter * 0.75) * 0.0).b * 2.5;	
		#endif
	float rayDepth = dither * rayStepSize;

	for (int i = 0; i < raySteps; i++)
	{
		//vec3 rayPos = (worldDir / mix(abs(worldDir.y) + 5e-6, 1.0, saturate(abs(worldDir.y) * abs(worldDir.y))) + cameraPosition.y * vec3(0.0f, 1.0, 0.0f) * worldscale) * rayDepth + cameraPosition;
		vec3 rayPos = (worldDir / mix(abs(worldDir.y), 1.0, saturate(4e2 * C_S_W / (rayDepth + 5e-6)))) * rayDepth + cameraPosition;		
		
		//cloudsThickness = Cloud3thick + 5.0 * (abs(worldDir.y) + 0.1);
		//cloudsThickness -= length(rayPos - cameraPosition) * 0.015 / C_S_W;
		//cloudsAltitude = Cloud3Height + 48.88889 * C_S_W - length(rayPos - cameraPosition) * 0.0118125 / C_S_W;
        //cloudsAltitude = Cloud3Height + 400.0 * C_S_W * (abs(worldDir.y) + 0.05);		
		//When fully opaque, stop
		if (length(rayPos - cameraPosition) > length(worldPos) || visibilityAccum < 0.00001)
		{
			break;
		}

		//early out if not in correct altitude range
		if (worldPos.y < cloudsAltitude &&  worldPos.y> cloudsAltitude + cloudsThickness)
		{
			rayDepth += rayStepSize;
			continue;
		}
		
		vec4 cloudSample = CloudColor3(vec4(rayPos, 1.0f), 1.0f, worldLightVector, worldDir, vec3(0.0f), cloudsAltitude, cloudsThickness, eyeLength, viewDir);
		cloudAccum.rgb += (cloudSample.rgb * cloudSample.a) * visibilityAccum;
		visibilityAccum *= 1.0 - cloudSample.a;
        //rayStepSize *= 1.01;
		rayDepth += rayStepSize;
	}
		cloudAlpha = 1.0 - visibilityAccum;
	color = (color * visibilityAccum) + cloudAccum.rgb;	

}

void CloudPlane4(inout vec3 color, vec3 viewDir, vec3 worldVector, float linearDepth, MaterialMask mask, vec3 worldLightVector, vec3 lightVector, in vec3 worldDir, float gbufferdepth, inout float cloudAlpha, vec3 worldPos)
{
	   Ray viewRay;
	   viewRay.dir = normalize(worldVector.xyz + cameraPosition.y * vec3(0.0f, 1.0, 0.0f) * worldscale);
	   //viewRay.dir = worldVector.xyz;	   
	   viewRay.origin = vec3(0.0);	
	   float cloudsAltitude = Cloud3Height * C_S_W;
	   float cloudsThickness = Cloud3thick * C_S_W;
	   float cloudsUpperLimit = cloudsAltitude;
	   float planeHeight = cloudsUpperLimit;	
	   const int numSamples = C_Q;	
	   #ifdef TAA_ENABLED	
 	      float dither = BlueNoise(texcoord.st);		
		#else
 	      float dither = CalculateNoisePattern1(vec2(0.0f), 4 + sin(frameCounter * 0.75) * 0.0).b * 2.5;	
		#endif
	   planeHeight -= dither * (cloudsThickness / numSamples);
	   for (int j = 0; j < numSamples; j++)
	   {
	       Plane pl;
		   pl.origin = vec3(0.0f, cameraPosition.y - planeHeight, 0.0f);
		   pl.normal = vec3(0.0f, 1.0f, 0.0f);		
		   Intersection intersection = RayPlaneIntersectionWorld(viewRay, pl);
		   if (intersection.angle < 0.0f)
		   {
			   if (intersection.distance < linearDepth || linearDepth <= far - 0.1)
			   {			    
				   vec4 cloudSample = CloudColor3(vec4(intersection.pos.xyz, 1.0f), 1.0f, worldLightVector, vec3(1.0, -1.0, 1.0) * worldDir, vec3(0.0f), cloudsAltitude, cloudsThickness, 1.0f, viewDir);
			       float cloudDist = length(intersection.pos.xyz-cameraPosition.xyz);
				   color.rgb = mix(color.rgb, cloudSample.rgb * 1.0f, cloudSample.a);
			   }
		   }
		     planeHeight += cloudsThickness / numSamples;		
	   }
}

float CloudShadow3(vec4 worldPos, vec3 worldLightVector)
{	
    #ifdef cloud_shadow	
	      Ray ray;
	      ray.dir = worldLightVector;
	      ray.origin = worldPos.xyz + cameraPosition.xyz;

	      Plane plane;
	      plane.normal = vec3(0.0, 1.0, 0.0);
	      plane.origin = vec3(0.0, Cloud3Height * C_S_W, 0.0);

	    vec3 cloudCheckPos = RayPlaneIntersection(ray, plane).pos;
        float cloudshadow = 1.0;
		float dither = rand(texcoord.st).x * 0.0 + 1.0;
		const int steps = 5;
	    float rSteps = Cloud3thick * C_S_W / steps;
        float stepSize = rSteps / abs(worldLightVector.y);	
        vec3 increment = worldLightVector.xyz * stepSize * dither;		  
        float fade = smoothstep(0.125, 0.075, abs(worldLightVector.y)) * 1.0f;		  
        cloudCheckPos.xyz += cloudCheckPos.y <= Cloud3Height * C_S_W ? worldLightVector * (Cloud3Height * C_S_W - cloudCheckPos.y) / worldLightVector.y : vec3(0.0);
        float cloudDensity = 0.0;

        for (int i = 0; i < steps; ++i, cloudCheckPos.xyz += increment){
            cloudDensity += GetCN(cloudCheckPos.xyz, true, 1.0f, 0.0f, Cloud3Height * C_S_W, Cloud3thick * C_S_W, min(int(floor(A_C_O_S + C_O_S)), 4));
        }		  
	    cloudshadow = (exp(-cloudDensity * L_A_C * stepSize) * (1.0 - fade) + fade)
		//* 0.9 + 0.1
		;
        return cloudshadow;			  
	
	#else
 	      return 1.0f;
	#endif

}