const float fscale = 1.0;

float GetfCN(vec3 wp, bool forCL, float lr, float Detail, float cloudHeight, float cloudDepth, int co)
{		
	float t = frameTimeCounter*1e-1;		
	float lC = 1.0f;
	  lC = texture2D(noisetex, (wp.xz - vec2(t*1e-1,.0))*1e-4/C_S_W).x;
	  lC = saturate(lC*3.-.75)*.5+.5;
	  
	float Hc = saturate((wp.y-cloudHeight)/cloudDepth);		
	float Hcf = saturate(1.-Hc); 
	float heightAttenuation = saturate(Hc * 5.0) * saturate(Hcf * 5.0);  	
		
	vec3 p = wp.xyz*1e-2/fscale;  
    float G = 1.0;	
    float T = 1.0;	
	
	vec3 p1 = p;
	//p1 *= vec3(1.0, 1.5, 1.0);
    p1.xy -= vec2(1.0, 0.6) * t;	
	
	float noise = 0.0f;
	float largernoise = mix(Get3DNoise(p1), 1., wetness*.2);    
	
	noise += largernoise;
    p.xy -= vec2(0.0 - wetness*.5, -1.0 - wetness*1.6) * t;	
	p.y *= 0.62f;	
	const int octaves = 0; 	
	float octScale = 3.0f; 	
	for (int j = 1; j < octaves + co; j++)
    {	      	    
	    p *= octScale;		
		G *= VC_R / octScale * lr;		
        noise += Get3DNoise(p)*G;	
		T += G;
        octScale *= 1.2;
    } 		 
	    noise /= T;
		noise -= Detail;
	    noise *= heightAttenuation * lC * 3.0;	
     	noise -= heightAttenuation * 0.5 + Hc * 0.2;	
		//noise += 1.0;
        noise *= mix(0.0, 1.0, saturate(wetness + 1.0 - saturate(worldSunVector.y * 10.0) - saturate(-worldSunVector.y * 1.0)));		
		//noise *= largernoise;	

	return saturate(noise);
}

float GetfSNShadow(vec3 wp, vec3 l, vec3 wd, float ch, float cd, float Detail, int co)
{
	    float se = 0.0;
	    float r = 1.0;				
		const int q = 4;				
		float dither = 0.0f;	
		#ifdef TAA_ENABLED
		  dither = BlueNoiseTemporal(texcoord.st+0.112).x;			
		#else
	      dither = CalculateNoisePattern1(vec2(0.566483f), 4).b * 2.5 - 1.25;	
		#endif	
	    for (int i = 1; i <= q; ++i)
	    {	
    		if(wp.y > Cloud5Height + Cloud5thick && wp.y < Cloud5Height) break;	  
            float fi = pow(2.0, float(i)+dither*.0) * fscale;  		

			wp += l * fi * 10.0;					
		    float densityCheck = saturate(GetfCN(wp, true, r, 0.0,ch,cd, co) * 10.0) * 2e-2;
		           se += densityCheck * fi;				
	    }
        se *= 10.0;
	return se;
}

float GetfSkyN(vec3 wp, vec3 l, vec3 wd, float ch, float cd, float Detail, int co)
{
	    float se = 0.0;
	    float r = 1.0;
		const int q = 2;			
		float dither = 0.0f;	
		#ifdef TAA_ENABLED
		  dither = BlueNoiseTemporal(texcoord.st+0.111).x;			
		#else
	      dither = CalculateNoisePattern1(vec2(0.566483f), 4).b * 2.5 - 1.25;	
		#endif		
		vec3 lv = mix(l, vec3(0.0, 1.0, 0.0), saturate(l.y*100.0));
	    for (int j = 1; j <= q; ++j)
	    {
		    if(wp.y > Cloud5Height + Cloud5thick && wp.y < Cloud5Height) break;			
		    float fi = pow(3.0, float(j)+dither*.0) * fscale;
				wp += lv * fi * 120.0;					
		    float densityCheck = GetfCN(wp, true, r, 0.0,ch,cd, co) * 2e-2;	
	
		        se += densityCheck * fi;
	    }
        se *= 120.0;		
	return se;
}

float fDirectDetail(vec3 worldDir, float dist, vec3 WindDir)
{	
    float pnoise = 0.0f;
      vec3 pos = worldDir + WindDir; 
	    pos.y *= 0.62f;
	    pos += Get3DNoise(worldDir*20.0)*.01;	
		
	  pnoise += Get3DNoise(pos * 30.0) * 2.0;	
	  pnoise += Get3DNoise(pos * 60.0) * 2.0;			
	  pnoise += Get3DNoise(pos * 120.0) * 1.0;			
	  pnoise += Get3DNoise(pos * 240.0) * 0.5;		
	  pnoise += Get3DNoise(pos * 480.0) * 0.5;		  
	  pnoise = mix(pnoise, 2.7, 1.0 / (dist * 25e-5 + 1.0));	 
 	  pnoise *= 0.32;	  	
 	  pnoise -= 0.8512;	  
	  
	return pnoise;	
}		

vec4 CloudColorf(vec4 worldPosition, float sunglow, vec3 worldLightVector, vec3 worldDir, vec3 atmosphere, float cloudHeight, float cloudDepth, float eyeLength)
{	
    float dist = length(worldPosition.xyz - cameraPosition) / fscale;
    float Density = saturate((worldPosition.y - Cloud5Height) / Cloud5thick);	
    const float AC = 3.0;	
	int co = int(clamp(AC - floor(sqrt(dist) * 8e-3), 0.0, AC));	
		float LdotV = dot(worldDir, worldLightVector);	
	    float LdotV2 = LdotV * LdotV;	
		float LdotV01 = LdotV * 0.5 + 0.5;			
	float highPoint = cloudHeight + cloudDepth;
	float lowPoint =  cloudHeight;
	float Detail = 0.0f;
	float t = frameTimeCounter * VOLUMETRIC_CLOUD_SPEED * 2e-1;
	vec3 motion = vec3(-t,t,.0f);	
	vec3 ppos = worldDir;
		 Detail = fDirectDetail(ppos, dist, motion); 
    float noise = GetfCN(worldPosition.xyz, false, 1.0, Detail, cloudHeight, cloudDepth, co);
	
	     //noise = saturate(noise * (2.0 * Density + 0.1));	
		 
	float sn = noise;
	     noise = saturate(noise * 50.0) * 0.1;	 	
		 
 		if (noise < 0.0001f){
		  return vec4(0.0f);
		}		 
		
	float sunE = GetfSNShadow(worldPosition.xyz, worldLightVector, worldDir, cloudHeight, cloudDepth, Detail, co);			
	float skyE = GetfSkyN(worldPosition.xyz, worldLightVector, worldDir, cloudHeight, cloudDepth, Detail, co);
	
	float sE = pow(1.+sunE, -1.); 	
	
	//if(texcoord.s > 0.5) sE = pow(1.+sunE*L_A_C, -1.); 			
	/*
	if(texcoord.s > 0.5){
	  sE = 0.f;
	  float cn = 1.0f;
	  float T = 0.0f;
	  for (int j = 1; j <= 1; j++)
      {	      	
	    sE += exp(-sunE*L_A_C*rLOG2) * cn;
	    T += cn;
	    cn *= 0.5;
	    sunE *= 0.5;
	  }
	  sE /= T;		
	}
    */

	float limit = saturate((Density - 0.15) * 2.0);
	float fakeAO = 1.0 - exp2(-sn * 80.0);
	float slE = pow(1.+skyE, -0.9); 
	
             sn *= 300.0 * L_A_C;
	
    float Phases = CalculateMultipleScatteringCloudPhases(LdotV);			
	    vec3 colorDirect = CloudSunlightColor * 20.0 * (1.0 - wetness * 0.4);
		     colorDirect *= sE;	
			 sE *= mix(sE, exp2(-sn), sE);
			 colorDirect *= MiePhaseFunction(sE, LdotV01);
			 colorDirect *= Phases;		
			 
		vec3 CSL = mix(colorSkylight, vec3(1.0) * Luminance(colorSkylight), saturate(wetness) * rainModefactor * 0.0f); 
			 //CSL = mix(CSL * exp2(-wetness*2.), CloudSunlightColor * exp(-wetness), 1.-exp2(-wetness*2.));
			 //CSL = mix(CSL, CSL * 0.01f, timeMidnight);			 
             CSL *= slE * (0.9 + exp2(-sn) * 0.2) * fakeAO * (1.0 - wetness * 0.4);
			 
		float AD = dist * 1e-3; 
		     AD = min(AD, 80.0);
			 
    	if (worldDir.y < 0.0f){
			worldDir *= vec3(1.0, -1.0, 1.0);
		}				 
	    atmosphere += AtmosphericScattering( normalize(worldDir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), worldSunVector, 1.0, AD);			
	    //atmosphere = mix(atmosphere, vec3(Luminance(colorSkylight)), saturate(wetness) * rainModefactor);
	
		vec3 absorb = AtmosphereAbsorption(normalize(worldDir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), AD);	

		 atmosphere = mix(atmosphere, vec3(1.0) * Luminance(colorSkylight), saturate(wetness) * rainModefactor);	
		 
		 //cloud shadows
	     vec4 shadowPosition = shadowModelView * (worldPosition - vec4(cameraPosition, 0.0f));
		 	 shadowPosition = shadowProjection * shadowPosition;
		 	 shadowPosition /= shadowPosition.w;

	     float shadowdist = sqrt(dot(shadowPosition.xy, shadowPosition.xy));
	     float distortFactor = (1.0f - SHADOW_MAP_BIAS) + shadowdist * SHADOW_MAP_BIAS;
		 	 shadowPosition.xy *= 0.95f / distortFactor;
		 	 shadowPosition.z = mix(shadowPosition.z, 0.5, 0.8);
		 	 shadowPosition = shadowPosition * 0.5f + 0.5f;

		 float sunlightVisibility = shadow2DLod(shadow, vec3(shadowPosition.st, shadowPosition.z), 4).x;	 
		 	 noise *= sunlightVisibility;	
		 
		vec3 color = vec3(0.0);	
			 color += CSL;		 
			 color += colorDirect;	
             color *= absorb;	
	         color += atmosphere;	
			 
			 // color = vec3(co);
			 
 			 //color = vec3(20.0)
			 //* max(GetSNGIWay(worldPosition.xyz, worldLightVector, worldDir, cloudHeight, cloudDepth, Detail, co), 0.0f) 
 			 //* exp2(-GetSNGIHit(worldPosition.xyz, worldLightVector, worldDir, cloudHeight, cloudDepth, Detail, co) * L_A_C) * fakeAO
			 //* limit
			 //;			
			 
		vec4 result = vec4(color.rgb, noise);
		return result;
}
/*
	if(lumB > lumD)
	{
	 lumD = lumB;
	}
	
	if(lumE > lumF)
	{	   
	    if(lumE > lumD)
	    {
	      color = vec3(lumE);
	    }
	 lumF = lumE;
	  if(lumH > lumF)
	  {
	    if(lumH > lumE)
	    {
	      lumE = lumH;
	    }
	  }

    } 
	*/
void CloudPlane5(inout vec3 color, vec3 viewDir, vec3 worldVector, float linearDepth, MaterialMask mask, vec3 worldLightVector, vec3 lightVector, in vec3 worldDir, float gbufferdepth, inout float cloudAlpha, vec3 worldPos)
{
       	float cloudsAltitude = Cloud5Height;
       	float cloudsThickness = Cloud5thick;
	
	    float eyeLength = length(viewDir);
	
    const float AC = 0;	
	int as = int(clamp(AC - floor(sqrt(eyeLength)), 0.0, AC));	
	const int raySteps = 0;
	const float rayExtent = 2100.0f * fscale;
	float rayStepSize = rayExtent / (raySteps + as);

	vec4 cloudAccum = vec4(0.0);
	float visibilityAccum = 1.0;

	float rayDepth = BlueNoiseTemporal(texcoord.st+sin(frameTimeCounter)).x * rayStepSize;

	for (int i = 0; i < (raySteps + as); i++)
	{
		vec3 rayPos = worldDir * rayDepth + cameraPosition;
		cloudsThickness -= length(rayPos - cameraPosition) * 0.001;
		//When fully opaque, stop
		if (length(rayPos - cameraPosition) > length(worldPos) || visibilityAccum < 0.00001)
		{
			break;
		}

		//early out if not in correct altitude range
		if (worldPos.y < cloudsAltitude &&  worldPos.y> cloudsAltitude + cloudsThickness)
		{
			rayDepth += rayStepSize;
			continue;
		}
		
		vec4 cloudSample = CloudColorf(vec4(rayPos, 1.0f), 1.0f, worldLightVector, worldDir, vec3(0.0f), cloudsAltitude, cloudsThickness, eyeLength);
		cloudAccum.rgb += (cloudSample.rgb * cloudSample.a) * visibilityAccum;
		visibilityAccum *= 1.0 - cloudSample.a;

		rayDepth += rayStepSize;
	}
		cloudAlpha = 1.0 - visibilityAccum;
	color = (color * visibilityAccum) + cloudAccum.rgb;	

}