const float Nb1 = 0.5f;
const int Nc1 = 3;
float cloudForwardG = 0.0;
float cloudBackwardG = -0.5;
float cloudMixG = 0.5;
const float CPH = 8000.0;

float MiePhaseFunction(float g, float cosTheta){
    float g2 = g * g;
    //return 1.5 / (2.0 + g2) * (1.0 - g2) * (1.0 + g2) * pow(1.0 + g2 - 2.0 * g * cosTheta, -1.1) + g * cosTheta;
    return (0.5 + cosTheta * cosTheta * 0.5) * pow(1.0 + g2 - 2.0 * g * cosTheta, -1.5);	
    //return phase_mie(0.0f, cosTheta, cosTheta * cosTheta);		
}

float PhaseGDualLobe(float VoL, const float g0, const float g1, const float m){
    float p1 = MiePhaseFunction(g0, VoL);
    float p2 = MiePhaseFunction(g1, VoL);

    return mix(p2, p1, m);
}

float CalculateMultipleScatteringCloudPhases(float VoL){
	float phases = 0.0;
	float cn1 = 1.0;
	float cn2 = 1.0;
    for (int i = 0; i < 2; i++, cn1 *= 0.125, cn2 *= 0.841){
        phases += PhaseGDualLobe(VoL, cloudForwardG * cn1, cloudBackwardG * cn1, cloudMixG) * cn2;
    }
	return phases;
}

const float scaleforplane = 1.0;
float CloudDensity1(vec3 p, vec3 worldDir, const int level, const float lunacrity, vec3 worldLightVector, float R)
{	
	float dist = length(p - cameraPosition);	
	float t = frameTimeCounter * VOLUMETRIC_CLOUD_SPEED;	
    if(cameraPosition.y > CPH)
	{
	  worldDir *= vec3(1.0f, -1.0f, 1.0f);
	}
	
	float LdotV = dot(worldDir, -worldLightVector);		
    p *= 0.0002;

	float lC = 1.0f;
		
	float n = Get3DNoise(p);		
	p.x += t;		
    ///*     
	vec3 p1 = p;
    float G = 1.0;	
    float T = 1.0;	

	int octaves = int(clamp(8.0 - floor(sqrt(dist) * 8e-3), 0.0, 8.0));
	//int octaves = 6.0; 	 	
	float octScale = 3.0f; 	
	for (int j = 1; j < octaves; j++)
    {	      	    

    	n += Get3DNoise(p) * G;	
 		T += G;
		p *= octScale;
		//G *= pow(0.8, float(j));	
		//G *= 1.5 / octScale * lunacrity;		
        G *= 0.5;
        //octScale *= 1.0;
    } 		
	n /= T;
    n *= 1.5;
    n -= 0.35;
	//*/	
	return saturate(n);
}

float CloudDensity2(vec3 p, vec3 dir, const int level, const float lunacrity, vec3 worldLightVector, float R)
{	
	float dist = length(p - cameraPosition);	
	float t = frameTimeCounter * VOLUMETRIC_CLOUD_SPEED * 40.0;	
	p /= scaleforplane;
    if(cameraPosition.y > CPH)
	{
	  dir *= vec3(1.0f, -1.0f, 1.0f);
	}
	
	//p -= dir * 3500.0;
	
	float lC = texture2D(noisetex, (p.xz - t * 50.0) * 0.0000006 + 0.5).x+texture2D(noisetex, (p.xz + t * 50.0) * 0.000004 + 0.5).x * 0.5;
	  lC = pow(saturate(lC + wetness*.5), 2.)*.8+.2;	
	  
	float lC2 = texture2D(noisetex, (p.xz - t * 50.0) * 0.0000006 + 0.5).x+texture2D(noisetex, (p.xz + t * 50.0) * 0.000012 + 0.5).x * 0.5;
	  lC2 = pow(saturate(lC + wetness*.5), 2.)*.9+.1;	
      lC *= lC2;
	  
	float lC3 = texture2D(noisetex, (p.xz - t * 50.0) * 0.0000006 + 0.5).x+texture2D(noisetex, (p.xz + t * 50.0) * 0.000036 + 0.5).x * 0.5;
	  lC3 = pow(saturate(lC + wetness*.5), 2.)*.8+.2;	
      lC *= lC2;
	  
	float LdotV = dot(dir, -worldLightVector);		
    p *= 0.00045;


    /*		
	float n = Get2DNoise(p);		
	p.x += t;		

	vec3 p1 = p;
    float G = 1.0;	
    float T = 1.0;	
		float dither = 0.0f;	
		#ifdef TAA_ENABLED
		  dither = BlueNoiseTemporal(texcoord.st+frameTimeCounter*1e-3).x - 0.5;			
		#else
	      dither = CalculateNoisePattern1(vec2(0.566483f), 4).b * 2.5 - 1.25;	
		#endif	
	//int octaves = int(clamp(8.0 - floor(sqrt(dist) * 2e-4), 0.0, 8.0));
	int octaves = 3; 	 	
	float octScale = 3.0f; 	
	for (int j = 1; j < octaves; j++)
    {	      	    
		p *= octScale;
		//G *= pow(0.8, float(j));	
		//G *= 1.5 / octScale * lunacrity;		
        G *= 0.23;
        //octScale *= 1.0;
    	n += Get3DNoise(p) * G;	
 		T += G;

    } 		
	n /= T;	
	*/
	///*
	 p += (Get3DNoise3(p * 2.0f) * 2.0f - 1.0f) * 0.10f;

	 p.x -= (Get3DNoise3(p * 0.125f) * 2.0f - 1.0f) * 2.4f;
	 p.xz -= (Get3DNoise3(p * 0.0525f) * 2.0f - 1.0f) * 3.4f;
    //*/
	
    p.z -= p.x * 0.4;	
	//p.x *= 0.35f;  

	///p.x -= t * 0.01f + R * 1e-3;
    t *= -1.0;
	float n = Get3DNoise(p + vec3(t * 0.01f, t * 0.001f, 0.0f));
///*	  p *= 2.0f;	    p.xz += t * 0.012f;	p.z += n * 1.35f;	p.x += n * 0.5f; 									
		  n += (abs(Get2DNoise(p) * 2.2f - 1.1f) - 0.0) * (0.7f);					        p *= 3.0f;	    p.xz += t * 0.005f;	p.z += n * 1.35f;	p.x += n * 0.5f; 	//p.x *= 3.0f;	p.z *= 0.55f;	
			                                                                                                                    //p.z -= (Get3DNoise3(p * 0.25f + vec3(t * 0.00f, t * 0.0f, 0.0f)) * 2.0f - 1.0f) * 0.284f;
		  n += (abs(Get3DNoise(p) * 1.7f - 0.7f) - 0.0) * (0.44f);					        p *= 3.0f;	    p.xz += t * 0.005f;																					
		  n += (abs(Get3DNoise(p) * 1.4f - 0.4f) - 0.0) * (0.13f);					        p *= 3.0f;	    
		  n += (abs(Get3DNoise(p) * 1.3f - 0.3f) - 0.0) * (0.04f);					        p *= 3.0f;	    	  
		  //n += (Get2DNoisel(p)) * (0.033f);												p *= 3.0f;
		  //n += (Get2DNoisel(p)) * (0.023f);												p *= 2.0f;
		  //n += (Get2DNoisel(p)) * (0.013f);		  
 		  //n /= 1.978f;
 		  n *= 0.5;		  
//*/

	//p.x -= t * 0.01f + R * 1e-3;
    //float T = 1.0;	
    //float n = Get3DNoise(p);
	//n += Get3DNoise(p * 3.0) * (0.23 + 0.103 * n); T += (0.23 + 0.103 * n);
	//n += Get3DNoise(p * 9.0) * (0.053 + 0.058 * n); T += (0.053 + 0.058 * n);
	
    //n /= T;
	//n -= abs(dir.y) * 0.5 - 0.2;   
    //n *= lC;	

	n = n * 1.0
	* lC
	- 0.15;
	//n += (R * 0.05 + 0.15);	
	//n -= R - 0.2;
    //n = curve(n);
	//if(level == 1){
	////  n /= 0.25 + dist * 1e-4;
	//  n = 1.0 - exp(-n * n * 45.0);		
	//}
    //n = lC;
	return saturate(n * 1.5);
}

float TraceCloudDensity1(vec3 pos, vec3 lightDir, vec3 worldDir, float perturbNoise, float cloudDensity, float cloudDist, vec3 worldLightVector)
{
	float shadowFactor = 0.0;
	const int LQnum = 4;
	const float LL = 200.0;	
	float dither = BlueNoise(texcoord.st + 0.142) - 0.5;		
	float R = 1.0;
	for (int i = 1; i <= LQnum; i++)
	{
		vec3 sp = pos + LL * scaleforplane * lightDir * pow(1.5, float(i) + dither * 0.9f);
		float d = saturate(CloudDensity2(sp, worldDir, Nc1, Nb1, worldLightVector, 0.0) - cloudDist * 1e-6);
        //R *= 0.3;
		shadowFactor += d * pow(1.5, float(i) + dither * 1.0f) * LL * 0.004;
	}
	return shadowFactor;
}

vec4 CloudColor1(in vec4 worldPosition, in float sunglow, in vec3 worldLightVector, in float altitude, in float thickness, const bool isShadowPass, vec3 dir, vec3 atmosphere)
{	
    float GAV = worldPosition.x / abs(worldPosition.x);
    float GA = distance(min(length(worldPosition.x / GAV), 2.0), worldPosition.x * 0.0f / GAV) - 1.0;	
	
	//float VecterY = dir.y / abs(dir.y) * rand(texcoord.st).x * 1000.0 + worldPosition.y;
    float dist = length(worldPosition.xyz-cameraPosition) / scaleforplane;
	float cloudHeight = altitude;
	float cloudDepth  = thickness;
	float cloudUpperHeight = cloudHeight + (cloudDepth / 2.0f);
	float cloudLowerHeight = cloudHeight - (cloudDepth / 2.0f);
	float LdotV = dot(dir, -worldLightVector);	
	float LdotV01 = LdotV * 0.5 + 0.5;
		float LdotVo = dot(dir, -worldLightVector);	
	    float LdotVo2 = LdotVo * LdotVo;	
		float LdotVo01 = LdotVo * 0.5 + 0.5;	
	///*
	vec3 p = worldPosition.xyz
	//+(abs(dir.y) * vec3(1.0, 1.0, 1.0) * 10.0 + dir / abs(dir.y) + vec3(0.0, 1.0, 0.0)) * 16000.0
	//+(dir / abs(dir.y) + vec3(0.0, 1.0, 0.0)) * 16000.0
	//+ dir / abs(dir.y)
	//* rand(texcoord.st).x
	//* GA
	//* 1500.0
	;	
	//*/

	float noiseHc = CloudDensity1(p, dir, Nc1, Nb1, worldLightVector, 0.0);	
	
	//p += vec3(0.0, 1.0, 0.0) * (1.0 - noiseHc);
	
	//vec3 p = vec3(worldPosition.x, worldPosition.y + GA * 8500.0, worldPosition.z);			

	vec3 motion = vec3(frameTimeCounter * 8e-2, 0, 0) * VOLUMETRIC_CLOUD_SPEED;
	vec3 ppos = dir;
		ppos += Get3DNoise(dir * 20.0) * 0.02;	
    ///*
	const float noiselack = 1.0f; 
	float perturbNoise = (Get3DNoise3((ppos + motion) * 70.0) - noiselack) * 2.0 / (dist * 2e-4 + 1.0); 
		 perturbNoise += (Get3DNoise3((ppos + motion) * 140.0) - noiselack) / (dist * 1e-4 + 1.0);
		 perturbNoise += (Get3DNoise3((ppos + motion) * 280.0) - noiselack) * 0.5 / (dist * 5e-5 + 1.0);
		 perturbNoise += (Get3DNoise3((ppos + motion) * 560.0) - noiselack) * 0.25 / (dist * 25e-6 + 1.0);	 
         perturbNoise *= dist * 2e-4 + 0.1;
         perturbNoise *= 1.2;	
    //*/
	/*
	float perturbNoise = Get3DNoise3((ppos + motion) * 30.0) * 2.0;
	     perturbNoise += Get3DNoise3((ppos + motion) * 60.0) * 2.0;
	     perturbNoise += Get3DNoise3((ppos + motion) * 120.0);	
	     perturbNoise += Get3DNoise3((ppos + motion) * 240.0) * 0.5;	
	     perturbNoise += Get3DNoise3((ppos + motion) * 480.0) * 0.25;	
    */
	float rawperturbNoise = perturbNoise;		 
	//     perturbNoise = (mix(perturbNoise, 2.7, 1.0 / (1.0 + dist * 0.000025)) * 0.5 - 1.33) * 0.4;
		 
		 
	float noise = CloudDensity2(p, dir, Nc1, Nb1, worldLightVector, perturbNoise);	
	
	noise = saturate(noise * 0.9 + (0.1 + perturbNoise * 1e-2) / 1.0);			 
	noise = saturate(noise * 1.15 + (-0.15 + perturbNoise * 35e-3 + 6e-2) / 1.0);	
	//noise = saturate(noise * 1.1 - 0.1 + perturbNoise * 0.03);	
	
	float fakeCLP = mix(noise, 1.0, 0.1) * (0.5 - rawperturbNoise * 0.6)
	// * pow(-LdotV * 0.5 + 0.5, 0.25)
	;	
    float forupperlight = 1.0;	
	if(cameraPosition.y > cloudHeight)
	{	
	  forupperlight = 0.0;
	}
	vec3 lightDir = normalize(worldLightVector + dir * (1.0f - timeSunriseSunset));	 
		 //lightDir += dir * dist * 3e-5; 		
		 lightDir *= fakeCLP;
		 
	vec3 lightDir2 = normalize(vec3(0.0, 1.0, 0.0) + dir);	
		 lightDir2 += dir * dist * 1e-5; 		
		 lightDir2 *= fakeCLP; 
		 
	float sundiff = TraceCloudDensity1(p + dir * noise * 500.0, lightDir, dir, perturbNoise, noise, dist, worldLightVector);		

		 sundiff += rawperturbNoise * 1e-3;	 
         sundiff = max(0.0f, sundiff) * forupperlight;   
		 sundiff /= abs(worldLightVector.y) * 2.0 + 1.0;
		 sundiff /= pow(LdotV01, 20.0f) * 1.0 + 1.0;	
		 
	float sundiff2 = TraceCloudDensity1(p + dir * noise * 500.0, lightDir2, dir, perturbNoise, noise, dist, worldLightVector) * forupperlight;			 
	float Order = pow(sundiff * 1.2 + 1.0, -0.93);
	float sE = exp(-sundiff);	
	float Orderftexp = mix(Order, sE, Order);	
	float Order2 = pow(sundiff2 * 1.3 + 1.0, -0.98);
	float DN = noise;
	float sEm = Order;
	     //DN = exp2(-DN * 20.0);
		 
	float AD = dist * 8e-4; 
		 //AD = min(AD, 80.0);	 
		 float Dirlength = length(dir / abs(dir.y));		 
	vec3 Halo = mix(vec3(1.0), pow(1.0 + pow(1.0 - C_R1, vec3(1.0)) * pow(LdotV01, 100.0) - 1.0 * pow(LdotV01, 50.0) * (1.0 - C_R1), vec3(-1.5)) * (1.0 + C_R1 * pow(LdotV01, 100.0)), vec3(sE));				 
	vec3 colorDirect = upperCloudSunlightColor * 50.0;
		 //colorDirect = mix(colorDirect, colorDirect, vec3(wetness));	
         colorDirect *= Order;
		 colorDirect *= 1.0
			 //* mix(phase_mie(Order * exp(-noise * 4.0) * 0.95, LdotV01, LdotV01 * LdotV01), phase_mie(-Order * 0.5, LdotV, LdotV * LdotV), 0.0)
			 * Halo
			 ;
			 float test = abs(sin(frameTimeCounter * VOLUMETRIC_CLOUD_SPEED * 50.0));
			 const float af = 0.73;				 
			 const float agc1 = 0.995;
			 const float agc2 = 1.0;	
			 float Lagc2 = pow(LdotV * 0.5 + 0.5, 1.2);	
			 float Lagco2 = pow(LdotVo * 0.5 + 0.5, 1.2);	
			 float Ldagc = pow(1.0 + sundiff * 1.3, -1.0);			 
			 colorDirect *= Order * af * max(0.0, 0.0		
			 + phase_mie(-0.5 * Lagco2 * Ldagc, LdotV * agc2, LdotV * LdotV * agc2 * agc2) 
			 + phase_mie( 0.8 * Lagc2 * Ldagc, LdotV * agc1, LdotV * LdotV * agc1 * agc1)		
             )	
             * (mix(1.0 - exp(-sundiff), 1.0, LdotV01)	
             //* ((1.0 - exp(-DN * sqrt(Dirlength) * 1.3))* (1.0 - LdotV01 * LdotV01) * 3.1 + LdotV01 * LdotV01) + 0.05)		
			 * ((1.0 - exp(-DN * sqrt(Dirlength) * 0.8)) * (1.0 - LdotV01 * LdotV01) * 3.1 + LdotV01 * LdotV01) + 0.05)	
             //+ (1.0 - Order) * 0.0	 
			 ;			 
	     //colorDirect *= (DN + 0.05) * pow(Orderftexp * 6.0 + 1.0 - Orderftexp * 0.9, 0.8) * (1.0 - LdotV01 * LdotV01) + LdotV01 * LdotV01; 	 
		 //colorDirect *= 1.0 + MiePhaseFunction(-0.5 * Order, LdotV01) * 0.5 + MiePhaseFunction(0.8 * Order, LdotV01) * 0.5;		 
		 //colorDirect *= CalculateMultipleScatteringCloudPhases(LdotV);	
		 //colorDirect += upperCloudSunlightColor * MiePhaseFunction(0.8 * Order, LdotV01) * 10.0 * MiePhaseFunction(Order, LdotV01);	 		
		 
	vec3 colorAmbient = mix(colorSkylight, vec3(1.0) * Luminance(colorSkylight), saturate(wetness) * rainModefactor * 0.0f); 
		 //colorAmbient = mix(colorAmbient*exp2(-wetness*2.), upperCloudSunlightColor*exp(-wetness), 1.-exp2(-wetness*2.));		
		 //colorAmbient = mix(colorAmbient, colorAmbient * 0.001f, timeMidnight);	
		 colorAmbient *= Order2 * (noise * 0.3 + 0.9);
	     atmosphere += AtmosphericScattering(normalize(-dir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), worldSunVector, 1.0, min(AD, 80.0));
	     atmosphere += AtmosphericScattering(normalize(-dir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), -worldSunVector, 1.0, min(AD, 80.0)) * 4e-4;		 
		 atmosphere = mix(atmosphere, vec3(1.0) * Luminance(colorSkylight), saturate(wetness) * rainModefactor);		 
		 
    vec3 absorb = AtmosphereAbsorption(normalize(-dir + cameraPosition.y * vec3(0.0, 1.0, 0.0) * worldscale), AD);	
	vec3 color = colorDirect * 1.0f;
    color += colorAmbient;		 
    color *= absorb;
	color += atmosphere;

	  noise = 1.0 - exp(-noise * noise * 45.0);		

	//if(texcoord.s > 0.5){
	//  color = (dir / abs(dir.y) + vec3(0.0, 1.0, 0.0)) * 1600.0 * rand(texcoord.st).x + worldPosition.xyz * 1.0f;
	//}
	//else
	//{
	//  color = pow(dir / abs(dir.y) + vec3(0.0, 1.0, 0.0), vec3(1.0)) * 1600.0 + worldPosition.xyz * 1.0f;		
	//}
	//color = abs(dir.y) * vec3(1.0, 1.0, 1.0) + (dir / abs(dir.y) + vec3(0.0, 1.0, 0.0)) * 1600.0 + worldPosition.xyz;
    //noise = 1.0;
	vec4 result = vec4(color.rgb, noise);
	return result;
}

void CloudPlane1(inout vec3 color, vec3 viewDir, vec3 worldVector, float linearDepth, MaterialMask mask, vec3 worldLightVector, vec3 lightVector, float gbufferdepth)
{
	//Initialize view ray
	 vec4 worldPos = gbufferModelViewInverse * (vec4(-GetViewPosition(texcoord.st, gbufferdepth).xyz, 1.0));
	// worldVector = normalize(worldPos.xyz);


	Ray viewRay;

	viewRay.dir = normalize(worldVector.xyz - cameraPosition.y * vec3(0.0f, 1.0, 0.0f) * worldscale);
	// viewRay.origin = (gbufferModelViewInverse * vec4(0.0, 0.0, 0.0, 1.0)).xyz;
	viewRay.origin = vec3(0.0);

	float sunglow = CalculateSunglow(viewDir, lightVector);

	float cloudsAltitude = CPH;
	float cloudsThickness = 1600.0f;

	float cloudsUpperLimit = cloudsAltitude;

	float density = 1.0f;

	float planeHeight = cloudsUpperLimit;

	Plane pl;
	pl.origin = vec3(0.0f, cameraPosition.y - planeHeight, 0.0f);
	pl.normal = vec3(0.0f, 1.0f, 0.0f);
	vec3 dir = worldVector;
    if(cameraPosition.y > cloudsAltitude)
	{
	  pl.normal = vec3(0.0f, -1.0f, 0.0f);	
	  worldVector *= vec3(1.0f, -1.0f, 1.0f);
	}
	
	Intersection intersection = RayPlaneIntersectionWorld(viewRay, pl);

	vec3 original = color.rgb;

	if (intersection.angle < 0.0f)
	{
		//if (intersection.distance < linearDepth || mask.sky > 0.5 || linearDepth >= far - 0.1)
		//{
            //intersection.pos.xyz -= (dir / abs(dir.y)) * cloudsThickness * rand(texcoord.st).x;
            //intersection.pos.xyz -= dir / abs(dir.y) * (1.0 - abs(dir.y)) * cloudsThickness;
			
			vec4 cloudSample = CloudColor1(vec4(intersection.pos.xyz, 1.0f), sunglow, worldLightVector, cloudsAltitude, cloudsThickness, false, worldVector, vec3(0.0f));
			 	 cloudSample.a = min(1.0f, cloudSample.a * density);
              

			float cloudDist = length(intersection.pos.xyz - cameraPosition.xyz);


			color.rgb = mix(color.rgb, cloudSample.rgb, cloudSample.a);

		//}
	}
}


float CloudShadow4(vec4 worldPos, vec3 worldLightVector)
{
	Ray ray;
	ray.dir = worldLightVector;
	ray.origin = worldPos.xyz + cameraPosition.xyz;

	Plane plane;
	plane.normal = vec3(0.0, 1.0, 0.0);
	plane.origin = vec3(0.0, 6400.0f, 0.0);

	vec3 cloudCheckPos = RayPlaneIntersection(ray, plane).pos;

	float cloudDensity = CloudDensity1 (cloudCheckPos, vec3(0.0f), 3, 0.23, worldLightVector, 1.0);
                  //(vec3 p, vec3 worldDir, const int level, const float lunacrity, vec3 worldLightVector, float R)
	return 1.0 - saturate(cloudDensity * 16.0) * 0.8;
}